/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import jmri.EnumPermission;
import jmri.Permission;
import jmri.PermissionFactory;
import jmri.PermissionManager;
import jmri.PermissionOwner;
import jmri.PermissionValue;
import jmri.Role;
import jmri.jmrit.display.Bundle;

public class EditorPermissions {
    public static final PermissionOwner EDITOR_PERMISSION_OWNER = new EditorPermissionOwner();
    public static final Permission EDITOR_PERMISSION = new EditorPermission();

    public static enum EditorPermissionEnum implements PermissionValue
    {
        Default(true, Bundle.getMessage("EditorPermissions_EditorPermission_Default")),
        None(false, Bundle.getMessage("EditorPermissions_EditorPermission_None")),
        View(false, Bundle.getMessage("EditorPermissions_EditorPermission_View")),
        ViewControl(false, Bundle.getMessage("EditorPermissions_EditorPermission_ViewControl")),
        ViewControlEdit(false, Bundle.getMessage("EditorPermissions_EditorPermission_ViewControlEdit"));

        final boolean _isDefault;
        final String _text;

        private EditorPermissionEnum(boolean isDefault, String text) {
            this._isDefault = isDefault;
            this._text = text;
        }

        @Override
        public boolean isDefault() {
            return this._isDefault;
        }

        public String toString() {
            return this._text;
        }
    }

    public static class EditorPermission
    implements EnumPermission<EditorPermissionEnum> {
        public EditorPermissionEnum[] getValues() {
            return EditorPermissionEnum.values();
        }

        @Override
        public PermissionOwner getOwner() {
            return EDITOR_PERMISSION_OWNER;
        }

        @Override
        public String getName() {
            return Bundle.getMessage("EditorPermissions_EditorPermission");
        }

        @Override
        public String getValue(PermissionValue value) {
            if (!(value instanceof EditorPermissionEnum)) {
                throw new IllegalArgumentException("value is not a EditorPermissionEnum: " + (value != null ? value.getClass().getName() : "null"));
            }
            return ((EditorPermissionEnum)value).name();
        }

        @Override
        public PermissionValue valueOf(String value) {
            if ("Read".equals(value)) {
                value = "View";
            }
            if ("ReadWrite".equals(value)) {
                value = "ViewControl";
            }
            if ("ReadWriteEdit".equals(value)) {
                value = "ViewControlEdit";
            }
            return EditorPermissionEnum.valueOf(value);
        }

        @Override
        public PermissionValue getDefaultPermission() {
            return EditorPermissionEnum.None;
        }

        @Override
        public PermissionValue getDefaultPermission(Role role) {
            return EditorPermissionEnum.ViewControlEdit;
        }

        @Override
        public int compare(PermissionValue o1, PermissionValue o2) {
            if (o1 instanceof EditorPermissionEnum && o2 instanceof EditorPermissionEnum) {
                EditorPermissionEnum ep1 = (EditorPermissionEnum)o1;
                EditorPermissionEnum ep2 = (EditorPermissionEnum)o2;
                return Integer.compare(ep1.ordinal(), ep2.ordinal());
            }
            throw new IllegalArgumentException("Cannot compare o1 and o2 since one or both is not an EditorPermissionEnum");
        }
    }

    public static class EditorPermissionOwner
    implements PermissionOwner {
        @Override
        public String getName() {
            return Bundle.getMessage("EditorPermissions_EditorPermissionOwner");
        }
    }

    public static class Factory
    implements PermissionFactory {
        @Override
        public void register(PermissionManager manager) {
            manager.registerOwner(EDITOR_PERMISSION_OWNER);
            manager.registerPermission(EDITOR_PERMISSION);
        }
    }
}

