/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.IconAdder;
import jmri.jmrit.display.MemoryOrGVComboIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.logixng.GlobalVariable;
import jmri.jmrit.logixng.GlobalVariableManager;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.swing.JmriMouseMotionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalVariableComboIcon
extends MemoryOrGVComboIcon
implements PropertyChangeListener,
ActionListener {
    private final JComboBox<String> _comboBox;
    private final MemoryOrGVComboIcon.ComboModel _model;
    private NamedBeanHandle<GlobalVariable> namedGlobalVariable;
    private final MouseListener _mouseListener = JmriMouseListener.adapt(this);
    private final MouseMotionListener _mouseMotionListener = JmriMouseMotionListener.adapt(this);
    private DefaultListModel<String> _listModel;
    private static final Logger log = LoggerFactory.getLogger(GlobalVariableComboIcon.class);

    public GlobalVariableComboIcon(Editor editor, String[] list) {
        super(editor);
        this._model = list != null ? new MemoryOrGVComboIcon.ComboModel(this, list) : new MemoryOrGVComboIcon.ComboModel(this);
        this._comboBox = new JComboBox<String>(this._model);
        this._comboBox.addActionListener(this);
        this.setDisplayLevel(4);
        this.setLayout(new GridBagLayout());
        this.add(this._comboBox);
        this._comboBox.addMouseListener(JmriMouseListener.adapt(this));
        for (int i = 0; i < this._comboBox.getComponentCount(); ++i) {
            Component component = this._comboBox.getComponent(i);
            if (!(component instanceof AbstractButton)) continue;
            component.addMouseListener(this._mouseListener);
            component.addMouseMotionListener(this._mouseMotionListener);
        }
        this.setPopupUtility(new PositionablePopupUtil(this, this._comboBox));
    }

    @Override
    public JComboBox<String> getTextComponent() {
        return this._comboBox;
    }

    @Override
    public Positionable deepClone() {
        String[] list = new String[this._model.getSize()];
        for (int i = 0; i < this._model.getSize(); ++i) {
            list[i] = (String)this._model.getElementAt(i);
        }
        GlobalVariableComboIcon pos = new GlobalVariableComboIcon(this._editor, list);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(GlobalVariableComboIcon pos) {
        pos.setGlobalVariable(this.namedGlobalVariable.getName());
        return super.finishClone(pos);
    }

    public void setGlobalVariable(String pName) {
        log.debug("setGlobalVariable for memory= {}", (Object)pName);
        if (InstanceManager.getNullableDefault(GlobalVariableManager.class) != null) {
            try {
                GlobalVariable globalVariable = InstanceManager.getDefault(GlobalVariableManager.class).getGlobalVariable(pName);
                this.setGlobalVariable(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, globalVariable));
            }
            catch (IllegalArgumentException e) {
                log.error("No GlobalVariableManager for this protocol, icon won't see changes");
            }
        }
        this.updateSize();
    }

    public void setGlobalVariable(NamedBeanHandle<GlobalVariable> m) {
        if (this.namedGlobalVariable != null) {
            this.getGlobalVariable().removePropertyChangeListener(this);
        }
        this.namedGlobalVariable = m;
        if (this.namedGlobalVariable != null) {
            this.getGlobalVariable().addPropertyChangeListener(this, this.namedGlobalVariable.getName(), "GlobalVariable Input Icon");
            this.displayState();
            this.setName(this.namedGlobalVariable.getName());
        }
    }

    public NamedBeanHandle<GlobalVariable> getNamedGlobalVariable() {
        return this.namedGlobalVariable;
    }

    public GlobalVariable getGlobalVariable() {
        if (this.namedGlobalVariable == null) {
            return null;
        }
        return this.namedGlobalVariable.getBean();
    }

    @Override
    public MemoryOrGVComboIcon.ComboModel getComboModel() {
        return this._model;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.update();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("value")) {
            this.displayState();
        }
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_GlobalVariableComboIcon");
    }

    @Override
    public String getNameString() {
        String name = this.namedGlobalVariable == null ? Bundle.getMessage("NotConnected") : this.getGlobalVariable().getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    @Override
    protected void update() {
        if (this.namedGlobalVariable == null) {
            return;
        }
        this.getGlobalVariable().setValue(this._comboBox.getSelectedItem());
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameGlobalVariable"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalVariableComboIcon.this.edit();
            }
        });
        return true;
    }

    @Override
    protected void edit() {
        this._iconEditor = new IconAdder("GlobalVariable"){
            JList<String> list;
            final JButton bDel;
            final JButton bAdd;
            final JTextField textfield;
            int idx;
            {
                this.bDel = new JButton(Bundle.getMessage("deleteSelection"));
                this.bAdd = new JButton(Bundle.getMessage("addItem"));
                this.textfield = new JTextField(30);
            }

            @Override
            protected void addAdditionalButtons(JPanel p) {
                GlobalVariableComboIcon.this._listModel = new DefaultListModel();
                this.bDel.addActionListener(a -> {
                    if (this.list == null) {
                        return;
                    }
                    this.idx = this.list.getSelectedIndex();
                    if (this.idx >= 0) {
                        GlobalVariableComboIcon.this._listModel.removeElementAt(this.idx);
                    }
                });
                this.bAdd.addActionListener(a -> {
                    String text = this.textfield.getText();
                    if (text == null || this.list == null || text.length() == 0 || GlobalVariableComboIcon.this._listModel.indexOf(text) >= 0) {
                        return;
                    }
                    this.idx = this.list.getSelectedIndex();
                    if (this.idx < 0) {
                        this.idx = GlobalVariableComboIcon.this._listModel.getSize();
                    }
                    GlobalVariableComboIcon.this._listModel.add(this.idx, text);
                });
                for (int i = 0; i < GlobalVariableComboIcon.this._model.getSize(); ++i) {
                    GlobalVariableComboIcon.this._listModel.add(i, (String)GlobalVariableComboIcon.this._model.getElementAt(i));
                }
                this.list = new JList<String>(GlobalVariableComboIcon.this._listModel);
                JScrollPane scrollPane = new JScrollPane(this.list);
                JPanel p1 = new JPanel();
                p1.add(new JLabel(Bundle.getMessage("comboList")));
                p.add(p1);
                p.add(scrollPane);
                p1 = new JPanel();
                p1.add(new JLabel(Bundle.getMessage("newItem"), 4));
                this.textfield.setMaximumSize(this.textfield.getPreferredSize());
                p1.add(this.textfield);
                p.add(p1);
                JPanel p2 = new JPanel();
                p2.add(this.bDel);
                p2.add(this.bAdd);
                p.add(p2);
                p.setVisible(true);
            }
        };
        this.makeIconEditorFrame(this, "GlobalVariable", true, this._iconEditor);
        this._iconEditor.setPickList(PickListModel.globalVariablePickModelInstance());
        ActionListener addIconAction = a -> this.editGlobalVariable();
        this._iconEditor.makeIconPanel(false);
        this._iconEditor.complete(addIconAction, false, false, true);
        this._iconEditor.setSelection(this.getGlobalVariable());
    }

    void editGlobalVariable() {
        NamedBean bean = this._iconEditor.getTableSelection();
        this.setGlobalVariable(bean.getDisplayName());
        this._model.removeAllElements();
        for (int i = 0; i < this._listModel.size(); ++i) {
            this._model.addElement(this._listModel.getElementAt(i));
        }
        this.setSize(this.getPreferredSize().width + 1, this.getPreferredSize().height);
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.validate();
    }

    public void displayState() {
        log.debug("displayState");
        if (this.namedGlobalVariable == null) {
            return;
        }
        this._model.setSelectedItem(this.getGlobalVariable().getValue());
    }

    @Override
    public void mouseExited(JmriMouseEvent e) {
        this._comboBox.setFocusable(false);
        this._comboBox.transferFocus();
        super.mouseExited(e);
    }

    @Override
    void cleanup() {
        if (this.namedGlobalVariable != null) {
            this.getGlobalVariable().removePropertyChangeListener(this);
        }
        if (this._comboBox != null) {
            for (int i = 0; i < this._comboBox.getComponentCount(); ++i) {
                Component component = this._comboBox.getComponent(i);
                if (!(component instanceof AbstractButton)) continue;
                component.removeMouseListener(this._mouseListener);
                component.removeMouseMotionListener(this._mouseMotionListener);
            }
            this._comboBox.removeMouseListener(this._mouseListener);
        }
        this.namedGlobalVariable = null;
    }
}

