/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import jmri.IdTag;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Reportable;
import jmri.Throttle;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.MemoryOrGVIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.logixng.GlobalVariable;
import jmri.jmrit.logixng.GlobalVariableManager;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalVariableIcon
extends MemoryOrGVIcon
implements PropertyChangeListener {
    NamedIcon defaultIcon = null;
    HashMap<String, NamedIcon> map = null;
    private NamedBeanHandle<GlobalVariable> namedGlobalVariable;
    boolean selectable = false;
    Color _saveColor;
    static final int LEFT = 0;
    static final int RIGHT = 2;
    static final int CENTRE = 4;
    private int originalX = 0;
    private int originalY = 0;
    private static final Logger log = LoggerFactory.getLogger(GlobalVariableIcon.class);

    public GlobalVariableIcon(String s, Editor editor) {
        super(s, editor);
        this.resetDefaultIcon();
        this._namedIcon = this.defaultIcon;
        this._popupUtil.setJustification(0);
    }

    public GlobalVariableIcon(NamedIcon s, Editor editor) {
        super(s, editor);
        this.setDisplayLevel(4);
        this.defaultIcon = s;
        this._popupUtil.setJustification(0);
        log.debug("GlobalVariableIcon ctor= {}", (Object)GlobalVariableIcon.class.getName());
    }

    @Override
    public Positionable deepClone() {
        GlobalVariableIcon pos = new GlobalVariableIcon("", this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(GlobalVariableIcon pos) {
        pos.setGlobalVariable(this.namedGlobalVariable.getName());
        pos.setOriginalLocation(this.getOriginalX(), this.getOriginalY());
        if (this.map != null) {
            for (Map.Entry<String, NamedIcon> entry : this.map.entrySet()) {
                String url = entry.getValue().getName();
                pos.addKeyAndIcon(NamedIcon.getIconByName(url), entry.getKey());
            }
        }
        return super.finishClone(pos);
    }

    public void resetDefaultIcon() {
        this.defaultIcon = new NamedIcon("resources/icons/misc/X-red.gif", "resources/icons/misc/X-red.gif");
    }

    public void setDefaultIcon(NamedIcon n) {
        this.defaultIcon = n;
    }

    public NamedIcon getDefaultIcon() {
        return this.defaultIcon;
    }

    private void setMap() {
        if (this.map == null) {
            this.map = new HashMap();
        }
    }

    public void setGlobalVariable(String pName) {
        if (InstanceManager.getNullableDefault(GlobalVariableManager.class) != null) {
            try {
                GlobalVariable globalVariable = InstanceManager.getDefault(GlobalVariableManager.class).getGlobalVariable(pName);
                this.setGlobalVariable(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, globalVariable));
            }
            catch (IllegalArgumentException e) {
                log.error("GlobalVariable '{}' not available, icon won't see changes", (Object)pName);
            }
        } else {
            log.error("No GlobalVariableManager for this protocol, icon won't see changes");
        }
        this.updateSize();
    }

    public void setGlobalVariable(NamedBeanHandle<GlobalVariable> m) {
        if (this.namedGlobalVariable != null) {
            this.getGlobalVariable().removePropertyChangeListener(this);
        }
        this.namedGlobalVariable = m;
        if (this.namedGlobalVariable != null) {
            this.getGlobalVariable().addPropertyChangeListener(this, this.namedGlobalVariable.getName(), "GlobalVariable Icon");
            this.displayState();
            this.setName(this.namedGlobalVariable.getName());
        }
    }

    public NamedBeanHandle<GlobalVariable> getNamedGlobalVariable() {
        return this.namedGlobalVariable;
    }

    public GlobalVariable getGlobalVariable() {
        if (this.namedGlobalVariable == null) {
            return null;
        }
        return this.namedGlobalVariable.getBean();
    }

    @Override
    public NamedBean getNamedBean() {
        return this.getGlobalVariable();
    }

    public HashMap<String, NamedIcon> getMap() {
        return this.map;
    }

    public void addKeyAndIcon(NamedIcon icon, String keyValue) {
        if (this.map == null) {
            this.setMap();
        }
        this.map.put(keyValue, icon);
        this.displayState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("property change: {} is now {}", (Object)e.getPropertyName(), e.getNewValue());
        }
        if (e.getPropertyName().equals("value")) {
            this.displayState();
        }
        if (e.getSource() instanceof Throttle && e.getPropertyName().equals("IsForward")) {
            Boolean boo = (Boolean)e.getNewValue();
            if (boo.booleanValue()) {
                this.flipIcon(0);
            } else {
                this.flipIcon(1);
            }
        }
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_GlobalVariableIcon");
    }

    @Override
    public String getNameString() {
        String name = this.namedGlobalVariable == null ? Bundle.getMessage("NotConnected") : this.getGlobalVariable().getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    public void setSelectable(boolean b) {
        this.selectable = b;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this.isEditable() && this.selectable) {
            popup.add(new JSeparator());
            for (String key : this.map.keySet()) {
                popup.add(new AbstractAction(key){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String key = e.getActionCommand();
                        GlobalVariableIcon.this.setValue(key);
                    }
                });
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setTextEditMenu(JPopupMenu popup) {
        popup.add(new AbstractAction(Bundle.getMessage("EditGlobalVariableValue")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalVariableIcon.this.editGlobalVariableValue();
            }
        });
        return true;
    }

    protected void flipIcon(int flip) {
        if (this._namedIcon != null) {
            this._namedIcon.flip(flip, this);
        }
        this.updateSize();
        this.repaint();
    }

    @Override
    public void displayState() {
        log.debug("displayState()");
        if (this.namedGlobalVariable == null) {
            this.setIcon(this.defaultIcon);
            this.updateSize();
            return;
        }
        Object key = this.getGlobalVariable().getValue();
        this.displayState(key);
    }

    public void setAttributes(PositionablePopupUtil util, Positionable that) {
        this._editor.setAttributes(util, that);
    }

    protected void displayState(Object key) {
        log.debug("displayState({})", key);
        if (key != null) {
            if (this.map == null) {
                Object val = key;
                if (val instanceof String) {
                    String str = (String)val;
                    this._icon = false;
                    this._text = true;
                    this.setText(str);
                    this.updateIcon(null);
                    if (log.isDebugEnabled()) {
                        log.debug("String str= \"{}\" str.trim().length()= {}", (Object)str, (Object)str.trim().length());
                        log.debug("  maxWidth()= {}, maxHeight()= {}", (Object)this.maxWidth(), (Object)this.maxHeight());
                        log.debug("  getBackground(): {}", (Object)this.getBackground());
                        log.debug("  _editor.getTargetPanel().getBackground(): {}", (Object)this._editor.getTargetPanel().getBackground());
                        log.debug("  setAttributes to getPopupUtility({}) with", (Object)this.getPopupUtility());
                        log.debug("     hasBackground() {}", (Object)this.getPopupUtility().hasBackground());
                        log.debug("     getBackground() {}", (Object)this.getPopupUtility().getBackground());
                        log.debug("    on editor {}", (Object)this._editor);
                    }
                    this._editor.setAttributes(this.getPopupUtility(), this);
                } else if (val instanceof ImageIcon) {
                    this._icon = true;
                    this._text = false;
                    this.setIcon((ImageIcon)val);
                    this.setText(null);
                } else if (val instanceof Number) {
                    this._icon = false;
                    this._text = true;
                    this.setText(val.toString());
                    this.setIcon(null);
                } else if (val instanceof IdTag) {
                    this._icon = false;
                    this._text = true;
                    this.setIcon(null);
                    this.setText(((IdTag)val).getDisplayName());
                } else if (val instanceof Reportable) {
                    this._icon = false;
                    this._text = true;
                    this.setText(((Reportable)val).toReportString());
                    this.setIcon(null);
                } else {
                    log.debug("display current value of {} as String, val= {} of Class {}", new Object[]{this.getNameString(), val, val.getClass().getName()});
                    this._icon = false;
                    this._text = true;
                    this.setText(val.toString());
                    this.setIcon(null);
                }
            } else {
                NamedIcon newicon = this.map.get(key.toString());
                if (newicon != null) {
                    this.setText(null);
                    super.setIcon(newicon);
                } else {
                    this._icon = true;
                    this._text = false;
                    this.setIcon(this.defaultIcon);
                    this.setText(null);
                }
            }
        } else {
            log.debug("object null");
            this._icon = true;
            this._text = false;
            this.setIcon(this.defaultIcon);
            this.setText(null);
        }
        this.updateSize();
    }

    @Override
    public void updateSize() {
        if (this._popupUtil.getFixedWidth() == 0) {
            switch (this._popupUtil.getJustification()) {
                case 0: {
                    super.setLocation(this.getOriginalX(), this.getOriginalY());
                    break;
                }
                case 2: {
                    super.setLocation(this.getOriginalX() - this.maxWidth(), this.getOriginalY());
                    break;
                }
                case 4: {
                    super.setLocation(this.getOriginalX() - this.maxWidth() / 2, this.getOriginalY());
                    break;
                }
                default: {
                    log.warn("Unhandled justification code: {}", (Object)this._popupUtil.getJustification());
                }
            }
            this.setSize(this.maxWidth(), this.maxHeight());
        } else {
            super.updateSize();
            if (this._icon && this._namedIcon != null) {
                this._namedIcon.reduceTo(this.maxWidthTrue(), this.maxHeightTrue(), 0.2);
            }
        }
    }

    public void setOriginalLocation(int x, int y) {
        this.originalX = x;
        this.originalY = y;
        this.updateSize();
    }

    @Override
    public int getOriginalX() {
        return this.originalX;
    }

    @Override
    public int getOriginalY() {
        return this.originalY;
    }

    @Override
    public void setLocation(int x, int y) {
        if (this._popupUtil.getFixedWidth() == 0) {
            this.setOriginalLocation(x, y);
        } else {
            super.setLocation(x, y);
        }
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameGlobalVariable"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalVariableIcon.this.edit();
            }
        });
        return true;
    }

    @Override
    protected void edit() {
        this.makeIconEditorFrame(this, "GlobalVariable", true, null);
        this._iconEditor.setPickList(PickListModel.globalVariablePickModelInstance());
        ActionListener addIconAction = a -> this.editGlobalVariable();
        this._iconEditor.complete(addIconAction, false, false, true);
        this._iconEditor.setSelection(this.getGlobalVariable());
    }

    void editGlobalVariable() {
        this.setGlobalVariable(this._iconEditor.getTableSelection().getDisplayName());
        this.updateSize();
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.invalidate();
    }

    @Override
    public void dispose() {
        if (this.getGlobalVariable() != null) {
            this.getGlobalVariable().removePropertyChangeListener(this);
        }
        this.namedGlobalVariable = null;
        super.dispose();
    }

    @Override
    public void doMouseClicked(JmriMouseEvent e) {
        if (e.getClickCount() == 2) {
            if (!this.getEditor().isEditable() && this.isValueEditDisabled()) {
                log.debug("Double click global variable value edit is disabled");
                return;
            }
            this.editGlobalVariableValue();
        }
    }

    protected void editGlobalVariableValue() {
        String reval = (String)JmriJOptionPane.showInputDialog((Component)this, Bundle.getMessage("EditCurrentGlobalVariableValue", this.namedGlobalVariable.getName()), this.getGlobalVariable().getValue());
        this.setValue(reval);
        this.updateSize();
    }

    protected Object getValue() {
        if (this.getGlobalVariable() == null) {
            return null;
        }
        return this.getGlobalVariable().getValue();
    }

    protected void setValue(Object val) {
        this.getGlobalVariable().setValue(val);
    }
}

