/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.IconAdder;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableJPanel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.logixng.GlobalVariable;
import jmri.jmrit.logixng.GlobalVariableManager;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.swing.JmriMouseMotionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalVariableInputIcon
extends PositionableJPanel
implements PropertyChangeListener {
    JTextField _textBox = new JTextField();
    int _nCols;
    private NamedBeanHandle<GlobalVariable> namedGlobalVariable;
    private final MouseListener _mouseListener = JmriMouseListener.adapt(this);
    private final MouseMotionListener _mouseMotionListener = JmriMouseMotionListener.adapt(this);
    SpinnerNumberModel _spinModel = new SpinnerNumberModel(3, 1, 100, 1);
    private static final Logger log = LoggerFactory.getLogger(GlobalVariableInputIcon.class);

    public GlobalVariableInputIcon(int nCols, Editor editor) {
        super(editor);
        this._nCols = nCols;
        this.setDisplayLevel(4);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._textBox, new GridBagConstraints());
        this._textBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10 || key == 9) {
                    GlobalVariableInputIcon.this.updateGlobalVariable();
                }
            }
        });
        this._textBox.setColumns(this._nCols);
        this._textBox.addMouseMotionListener(this._mouseMotionListener);
        this._textBox.addMouseListener(this._mouseListener);
        this.setPopupUtility(new PositionablePopupUtil(this, this._textBox));
    }

    @Override
    public Positionable deepClone() {
        GlobalVariableInputIcon pos = new GlobalVariableInputIcon(this._nCols, this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(GlobalVariableInputIcon pos) {
        pos.setGlobalVariable(this.namedGlobalVariable.getName());
        return super.finishClone(pos);
    }

    @Override
    public JComponent getTextComponent() {
        return this._textBox;
    }

    @Override
    public void mouseExited(JmriMouseEvent e) {
        this.updateGlobalVariable();
        super.mouseExited(e);
    }

    public void setGlobalVariable(String pName) {
        log.debug("setGlobalVariable for memory= {}", (Object)pName);
        if (InstanceManager.getNullableDefault(GlobalVariableManager.class) != null) {
            try {
                GlobalVariable globalVariable = InstanceManager.getDefault(GlobalVariableManager.class).getGlobalVariable(pName);
                this.setGlobalVariable(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, globalVariable));
            }
            catch (IllegalArgumentException e) {
                log.error("GlobalVariable '{}' not available, icon won't see changes", (Object)pName);
            }
        } else {
            log.error("No GlobalVariableManager for this protocol, icon won't see changes");
        }
        this.updateSize();
    }

    public void setGlobalVariable(NamedBeanHandle<GlobalVariable> m) {
        if (this.namedGlobalVariable != null) {
            this.getGlobalVariable().removePropertyChangeListener(this);
        }
        this.namedGlobalVariable = m;
        if (this.namedGlobalVariable != null) {
            this.getGlobalVariable().addPropertyChangeListener(this, this.namedGlobalVariable.getName(), "GlobalVariable Input Icon");
            this.displayState();
            this.setName(this.namedGlobalVariable.getName());
        }
    }

    public void setNumColumns(int nCols) {
        this._textBox.setColumns(nCols);
        this._nCols = nCols;
    }

    public NamedBeanHandle<GlobalVariable> getNamedGlobalVariable() {
        return this.namedGlobalVariable;
    }

    public GlobalVariable getGlobalVariable() {
        if (this.namedGlobalVariable == null) {
            return null;
        }
        return this.namedGlobalVariable.getBean();
    }

    public int getNumColumns() {
        return this._nCols;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("value")) {
            this.displayState();
        }
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_GlobalVariableInputIcon");
    }

    @Override
    public String getNameString() {
        String name = this.namedGlobalVariable == null ? Bundle.getMessage("NotConnected") : this.getGlobalVariable().getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    @Override
    public void mouseMoved(JmriMouseEvent e) {
        this.updateGlobalVariable();
    }

    private void updateGlobalVariable() {
        if (this.namedGlobalVariable == null) {
            return;
        }
        String str = this._textBox.getText();
        this.getGlobalVariable().setValue(str);
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameGlobalVariable"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalVariableInputIcon.this.edit();
            }
        });
        return true;
    }

    @Override
    protected void edit() {
        this._iconEditor = new IconAdder("GlobalVariable"){
            final JSpinner spinner;
            {
                this.spinner = new JSpinner(GlobalVariableInputIcon.this._spinModel);
            }

            @Override
            protected void addAdditionalButtons(JPanel p) {
                ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setColumns(2);
                this.spinner.setMaximumSize(this.spinner.getPreferredSize());
                this.spinner.setValue(GlobalVariableInputIcon.this._textBox.getColumns());
                JPanel p2 = new JPanel();
                p2.add(new JLabel(Bundle.getMessage("NumColsLabel")));
                p2.add(this.spinner);
                p.add(p2);
                p.setVisible(true);
            }
        };
        this.makeIconEditorFrame(this, "GlobalVariable", true, this._iconEditor);
        this._iconEditor.setPickList(PickListModel.globalVariablePickModelInstance());
        ActionListener addIconAction = a -> this.editGlobalVariable();
        this._iconEditor.makeIconPanel(false);
        this._iconEditor.complete(addIconAction, false, false, true);
        this._iconEditor.setSelection(this.getGlobalVariable());
    }

    void editGlobalVariable() {
        this.setGlobalVariable(this._iconEditor.getTableSelection().getDisplayName());
        this._nCols = this._spinModel.getNumber().intValue();
        this._textBox.setColumns(this._nCols);
        this.setSize(this.getPreferredSize().width + 1, this.getPreferredSize().height);
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.validate();
    }

    public void displayState() {
        log.debug("displayState");
        if (this.namedGlobalVariable == null) {
            return;
        }
        Object show = this.getGlobalVariable().getValue();
        if (show != null) {
            this._textBox.setText(show.toString());
        } else {
            this._textBox.setText("");
        }
    }

    @Override
    void cleanup() {
        if (this.namedGlobalVariable != null) {
            this.getGlobalVariable().removePropertyChangeListener(this);
        }
        if (this._textBox != null) {
            this._textBox.removeMouseMotionListener(this._mouseMotionListener);
            this._textBox.removeMouseListener(this._mouseListener);
        }
        this.namedGlobalVariable = null;
    }
}

