/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableJPanel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.logixng.GlobalVariable;
import jmri.jmrit.logixng.GlobalVariableManager;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.swing.JmriMouseMotionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalVariableSpinnerIcon
extends PositionableJPanel
implements ChangeListener,
PropertyChangeListener {
    int _min = 0;
    int _max = 100;
    JSpinner spinner = new JSpinner(new SpinnerNumberModel(0, this._min, this._max, 1));
    private NamedBeanHandle<GlobalVariable> namedGlobalVariable;
    private final MouseListener _mouseListener = JmriMouseListener.adapt(this);
    private final MouseMotionListener _mouseMotionListener = JmriMouseMotionListener.adapt(this);
    private static final Logger log = LoggerFactory.getLogger(GlobalVariableSpinnerIcon.class);

    public GlobalVariableSpinnerIcon(Editor editor) {
        super(editor);
        this.setDisplayLevel(4);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.spinner, new GridBagConstraints());
        this.spinner.addChangeListener(this);
        JFormattedTextField textBox = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
        textBox.addMouseMotionListener(this._mouseMotionListener);
        textBox.addMouseListener(this._mouseListener);
        this.setPopupUtility(new PositionablePopupUtil(this, textBox));
    }

    @Override
    public Positionable deepClone() {
        GlobalVariableSpinnerIcon pos = new GlobalVariableSpinnerIcon(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(GlobalVariableSpinnerIcon pos) {
        pos.setGlobalVariable(this.namedGlobalVariable.getName());
        return super.finishClone(pos);
    }

    @Override
    public JComponent getTextComponent() {
        return ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
    }

    @Override
    public Dimension getSize() {
        if (log.isDebugEnabled()) {
            Dimension d = this.spinner.getSize();
            log.debug("spinner width= {}, height= {}", (Object)d.width, (Object)d.height);
            Rectangle rect = this.getBounds(null);
            log.debug("Bounds rect= ({},{}) width= {}, height= {}", new Object[]{rect.x, rect.y, rect.width, rect.height});
            d = super.getSize();
            log.debug("Panel width= {}, height= {}", (Object)d.width, (Object)d.height);
        }
        return super.getSize();
    }

    public void setGlobalVariable(String pName) {
        log.debug("setGlobalVariable for memory= {}", (Object)pName);
        if (InstanceManager.getNullableDefault(GlobalVariableManager.class) != null) {
            try {
                GlobalVariable globalVariable = InstanceManager.getDefault(GlobalVariableManager.class).getGlobalVariable(pName);
                this.setGlobalVariable(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, globalVariable));
            }
            catch (IllegalArgumentException e) {
                log.error("GlobalVariable '{}' not available, icon won't see changes", (Object)pName);
            }
        } else {
            log.error("No GlobalVariableManager for this protocol, icon won't see changes");
        }
        this.updateSize();
    }

    public void setGlobalVariable(NamedBeanHandle<GlobalVariable> m) {
        if (this.namedGlobalVariable != null) {
            this.getGlobalVariable().removePropertyChangeListener(this);
        }
        this.namedGlobalVariable = m;
        if (this.namedGlobalVariable != null) {
            this.getGlobalVariable().addPropertyChangeListener(this, this.namedGlobalVariable.getName(), "GlobalVariable Spinner Icon");
            this.displayState();
            this.setName(this.namedGlobalVariable.getName());
        }
    }

    public NamedBeanHandle<GlobalVariable> getNamedGlobalVariable() {
        return this.namedGlobalVariable;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("value")) {
            this.displayState();
        }
    }

    public GlobalVariable getGlobalVariable() {
        if (this.namedGlobalVariable == null) {
            return null;
        }
        return this.namedGlobalVariable.getBean();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.spinnerUpdated();
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_GlobalVariableSpinnerIcon");
    }

    @Override
    public String getNameString() {
        String name = this.namedGlobalVariable == null ? Bundle.getMessage("NotConnected") : this.getGlobalVariable().getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameGlobalVariable"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalVariableSpinnerIcon.this.edit();
            }
        });
        return true;
    }

    @Override
    protected void edit() {
        this.makeIconEditorFrame(this, "GlobalVariable", true, null);
        this._iconEditor.setPickList(PickListModel.globalVariablePickModelInstance());
        ActionListener addIconAction = a -> this.editGlobalVariable();
        this._iconEditor.complete(addIconAction, false, false, true);
        this._iconEditor.setSelection(this.getGlobalVariable());
    }

    void editGlobalVariable() {
        this.setGlobalVariable(this._iconEditor.getTableSelection().getDisplayName());
        this.setSize(this.getPreferredSize().width, this.getPreferredSize().height);
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.invalidate();
    }

    public void displayState() {
        log.debug("displayState");
        if (this.namedGlobalVariable == null) {
            return;
        }
        if (this.getGlobalVariable().getValue() == null) {
            return;
        }
        Integer num = null;
        if (this.getGlobalVariable().getValue().getClass() == String.class) {
            try {
                num = Integer.valueOf((String)this.getGlobalVariable().getValue());
            }
            catch (NumberFormatException e) {
                return;
            }
        } else if (this.getGlobalVariable().getValue().getClass() == Integer.class) {
            num = ((Number)this.getGlobalVariable().getValue()).intValue();
        } else if (this.getGlobalVariable().getValue().getClass() == Float.class) {
            num = Math.round(((Float)this.getGlobalVariable().getValue()).floatValue());
            log.debug("num= {}", (Object)num);
        } else {
            return;
        }
        int n = num;
        if (n > this._max) {
            num = this._max;
        } else if (n < this._min) {
            num = this._min;
        }
        this.spinner.setValue(num);
    }

    @Override
    public void mouseExited(JmriMouseEvent e) {
        this.spinnerUpdated();
        super.mouseExited(e);
    }

    protected void spinnerUpdated() {
        if (this.namedGlobalVariable == null) {
            return;
        }
        if (this.getGlobalVariable().getValue() == null) {
            this.getGlobalVariable().setValue(this.spinner.getValue());
            return;
        }
        if (this.getGlobalVariable().getValue().getClass() == String.class) {
            String newValue = "" + this.spinner.getValue();
            if (!this.getGlobalVariable().getValue().equals(newValue)) {
                this.getGlobalVariable().setValue(newValue);
            }
        } else {
            this.getGlobalVariable().setValue(this.spinner.getValue());
        }
    }

    public String getValue() {
        return "" + this.spinner.getValue();
    }

    @Override
    void cleanup() {
        if (this.namedGlobalVariable != null) {
            this.getGlobalVariable().removePropertyChangeListener(this);
        }
        if (this.spinner != null) {
            this.spinner.removeChangeListener(this);
            ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().removeMouseMotionListener(this._mouseMotionListener);
            ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().removeMouseListener(this._mouseListener);
        }
        this.namedGlobalVariable = null;
    }
}

