/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.IndicatorTrack;
import jmri.jmrit.display.IndicatorTrackPaths;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableIcon;
import jmri.jmrit.display.ToolTip;
import jmri.jmrit.display.palette.IndicatorItemPanel;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicatorTrackIcon
extends PositionableIcon
implements PropertyChangeListener,
IndicatorTrack {
    private NamedBeanHandle<Sensor> namedOccSensor = null;
    private NamedBeanHandle<OBlock> namedOccBlock = null;
    private IndicatorTrackPaths _pathUtil = new IndicatorTrackPaths();
    private IndicatorItemPanel _trackPanel;
    private String _status = "ClearTrack";
    private static final Logger log = LoggerFactory.getLogger(IndicatorTrackIcon.class);

    public IndicatorTrackIcon(Editor editor) {
        super(editor);
        this._iconMap = new HashMap();
    }

    @Override
    @Nonnull
    public Positionable deepClone() {
        IndicatorTrackIcon pos = new IndicatorTrackIcon(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(IndicatorTrackIcon pos) {
        pos.setOccSensorHandle(this.namedOccSensor);
        pos.setOccBlockHandle(this.namedOccBlock);
        pos._iconMap = IndicatorTrackIcon.cloneMap(this._iconMap, pos);
        pos._pathUtil = this._pathUtil.deepClone();
        pos._iconFamily = this._iconFamily;
        pos._namedIcon = null;
        pos._status = this._status;
        return super.finishClone(pos);
    }

    @Override
    public void setOccSensor(String pName) {
        if (pName == null || pName.trim().isEmpty()) {
            this.setOccSensorHandle(null);
            return;
        }
        if (InstanceManager.getNullableDefault(SensorManager.class) != null) {
            try {
                Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(pName);
                this.setOccSensorHandle(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, sensor));
            }
            catch (IllegalArgumentException ex) {
                log.error("Occupancy Sensor '{}' not available, icon won't see changes", (Object)pName);
            }
        } else {
            log.error("No SensorManager for this protocol, block icons won't see changes");
        }
    }

    @Override
    public void setOccSensorHandle(NamedBeanHandle<Sensor> senHandle) {
        if (this.namedOccSensor != null) {
            this.getOccSensor().removePropertyChangeListener(this);
        }
        this.namedOccSensor = senHandle;
        if (this.namedOccSensor != null) {
            if (this._iconMap == null) {
                this._iconMap = new HashMap();
            }
            Sensor sensor = this.getOccSensor();
            sensor.addPropertyChangeListener(this, this.namedOccSensor.getName(), "Indicator Track");
            this._status = this._pathUtil.getStatus(sensor.getKnownState());
            this.displayState(this._status);
        }
    }

    @Override
    public Sensor getOccSensor() {
        if (this.namedOccSensor == null) {
            return null;
        }
        return this.namedOccSensor.getBean();
    }

    @Override
    public NamedBeanHandle<Sensor> getNamedOccSensor() {
        return this.namedOccSensor;
    }

    @Override
    public void setOccBlock(String pName) {
        if (pName == null || pName.trim().isEmpty()) {
            this.setOccBlockHandle(null);
            return;
        }
        OBlock block = InstanceManager.getDefault(OBlockManager.class).getOBlock(pName);
        if (block != null) {
            this.setOccBlockHandle(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, block));
        } else {
            log.error("Detection OBlock '{}' not available, icon won't see changes", (Object)pName);
        }
    }

    @Override
    public void setOccBlockHandle(NamedBeanHandle<OBlock> blockHandle) {
        if (this.namedOccBlock != null) {
            this.getOccBlock().removePropertyChangeListener(this);
        }
        this.namedOccBlock = blockHandle;
        if (this.namedOccBlock != null) {
            if (this._iconMap == null) {
                this._iconMap = new HashMap();
            }
            OBlock block = this.getOccBlock();
            block.addPropertyChangeListener(this, this.namedOccBlock.getName(), "Indicator Track");
            this.setStatus(block, block.getState());
            this.displayState(this._status);
            this.setToolTip(new ToolTip(block.getDescription(), 0, 0, this));
        } else {
            this.setToolTip(new ToolTip(null, 0, 0, this));
        }
    }

    @Override
    public OBlock getOccBlock() {
        if (this.namedOccBlock == null) {
            return null;
        }
        return this.namedOccBlock.getBean();
    }

    @Override
    public NamedBeanHandle<OBlock> getNamedOccBlock() {
        return this.namedOccBlock;
    }

    @Override
    public void setShowTrain(boolean set) {
        this._pathUtil.setShowTrain(set);
    }

    @Override
    public boolean showTrain() {
        return this._pathUtil.showTrain();
    }

    @Override
    public ArrayList<String> getPaths() {
        return this._pathUtil.getPaths();
    }

    public void setPaths(ArrayList<String> paths) {
        this._pathUtil.setPaths(paths);
    }

    @Override
    public void addPath(String path) {
        this._pathUtil.addPath(path);
    }

    @Override
    public void removePath(String path) {
        this._pathUtil.removePath(path);
    }

    @Override
    public void setStatus(int state) {
        this._status = this._pathUtil.getStatus(state);
    }

    public void setIcon(String name, NamedIcon icon) {
        log.debug("set \"{}\" icon= {}", (Object)name, (Object)icon);
        this._iconMap.put(name, icon);
        if (this._status.equals(name)) {
            this.setIcon(icon);
        }
    }

    public String getStatus() {
        return this._status;
    }

    @Override
    public int maxHeight() {
        if (this._iconMap == null) {
            return 0;
        }
        int max = 0;
        for (NamedIcon namedIcon : this._iconMap.values()) {
            max = Math.max(namedIcon.getIconHeight(), max);
        }
        return max;
    }

    @Override
    public int maxWidth() {
        if (this._iconMap == null) {
            return 0;
        }
        int max = 0;
        for (NamedIcon namedIcon : this._iconMap.values()) {
            max = Math.max(namedIcon.getIconWidth(), max);
        }
        return max;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source;
        if (log.isDebugEnabled()) {
            log.debug("property change: {} property {} is now {} from {}", new Object[]{this.getNameString(), evt.getPropertyName(), evt.getNewValue(), evt.getSource().getClass().getName()});
        }
        if ((source = evt.getSource()) instanceof OBlock) {
            String property = evt.getPropertyName();
            if ("state".equals(property) || "pathState".equals(property)) {
                int now = (Integer)evt.getNewValue();
                this.setStatus((OBlock)source, now);
            } else if ("pathName".equals(property)) {
                this._pathUtil.removePath((String)evt.getOldValue());
                this._pathUtil.addPath((String)evt.getNewValue());
            }
        } else if (source instanceof Sensor && evt.getPropertyName().equals("KnownState")) {
            int now = (Integer)evt.getNewValue();
            if (source.equals(this.getOccSensor())) {
                this._status = this._pathUtil.getStatus(now);
            }
        }
        this.displayState(this._status);
    }

    private void setStatus(OBlock block, int state) {
        this._status = this._pathUtil.getStatus(block, state);
        if ((state & 0x22) != 0) {
            ThreadingUtil.runOnGUIEventually(() -> {
                this._pathUtil.setLocoIcon(block, this.getLocation(), this.getSize(), this._editor);
                this.repaint();
            });
        }
        if ((block.getState() & 0x40) != 0) {
            this.setControlling(false);
        } else {
            this.setControlling(true);
        }
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_IndicatorTrackIcon");
    }

    @Override
    @Nonnull
    public String getNameString() {
        Object str = "";
        if (this.namedOccBlock != null) {
            str = "in " + this.namedOccBlock.getBean().getDisplayName();
        } else if (this.namedOccSensor != null) {
            str = "on " + this.namedOccSensor.getBean().getDisplayName();
        }
        return "ITrack " + (String)str;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        return false;
    }

    public void displayState(String status) {
        log.debug("{} displayStatus {}", (Object)this.getNameString(), (Object)this._status);
        NamedIcon icon = this.getIcon(status);
        if (icon != null) {
            super.setIcon(icon);
        }
        this.updateSize();
    }

    @Override
    public void rotate(int deg) {
        super.rotate(deg);
        this.displayState(this._status);
    }

    @Override
    public boolean setEditItemMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("IndicatorTrack"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndicatorTrackIcon.this.editItem();
            }
        });
        return true;
    }

    protected void editItem() {
        this._paletteFrame = this.makePaletteFrame(MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("IndicatorTrack")));
        this._trackPanel = new IndicatorItemPanel(this._paletteFrame, "IndicatorTrack", this._iconFamily);
        ActionListener updateAction = a -> this.updateItem();
        HashMap<String, NamedIcon> map = new HashMap<String, NamedIcon>();
        for (Map.Entry entry : this._iconMap.entrySet()) {
            NamedIcon oldIcon = (NamedIcon)entry.getValue();
            NamedIcon newIcon = IndicatorTrackIcon.cloneIcon(oldIcon, this);
            newIcon.rotate(0, this);
            newIcon.scale(1.0, this);
            newIcon.setRotation(4, this);
            map.put((String)entry.getKey(), newIcon);
        }
        this._trackPanel.init(updateAction, map);
        if (this.namedOccSensor != null) {
            this._trackPanel.setOccDetector(this.namedOccSensor.getBean().getDisplayName());
        }
        if (this.namedOccBlock != null) {
            this._trackPanel.setOccDetector(this.namedOccBlock.getBean().getDisplayName());
        }
        this._trackPanel.setShowTrainName(this._pathUtil.showTrain());
        this._trackPanel.setPaths(this._pathUtil.getPaths());
        this.initPaletteFrame(this._paletteFrame, this._trackPanel);
    }

    private void updateItem() {
        this.setOccSensor(this._trackPanel.getOccSensor());
        this.setOccBlock(this._trackPanel.getOccBlock());
        this._pathUtil.setShowTrain(this._trackPanel.getShowTrainName());
        this._iconFamily = this._trackPanel.getFamilyName();
        this._pathUtil.setPaths(this._trackPanel.getPaths());
        HashMap<String, NamedIcon> iconMap = this._trackPanel.getIconMap();
        if (iconMap != null) {
            HashMap<String, NamedIcon> oldMap = IndicatorTrackIcon.cloneMap(this._iconMap, this);
            for (Map.Entry entry : this._iconMap.entrySet()) {
                if (log.isDebugEnabled()) {
                    log.debug("key= {}", entry.getKey());
                }
                NamedIcon newIcon = (NamedIcon)entry.getValue();
                NamedIcon oldIcon = oldMap.get(entry.getKey());
                newIcon.setLoad(oldIcon.getDegrees(), oldIcon.getScale(), this);
                newIcon.setRotation(oldIcon.getRotation(), this);
                this.setIcon((String)entry.getKey(), newIcon);
            }
        }
        this.finishItemUpdate(this._paletteFrame, this._trackPanel);
        this.displayState(this._status);
    }

    @Override
    public void dispose() {
        if (this.namedOccSensor != null) {
            this.getOccSensor().removePropertyChangeListener(this);
        }
        this.namedOccSensor = null;
        if (this.namedOccBlock != null) {
            this.getOccBlock().removePropertyChangeListener(this);
        }
        this.namedOccBlock = null;
        this._iconMap = null;
        super.dispose();
    }

    @Override
    public NamedBean getNamedBean() {
        if (this.namedOccBlock != null) {
            return this.namedOccBlock.getBean();
        }
        if (this.namedOccSensor != null) {
            return this.namedOccSensor.getBean();
        }
        return null;
    }
}

