/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.PermissionManager;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.EditorPermissions;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;

public class JmriJFrameWithPermissions
extends JmriJFrame {
    private final JPanel _hiddenPane = new JPanel();
    private Container _contentPane = new JPanel();
    private final JMenuBar _hiddenMenuBar = new JMenuBar();
    private JMenuBar _menuBar = super.getJMenuBar();
    private boolean _keepSize = true;

    public JmriJFrameWithPermissions() {
        this.setupContentPaneAndMenu();
    }

    public JmriJFrameWithPermissions(String name) {
        super(name);
        this.setupContentPaneAndMenu();
    }

    public JmriJFrameWithPermissions(String name, boolean saveSize, boolean savePosition) {
        super(name, saveSize, savePosition);
        this.setupContentPaneAndMenu();
    }

    private void setupContentPaneAndMenu() {
        this._contentPane.setLayout(new BorderLayout(){

            @Override
            public void addLayoutComponent(Component comp, Object constraints) {
                if (constraints == null) {
                    constraints = "Center";
                }
                super.addLayoutComponent(comp, constraints);
            }
        });
        if (!InstanceManager.getDefault(PermissionManager.class).isEnabled()) {
            return;
        }
        this.setGlassPane(new MyGlassPane().init());
        this._hiddenPane.setLayout(new GridBagLayout());
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        innerPanel.add(new JLabel(Bundle.getMessage("Editor_PermissionDenied")));
        innerPanel.add(Box.createVerticalStrut(5));
        innerPanel.add(new JLabel(Bundle.getMessage("Editor_LoginToViewPanel")));
        this._hiddenPane.add(innerPanel);
        this.switchContentPaneAndMenu();
        InstanceManager.getDefault(PermissionManager.class).addLoginListener(isLogin -> this.switchContentPaneAndMenu());
    }

    @Override
    public void setContentPane(Container contentPane) {
        this._contentPane = contentPane;
    }

    private void switchContentPaneAndMenu() {
        if (!InstanceManager.getDefault(PermissionManager.class).hasAtLeastPermission(EditorPermissions.EDITOR_PERMISSION, EditorPermissions.EditorPermissionEnum.View)) {
            super.getGlassPane().setVisible(false);
            super.setContentPane(this._hiddenPane);
            super.setJMenuBar(this._hiddenMenuBar);
        } else {
            super.setContentPane(this._contentPane);
            super.setJMenuBar(this._menuBar);
            super.getGlassPane().setVisible(!InstanceManager.getDefault(PermissionManager.class).hasAtLeastPermission(EditorPermissions.EDITOR_PERMISSION, EditorPermissions.EditorPermissionEnum.ViewControl));
        }
        Rectangle bounds = this.getBounds();
        this.pack();
        if (this._keepSize) {
            this.setBounds(bounds);
        } else {
            this.setLocation(bounds.x, bounds.y);
        }
        this.revalidate();
    }

    @Override
    public void revalidate() {
        if (this._contentPane != super.getContentPane()) {
            super.setContentPane(this._contentPane);
            this._contentPane.revalidate();
            super.setContentPane(this._hiddenPane);
        }
        super.revalidate();
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this._contentPane != super.getContentPane()) {
            super.setContentPane(this._contentPane);
            super.setVisible(b);
            super.setContentPane(this._hiddenPane);
        }
        super.setVisible(b);
    }

    @Override
    public Container getContentPane() {
        return this._contentPane;
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this._menuBar;
    }

    @Override
    public void setJMenuBar(JMenuBar menuBar) {
        this._menuBar = menuBar;
        this.switchContentPaneAndMenu();
    }

    public final void setKeepSize(boolean keepSize) {
        this._keepSize = keepSize;
    }

    private static class MyGlassPane
    extends JPanel
    implements JmriMouseListener,
    KeyListener {
        private MyGlassPane() {
        }

        private MyGlassPane init() {
            this.setOpaque(false);
            this.addMouseListener(JmriMouseListener.adapt(this));
            this.addKeyListener(this);
            return this;
        }

        private void showReadOnly() {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("JmriJFrameWithPermissions_PanelReadOnly"), Bundle.getMessage("JmriJFrameWithPermissions_TitleError"), 0);
        }

        @Override
        public void mouseClicked(JmriMouseEvent e) {
        }

        @Override
        public void mousePressed(JmriMouseEvent e) {
            e.consume();
            this.requestFocusInWindow();
            this.showReadOnly();
        }

        @Override
        public void mouseReleased(JmriMouseEvent e) {
        }

        @Override
        public void mouseEntered(JmriMouseEvent e) {
        }

        @Override
        public void mouseExited(JmriMouseEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.consume();
            this.showReadOnly();
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

