/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import jmri.InstanceManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.IndicatorTrack;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.TrackerTableAction;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoIcon
extends PositionableLabel {
    public static final String WHITE = Bundle.getMessage("White");
    public static final String GREEN = Bundle.getMessage("Green");
    public static final String GRAY = Bundle.getMessage("Gray");
    public static final String RED = Bundle.getMessage("Red");
    public static final String BLUE = Bundle.getMessage("Blue");
    public static final String YELLOW = Bundle.getMessage("Yellow");
    public static final Color COLOR_BLUE = new Color(40, 140, 255);
    private int _dockX = 0;
    private int _dockY = 0;
    private Color _locoColor;
    ThrottleFrame tf = null;
    ButtonGroup locoButtonGroup = null;
    NamedIcon white = new NamedIcon("resources/icons/markers/loco-white.gif", "resources/icons/markers/loco-white.gif");
    NamedIcon green = new NamedIcon("resources/icons/markers/loco-green.gif", "resources/icons/markers/loco-green.gif");
    NamedIcon gray = new NamedIcon("resources/icons/markers/loco-gray.gif", "resources/icons/markers/loco-gray.gif");
    NamedIcon red = new NamedIcon("resources/icons/markers/loco-red.gif", "resources/icons/markers/loco-red.gif");
    NamedIcon blue = new NamedIcon("resources/icons/markers/loco-blue.gif", "resources/icons/markers/loco-blue.gif");
    NamedIcon yellow = new NamedIcon("resources/icons/markers/loco-yellow.gif", "resources/icons/markers/loco-yellow.gif");
    protected RosterEntry _entry = null;
    private static final Logger log = LoggerFactory.getLogger(LocoIcon.class);

    public LocoIcon(Editor editor) {
        super(new NamedIcon("resources/icons/markers/loco-white.gif", "resources/icons/markers/loco-white.gif"), editor);
        this._locoColor = Color.WHITE;
        this.setDisplayLevel(10);
        this.setShowToolTip(false);
        this._text = true;
        this.setPopupUtility(new PositionablePopupUtil(this, this){

            @Override
            public void setFixedTextMenu(JPopupMenu popup) {
            }

            @Override
            public void setTextMarginMenu(JPopupMenu popup) {
            }

            @Override
            public void setTextBorderMenu(JPopupMenu popup) {
            }

            @Override
            public void setTextJustificationMenu(JPopupMenu popup) {
            }
        });
    }

    @Override
    public Positionable deepClone() {
        LocoIcon pos = new LocoIcon(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(LocoIcon pos) {
        if (this._entry != null) {
            pos.setRosterEntry(this.getRosterEntry());
        }
        pos.setText(this.getText());
        return super.finishClone(pos);
    }

    @Override
    public void setShowToolTip(boolean set) {
        super.setShowToolTip(false);
    }

    @Override
    public void setPositionable(boolean enabled) {
        super.setPositionable(true);
    }

    @Override
    public boolean doViemMenu() {
        return false;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this._entry != null) {
            popup.add(new AbstractAction("Throttle"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LocoIcon.this.tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame();
                    LocoIcon.this.tf.getAddressPanel().setRosterEntry(LocoIcon.this._entry);
                    LocoIcon.this.tf.toFront();
                }
            });
        }
        popup.add(this.makeLocoIconMenu());
        if (this.isEditable()) {
            this.getEditor().setShowAlignmentMenu(this, popup);
            this.getEditor().setShowCoordinatesMenu(this, popup);
            popup.add(this.makeDockingMenu());
            popup.add(this.makeDockMenu());
            this.getPopupUtility().setTextFontMenu(popup);
        } else {
            this.setRotateMenu(popup);
            if (this._entry == null) {
                this.setTextEditMenu(popup);
            }
            popup.add(this.makeDockMenu());
            this.getPopupUtility().setTextFontMenu(popup);
            this.getEditor().setRemoveMenu(this, popup);
        }
        return true;
    }

    protected JMenu makeLocoIconMenu() {
        String[] colors;
        JMenu iconMenu = new JMenu(Bundle.getMessage("LocoColor"));
        this.locoButtonGroup = new ButtonGroup();
        for (String color : colors = LocoIcon.getLocoColors()) {
            this.addLocoMenuEntry(iconMenu, color);
        }
        return iconMenu;
    }

    public void addLocoMenuEntry(JMenu iconMenu, final String color) {
        JRadioButtonMenuItem r = new JRadioButtonMenuItem(color);
        r.addActionListener(new ActionListener(){
            final String desiredColor;
            {
                this.desiredColor = color;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LocoIcon.this.setLocoColor(this.desiredColor);
            }
        });
        this.locoButtonGroup.add(r);
        iconMenu.add(r);
    }

    public void setLocoColor(String color) {
        log.debug("Set loco color to {}", (Object)color);
        if (color.equals(WHITE)) {
            super.updateIcon(this.white);
            this._locoColor = Color.WHITE;
            this.setForeground(Color.black);
        }
        if (color.equals(GREEN)) {
            super.updateIcon(this.green);
            this._locoColor = Color.GREEN;
            this.setForeground(Color.black);
        }
        if (color.equals(GRAY)) {
            super.updateIcon(this.gray);
            this._locoColor = Color.GRAY;
            this.setForeground(Color.white);
        }
        if (color.equals(RED)) {
            super.updateIcon(this.red);
            this._locoColor = Color.RED;
            this.setForeground(Color.white);
        }
        if (color.equals(BLUE)) {
            super.updateIcon(this.blue);
            this._locoColor = COLOR_BLUE;
            this.setForeground(Color.white);
        }
        if (color.equals(YELLOW)) {
            super.updateIcon(this.yellow);
            this._locoColor = Color.YELLOW;
            this.setForeground(Color.black);
        }
    }

    public static String[] getLocoColors() {
        return new String[]{WHITE, GREEN, GRAY, RED, BLUE, YELLOW};
    }

    public Color getLocoColor() {
        return this._locoColor;
    }

    public void setRosterEntry(RosterEntry entry) {
        this._entry = entry;
    }

    public RosterEntry getRosterEntry() {
        return this._entry;
    }

    protected JMenuItem makeDockingMenu() {
        JMenuItem dockingMenu = new JMenuItem(Bundle.getMessage("setDockingLocation"));
        dockingMenu.addActionListener(new ActionListener(){
            Editor ed;
            LocoIcon loco;

            ActionListener init(Editor e, LocoIcon l) {
                this.ed = e;
                this.loco = l;
                return this;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.ed.setSelectionsDockingLocation(this.loco);
            }
        }.init(this.getEditor(), this));
        return dockingMenu;
    }

    public void setDockingLocation(int x, int y) {
        this._dockX = x;
        this._dockY = y;
    }

    public int getDockX() {
        return this._dockX;
    }

    public int getDockY() {
        return this._dockY;
    }

    public void dock() {
        this.setLocation(this._dockX, this._dockY);
    }

    protected JMenuItem makeDockMenu() {
        JMenuItem dockMenu = new JMenuItem(Bundle.getMessage("dockIcon"));
        dockMenu.addActionListener(new ActionListener(){
            Editor ed;
            LocoIcon loco;

            ActionListener init(Editor e, LocoIcon l) {
                this.ed = e;
                this.loco = l;
                return this;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.ed.dockSelections(this.loco);
            }
        }.init(this.getEditor(), this));
        return dockMenu;
    }

    public void init() {
        NamedIcon icon = (NamedIcon)this.getIcon();
        String name = icon.getURL();
        if (name != null) {
            if (name.endsWith("loco-white.gif")) {
                this._locoColor = Color.WHITE;
            } else if (name.endsWith("loco-green.gif")) {
                this._locoColor = Color.GREEN;
            } else if (name.endsWith("loco-gray.gif")) {
                this._locoColor = Color.GRAY;
            } else if (name.endsWith("loco-red.gif")) {
                this._locoColor = Color.RED;
            } else if (name.endsWith("loco-blue.gif")) {
                this._locoColor = COLOR_BLUE;
            } else if (name.endsWith("loco-yellow.gif")) {
                this._locoColor = Color.YELLOW;
            }
        }
    }

    @Override
    public void doMouseReleased(JmriMouseEvent event) {
        List<Positionable> selections = this._editor.getSelectedItems(event);
        for (Positionable selection : selections) {
            if (!(selection instanceof IndicatorTrack)) continue;
            IndicatorTrack t = (IndicatorTrack)selection;
            OBlock block = t.getOccBlock();
            if (block == null) break;
            block.setMarkerForeground(this.getForeground());
            block.setMarkerBackground(this._locoColor);
            PositionablePopupUtil util = this.getPopupUtility();
            block.setMarkerFont(util.getFont());
            String name = this.getText();
            if (name == null || name.length() == 0) {
                name = this.getUnRotatedText();
            }
            InstanceManager.getDefault(TrackerTableAction.class).markNewTracker(block, name, this);
            this.dock();
            break;
        }
    }
}

