/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.logixng.LogixNG;

public class LogixNGDeleteDialog
extends JDialog {
    private JLabel label;
    private JList<CheckableItem> itemList;
    private DefaultListModel<CheckableItem> listModel;
    private JCheckBox selectAllCheckBox;
    private JCheckBox disableCheckBox;
    private JButton okButton;
    private List<CheckableItem> selectedItems;
    private boolean isSelectAllChecked = false;

    public LogixNGDeleteDialog(Frame owner, String panelName, List<LogixNG> items) {
        super(owner, Bundle.getMessage("LogixNGDeleteDialog_Title"), true);
        this.initComponents(panelName, items);
        this.layoutComponents();
        this.addEventHandlers();
        this.selectedItems = new ArrayList<CheckableItem>();
    }

    private void initComponents(String panelName, List<LogixNG> items) {
        this.label = new JLabel(Bundle.getMessage("LogixNGDeleteDialog_PanelText", panelName));
        this.listModel = new DefaultListModel();
        for (LogixNG item : items) {
            this.listModel.addElement(new CheckableItem(item));
        }
        this.itemList = new JList<CheckableItem>(this.listModel);
        this.itemList.setCellRenderer(new CheckboxListCellRenderer());
        this.itemList.setSelectionMode(2);
        this.selectAllCheckBox = new JCheckBox(Bundle.getMessage("LogixNGDeleteDialog_SelectCheckBox"));
        this.disableCheckBox = new JCheckBox(Bundle.getMessage("LogixNGDeleteDialog_DisableCheckBox"));
        this.okButton = new JButton(Bundle.getMessage("ButtonOK"));
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void layoutComponents() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)this.label, "North");
        headerPanel.add(this.itemList, "Center");
        headerPanel.add((Component)this.selectAllCheckBox, "South");
        contentPanel.add((Component)headerPanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.itemList);
        contentPanel.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.okButton);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)this.disableCheckBox, "North");
        southPanel.add((Component)buttonPanel, "South");
        contentPanel.add((Component)southPanel, "South");
        this.setContentPane(contentPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void addEventHandlers() {
        this.selectAllCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogixNGDeleteDialog.this.isSelectAllChecked = e.getStateChange() == 1;
                for (int i = 0; i < LogixNGDeleteDialog.this.listModel.getSize(); ++i) {
                    LogixNGDeleteDialog.this.listModel.getElementAt(i).setSelected(LogixNGDeleteDialog.this.isSelectAllChecked);
                }
                LogixNGDeleteDialog.this.itemList.repaint();
            }
        });
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedIndex;
                if (!e.getValueIsAdjusting() && (selectedIndex = LogixNGDeleteDialog.this.itemList.getSelectedIndex()) != -1) {
                    CheckableItem selectedItem;
                    selectedItem.setSelected(!(selectedItem = LogixNGDeleteDialog.this.listModel.getElementAt(selectedIndex)).isSelected());
                    LogixNGDeleteDialog.this.listModel.setElementAt(selectedItem, selectedIndex);
                    LogixNGDeleteDialog.this.itemList.repaint();
                    LogixNGDeleteDialog.this.updateSelectAllCheckbox();
                }
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogixNGDeleteDialog.this.selectedItems.clear();
                for (int i = 0; i < LogixNGDeleteDialog.this.listModel.getSize(); ++i) {
                    CheckableItem item = LogixNGDeleteDialog.this.listModel.getElementAt(i);
                    if (!item.isSelected()) continue;
                    LogixNGDeleteDialog.this.selectedItems.add(item);
                }
                LogixNGDeleteDialog.this.setVisible(false);
            }
        });
    }

    private void updateSelectAllCheckbox() {
        boolean allSelected = true;
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (this.listModel.getElementAt(i).isSelected()) continue;
            allSelected = false;
            break;
        }
        this.selectAllCheckBox.setSelected(allSelected);
        this.isSelectAllChecked = allSelected;
    }

    public List<LogixNG> getSelectedItems() {
        ArrayList<LogixNG> selections = new ArrayList<LogixNG>();
        for (CheckableItem item : this.selectedItems) {
            selections.add(item.getLogixNG());
        }
        return selections;
    }

    public boolean isDisableLogixNG() {
        return this.disableCheckBox.isSelected();
    }

    private static class CheckboxListCellRenderer
    extends JPanel
    implements ListCellRenderer<CheckableItem> {
        private JCheckBox checkBox;

        public CheckboxListCellRenderer() {
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox();
            this.checkBox.setMargin(new Insets(0, 0, 0, 0));
            this.add((Component)this.checkBox, "Center");
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends CheckableItem> list, CheckableItem value, int index, boolean isSelected, boolean cellHasFocus) {
            this.checkBox.setText(value.getLogixNG().getDisplayName());
            this.checkBox.setSelected(value.isSelected());
            this.checkBox.setEnabled(list.isEnabled());
            this.checkBox.setFont(list.getFont());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    public static class CheckableItem {
        private LogixNG logixNG;
        private boolean isSelected;

        public CheckableItem(LogixNG logixNG) {
            this.logixNG = logixNG;
            this.isSelected = false;
        }

        public LogixNG getLogixNG() {
            return this.logixNG;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean selected) {
            this.isSelected = selected;
        }

        public String toString() {
            return this.logixNG.getDisplayName();
        }
    }
}

