/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.logixng.LogixNG;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixNGIcon
extends PositionableLabel {
    public static final IdentityManager IDENTITY_MANAGER = new IdentityManager();
    private final int _identity;
    private NamedIcon _originalIcon = new NamedIcon("resources/icons/logixng/logixng_icon.gif", "resources/icons/logixng/logixng_icon.gif");
    private String _originalText = Bundle.getMessage("LogixNGIcon_Text");
    private static final Logger log = LoggerFactory.getLogger(LogixNGIcon.class);

    public LogixNGIcon(String s, @Nonnull Editor editor) {
        super(s, editor);
        this._identity = IDENTITY_MANAGER.getIdentity(this);
        this._originalText = s;
    }

    public LogixNGIcon(int identity, String s, @Nonnull Editor editor) {
        super(s, editor);
        this._identity = IDENTITY_MANAGER.getIdentity(identity, this);
        this._originalText = s;
    }

    public LogixNGIcon(@CheckForNull NamedIcon s, @Nonnull Editor editor) {
        super(s, editor);
        this._identity = IDENTITY_MANAGER.getIdentity(this);
        this._originalIcon = this._namedIcon;
    }

    public LogixNGIcon(int identity, @CheckForNull NamedIcon s, @Nonnull Editor editor) {
        super(s, editor);
        this._identity = IDENTITY_MANAGER.getIdentity(identity, this);
        this._originalIcon = this._namedIcon;
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_LogixNGIcon");
    }

    public int getIdentity() {
        return this._identity;
    }

    @Override
    protected void editIcon() {
        super.editIcon();
        this._originalIcon = this._namedIcon;
    }

    @Override
    public void doMousePressed(JmriMouseEvent e) {
        log.debug("doMousePressed");
        if (!e.isMetaDown() && !e.isAltDown()) {
            this.executeLogixNG();
        }
        super.doMousePressed(e);
    }

    public void executeLogixNG() {
        LogixNG logixNG = this.getLogixNG();
        if (logixNG != null) {
            for (int i = 0; i < logixNG.getNumConditionalNGs(); ++i) {
                logixNG.getConditionalNG(i).execute();
            }
        }
    }

    private void changeLogixNGIconType() {
        this._unRotatedText = null;
        if (this.isIcon()) {
            this._icon = false;
            this._text = true;
            this.setText(this._originalText);
            this.setIcon(null);
            this.setOpaque(true);
        } else if (this.isText()) {
            this._icon = true;
            if (this.getText() != null) {
                this._originalText = this.getText();
            }
            this._text = false;
            this.setText(null);
            this.setUnRotatedText(null);
            this.setOpaque(false);
            this.setIcon(this._originalIcon);
        }
        int deg = this.getDegrees();
        this.rotate(deg);
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this.isEditable()) {
            if (this.isIcon()) {
                popup.add(new AbstractAction(Bundle.getMessage("ChangeToText")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LogixNGIcon.this.changeLogixNGIconType();
                    }
                });
            } else {
                popup.add(new AbstractAction(Bundle.getMessage("ChangeToIcon")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LogixNGIcon.this.changeLogixNGIconType();
                    }
                });
            }
        }
        return true;
    }

    public static class IdentityManager {
        Map<Integer, LogixNGIcon> _identities = new HashMap<Integer, LogixNGIcon>();
        int _lastIdentity = -1;

        private IdentityManager() {
        }

        public int getIdentity(LogixNGIcon logixNGIcon) {
            ++this._lastIdentity;
            this._identities.put(this._lastIdentity, logixNGIcon);
            return this._lastIdentity;
        }

        public int getIdentity(int identity, LogixNGIcon logixNGIcon) {
            if (this._identities.containsKey(identity)) {
                log.error("Identity {} already exists", (Object)identity);
                return this.getIdentity(logixNGIcon);
            }
            this._identities.put(identity, logixNGIcon);
            if (identity > this._lastIdentity) {
                this._lastIdentity = identity;
            }
            return identity;
        }

        public LogixNGIcon getLogixNGIcon(int identity) {
            return this._identities.get(identity);
        }
    }
}

