/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.IconAdder;
import jmri.jmrit.display.MemoryOrGVComboIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.swing.JmriMouseMotionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryComboIcon
extends MemoryOrGVComboIcon
implements PropertyChangeListener,
ActionListener {
    private final JComboBox<String> _comboBox;
    private final MemoryOrGVComboIcon.ComboModel _model;
    private NamedBeanHandle<Memory> namedMemory;
    private final MouseListener _mouseListener = JmriMouseListener.adapt(this);
    private final MouseMotionListener _mouseMotionListener = JmriMouseMotionListener.adapt(this);
    private DefaultListModel<String> _listModel;
    private static final Logger log = LoggerFactory.getLogger(MemoryComboIcon.class);

    public MemoryComboIcon(Editor editor, String[] list) {
        super(editor);
        this._model = list != null ? new MemoryOrGVComboIcon.ComboModel(this, list) : new MemoryOrGVComboIcon.ComboModel(this);
        this._comboBox = new JComboBox<String>(this._model);
        this._comboBox.addActionListener(this);
        this.setDisplayLevel(4);
        this.setLayout(new GridBagLayout());
        this.add(this._comboBox);
        this._comboBox.addMouseListener(JmriMouseListener.adapt(this));
        for (int i = 0; i < this._comboBox.getComponentCount(); ++i) {
            Component component = this._comboBox.getComponent(i);
            if (!(component instanceof AbstractButton)) continue;
            component.addMouseListener(this._mouseListener);
            component.addMouseMotionListener(this._mouseMotionListener);
        }
        this.setPopupUtility(new PositionablePopupUtil(this, this._comboBox));
    }

    @Override
    public JComboBox<String> getTextComponent() {
        return this._comboBox;
    }

    @Override
    public Positionable deepClone() {
        String[] list = new String[this._model.getSize()];
        for (int i = 0; i < this._model.getSize(); ++i) {
            list[i] = (String)this._model.getElementAt(i);
        }
        MemoryComboIcon pos = new MemoryComboIcon(this._editor, list);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(MemoryComboIcon pos) {
        pos.setMemory(this.namedMemory.getName());
        return super.finishClone(pos);
    }

    public void setMemory(String pName) {
        log.debug("setMemory for memory= {}", (Object)pName);
        if (InstanceManager.getNullableDefault(MemoryManager.class) != null) {
            try {
                Memory memory = InstanceManager.memoryManagerInstance().provideMemory(pName);
                this.setMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, memory));
            }
            catch (IllegalArgumentException e) {
                log.error("No MemoryManager for this protocol, icon won't see changes");
            }
        }
        this.updateSize();
    }

    public void setMemory(NamedBeanHandle<Memory> m) {
        if (this.namedMemory != null) {
            this.getMemory().removePropertyChangeListener(this);
        }
        this.namedMemory = m;
        if (this.namedMemory != null) {
            this.getMemory().addPropertyChangeListener(this, this.namedMemory.getName(), "Memory Input Icon");
            this.displayState();
            this.setName(this.namedMemory.getName());
        }
    }

    public NamedBeanHandle<Memory> getNamedMemory() {
        return this.namedMemory;
    }

    public Memory getMemory() {
        if (this.namedMemory == null) {
            return null;
        }
        return this.namedMemory.getBean();
    }

    @Override
    public MemoryOrGVComboIcon.ComboModel getComboModel() {
        return this._model;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.update();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("value")) {
            this.displayState();
        }
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_MemoryComboIcon");
    }

    @Override
    public String getNameString() {
        String name = this.namedMemory == null ? Bundle.getMessage("NotConnected") : this.getMemory().getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    @Override
    protected void update() {
        if (this.namedMemory == null) {
            return;
        }
        this.getMemory().setValue(this._comboBox.getSelectedItem());
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameMemory"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryComboIcon.this.edit();
            }
        });
        return true;
    }

    @Override
    protected void edit() {
        this._iconEditor = new IconAdder("Memory"){
            JList<String> list;
            final JButton bDel;
            final JButton bAdd;
            final JTextField textfield;
            int idx;
            {
                this.bDel = new JButton(Bundle.getMessage("deleteSelection"));
                this.bAdd = new JButton(Bundle.getMessage("addItem"));
                this.textfield = new JTextField(30);
            }

            @Override
            protected void addAdditionalButtons(JPanel p) {
                MemoryComboIcon.this._listModel = new DefaultListModel();
                this.bDel.addActionListener(a -> {
                    if (this.list == null) {
                        return;
                    }
                    this.idx = this.list.getSelectedIndex();
                    if (this.idx >= 0) {
                        MemoryComboIcon.this._listModel.removeElementAt(this.idx);
                    }
                });
                this.bAdd.addActionListener(a -> {
                    String text = this.textfield.getText();
                    if (text == null || this.list == null || text.length() == 0 || MemoryComboIcon.this._listModel.indexOf(text) >= 0) {
                        return;
                    }
                    this.idx = this.list.getSelectedIndex();
                    if (this.idx < 0) {
                        this.idx = MemoryComboIcon.this._listModel.getSize();
                    }
                    MemoryComboIcon.this._listModel.add(this.idx, text);
                });
                for (int i = 0; i < MemoryComboIcon.this._model.getSize(); ++i) {
                    MemoryComboIcon.this._listModel.add(i, (String)MemoryComboIcon.this._model.getElementAt(i));
                }
                this.list = new JList<String>(MemoryComboIcon.this._listModel);
                JScrollPane scrollPane = new JScrollPane(this.list);
                JPanel p1 = new JPanel();
                p1.add(new JLabel(Bundle.getMessage("comboList")));
                p.add(p1);
                p.add(scrollPane);
                p1 = new JPanel();
                JPanel pInner1 = new JPanel();
                pInner1.setLayout(new BoxLayout(pInner1, 0));
                pInner1.add(new JLabel(Bundle.getMessage("newItem"), 4));
                pInner1.add(this.textfield);
                p1.add(pInner1);
                p.add(p1);
                JPanel p2 = new JPanel();
                p2.add(this.bDel);
                p2.add(this.bAdd);
                p.add(p2);
                p.setVisible(true);
            }
        };
        this.makeIconEditorFrame(this, "Memory", true, this._iconEditor);
        this._iconEditor.setPickList(PickListModel.memoryPickModelInstance());
        ActionListener addIconAction = a -> this.editMemory();
        this._iconEditor.makeIconPanel(false);
        this._iconEditor.complete(addIconAction, false, true, true);
        this._iconEditor.setSelection(this.getMemory());
    }

    void editMemory() {
        NamedBean bean = this._iconEditor.getTableSelection();
        this.setMemory(bean.getDisplayName());
        this._model.removeAllElements();
        for (int i = 0; i < this._listModel.size(); ++i) {
            this._model.addElement(this._listModel.getElementAt(i));
        }
        this.setSize(this.getPreferredSize().width + 1, this.getPreferredSize().height);
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.validate();
    }

    public void displayState() {
        log.debug("displayState");
        if (this.namedMemory == null) {
            return;
        }
        this._model.setSelectedItem(this.getMemory().getValue());
    }

    @Override
    public void mouseExited(JmriMouseEvent e) {
        this._comboBox.setFocusable(false);
        this._comboBox.transferFocus();
        super.mouseExited(e);
    }

    @Override
    void cleanup() {
        if (this.namedMemory != null) {
            this.getMemory().removePropertyChangeListener(this);
        }
        if (this._comboBox != null) {
            for (int i = 0; i < this._comboBox.getComponentCount(); ++i) {
                Component component = this._comboBox.getComponent(i);
                if (!(component instanceof AbstractButton)) continue;
                component.removeMouseListener(this._mouseListener);
                component.removeMouseMotionListener(this._mouseMotionListener);
            }
            this._comboBox.removeMouseListener(this._mouseListener);
        }
        this.namedMemory = null;
    }
}

