/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import jmri.IdTag;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Reportable;
import jmri.SectionManager;
import jmri.Throttle;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.MemoryOrGVIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.picker.PickListModel;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterIconFactory;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.util.datatransfer.RosterEntrySelection;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryIcon
extends MemoryOrGVIcon
implements PropertyChangeListener {
    NamedIcon defaultIcon = null;
    HashMap<String, NamedIcon> map = null;
    private NamedBeanHandle<Memory> namedMemory;
    boolean selectable = false;
    Color _saveColor;
    protected RosterEntry re = null;
    static final int LEFT = 0;
    static final int RIGHT = 2;
    static final int CENTRE = 4;
    private int originalX = 0;
    private int originalY = 0;
    protected boolean updateBlockValue = false;
    protected boolean flipRosterIcon = false;
    private static final Logger log = LoggerFactory.getLogger(MemoryIcon.class);

    public MemoryIcon(String s, Editor editor) {
        super(s, editor);
        this.resetDefaultIcon();
        this._namedIcon = this.defaultIcon;
        this._popupUtil.setJustification(0);
        this.setTransferHandler(new TransferHandler());
    }

    public MemoryIcon(NamedIcon s, Editor editor) {
        super(s, editor);
        this.setDisplayLevel(4);
        this.defaultIcon = s;
        this._popupUtil.setJustification(0);
        log.debug("MemoryIcon ctor= {}", (Object)MemoryIcon.class.getName());
        this.setTransferHandler(new TransferHandler());
    }

    @Override
    public Positionable deepClone() {
        MemoryIcon pos = new MemoryIcon("", this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(MemoryIcon pos) {
        pos.setMemory(this.namedMemory.getName());
        pos.setOriginalLocation(this.getOriginalX(), this.getOriginalY());
        if (this.map != null) {
            for (Map.Entry<String, NamedIcon> entry : this.map.entrySet()) {
                String url = entry.getValue().getName();
                pos.addKeyAndIcon(NamedIcon.getIconByName(url), entry.getKey());
            }
        }
        return super.finishClone(pos);
    }

    public void resetDefaultIcon() {
        this.defaultIcon = new NamedIcon("resources/icons/misc/X-red.gif", "resources/icons/misc/X-red.gif");
    }

    public void setDefaultIcon(NamedIcon n) {
        this.defaultIcon = n;
    }

    public NamedIcon getDefaultIcon() {
        return this.defaultIcon;
    }

    private void setMap() {
        if (this.map == null) {
            this.map = new HashMap();
        }
    }

    public void setMemory(String pName) {
        if (InstanceManager.getNullableDefault(MemoryManager.class) != null) {
            try {
                Memory memory = InstanceManager.memoryManagerInstance().provideMemory(pName);
                this.setMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, memory));
            }
            catch (IllegalArgumentException e) {
                log.error("Memory '{}' not available, icon won't see changes", (Object)pName);
            }
        } else {
            log.error("No MemoryManager for this protocol, icon won't see changes");
        }
        this.updateSize();
    }

    public void setMemory(NamedBeanHandle<Memory> m) {
        if (this.namedMemory != null) {
            this.getMemory().removePropertyChangeListener(this);
        }
        this.namedMemory = m;
        if (this.namedMemory != null) {
            this.getMemory().addPropertyChangeListener(this, this.namedMemory.getName(), "Memory Icon");
            this.displayState();
            this.setName(this.namedMemory.getName());
        }
    }

    public NamedBeanHandle<Memory> getNamedMemory() {
        return this.namedMemory;
    }

    public Memory getMemory() {
        if (this.namedMemory == null) {
            return null;
        }
        return this.namedMemory.getBean();
    }

    @Override
    public NamedBean getNamedBean() {
        return this.getMemory();
    }

    public HashMap<String, NamedIcon> getMap() {
        return this.map;
    }

    public void addKeyAndIcon(NamedIcon icon, String keyValue) {
        if (this.map == null) {
            this.setMap();
        }
        this.map.put(keyValue, icon);
        this.displayState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("property change: {} is now {}", (Object)e.getPropertyName(), e.getNewValue());
        }
        if (e.getPropertyName().equals("value")) {
            this.displayState();
        }
        if (e.getSource() instanceof Throttle && e.getPropertyName().equals("IsForward")) {
            Boolean boo = (Boolean)e.getNewValue();
            if (boo.booleanValue()) {
                this.flipIcon(0);
            } else {
                this.flipIcon(1);
            }
        }
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_MemoryIcon");
    }

    @Override
    public String getNameString() {
        String name = this.namedMemory == null ? Bundle.getMessage("NotConnected") : this.getMemory().getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    public void setSelectable(boolean b) {
        this.selectable = b;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this.isEditable() && this.selectable) {
            popup.add(new JSeparator());
            for (String key : this.map.keySet()) {
                popup.add(new AbstractAction(key){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String key = e.getActionCommand();
                        MemoryIcon.this.setValue(key);
                    }
                });
            }
            return true;
        }
        if (this.re != null) {
            DispatcherFrame df;
            popup.add(new AbstractAction(Bundle.getMessage("OpenThrottle")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ThrottleFrame tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame();
                    tf.toFront();
                    tf.getAddressPanel().setRosterEntry(MemoryIcon.this.re);
                }
            });
            if (InstanceManager.getDefault(SectionManager.class).getNamedBeanSet().size() > 0 && InstanceManager.getDefault(LayoutBlockManager.class).getBlockWithMemoryAssigned(this.getMemory()) != null && (df = InstanceManager.getNullableDefault(DispatcherFrame.class)) != null) {
                final ActiveTrain at = df.getActiveTrainForRoster(this.re);
                if (at != null) {
                    popup.add(new AbstractAction(Bundle.getMessage("MenuTerminateTrain")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            df.terminateActiveTrain(at, true, false);
                        }
                    });
                    popup.add(new AbstractAction(Bundle.getMessage("MenuAllocateExtra")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            df.allocateExtraSection(e, at);
                        }
                    });
                    if (at.getStatus() == 64) {
                        popup.add(new AbstractAction(Bundle.getMessage("MenuRestartTrain")){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                at.allocateAFresh();
                            }
                        });
                    }
                } else {
                    popup.add(new AbstractAction(Bundle.getMessage("MenuNewTrain")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutBlock lBlock = InstanceManager.getDefault(LayoutBlockManager.class).getBlockWithMemoryAssigned(MemoryIcon.this.getMemory());
                            if (!df.getNewTrainActive() && lBlock != null) {
                                df.getActiveTrainFrame().initiateTrain(e, MemoryIcon.this.re, lBlock.getBlock());
                                df.setNewTrainActive(true);
                            } else {
                                df.getActiveTrainFrame().showActivateFrame(MemoryIcon.this.re);
                            }
                        }
                    });
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setTextEditMenu(JPopupMenu popup) {
        popup.add(new AbstractAction(Bundle.getMessage("EditMemoryValue")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryIcon.this.editMemoryValue();
            }
        });
        return true;
    }

    protected void flipIcon(int flip) {
        if (this._namedIcon != null) {
            this._namedIcon.flip(flip, this);
        }
        this.updateSize();
        this.repaint();
    }

    @Override
    public void displayState() {
        log.debug("displayState()");
        if (this.namedMemory == null) {
            this.setIcon(this.defaultIcon);
            this.updateSize();
            return;
        }
        if (this.re != null) {
            InstanceManager.throttleManagerInstance().removeListener(this.re.getDccLocoAddress(), this);
            this.re = null;
        }
        Object key = this.getMemory().getValue();
        this.displayState(key);
    }

    public void setAttributes(PositionablePopupUtil util, Positionable that) {
        this._editor.setAttributes(util, that);
    }

    protected void displayState(Object key) {
        log.debug("displayState({})", key);
        if (key != null) {
            if (this.map == null) {
                Object val = key;
                if (val instanceof RosterEntry) {
                    RosterEntry roster = (RosterEntry)val;
                    val = this.updateIconFromRosterVal(roster);
                    this.flipRosterIcon = false;
                    if (val == null) {
                        return;
                    }
                }
                if (val instanceof String) {
                    String str = (String)val;
                    this._icon = false;
                    this.setIcon(null);
                    this.setText(str);
                    this._text = true;
                    if (log.isDebugEnabled()) {
                        log.debug("String str= \"{}\" str.trim().length()= {}", (Object)str, (Object)str.trim().length());
                        log.debug("  maxWidth()= {}, maxHeight()= {}", (Object)this.maxWidth(), (Object)this.maxHeight());
                        log.debug("  getBackground(): {}", (Object)this.getBackground());
                        log.debug("  _editor.getTargetPanel().getBackground(): {}", (Object)this._editor.getTargetPanel().getBackground());
                        log.debug("  setAttributes to getPopupUtility({}) with", (Object)this.getPopupUtility());
                        log.debug("     hasBackground() {}", (Object)this.getPopupUtility().hasBackground());
                        log.debug("     getBackground() {}", (Object)this.getPopupUtility().getBackground());
                        log.debug("    on editor {}", (Object)this._editor);
                    }
                    this._editor.setAttributes(this.getPopupUtility(), this);
                } else if (val instanceof ImageIcon) {
                    this._icon = true;
                    this._text = false;
                    this.setIcon((ImageIcon)val);
                    this.setText(null);
                } else if (val instanceof Number) {
                    this._icon = false;
                    this.setIcon(null);
                    this.setText(val.toString());
                    this._text = true;
                    this._editor.setAttributes(this.getPopupUtility(), this);
                } else if (val instanceof IdTag) {
                    this._icon = false;
                    this._text = true;
                    this.setIcon(null);
                    this.setText(((IdTag)val).getDisplayName());
                } else if (val instanceof Reportable) {
                    this._icon = false;
                    this._text = true;
                    this.setText(((Reportable)val).toReportString());
                    this.setIcon(null);
                } else {
                    log.debug("display current value of {} as String, val= {} of Class {}", new Object[]{this.getNameString(), val, val.getClass().getName()});
                    this._icon = false;
                    this._text = true;
                    this.setIcon(null);
                    this.setText(val.toString());
                }
            } else {
                NamedIcon newicon = this.map.get(key.toString());
                if (newicon != null) {
                    this.setText(null);
                    super.setIcon(newicon);
                } else {
                    this._icon = true;
                    this._text = false;
                    this.setIcon(this.defaultIcon);
                    this.setText(null);
                }
            }
        } else {
            log.debug("object null");
            this._icon = true;
            this.setIcon(this.defaultIcon);
            this.setText(null);
            this._text = false;
            this._editor.setAttributes(this.getPopupUtility(), this);
        }
        this.updateSize();
    }

    protected Object updateIconFromRosterVal(RosterEntry roster) {
        this.re = roster;
        ImageIcon icon = InstanceManager.getDefault(RosterIconFactory.class).getIcon(roster);
        if (icon == null || icon.getIconWidth() == -1 || icon.getIconHeight() == -1) {
            return roster.titleString();
        }
        NamedIcon rosterIcon = new NamedIcon(roster.getIconPath(), roster.getIconPath());
        this._text = false;
        this._icon = true;
        this.updateIcon(rosterIcon);
        if (this.flipRosterIcon) {
            this.flipIcon(1);
        }
        InstanceManager.throttleManagerInstance().attachListener(this.re.getDccLocoAddress(), this);
        Object isForward = InstanceManager.throttleManagerInstance().getThrottleInfo(this.re.getDccLocoAddress(), "IsForward");
        if (isForward != null && !((Boolean)isForward).booleanValue()) {
            this.flipIcon(1);
        }
        return null;
    }

    @Override
    public void updateSize() {
        if (this._popupUtil.getFixedWidth() == 0) {
            switch (this._popupUtil.getJustification()) {
                case 0: {
                    super.setLocation(this.getOriginalX(), this.getOriginalY());
                    break;
                }
                case 2: {
                    super.setLocation(this.getOriginalX() - this.maxWidth(), this.getOriginalY());
                    break;
                }
                case 4: {
                    super.setLocation(this.getOriginalX() - this.maxWidth() / 2, this.getOriginalY());
                    break;
                }
                default: {
                    log.warn("Unhandled justification code: {}", (Object)this._popupUtil.getJustification());
                }
            }
            this.setSize(this.maxWidth(), this.maxHeight());
            this.setPreferredSize(new Dimension(this.maxWidth(), this.maxHeight()));
        } else {
            super.updateSize();
            if (this._icon && this._namedIcon != null) {
                this._namedIcon.reduceTo(this.maxWidthTrue(), this.maxHeightTrue(), 0.2);
            }
        }
    }

    public void setOriginalLocation(int x, int y) {
        this.originalX = x;
        this.originalY = y;
        this.updateSize();
    }

    @Override
    public int getOriginalX() {
        return this.originalX;
    }

    @Override
    public int getOriginalY() {
        return this.originalY;
    }

    @Override
    public void setLocation(int x, int y) {
        if (this._popupUtil.getFixedWidth() == 0) {
            this.setOriginalLocation(x, y);
        } else {
            super.setLocation(x, y);
        }
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameMemory"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryIcon.this.edit();
            }
        });
        return true;
    }

    @Override
    protected void edit() {
        this.makeIconEditorFrame(this, "Memory", true, null);
        this._iconEditor.setPickList(PickListModel.memoryPickModelInstance());
        ActionListener addIconAction = a -> this.editMemory();
        this._iconEditor.complete(addIconAction, false, true, true);
        this._iconEditor.setSelection(this.getMemory());
    }

    void editMemory() {
        this.setMemory(this._iconEditor.getTableSelection().getDisplayName());
        this.updateSize();
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.invalidate();
    }

    @Override
    public void dispose() {
        if (this.getMemory() != null) {
            this.getMemory().removePropertyChangeListener(this);
        }
        this.namedMemory = null;
        if (this.re != null) {
            InstanceManager.throttleManagerInstance().removeListener(this.re.getDccLocoAddress(), this);
            this.re = null;
        }
        super.dispose();
    }

    @Override
    public void doMouseClicked(JmriMouseEvent e) {
        if (e.getClickCount() == 2) {
            if (!this.getEditor().isEditable() && this.isValueEditDisabled()) {
                log.debug("Double click memory value edit is disabled");
                return;
            }
            this.editMemoryValue();
        }
    }

    protected void editMemoryValue() {
        String reval = (String)JmriJOptionPane.showInputDialog((Component)this, Bundle.getMessage("EditCurrentMemoryValue", this.namedMemory.getName()), this.getMemory().getValue());
        this.setValue(reval);
        this.updateSize();
    }

    public void updateBlockValueOnChange(boolean boo) {
        this.updateBlockValue = boo;
    }

    public boolean updateBlockValueOnChange() {
        return this.updateBlockValue;
    }

    protected void addRosterToIcon(RosterEntry roster) {
        Object[] options = new Object[]{"Facing West", "Facing East", "Do Not Add"};
        int n = JmriJOptionPane.showOptionDialog(this, "Would you like to assign loco " + roster.titleString() + " to this location", "Assign Loco", -1, 3, null, options, options[2]);
        if (n == 2 || n == -1) {
            return;
        }
        boolean bl = this.flipRosterIcon = n == 0;
        if (this.getValue() == roster) {
            this.updateIconFromRosterVal(roster);
        } else {
            this.setValue(roster);
        }
    }

    protected Object getValue() {
        if (this.getMemory() == null) {
            return null;
        }
        return this.getMemory().getValue();
    }

    protected void setValue(Object val) {
        this.getMemory().setValue(val);
    }

    class TransferHandler
    extends javax.swing.TransferHandler {
        TransferHandler() {
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] transferFlavors) {
            for (DataFlavor flavor : transferFlavors) {
                if (!RosterEntrySelection.rosterEntryFlavor.equals(flavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(JComponent c, Transferable t) {
            try {
                ArrayList<RosterEntry> REs = RosterEntrySelection.getRosterEntries(t);
                for (RosterEntry roster : REs) {
                    MemoryIcon.this.addRosterToIcon(roster);
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                log.error("Could not add a RosterEntry to Icon.", (Throwable)e);
            }
            return true;
        }
    }
}

