/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.CoordinateEdit;
import jmri.jmrit.display.MemoryOrGVIcon;

public class MemoryIconCoordinateEdit
extends CoordinateEdit {
    MemoryOrGVIcon pl;
    int oldX;
    int oldY;
    double oldD;
    String oldStr;

    public void init(String title, MemoryOrGVIcon pos, boolean showName) {
        super.init(title, pos, showName);
        this.pl = pos;
    }

    public static AbstractAction getCoordinateEditAction(final MemoryOrGVIcon pos) {
        return new AbstractAction(Bundle.getMessage("SetXY", "")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryIconCoordinateEdit f = new MemoryIconCoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage("SetXY", ""), pos, true);
                f.initSetXY();
                f.setVisible(true);
                f.setLocationRelativeTo(pos);
            }
        };
    }

    @Override
    public void initSetXY() {
        this.oldX = this.pl.getOriginalX();
        this.oldY = this.pl.getOriginalY();
        this.textX = new JLabel();
        this.textX.setText("X: " + this.pl.getOriginalX());
        this.textX.setVisible(true);
        this.textY = new JLabel();
        this.textY.setText("Y: " + this.pl.getOriginalY());
        this.textY.setVisible(true);
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 10000, 1);
        ChangeListener listener = e -> {
            int x = ((Number)this.spinX.getValue()).intValue();
            int y = ((Number)this.spinY.getValue()).intValue();
            this.pl.setLocation(x, y);
            this.textX.setText(" X: " + this.pl.getOriginalX());
            this.textY.setText(" Y: " + this.pl.getOriginalY());
        };
        this.spinX = new JSpinner(model);
        this.spinX.setValue(this.pl.getOriginalX());
        this.spinX.setToolTipText(Bundle.getMessage("EnterXcoord"));
        this.spinX.setMaximumSize(new Dimension(this.spinX.getMaximumSize().width, this.spinX.getPreferredSize().height));
        this.spinX.addChangeListener(listener);
        model = new SpinnerNumberModel(0, 0, 10000, 1);
        this.spinY = new JSpinner(model);
        this.spinY.setValue(this.pl.getOriginalY());
        this.spinY.setToolTipText(Bundle.getMessage("EnterYcoord"));
        this.spinY.setMaximumSize(new Dimension(this.spinY.getMaximumSize().width, this.spinY.getPreferredSize().height));
        this.spinY.addChangeListener(listener);
        this.getContentPane().setLayout(new GridBagLayout());
        this.addSpinItems(true);
        this.okButton.addActionListener(e -> {
            int x = ((Number)this.spinX.getValue()).intValue();
            int y = ((Number)this.spinY.getValue()).intValue();
            this.pl.setLocation(x, y);
            this.textX.setText(" X: " + this.pl.getOriginalX());
            this.textY.setText(" Y: " + this.pl.getOriginalY());
            this.dispose();
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> {
            this.pl.setLocation(this.oldX, this.oldY);
            this.dispose();
        });
        this.setMinimumSize(new Dimension(250, 175));
        this.pack();
    }
}

