/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.IconAdder;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableJPanel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.swing.JmriMouseMotionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryInputIcon
extends PositionableJPanel
implements PropertyChangeListener {
    JTextField _textBox = new JTextField();
    int _nCols;
    private NamedBeanHandle<Memory> namedMemory;
    private final MouseListener _mouseListener = JmriMouseListener.adapt(this);
    private final MouseMotionListener _mouseMotionListener = JmriMouseMotionListener.adapt(this);
    SpinnerNumberModel _spinModel = new SpinnerNumberModel(3, 1, 100, 1);
    private static final Logger log = LoggerFactory.getLogger(MemoryInputIcon.class);

    public MemoryInputIcon(int nCols, Editor editor) {
        super(editor);
        this._nCols = nCols;
        this.setDisplayLevel(4);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._textBox, new GridBagConstraints());
        this._textBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10 || key == 9) {
                    MemoryInputIcon.this.updateMemory();
                }
            }
        });
        this._textBox.setColumns(this._nCols);
        this._textBox.addMouseMotionListener(this._mouseMotionListener);
        this._textBox.addMouseListener(this._mouseListener);
        this.setPopupUtility(new PositionablePopupUtil(this, this._textBox));
    }

    @Override
    public Positionable deepClone() {
        MemoryInputIcon pos = new MemoryInputIcon(this._nCols, this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(MemoryInputIcon pos) {
        pos.setMemory(this.namedMemory.getName());
        return super.finishClone(pos);
    }

    @Override
    public JComponent getTextComponent() {
        return this._textBox;
    }

    @Override
    public void mouseExited(JmriMouseEvent e) {
        this.updateMemory();
        super.mouseExited(e);
    }

    public void setMemory(String pName) {
        log.debug("setMemory for memory= {}", (Object)pName);
        if (InstanceManager.getNullableDefault(MemoryManager.class) != null) {
            try {
                Memory memory = InstanceManager.memoryManagerInstance().provideMemory(pName);
                this.setMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, memory));
            }
            catch (IllegalArgumentException e) {
                log.error("Memory '{}' not available, icon won't see changes", (Object)pName);
            }
        } else {
            log.error("No MemoryManager for this protocol, icon won't see changes");
        }
        this.updateSize();
    }

    public void setMemory(NamedBeanHandle<Memory> m) {
        if (this.namedMemory != null) {
            this.getMemory().removePropertyChangeListener(this);
        }
        this.namedMemory = m;
        if (this.namedMemory != null) {
            this.getMemory().addPropertyChangeListener(this, this.namedMemory.getName(), "Memory Input Icon");
            this.displayState();
            this.setName(this.namedMemory.getName());
        }
    }

    public void setNumColumns(int nCols) {
        this._textBox.setColumns(nCols);
        this._nCols = nCols;
    }

    public NamedBeanHandle<Memory> getNamedMemory() {
        return this.namedMemory;
    }

    public Memory getMemory() {
        if (this.namedMemory == null) {
            return null;
        }
        return this.namedMemory.getBean();
    }

    public int getNumColumns() {
        return this._nCols;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("value")) {
            this.displayState();
        }
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_MemoryInputIcon");
    }

    @Override
    public String getNameString() {
        String name = this.namedMemory == null ? Bundle.getMessage("NotConnected") : this.getMemory().getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    @Override
    public void mouseMoved(JmriMouseEvent e) {
        this.updateMemory();
    }

    private void updateMemory() {
        if (this.namedMemory == null) {
            return;
        }
        String str = this._textBox.getText();
        this.getMemory().setValue(str);
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameMemory"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryInputIcon.this.edit();
            }
        });
        return true;
    }

    @Override
    protected void edit() {
        this._iconEditor = new IconAdder("Memory"){
            final JSpinner spinner;
            {
                this.spinner = new JSpinner(MemoryInputIcon.this._spinModel);
            }

            @Override
            protected void addAdditionalButtons(JPanel p) {
                ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setColumns(2);
                this.spinner.setMaximumSize(this.spinner.getPreferredSize());
                this.spinner.setValue(MemoryInputIcon.this._textBox.getColumns());
                JPanel p2 = new JPanel();
                p2.add(new JLabel(Bundle.getMessage("NumColsLabel")));
                p2.add(this.spinner);
                p.add(p2);
                p.setVisible(true);
            }
        };
        this.makeIconEditorFrame(this, "Memory", true, this._iconEditor);
        this._iconEditor.setPickList(PickListModel.memoryPickModelInstance());
        ActionListener addIconAction = a -> this.editMemory();
        this._iconEditor.makeIconPanel(false);
        this._iconEditor.complete(addIconAction, false, true, true);
        this._iconEditor.setSelection(this.getMemory());
    }

    void editMemory() {
        this.setMemory(this._iconEditor.getTableSelection().getDisplayName());
        this._nCols = this._spinModel.getNumber().intValue();
        this._textBox.setColumns(this._nCols);
        this.setSize(this.getPreferredSize().width + 1, this.getPreferredSize().height);
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.validate();
    }

    public void displayState() {
        log.debug("displayState");
        if (this.namedMemory == null) {
            return;
        }
        Object show = this.getMemory().getValue();
        if (show != null) {
            this._textBox.setText(show.toString());
        } else {
            this._textBox.setText("");
        }
    }

    @Override
    void cleanup() {
        if (this.namedMemory != null) {
            this.getMemory().removePropertyChangeListener(this);
        }
        if (this._textBox != null) {
            this._textBox.removeMouseMotionListener(this._mouseMotionListener);
            this._textBox.removeMouseListener(this._mouseListener);
        }
        this.namedMemory = null;
    }
}

