/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.catalog.CatalogPane;
import jmri.jmrit.catalog.NamedIcon;

public class MultiIconEditor
extends JPanel {
    JButton[] buttonList;
    NamedIcon[] iconList;
    public CatalogPane catalog = new CatalogPane();

    public MultiIconEditor(int nIcons) {
        this.setLayout(new BoxLayout(this, 1));
        this.buttonList = new JButton[nIcons];
        this.iconList = new NamedIcon[nIcons];
    }

    public void setIcon(int iconNum, String label, String name) {
        this.iconList[iconNum] = new NamedIcon(name, name);
        IconButton j = new IconButton(iconNum, this.iconList[iconNum]);
        j.setToolTipText(this.iconList[iconNum].getName());
        this.buttonList[iconNum] = j;
        JPanel p = new JPanel();
        p.add(new JLabel(label));
        p.add(j);
        this.add(p);
    }

    public NamedIcon getIcon(int iconNum) {
        return new NamedIcon(this.iconList[iconNum]);
    }

    public void complete() {
        this.add(this.catalog);
    }

    public void dispose() {
        this.removeAll();
        this.iconList = null;
        this.buttonList = null;
        this.catalog = null;
    }

    private class IconButton
    extends JButton {
        int savedIndex;

        IconButton(int index, Icon init) {
            super(init);
            this.savedIndex = index;
            this.addActionListener(a -> this.pickIcon());
        }

        void pickIcon() {
            NamedIcon newIcon;
            MultiIconEditor.this.iconList[this.savedIndex] = newIcon = MultiIconEditor.this.catalog.getSelectedIcon();
            MultiIconEditor.this.buttonList[this.savedIndex].setIcon(newIcon);
        }
    }
}

