/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.MultiSensorIconAdder;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.palette.MultiSensorItemPanel;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSensorIcon
extends PositionableLabel
implements PropertyChangeListener {
    String _iconFamily;
    boolean updown = false;
    ArrayList<Entry> entries = new ArrayList();
    String inactiveName = "resources/icons/USS/plate/levers/l-inactive.gif";
    NamedIcon inactive = new NamedIcon(this.inactiveName, this.inactiveName);
    String inconsistentName = "resources/icons/USS/plate/levers/l-inconsistent.gif";
    NamedIcon inconsistent = new NamedIcon(this.inconsistentName, this.inconsistentName);
    String unknownName = "resources/icons/USS/plate/levers/l-unknown.gif";
    NamedIcon unknown = new NamedIcon(this.unknownName, this.unknownName);
    MultiSensorItemPanel _itemPanel;
    int displaying = -1;
    private static final Logger log = LoggerFactory.getLogger(MultiSensorIcon.class);

    public MultiSensorIcon(Editor editor) {
        super(new NamedIcon("resources/icons/smallschematics/tracksegments/circuit-error.gif", "resources/icons/smallschematics/tracksegments/circuit-error.gif"), editor);
        this._control = true;
        this.displayState();
        this.setPopupUtility(null);
    }

    public void setUpDown(boolean b) {
        this.updown = b;
    }

    public boolean getUpDown() {
        return this.updown;
    }

    @Override
    public Positionable deepClone() {
        MultiSensorIcon pos = new MultiSensorIcon(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(MultiSensorIcon pos) {
        pos.setInactiveIcon(MultiSensorIcon.cloneIcon(this.getInactiveIcon(), pos));
        pos.setInconsistentIcon(MultiSensorIcon.cloneIcon(this.getInconsistentIcon(), pos));
        pos.setUnknownIcon(MultiSensorIcon.cloneIcon(this.getUnknownIcon(), pos));
        for (int i = 0; i < this.entries.size(); ++i) {
            pos.addEntry(this.getSensorName(i), MultiSensorIcon.cloneIcon(this.getSensorIcon(i), pos));
        }
        return super.finishClone(pos);
    }

    public void addEntry(NamedBeanHandle<Sensor> sensor, NamedIcon icon) {
        if (sensor != null) {
            if (log.isDebugEnabled()) {
                log.debug("addEntry: sensor= {}", (Object)sensor.getName());
            }
            Entry e = new Entry();
            sensor.getBean().addPropertyChangeListener(this, sensor.getName(), "MultiSensor Icon");
            e.namedSensor = sensor;
            e.icon = icon;
            this.entries.add(e);
            this.displayState();
        } else {
            log.error("Sensor not available, icon won't see changes");
        }
    }

    public void addEntry(String pName, NamedIcon icon) {
        if (InstanceManager.getNullableDefault(SensorManager.class) != null) {
            NamedBeanHandle<Sensor> sensor = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, InstanceManager.sensorManagerInstance().provideSensor(pName));
            this.addEntry(sensor, icon);
        } else {
            log.error("No SensorManager for this protocol, icon won't see changes");
        }
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public List<Sensor> getSensors() {
        ArrayList<Sensor> list = new ArrayList<Sensor>(this.getNumEntries());
        for (Entry handle : this.entries) {
            list.add(handle.namedSensor.getBean());
        }
        return list;
    }

    public String getSensorName(int i) {
        return this.entries.get((int)i).namedSensor.getName();
    }

    public NamedIcon getSensorIcon(int i) {
        return this.entries.get((int)i).icon;
    }

    public String getFamily() {
        return this._iconFamily;
    }

    public void setFamily(String family) {
        this._iconFamily = family;
    }

    public NamedIcon getInactiveIcon() {
        return this.inactive;
    }

    public void setInactiveIcon(NamedIcon i) {
        this.inactive = i;
    }

    public NamedIcon getInconsistentIcon() {
        return this.inconsistent;
    }

    public void setInconsistentIcon(NamedIcon i) {
        this.inconsistent = i;
    }

    public NamedIcon getUnknownIcon() {
        return this.unknown;
    }

    public void setUnknownIcon(NamedIcon i) {
        this.unknown = i;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (log.isDebugEnabled()) {
            String prop = e.getPropertyName();
            Sensor sen = (Sensor)e.getSource();
            log.debug("property change({}) Sensor state= {} - old= {}, new= {}", new Object[]{prop, sen.getKnownState(), e.getOldValue(), e.getNewValue()});
        }
        if (e.getPropertyName().equals("KnownState")) {
            this.displayState();
            this._editor.repaint();
        }
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_MultiSensorIcon");
    }

    @Override
    public String getNameString() {
        StringBuilder name = new StringBuilder();
        if (this.entries == null || this.entries.size() < 1) {
            name.append(Bundle.getMessage("NotConnected"));
        } else {
            name.append(this.entries.get((int)0).namedSensor.getName());
            this.entries.forEach(entry -> name.append(",").append(entry.namedSensor.getName()));
        }
        return name.toString();
    }

    @Override
    protected void rotateOrthogonal() {
        for (Entry entry : this.entries) {
            NamedIcon icon = entry.icon;
            icon.setRotation(icon.getRotation() + 1, this);
        }
        this.inactive.setRotation(this.inactive.getRotation() + 1, this);
        this.unknown.setRotation(this.unknown.getRotation() + 1, this);
        this.inconsistent.setRotation(this.inconsistent.getRotation() + 1, this);
        this.displayState();
        this.repaint();
    }

    @Override
    public void setScale(double s) {
        for (Entry entry : this.entries) {
            NamedIcon icon = entry.icon;
            icon.scale(s, this);
        }
        this.inactive.scale(s, this);
        this.unknown.scale(s, this);
        this.inconsistent.scale(s, this);
        this.displayState();
    }

    @Override
    public void rotate(int deg) {
        for (Entry entry : this.entries) {
            NamedIcon icon = entry.icon;
            icon.rotate(deg, this);
        }
        this.inactive.rotate(deg, this);
        this.unknown.rotate(deg, this);
        this.inconsistent.rotate(deg, this);
        this.displayState();
    }

    @Override
    public boolean setEditItemMenu(JPopupMenu popup) {
        String txt = Bundle.getMessage("EditItem", Bundle.getMessage("MultiSensor"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSensorIcon.this.editItem();
            }
        });
        return true;
    }

    protected void editItem() {
        this._paletteFrame = this.makePaletteFrame(Bundle.getMessage("EditItem", Bundle.getMessage("MultiSensor")));
        this._itemPanel = new MultiSensorItemPanel(this._paletteFrame, "MultiSensor", this._iconFamily, PickListModel.multiSensorPickModelInstance());
        ActionListener updateAction = a -> this.updateItem();
        HashMap<String, NamedIcon> map = new HashMap<String, NamedIcon>();
        map.put("SensorStateInactive", this.inactive);
        map.put("BeanStateInconsistent", this.inconsistent);
        map.put("BeanStateUnknown", this.unknown);
        for (int i = 0; i < this.entries.size(); ++i) {
            map.put(MultiSensorItemPanel.getPositionName(i), this.entries.get((int)i).icon);
        }
        this._itemPanel.init(updateAction, map);
        for (Entry entry : this.entries) {
            this._itemPanel.setSelection(entry.namedSensor.getBean());
        }
        this._itemPanel.setUpDown(this.getUpDown());
        this.initPaletteFrame(this._paletteFrame, this._itemPanel);
    }

    void updateItem() {
        if (!this._itemPanel.oktoUpdate()) {
            return;
        }
        HashMap<String, NamedIcon> iconMap = this._itemPanel.getIconMap();
        ArrayList<Sensor> selections = this._itemPanel.getTableSelections();
        this.setInactiveIcon(new NamedIcon(iconMap.get("SensorStateInactive")));
        this.setInconsistentIcon(new NamedIcon(iconMap.get("BeanStateInconsistent")));
        this.setUnknownIcon(new NamedIcon(iconMap.get("BeanStateUnknown")));
        this.entries = new ArrayList(selections.size());
        for (int i = 0; i < selections.size(); ++i) {
            this.addEntry(selections.get(i).getDisplayName(), new NamedIcon(iconMap.get(MultiSensorItemPanel.getPositionName(i))));
        }
        this._iconFamily = this._itemPanel.getFamilyName();
        this._itemPanel.clearSelections();
        this.setUpDown(this._itemPanel.getUpDown());
        this.finishItemUpdate(this._paletteFrame, this._itemPanel);
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        String txt = Bundle.getMessage("EditItem", Bundle.getMessage("MultiSensor"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSensorIcon.this.edit();
            }
        });
        return true;
    }

    @Override
    protected void edit() {
        MultiSensorIconAdder iconEditor = new MultiSensorIconAdder("MultiSensor");
        this.makeIconEditorFrame(this, "MultiSensor", false, iconEditor);
        this._iconEditor.setPickList(PickListModel.sensorPickModelInstance());
        this._iconEditor.setIcon(2, "SensorStateInactive", this.inactive);
        this._iconEditor.setIcon(0, "BeanStateInconsistent", this.inconsistent);
        this._iconEditor.setIcon(1, "BeanStateUnknown", this.unknown);
        if (this._iconEditor instanceof MultiSensorIconAdder) {
            ((MultiSensorIconAdder)this._iconEditor).setMultiIcon(this.entries);
            this._iconEditor.makeIconPanel(false);
            ActionListener addIconAction = a -> this.updateSensor();
            iconEditor.complete(addIconAction, true, true, true);
        }
    }

    void updateSensor() {
        if (this._iconEditor instanceof MultiSensorIconAdder) {
            MultiSensorIconAdder iconEditor = (MultiSensorIconAdder)this._iconEditor;
            this.setInactiveIcon(iconEditor.getIcon("SensorStateInactive"));
            this.setInconsistentIcon(iconEditor.getIcon("BeanStateInconsistent"));
            this.setUnknownIcon(iconEditor.getIcon("BeanStateUnknown"));
            for (Entry entry : this.entries) {
                entry.namedSensor.getBean().removePropertyChangeListener(this);
            }
            int numPositions = iconEditor.getNumIcons();
            this.entries = new ArrayList(numPositions);
            for (int i = 3; i < numPositions; ++i) {
                NamedIcon icon = iconEditor.getIcon(i);
                NamedBeanHandle<Sensor> namedSensor = iconEditor.getSensor(i);
                this.addEntry(namedSensor, icon);
            }
            this.setUpDown(iconEditor.getUpDown());
        }
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.invalidate();
    }

    public void displayState() {
        this.updateSize();
        boolean foundActive = false;
        block5: for (int i = 0; i < this.entries.size(); ++i) {
            Entry e = this.entries.get(i);
            int state = e.namedSensor.getBean().getKnownState();
            switch (state) {
                case 2: {
                    if (this.isText()) {
                        super.setText(Bundle.getMessage("SensorStateActive"));
                    }
                    if (this.isIcon()) {
                        super.setIcon(e.icon);
                    }
                    foundActive = true;
                    this.displaying = i;
                    continue block5;
                }
                case 1: {
                    if (this.isText()) {
                        super.setText(Bundle.getMessage("BeanStateUnknown"));
                    }
                    if (this.isIcon()) {
                        super.setIcon(this.unknown);
                    }
                    return;
                }
                case 8: {
                    if (this.isText()) {
                        super.setText(Bundle.getMessage("BeanStateInconsistent"));
                    }
                    if (!this.isIcon()) continue block5;
                    super.setIcon(this.inconsistent);
                    continue block5;
                }
            }
        }
        if (foundActive) {
            return;
        }
        if (this.isText()) {
            super.setText(Bundle.getMessage("SensorStateInactive"));
        }
        if (this.isIcon()) {
            super.setIcon(this.inactive);
        }
    }

    @Override
    public int maxHeight() {
        int size = Math.max(this.inactive != null ? this.inactive.getIconHeight() : 0, Math.max(this.unknown != null ? this.unknown.getIconHeight() : 0, this.inconsistent != null ? this.inconsistent.getIconHeight() : 0));
        if (this.entries != null) {
            for (Entry entry : this.entries) {
                size = Math.max(size, entry.icon.getIconHeight());
            }
        }
        return size;
    }

    @Override
    public int maxWidth() {
        int size = Math.max(this.inactive != null ? this.inactive.getIconWidth() : 0, Math.max(this.unknown != null ? this.unknown.getIconWidth() : 0, this.inconsistent != null ? this.inconsistent.getIconWidth() : 0));
        if (this.entries != null) {
            for (Entry entry : this.entries) {
                size = Math.max(size, entry.icon.getIconWidth());
            }
        }
        return size;
    }

    public void performMouseClicked(JmriMouseEvent e, int xx, int yy) {
        int next;
        if (log.isDebugEnabled()) {
            log.debug("performMouseClicked: location ({}, {}), click from ({}, {}) displaying={}", new Object[]{this.getX(), this.getY(), xx, yy, this.displaying});
        }
        if (!this.buttonLive() || this.entries == null || this.entries.size() < 1) {
            if (log.isDebugEnabled()) {
                log.debug("performMouseClicked: buttonLive={}, entries={}", (Object)this.buttonLive(), (Object)this.entries.size());
            }
            return;
        }
        double ratio = this._editor.getPaintScale();
        boolean dec = false;
        if (this.updown) {
            if ((double)yy / ratio - (double)this.getY() > (double)this.maxHeight() / 2.0) {
                dec = true;
            }
        } else if ((double)xx / ratio - (double)this.getX() < (double)this.maxWidth() / 2.0) {
            dec = true;
        }
        if ((next = dec ? this.displaying - 1 : this.displaying + 1) < 0) {
            next = 0;
        }
        if (next >= this.entries.size()) {
            next = this.entries.size() - 1;
        }
        int drop = this.displaying;
        if (log.isDebugEnabled()) {
            log.debug("dec= {} displaying={} next= {}", new Object[]{dec, this.displaying, next});
        }
        try {
            this.entries.get((int)next).namedSensor.getBean().setKnownState(2);
            if (drop >= 0 && drop != next) {
                this.entries.get((int)drop).namedSensor.getBean().setKnownState(4);
            }
        }
        catch (JmriException ex) {
            log.error("Click failed to set sensor: ", (Throwable)ex);
        }
    }

    boolean buttonLive() {
        return this._editor.getFlag(2, this.isControlling());
    }

    @Override
    public void doMouseClicked(JmriMouseEvent e) {
        if (!e.isAltDown() && !e.isMetaDown()) {
            this.performMouseClicked(e, e.getX(), e.getY());
        }
    }

    @Override
    public void dispose() {
        for (Entry entry : this.entries) {
            entry.namedSensor.getBean().removePropertyChangeListener(this);
        }
        super.dispose();
    }

    static class Entry {
        NamedBeanHandle<Sensor> namedSensor;
        NamedIcon icon;

        Entry() {
        }
    }
}

