/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import jmri.CatalogTreeLeaf;
import jmri.CatalogTreeManager;
import jmri.CatalogTreeNode;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.IconAdder;
import jmri.jmrit.display.MultiSensorIcon;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSensorIconAdder
extends IconAdder {
    JRadioButton _updown;
    JRadioButton _rightleft;
    HashMap<String, NamedBeanHandle<Sensor>> _sensorMap = new HashMap();
    public static final String NamedBeanFlavorMime = "application/x-java-jvm-local-objectref;class=jmri.NamedBean";
    private static final Logger log = LoggerFactory.getLogger(MultiSensorIconAdder.class);

    public MultiSensorIconAdder() {
    }

    public MultiSensorIconAdder(String type) {
        super(type);
    }

    @Override
    public void reset() {
        this._sensorMap = new HashMap();
        super.reset();
    }

    @Override
    protected void makeIcons(CatalogTreeNode n) {
        if (log.isDebugEnabled()) {
            log.debug("makeIcons from node= {}, numChildren= {}, NumLeaves= {}", new Object[]{n.toString(), n.getChildCount(), n.getNumLeaves()});
        }
        this._iconMap = new HashMap(10);
        this._iconOrderList = new ArrayList();
        ArrayList<CatalogTreeLeaf> list = n.getLeaves();
        for (int i = list.size() - 1; i >= 0; --i) {
            CatalogTreeLeaf leaf = list.get(i);
            String name = leaf.getName();
            String path = leaf.getPath();
            if ("BeanStateInconsistent".equals(name)) {
                this.setIcon(0, name, new NamedIcon(path, path));
                continue;
            }
            if ("BeanStateUnknown".equals(name)) {
                this.setIcon(1, name, new NamedIcon(path, path));
                continue;
            }
            if ("SensorStateInactive".equals(name)) {
                this.setIcon(2, name, new NamedIcon(path, path));
                continue;
            }
            int k = Character.digit(name.charAt(name.length() - 1), 10);
            this.setIcon(k + 3, name, new NamedIcon(path, path));
        }
    }

    void setMultiIcon(List<MultiSensorIcon.Entry> icons) {
        for (int i = 0; i < icons.size(); ++i) {
            MultiSensorIcon.Entry entry = icons.get(i);
            String label = "MultiSensorPosition " + i;
            String url = entry.icon.getURL();
            if (url == null) continue;
            this.setIcon(i + 3, label, url);
            this._sensorMap.put(label, entry.namedSensor);
        }
        if (log.isDebugEnabled()) {
            log.debug("setMultiIcon: Size: sensors= {}, icons= {}", (Object)this._sensorMap.size(), (Object)this._iconMap.size());
        }
    }

    @Override
    protected void doIconPanel() {
        String key;
        int i;
        if (log.isDebugEnabled()) {
            log.debug("doIconPanel: Sizes: _iconMap= {} _iconOrderList.size()= {}, _sensorMap.size()= {}", new Object[]{this._iconMap.size(), this._iconOrderList.size(), this._sensorMap.size()});
        }
        Dimension dim = null;
        JPanel rowPanel = null;
        int cnt = 0;
        for (i = 3; i < this._iconOrderList.size(); ++i) {
            if (rowPanel == null) {
                rowPanel = new JPanel();
                rowPanel.setLayout(new BoxLayout(rowPanel, 0));
                rowPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
            }
            if ((key = (String)this._iconOrderList.get(i)).equals("placeHolder")) continue;
            JPanel p1 = new JPanel();
            p1.setLayout(new BoxLayout(p1, 1));
            String label = MessageFormat.format(Bundle.getMessage("MultiSensorPosition"), cnt + 1);
            p1.add(new JLabel(label));
            p1.add((Component)this._iconMap.get(key));
            JPanel p2 = new JPanel();
            JButton delete = new JButton(Bundle.getMessage("ButtonDelete"));
            ActionListener action = new ActionListener(){
                String key;

                @Override
                public void actionPerformed(ActionEvent a) {
                    MultiSensorIconAdder.this.delete(this.key);
                }

                ActionListener init(String k) {
                    this.key = k;
                    return this;
                }
            }.init(key);
            delete.addActionListener(action);
            p2.add(delete);
            DropPanel p3 = new DropPanel();
            p3.setLayout(new BoxLayout(p3, 1));
            JLabel k = new JLabel(key);
            k.setName(key);
            k.setVisible(false);
            p3.add(k);
            JPanel p4 = new JPanel();
            p4.add(new JLabel(Bundle.getMessage("BeanNameSensor")));
            p3.add(p4);
            p4 = new JPanel();
            NamedBeanHandle<Sensor> sensor = this._sensorMap.get(key);
            String name = Bundle.getMessage("notSet");
            Color color = Color.RED;
            if (sensor != null) {
                name = sensor.getName();
                color = Color.BLACK;
            }
            p4.setBorder(BorderFactory.createLineBorder(color));
            p4.add(new JLabel(name));
            p4.setMaximumSize(p4.getPreferredSize());
            p3.add(p4);
            JPanel p13 = new JPanel();
            p13.setLayout(new BoxLayout(p13, 0));
            p13.add(p3);
            p13.add(p1);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(p13);
            panel.add(p2);
            panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            rowPanel.add(panel);
            rowPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
            if (++cnt % 3 == 0) {
                this._iconPanel.add(rowPanel);
                rowPanel = null;
            }
            dim = panel.getPreferredSize();
        }
        while (cnt % 3 != 0) {
            Objects.requireNonNull(rowPanel, "should not have found rowPanel null here");
            rowPanel.add(Box.createRigidArea(dim));
            ++cnt;
        }
        if (rowPanel != null) {
            this._iconPanel.add(rowPanel);
            this._iconPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        }
        rowPanel = new JPanel();
        rowPanel.setLayout(new BoxLayout(rowPanel, 0));
        rowPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        for (i = 0; i < 3; ++i) {
            key = (String)this._iconOrderList.get(i);
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.add(new JLabel(Bundle.getMessage(key)));
            p.add((Component)this._iconMap.get(key));
            rowPanel.add(p);
            rowPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        }
        this._iconPanel.add(rowPanel);
        this._iconPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        this.add((Component)this._iconPanel, 0);
        this.valueChanged(null);
        this.pack();
    }

    @Override
    public void complete(ActionListener addIconAction, boolean changeIcon, boolean addToTable, boolean update) {
        ButtonGroup group = new ButtonGroup();
        this._updown = new JRadioButton(Bundle.getMessage("UpDown"));
        this._rightleft = new JRadioButton(Bundle.getMessage("RightLeft"));
        this._rightleft.setSelected(true);
        group.add(this._updown);
        group.add(this._rightleft);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this._updown);
        p.add(this._rightleft);
        p.add(Box.createHorizontalStrut(STRUT_SIZE));
        JButton addIcon = new JButton(Bundle.getMessage("AddMultiSensorIcon"));
        addIcon.addActionListener(e -> this.addIcon());
        p.add(addIcon);
        this.add(p);
        this.add(new JSeparator());
        super.complete(addIconAction, changeIcon, addToTable, update);
        this._table.setDragEnabled(true);
        this._table.setTransferHandler(new ExportHandler());
        this.valueChanged(null);
    }

    private void addIcon() {
        int index = this._iconOrderList.size();
        String path = "resources/icons/misc/X-red.gif";
        String label = "MultiSensorPosition " + (index - 3);
        super.setIcon(index, label, new NamedIcon(path, path));
        this.valueChanged(null);
        if (!this._update) {
            this._defaultIcons.addLeaf(label, path);
            InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
        }
        this.makeIconPanel(!this._update);
        this.invalidate();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this._addButton == null) {
            return;
        }
        if (this._sensorMap.size() == this._iconMap.size() - 3) {
            this._addButton.setEnabled(true);
            this._addButton.setToolTipText(null);
        } else {
            this._addButton.setEnabled(false);
            this._addButton.setToolTipText(Bundle.getMessage("ToolTipAssignSensors"));
        }
    }

    void delete(String key) {
        this._iconMap.remove(key);
        this._sensorMap.remove(key);
        int index = this._iconOrderList.indexOf(key);
        this._iconOrderList.remove(key);
        if (!this._update) {
            this._defaultIcons.deleteLeaves(key);
            for (int k = index; k < this._iconOrderList.size(); ++k) {
                String label = (String)this._iconOrderList.get(k);
                ArrayList<CatalogTreeLeaf> leaves = this._defaultIcons.getLeaves(label);
                for (CatalogTreeLeaf leaf : leaves) {
                    String path = leaf.getPath();
                    this._defaultIcons.deleteLeaves(label);
                    this._defaultIcons.addLeaf("MultiSensorPosition " + (k - 3), path);
                }
            }
            InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
        }
        this.makeIconPanel(!this._update);
    }

    public NamedIcon getIcon(int index) {
        if (index >= this._iconOrderList.size()) {
            JmriJOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("NoIconAt"), index - 2), Bundle.getMessage("ErrorTitle"), 0);
            return null;
        }
        return (NamedIcon)((JToggleButton)this._iconMap.get(this._iconOrderList.get(index))).getIcon();
    }

    public NamedBeanHandle<Sensor> getSensor(int index) {
        if (index >= this._iconOrderList.size()) {
            JmriJOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("NoSensorAt"), index - 2), Bundle.getMessage("ErrorTitle"), 0);
            return null;
        }
        return this._sensorMap.get(this._iconOrderList.get(index));
    }

    public boolean getUpDown() {
        return this._updown.isSelected();
    }

    private boolean putSensor(String key, Sensor sensor) {
        String name = sensor.getDisplayName();
        log.debug("putSensor: key= {} sensor= {}", (Object)key, (Object)name);
        for (NamedBeanHandle<Sensor> sensorNamedBeanHandle : this._sensorMap.values()) {
            if (!name.equals(sensorNamedBeanHandle.getName())) continue;
            JmriJOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("DupSensorName"), name), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        this._sensorMap.put(key, InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, sensor));
        return true;
    }

    class DropPanel
    extends JPanel
    implements DropTargetListener {
        DataFlavor dataFlavor;

        DropPanel() {
            try {
                this.dataFlavor = new DataFlavor(MultiSensorIconAdder.NamedBeanFlavorMime);
            }
            catch (ClassNotFoundException cnfe) {
                log.error("Class not found.", (Throwable)cnfe);
            }
            new DropTarget(this, 3, this);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            try {
                Transferable tr = e.getTransferable();
                if (e.isDataFlavorSupported(this.dataFlavor)) {
                    Sensor sensor = (Sensor)tr.getTransferData(this.dataFlavor);
                    if (sensor != null) {
                        e.acceptDrop(3);
                        DropTarget target = (DropTarget)e.getSource();
                        JPanel panel = (JPanel)target.getComponent();
                        JLabel comp = (JLabel)panel.getComponent(0);
                        if (MultiSensorIconAdder.this.putSensor(comp.getName(), sensor)) {
                            MultiSensorIconAdder.this.makeIconPanel(!MultiSensorIconAdder.this._update);
                        }
                        e.dropComplete(true);
                        if (log.isDebugEnabled()) {
                            log.debug("DropPanel.drop COMPLETED for {}", (Object)comp.getName());
                        }
                    } else {
                        log.debug("DropPanel.drop REJECTED!");
                        e.rejectDrop();
                    }
                }
            }
            catch (UnsupportedFlavorException | IOException ioe) {
                log.debug("DropPanel.drop REJECTED!");
                e.rejectDrop();
            }
        }
    }

    class TransferableNamedBean
    implements Transferable {
        DataFlavor dataFlavor;

        TransferableNamedBean() {
            try {
                this.dataFlavor = new DataFlavor(MultiSensorIconAdder.NamedBeanFlavorMime);
            }
            catch (ClassNotFoundException cnfe) {
                log.error("Unable to find class", (Throwable)cnfe);
            }
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.dataFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.dataFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            log.debug("TransferableNamedBean.getTransferData");
            if (this.isDataFlavorSupported(flavor)) {
                return MultiSensorIconAdder.this.getTableSelection();
            }
            return null;
        }
    }

    class ExportHandler
    extends TransferHandler {
        ExportHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            return new TransferableNamedBean();
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
        }
    }
}

