/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionableIcon
extends PositionableLabel {
    protected HashMap<String, NamedIcon> _iconMap;
    protected String _iconFamily;
    protected double _scale = 1.0;
    protected int _rotate = 0;
    private static final Logger log = LoggerFactory.getLogger(PositionableIcon.class);

    public PositionableIcon(Editor editor) {
        super(new NamedIcon("resources/icons/misc/X-red.gif", "resources/icons/misc/X-red.gif"), editor);
    }

    public PositionableIcon(NamedIcon s, Editor editor) {
        super(s, editor);
    }

    public PositionableIcon(String s, Editor editor) {
        super(s, editor);
    }

    @Override
    public Positionable deepClone() {
        PositionableIcon pos = new PositionableIcon(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(PositionableIcon pos) {
        pos._iconFamily = this._iconFamily;
        pos._scale = this._scale;
        pos._rotate = this._rotate;
        pos._iconMap = PositionableIcon.cloneMap(this._iconMap, pos);
        return super.finishClone(pos);
    }

    public Collection<String> getStateNameCollection() {
        log.error("getStateNameCollection() must be implemented by extensions!");
        return null;
    }

    public NamedIcon getIcon(String state) {
        return this._iconMap.get(state);
    }

    public String getFamily() {
        return this._iconFamily;
    }

    public void setFamily(String family) {
        this._iconFamily = family;
    }

    public Iterator<String> getIconStateNames() {
        return this._iconMap.keySet().iterator();
    }

    public HashMap<String, NamedIcon> getIconMap() {
        return PositionableIcon.cloneMap(this._iconMap, this);
    }

    @Override
    public int maxHeight() {
        int max = super.maxHeight();
        if (this._iconMap != null) {
            for (NamedIcon namedIcon : this._iconMap.values()) {
                max = Math.max(namedIcon.getIconHeight(), max);
            }
        }
        return max;
    }

    @Override
    public int maxWidth() {
        int max = super.maxWidth();
        if (this._iconMap != null) {
            for (NamedIcon namedIcon : this._iconMap.values()) {
                max = Math.max(namedIcon.getIconWidth(), max);
            }
        }
        return max;
    }

    public void displayState(int state) {
    }

    @Override
    protected void rotateOrthogonal() {
        for (Map.Entry<String, NamedIcon> entry : this._iconMap.entrySet()) {
            entry.getValue().setRotation(entry.getValue().getRotation() + 1, this);
        }
        this.updateSize();
    }

    @Override
    public void setScale(double s) {
        this._scale = s;
        if (this._iconMap == null) {
            return;
        }
        for (Map.Entry<String, NamedIcon> entry : this._iconMap.entrySet()) {
            entry.getValue().scale(s, this);
        }
        this.updateSize();
    }

    @Override
    public double getScale() {
        return this._scale;
    }

    @Override
    public void rotate(int deg) {
        this._rotate = deg % 360;
        this.setDegrees(deg);
        if (this._iconMap != null) {
            for (Map.Entry<String, NamedIcon> entry : this._iconMap.entrySet()) {
                entry.getValue().rotate(deg, this);
            }
        }
        super.rotate(deg);
        this.updateSize();
    }

    public static HashMap<String, NamedIcon> cloneMap(HashMap<String, NamedIcon> map, PositionableLabel pos) {
        HashMap<String, NamedIcon> clone = new HashMap<String, NamedIcon>();
        if (map != null) {
            for (Map.Entry<String, NamedIcon> entry : map.entrySet()) {
                clone.put(entry.getKey(), PositionableIcon.cloneIcon(entry.getValue(), pos));
            }
        }
        return clone;
    }
}

