/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.BlockContentsIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.CoordinateEdit;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.GlobalVariableIcon;
import jmri.jmrit.display.IconAdder;
import jmri.jmrit.display.MemoryIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.ToolTip;
import jmri.jmrit.display.palette.IconItemPanel;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.display.palette.ItemPanel;
import jmri.jmrit.display.palette.TextItemPanel;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.LogixNG_UserPreferences;
import jmri.jmrit.logixng.tools.swing.DeleteBean;
import jmri.util.LoggingUtil;
import jmri.util.MathUtil;
import jmri.util.PlaceWindow;
import jmri.util.SystemType;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionableLabel
extends JLabel
implements Positionable {
    protected Editor _editor;
    private String _id;
    private final Set<String> _classes = new HashSet<String>();
    protected boolean _icon = false;
    protected boolean _text = false;
    protected boolean _control = false;
    protected NamedIcon _namedIcon;
    protected ToolTip _tooltip;
    protected boolean _showTooltip = true;
    protected boolean _editable = true;
    protected boolean _positionable = true;
    protected boolean _viewCoordinates = true;
    protected boolean _controlling = true;
    protected boolean _hidden = false;
    protected boolean _emptyHidden = false;
    protected boolean _valueEditDisabled = false;
    protected int _displayLevel;
    protected String _unRotatedText;
    protected boolean _rotateText = false;
    private int _degrees;
    private LogixNG _logixNG;
    private String _logixNG_SystemName;
    PositionablePopupUtil _popupUtil;
    JFrame _iconEditorFrame;
    IconAdder _iconEditor;
    public DisplayFrame _paletteFrame;
    IconItemPanel _iconItemPanel;
    TextItemPanel _itemPanel;
    JCheckBoxMenuItem disableItem = null;
    boolean active = true;
    private boolean needsRotate;
    private static final Logger log = LoggerFactory.getLogger(PositionableLabel.class);

    public PositionableLabel(String s, @Nonnull Editor editor) {
        super(s);
        this._editor = editor;
        this._text = true;
        this._unRotatedText = s;
        log.debug("PositionableLabel ctor (text) {}", (Object)s);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setPopupUtility(new PositionablePopupUtil(this, this));
    }

    public PositionableLabel(@CheckForNull NamedIcon s, @Nonnull Editor editor) {
        super(s);
        this._editor = editor;
        this._icon = true;
        this._namedIcon = s;
        log.debug("PositionableLabel ctor (icon) {}", (Object)(s != null ? s.getName() : null));
        this.setPopupUtility(new PositionablePopupUtil(this, this));
    }

    @Override
    public void setId(String id) throws Positionable.DuplicateIdException {
        if (Objects.equals(this._id, id)) {
            return;
        }
        this._editor.positionalIdChange(this, id);
        this._id = id;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void addClass(String className) {
        this._editor.positionalAddClass(this, className);
        this._classes.add(className);
    }

    @Override
    public void removeClass(String className) {
        this._editor.positionalRemoveClass(this, className);
        this._classes.remove(className);
    }

    @Override
    public void removeAllClasses() {
        for (String className : this._classes) {
            this._editor.positionalRemoveClass(this, className);
        }
        this._classes.clear();
    }

    @Override
    public Set<String> getClasses() {
        return Collections.unmodifiableSet(this._classes);
    }

    public final boolean isIcon() {
        return this._icon;
    }

    public final boolean isText() {
        return this._text;
    }

    public final boolean isControl() {
        return this._control;
    }

    @Override
    @Nonnull
    public Editor getEditor() {
        return this._editor;
    }

    @Override
    public void setEditor(@Nonnull Editor ed) {
        this._editor = ed;
    }

    @Override
    public void setPositionable(boolean enabled) {
        this._positionable = enabled;
    }

    @Override
    public final boolean isPositionable() {
        return this._positionable;
    }

    @Override
    public void setEditable(boolean enabled) {
        this._editable = enabled;
        this.showHidden();
    }

    @Override
    public boolean isEditable() {
        return this._editable;
    }

    @Override
    public void setViewCoordinates(boolean enabled) {
        this._viewCoordinates = enabled;
    }

    @Override
    public boolean getViewCoordinates() {
        return this._viewCoordinates;
    }

    @Override
    public void setControlling(boolean enabled) {
        this._controlling = enabled;
    }

    @Override
    public boolean isControlling() {
        return this._controlling;
    }

    @Override
    public void setHidden(boolean hide) {
        if (this._hidden != hide) {
            this._hidden = hide;
            this.showHidden();
        }
    }

    @Override
    public boolean isHidden() {
        return this._hidden;
    }

    @Override
    public void showHidden() {
        if (!this._hidden || this._editor.isEditable()) {
            this.showEmptyHidden();
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void setEmptyHidden(boolean hide) {
        this._emptyHidden = hide;
    }

    @Override
    public boolean isEmptyHidden() {
        return this._emptyHidden;
    }

    @Override
    public void setValueEditDisabled(boolean isDisabled) {
        this._valueEditDisabled = isDisabled;
    }

    @Override
    public boolean isValueEditDisabled() {
        return this._valueEditDisabled;
    }

    public void showEmptyHidden() {
        boolean visible = !this._emptyHidden || this._unRotatedText != null && !this._unRotatedText.trim().isEmpty();
        this.setVisible(visible);
    }

    public void setLevel(int l) {
        this._displayLevel = l;
    }

    @Override
    public void setDisplayLevel(int l) {
        int oldDisplayLevel = this._displayLevel;
        this._displayLevel = l;
        if (oldDisplayLevel != l) {
            log.debug("Changing label display level from {} to {}", (Object)oldDisplayLevel, (Object)this._displayLevel);
            this._editor.displayLevelChange(this);
        }
    }

    @Override
    public int getDisplayLevel() {
        return this._displayLevel;
    }

    @Override
    public void setShowToolTip(boolean set) {
        this._showTooltip = set;
    }

    @Override
    public boolean showToolTip() {
        return this._showTooltip;
    }

    @Override
    public void setToolTip(ToolTip tip) {
        this._tooltip = tip;
    }

    @Override
    public ToolTip getToolTip() {
        return this._tooltip;
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_PositionableLabel");
    }

    @Override
    @Nonnull
    public String getNameString() {
        if (this._icon && this._displayLevel > 1) {
            return "Icon";
        }
        if (this._text) {
            return "Text Label";
        }
        return "Background";
    }

    public String getUnRotatedText() {
        return this._unRotatedText;
    }

    public void setUnRotatedText(String s) {
        this._unRotatedText = s;
    }

    @Override
    @Nonnull
    public Positionable deepClone() {
        PositionableLabel pos;
        if (this._icon) {
            NamedIcon icon = new NamedIcon((NamedIcon)this.getIcon());
            pos = new PositionableLabel(icon, this._editor);
        } else {
            pos = new PositionableLabel(this.getText(), this._editor);
        }
        return this.finishClone(pos);
    }

    @Nonnull
    protected Positionable finishClone(@Nonnull PositionableLabel pos) {
        pos._text = this._text;
        pos._icon = this._icon;
        pos._control = this._control;
        pos._unRotatedText = this._unRotatedText;
        pos.setLocation(this.getX(), this.getY());
        pos._displayLevel = this._displayLevel;
        pos._controlling = this._controlling;
        pos._hidden = this._hidden;
        pos._positionable = this._positionable;
        pos._showTooltip = this._showTooltip;
        pos.setToolTip(this.getToolTip());
        pos._editable = this._editable;
        if (this.getPopupUtility() == null) {
            pos.setPopupUtility(null);
        } else {
            pos.setPopupUtility(this.getPopupUtility().clone(pos, pos.getTextComponent()));
        }
        pos.setOpaque(this.isOpaque());
        if (this._namedIcon != null) {
            pos._namedIcon = PositionableLabel.cloneIcon(this._namedIcon, pos);
            pos.setIcon(pos._namedIcon);
            pos.rotate(this._degrees);
        }
        pos.updateSize();
        return pos;
    }

    @Override
    @Nonnull
    public JComponent getTextComponent() {
        return this;
    }

    @Nonnull
    public static NamedIcon cloneIcon(NamedIcon icon, PositionableLabel pos) {
        if (icon.getURL() != null) {
            return new NamedIcon(icon, pos);
        }
        NamedIcon clone = new NamedIcon(icon.getImage());
        clone.scale(icon.getScale(), pos);
        clone.rotate(icon.getDegrees(), pos);
        return clone;
    }

    @Override
    public void doMousePressed(JmriMouseEvent event) {
    }

    @Override
    public void doMouseReleased(JmriMouseEvent event) {
    }

    @Override
    public void doMouseClicked(JmriMouseEvent event) {
    }

    @Override
    public void doMouseDragged(JmriMouseEvent event) {
    }

    @Override
    public void doMouseMoved(JmriMouseEvent event) {
    }

    @Override
    public void doMouseEntered(JmriMouseEvent event) {
    }

    @Override
    public void doMouseExited(JmriMouseEvent event) {
    }

    @Override
    public boolean storeItem() {
        return true;
    }

    @Override
    public boolean doViemMenu() {
        return true;
    }

    @Override
    public void setPopupUtility(PositionablePopupUtil tu) {
        this._popupUtil = tu;
    }

    @Override
    public PositionablePopupUtil getPopupUtility() {
        return this._popupUtil;
    }

    @Override
    public void updateSize() {
        int width = this.maxWidth();
        int height = this.maxHeight();
        log.trace("updateSize() w= {}, h= {} _namedIcon= {}", new Object[]{width, height, this._namedIcon});
        this.setSize(width, height);
        if (this._namedIcon != null && this._text) {
            this.setHorizontalTextPosition(0);
        }
    }

    @Override
    public int maxWidth() {
        if (this._rotateText && this._namedIcon != null) {
            return this._namedIcon.getIconWidth();
        }
        if (this._popupUtil == null) {
            return this.maxWidthTrue();
        }
        switch (this._popupUtil.getOrientation()) {
            case 1: 
            case 2: {
                return this.maxHeightTrue();
            }
        }
        return this.maxWidthTrue();
    }

    @Override
    public int maxHeight() {
        if (this._rotateText && this._namedIcon != null) {
            return this._namedIcon.getIconHeight();
        }
        if (this._popupUtil == null) {
            return this.maxHeightTrue();
        }
        switch (this._popupUtil.getOrientation()) {
            case 1: 
            case 2: {
                return this.maxWidthTrue();
            }
        }
        return this.maxHeightTrue();
    }

    public int maxWidthTrue() {
        int result = 0;
        if (this._popupUtil != null && this._popupUtil.getFixedWidth() != 0) {
            result = this._popupUtil.getFixedWidth();
            if ((result += this._popupUtil.getBorderSize() * 2) < 5) {
                this._popupUtil.setFixedWidth(5);
                result = 5;
            }
        } else {
            if (this._text && this.getText() != null) {
                if (this.getText().trim().length() == 0) {
                    if (this.getFont() != null) {
                        result = this.getFontMetrics(this.getFont()).stringWidth("0");
                    }
                } else {
                    result = this.getFontMetrics(this.getFont()).stringWidth(this.getText());
                }
            }
            if (this._icon && this._namedIcon != null) {
                result = Math.max(this._namedIcon.getIconWidth(), result);
            }
            if (this._text && this._popupUtil != null) {
                result += this._popupUtil.getMargin() * 2;
                result += this._popupUtil.getBorderSize() * 2;
            }
            if (result < 5) {
                result = 5;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("maxWidth= {} preferred width= {}", (Object)result, (Object)this.getPreferredSize().width);
        }
        return result;
    }

    public int maxHeightTrue() {
        int result = 0;
        if (this._popupUtil != null && this._popupUtil.getFixedHeight() != 0) {
            result = this._popupUtil.getFixedHeight();
            if ((result += this._popupUtil.getBorderSize() * 2) < 5) {
                this._popupUtil.setFixedHeight(5);
            }
        } else {
            if (this._text && this.getText() != null && this.getFont() != null) {
                result = this.getFontMetrics(this.getFont()).getHeight();
            }
            if (this._icon && this._namedIcon != null) {
                result = Math.max(this._namedIcon.getIconHeight(), result);
            }
            if (this._text && this._popupUtil != null) {
                result += this._popupUtil.getMargin() * 2;
                result += this._popupUtil.getBorderSize() * 2;
            }
            if (result < 5) {
                result = 5;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("maxHeight= {} preferred height= {}", (Object)result, (Object)this.getPreferredSize().height);
        }
        return result;
    }

    public boolean isBackground() {
        return this._displayLevel == 1;
    }

    public boolean isRotated() {
        return this._rotateText;
    }

    public void updateIcon(NamedIcon s) {
        ThreadingUtil.runOnGUIEventually(() -> {
            this._namedIcon = s;
            super.setIcon(this._namedIcon);
            this.updateSize();
            this.repaint();
        });
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setRotateOrthogonalMenu(JPopupMenu popup) {
        if (this.isIcon() && this._displayLevel > 1 && this._namedIcon != null) {
            popup.add(new AbstractAction(Bundle.getMessage("RotateOrthoSign", this._namedIcon.getRotation() * 90)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PositionableLabel.this.rotateOrthogonal();
                }
            });
            return true;
        }
        return false;
    }

    protected void rotateOrthogonal() {
        this._namedIcon.setRotation(this._namedIcon.getRotation() + 1, this);
        super.setIcon(this._namedIcon);
        this.updateSize();
        this.repaint();
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        if (this._icon && !this._text) {
            String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("Icon"));
            popup.add(new AbstractAction(txt){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PositionableLabel.this.edit();
                }
            });
            return true;
        }
        return false;
    }

    protected void makeIconEditorFrame(Container pos, String name, boolean table, IconAdder editor) {
        this._iconEditor = editor != null ? editor : new IconAdder(name);
        this._iconEditorFrame = this._editor.makeAddIconFrame(name, false, table, this._iconEditor);
        this._iconEditorFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PositionableLabel.this._iconEditorFrame.dispose();
                PositionableLabel.this._iconEditorFrame = null;
            }
        });
        this._iconEditorFrame.setLocationRelativeTo(pos);
        this._iconEditorFrame.toFront();
        this._iconEditorFrame.setVisible(true);
    }

    protected void edit() {
        this.makeIconEditorFrame(this, "Icon", false, null);
        NamedIcon icon = new NamedIcon(this._namedIcon);
        this._iconEditor.setIcon(0, "plainIcon", icon);
        this._iconEditor.makeIconPanel(false);
        ActionListener addIconAction = a -> this.editIcon();
        this._iconEditor.complete(addIconAction, true, false, true);
    }

    protected void editIcon() {
        String url = this._iconEditor.getIcon("plainIcon").getURL();
        this._namedIcon = NamedIcon.getIconByName(url);
        super.setIcon(this._namedIcon);
        this.updateSize();
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.invalidate();
        this.repaint();
    }

    public DisplayFrame makePaletteFrame(String title) {
        ItemPalette.loadIcons();
        DisplayFrame frame = new DisplayFrame(title, this._editor);
        return frame;
    }

    public void initPaletteFrame(DisplayFrame paletteFrame, @Nonnull ItemPanel itemPanel) {
        Dimension dim = itemPanel.getPreferredSize();
        JScrollPane sp = new JScrollPane(itemPanel);
        dim = new Dimension(dim.width + 25, dim.height + 25);
        sp.setPreferredSize(dim);
        paletteFrame.add(sp);
        paletteFrame.pack();
        paletteFrame.addWindowListener(new PaletteFrameCloser(itemPanel));
        InstanceManager.getDefault(PlaceWindow.class).nextTo(this._editor, this, paletteFrame);
        paletteFrame.setVisible(true);
    }

    public void finishItemUpdate(DisplayFrame paletteFrame, @Nonnull ItemPanel itemPanel) {
        itemPanel.closeDialogs();
        paletteFrame.dispose();
        this.invalidate();
    }

    @Override
    public boolean setEditItemMenu(@Nonnull JPopupMenu popup) {
        if (!this._icon) {
            return false;
        }
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("Icon"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                PositionableLabel.this.editIconItem();
            }
        });
        return true;
    }

    protected void editIconItem() {
        this._paletteFrame = this.makePaletteFrame(MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameTurnout")));
        this._iconItemPanel = new IconItemPanel(this._paletteFrame, "Icon");
        ActionListener updateAction = a -> this.updateIconItem();
        this._iconItemPanel.init(updateAction);
        this._iconItemPanel.setUpdateIcon((NamedIcon)this.getIcon());
        this.initPaletteFrame(this._paletteFrame, this._iconItemPanel);
    }

    private void updateIconItem() {
        NamedIcon icon = this._iconItemPanel.getUpdateIcon();
        if (icon != null) {
            String url = icon.getURL();
            this.setIcon(NamedIcon.getIconByName(url));
            this.updateSize();
        }
        this.finishItemUpdate(this._paletteFrame, this._iconItemPanel);
    }

    public boolean setEditTextItemMenu(JPopupMenu popup) {
        popup.add(new AbstractAction(Bundle.getMessage("SetTextSizeColor")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PositionableLabel.this.editTextItem();
            }
        });
        return true;
    }

    protected void editTextItem() {
        this._paletteFrame = this.makePaletteFrame(Bundle.getMessage("SetTextSizeColor"));
        this._itemPanel = new TextItemPanel(this._paletteFrame, "Text");
        ActionListener updateAction = a -> this.updateTextItem();
        this._itemPanel.init(updateAction, this);
        this.initPaletteFrame(this._paletteFrame, this._itemPanel);
    }

    protected void updateTextItem() {
        PositionablePopupUtil util = this._itemPanel.getPositionablePopupUtil();
        this._itemPanel.setAttributes(this);
        if (this._editor._selectionGroup != null) {
            this._editor.setSelectionsAttributes(util, this);
        } else {
            this._editor.setAttributes(util, this);
        }
        this.finishItemUpdate(this._paletteFrame, this._itemPanel);
    }

    @Override
    public boolean setRotateMenu(@Nonnull JPopupMenu popup) {
        if (this._displayLevel > 1) {
            popup.add(CoordinateEdit.getRotateEditAction(this));
        }
        return false;
    }

    @Override
    public boolean setScaleMenu(@Nonnull JPopupMenu popup) {
        if (this.isIcon() && this._displayLevel > 1) {
            popup.add(CoordinateEdit.getScaleEditAction(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean setTextEditMenu(@Nonnull JPopupMenu popup) {
        if (this.isText()) {
            popup.add(CoordinateEdit.getTextEditAction(this, "EditText"));
            return true;
        }
        return false;
    }

    @Override
    public boolean setDisableControlMenu(@Nonnull JPopupMenu popup) {
        if (this._control) {
            this.disableItem = new JCheckBoxMenuItem(Bundle.getMessage("Disable"));
            this.disableItem.setSelected(!this._controlling);
            popup.add(this.disableItem);
            this.disableItem.addActionListener(e -> this.setControlling(!this.disableItem.isSelected()));
            return true;
        }
        return false;
    }

    @Override
    public void setScale(double s) {
        if (this._namedIcon != null) {
            this._namedIcon.scale(s, this);
            super.setIcon(this._namedIcon);
            this.updateSize();
            this.repaint();
        }
    }

    @Override
    public double getScale() {
        if (this._namedIcon == null) {
            return 1.0;
        }
        return ((NamedIcon)this.getIcon()).getScale();
    }

    public void setIcon(NamedIcon icon) {
        this._namedIcon = icon;
        super.setIcon(icon);
    }

    @Override
    public void rotate(int deg) {
        if (log.isDebugEnabled()) {
            log.debug("rotate({}) with _rotateText {}, _text {}, _icon {}", new Object[]{deg, this._rotateText, this._text, this._icon});
        }
        this._degrees = deg;
        if (deg != 0 && this._popupUtil.getOrientation() != 0) {
            this._popupUtil.setOrientation(0);
        }
        if (this._rotateText || deg == 0) {
            if (deg == 0) {
                this._rotateText = false;
                if (this._text) {
                    if (log.isDebugEnabled()) {
                        log.debug("   super.setText(\"{}\");", (Object)this._unRotatedText);
                    }
                    super.setText(this._unRotatedText);
                    if (this._popupUtil != null) {
                        this.setOpaque(this._popupUtil.hasBackground());
                        this._popupUtil.setBorder(true);
                    }
                    if (this._namedIcon != null) {
                        String url = this._namedIcon.getURL();
                        if (url == null) {
                            if (this._text & this._icon) {
                                this._namedIcon = this.makeTextOverlaidIcon(this._unRotatedText, this._namedIcon);
                                this._namedIcon.rotate(deg, this);
                            } else if (this._text) {
                                this._namedIcon = null;
                            }
                        } else {
                            this._namedIcon = new NamedIcon(url, url);
                        }
                    }
                    super.setIcon(this._namedIcon);
                } else {
                    if (this._namedIcon != null) {
                        this._namedIcon.rotate(deg, this);
                    }
                    super.setIcon(this._namedIcon);
                }
            } else {
                if (this._text & this._icon) {
                    this._namedIcon = this.makeTextOverlaidIcon(this._unRotatedText, this._namedIcon);
                } else if (this._text) {
                    this._namedIcon = this.makeTextIcon(this._unRotatedText);
                }
                if (this._namedIcon != null) {
                    this._namedIcon.rotate(deg, this);
                    super.setIcon(this._namedIcon);
                    this.setOpaque(false);
                }
            }
        } else {
            if (this._text && this._icon) {
                this._namedIcon = this.makeTextOverlaidIcon(this._unRotatedText, this._namedIcon);
                super.setText(null);
                this._rotateText = true;
                this.setOpaque(false);
            } else if (this._text) {
                this._namedIcon = this.makeTextIcon(this._unRotatedText);
                super.setText(null);
                this._rotateText = true;
                this.setOpaque(false);
            }
            if (this._popupUtil != null) {
                this._popupUtil.setBorder(false);
            }
            if (this._namedIcon != null) {
                this._namedIcon.rotate(deg, this);
                super.setIcon(this._namedIcon);
            }
        }
        this.updateSize();
        this.repaint();
    }

    protected NamedIcon makeTextOverlaidIcon(String text, @Nonnull NamedIcon ic) {
        String url = ic.getURL();
        if (url == null) {
            return null;
        }
        NamedIcon icon = new NamedIcon(url, url);
        int iconWidth = icon.getIconWidth();
        int iconHeight = icon.getIconHeight();
        int textWidth = this.getFontMetrics(this.getFont()).stringWidth(text);
        int textHeight = this.getFontMetrics(this.getFont()).getHeight();
        int width = Math.max(textWidth, iconWidth);
        int height = Math.max(textHeight, iconHeight);
        int hOffset = Math.max((textWidth - iconWidth) / 2, 0);
        int vOffset = Math.max((textHeight - iconHeight) / 2, 0);
        if (this._popupUtil != null) {
            if (this._popupUtil.getFixedWidth() != 0) {
                switch (this._popupUtil.getJustification()) {
                    case 0: {
                        hOffset = this._popupUtil.getBorderSize();
                        break;
                    }
                    case 2: {
                        hOffset = this._popupUtil.getFixedWidth() - width;
                        hOffset += this._popupUtil.getBorderSize();
                        break;
                    }
                    default: {
                        hOffset = Math.max((this._popupUtil.getFixedWidth() - width) / 2, 0);
                        hOffset += this._popupUtil.getBorderSize();
                    }
                }
                width = this._popupUtil.getFixedWidth() + 2 * this._popupUtil.getBorderSize();
            } else {
                width += 2 * (this._popupUtil.getMargin() + this._popupUtil.getBorderSize());
                hOffset += this._popupUtil.getMargin() + this._popupUtil.getBorderSize();
            }
            if (this._popupUtil.getFixedHeight() != 0) {
                vOffset = Math.max(vOffset + (this._popupUtil.getFixedHeight() - height) / 2, 0);
                vOffset += this._popupUtil.getBorderSize();
                height = this._popupUtil.getFixedHeight() + 2 * this._popupUtil.getBorderSize();
            } else {
                height += 2 * (this._popupUtil.getMargin() + this._popupUtil.getBorderSize());
                vOffset += this._popupUtil.getMargin() + this._popupUtil.getBorderSize();
            }
        }
        BufferedImage bufIm = new BufferedImage(width, height, 2);
        Graphics2D g2d = bufIm.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        if (this._popupUtil != null) {
            if (this._popupUtil.hasBackground()) {
                g2d.setColor(this._popupUtil.getBackground());
                g2d.fillRect(0, 0, width, height);
            }
            if (this._popupUtil.getBorderSize() != 0) {
                g2d.setColor(this._popupUtil.getBorderColor());
                g2d.setStroke(new BasicStroke(2 * this._popupUtil.getBorderSize()));
                g2d.drawRect(0, 0, width, height);
            }
        }
        g2d.drawImage(icon.getImage(), AffineTransform.getTranslateInstance(hOffset, vOffset + 1), this);
        icon = new NamedIcon(bufIm);
        g2d.dispose();
        icon.setURL(url);
        return icon;
    }

    private NamedIcon makeTextIcon(String text) {
        if (text == null || text.equals("")) {
            text = " ";
        }
        int width = this.getFontMetrics(this.getFont()).stringWidth(text);
        int height = this.getFontMetrics(this.getFont()).getHeight();
        if (this._popupUtil != null) {
            if (this._popupUtil.getFixedWidth() != 0) {
                switch (this._popupUtil.getJustification()) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                width = this._popupUtil.getFixedWidth() + 2 * this._popupUtil.getBorderSize();
            } else {
                width += 2 * (this._popupUtil.getMargin() + this._popupUtil.getBorderSize());
            }
            height = this._popupUtil.getFixedHeight() != 0 ? this._popupUtil.getFixedHeight() + 2 * this._popupUtil.getBorderSize() : (height += 2 * (this._popupUtil.getMargin() + this._popupUtil.getBorderSize()));
        }
        BufferedImage bufIm = new BufferedImage(width + 2, height + 2, 2);
        Graphics2D g2d = bufIm.createGraphics();
        g2d.setBackground(new Color(0, 0, 0, 0));
        g2d.clearRect(0, 0, bufIm.getWidth(), bufIm.getHeight());
        g2d.setFont(this.getFont());
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        if (this._popupUtil != null) {
            if (this._popupUtil.hasBackground()) {
                g2d.setColor(this._popupUtil.getBackground());
                g2d.fillRect(0, 0, width, height);
            }
            if (this._popupUtil.getBorderSize() != 0) {
                g2d.setColor(this._popupUtil.getBorderColor());
                g2d.setStroke(new BasicStroke(2 * this._popupUtil.getBorderSize()));
                g2d.drawRect(0, 0, width, height);
            }
        }
        NamedIcon icon = new NamedIcon(bufIm);
        g2d.dispose();
        return icon;
    }

    public void setDegrees(int deg) {
        this._degrees = deg;
    }

    @Override
    public int getDegrees() {
        return this._degrees;
    }

    public void dispose() {
    }

    @Override
    public void remove() {
        LogixNG logixNG = this.getLogixNG();
        if (logixNG != null) {
            DeleteBean<LogixNG> deleteBean = new DeleteBean<LogixNG>(InstanceManager.getDefault(LogixNG_Manager.class));
            boolean hasChildren = logixNG.getNumConditionalNGs() > 0;
            deleteBean.delete(logixNG, hasChildren, t -> this.deleteLogixNG((LogixNG)t), (t, list) -> logixNG.getListenerRefsIncludingChildren(list), LogixNG_UserPreferences.class.getName());
        } else {
            this.doRemove();
        }
    }

    private void deleteLogixNG(LogixNG logixNG) {
        logixNG.setEnabled(false);
        try {
            InstanceManager.getDefault(LogixNG_Manager.class).deleteBean(logixNG, "DoDelete");
            this.setLogixNG(null);
            this.doRemove();
        }
        catch (PropertyVetoException e) {
            log.error("{} : Could not Delete.", (Object)e.getMessage());
        }
    }

    private void doRemove() {
        if (this._editor.removeFromContents(this)) {
            this.active = false;
            this.dispose();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    protected void setSuperText(String text) {
        this._unRotatedText = text;
        super.setText(text);
    }

    @Override
    public void setText(String text) {
        if ((this instanceof BlockContentsIcon || this instanceof MemoryIcon || this instanceof GlobalVariableIcon) && this._editor != null && !this._editor.isEditable() && this.isEmptyHidden()) {
            log.debug("label setText: {} :: {}", (Object)text, (Object)this.getNameString());
            if (text == null || text.trim().isEmpty()) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
        }
        this._unRotatedText = text;
        boolean bl = this._text = text != null && text.length() > 0;
        if (!(this.isIcon() || this._namedIcon == null && this._degrees == 0)) {
            log.debug("setText calls rotate({})", (Object)this._degrees);
            this.rotate(this._degrees);
        } else {
            log.debug("setText calls super.setText()");
            super.setText(text);
        }
    }

    @Override
    public Dimension getSize() {
        if (!this.needsRotate) {
            return super.getSize();
        }
        Dimension size = super.getSize();
        if (this._popupUtil == null) {
            return super.getSize();
        }
        switch (this._popupUtil.getOrientation()) {
            case 1: 
            case 2: {
                if (this._degrees != 0) {
                    this.rotate(0);
                }
                return new Dimension(size.height, size.width);
            }
        }
        return super.getSize();
    }

    @Override
    public int getHeight() {
        return this.getSize().height;
    }

    @Override
    public int getWidth() {
        return this.getSize().width;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this._popupUtil == null) {
            super.paintComponent(g);
        } else {
            Graphics2D g2d = (Graphics2D)g.create();
            if (SystemType.isMacOSX() || SystemType.isWindows()) {
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            }
            switch (this._popupUtil.getOrientation()) {
                case 1: {
                    g2d.translate(0.0, this.getSize().getHeight());
                    g2d.transform(AffineTransform.getQuadrantRotateInstance(-1));
                    break;
                }
                case 2: {
                    g2d.transform(AffineTransform.getQuadrantRotateInstance(1));
                    g2d.translate(0.0, -this.getSize().getWidth());
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    LoggingUtil.warnOnce(log, "Unexpected orientation = {}", this._popupUtil.getOrientation());
                }
            }
            this.needsRotate = true;
            super.paintComponent(g2d);
            this.needsRotate = false;
            if (this._popupUtil.getOrientation() == 0 && this._unRotatedText != null && this._degrees != 0) {
                double angleRAD = Math.toRadians(this._degrees);
                int iconWidth = this.getWidth();
                int iconHeight = this.getHeight();
                int textWidth = this.getFontMetrics(this.getFont()).stringWidth(this._unRotatedText);
                int textHeight = this.getFontMetrics(this.getFont()).getHeight();
                Point2D textSizeRotated = MathUtil.rotateRAD(textWidth, textHeight, angleRAD);
                int textWidthRotated = (int)textSizeRotated.getX();
                int textHeightRotated = (int)textSizeRotated.getY();
                int width = Math.max(textWidthRotated, iconWidth);
                int height = Math.max(textHeightRotated, iconHeight);
                int iconOffsetX = width / 2;
                int iconOffsetY = height / 2;
                g2d.transform(AffineTransform.getRotateInstance(angleRAD, iconOffsetX, iconOffsetY));
                int hOffset = iconOffsetX - textWidth / 2;
                int vOffset = iconOffsetY + textHeight / 4;
                g2d.setFont(this.getFont());
                g2d.setColor(this.getForeground());
                g2d.drawString(this._unRotatedText, hOffset, vOffset);
            }
        }
    }

    @Override
    public NamedBean getNamedBean() {
        return null;
    }

    @Override
    public LogixNG getLogixNG() {
        return this._logixNG;
    }

    @Override
    public void setLogixNG(LogixNG logixNG) {
        this._logixNG = logixNG;
    }

    @Override
    public void setLogixNG_SystemName(String systemName) {
        this._logixNG_SystemName = systemName;
    }

    @Override
    public void setupLogixNG() {
        this._logixNG = InstanceManager.getDefault(LogixNG_Manager.class).getBySystemName(this._logixNG_SystemName);
        if (this._logixNG == null) {
            throw new RuntimeException(String.format("LogixNG %s is not found for positional %s in panel %s", this._logixNG_SystemName, this.getNameString(), this.getEditor().getName()));
        }
        this._logixNG.setInlineLogixNG(this);
    }

    static class PaletteFrameCloser
    extends WindowAdapter {
        ItemPanel ip;

        PaletteFrameCloser(@Nonnull ItemPanel itemPanel) {
            this.ip = itemPanel;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.ip.closeDialogs();
        }
    }
}

