/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.CoordinateEdit;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableJPanel;
import jmri.jmrit.display.PositionablePropertiesUtil;
import jmri.util.ColorUtil;
import jmri.util.MenuScroller;
import jmri.util.swing.JmriColorChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionablePopupUtil {
    protected JComponent _textComponent;
    protected int _textType;
    protected Positionable _parent;
    protected PositionablePopupUtil _self;
    protected PositionablePropertiesUtil _propertiesUtil;
    private final Color defaultBorderColor;
    private boolean _suppressRecentColor = false;
    protected final int LABEL = 1;
    protected final int TEXTFIELD = 2;
    protected final int JCOMPONENT = 3;
    public static final int FONT_COLOR = 0;
    public static final int BACKGROUND_COLOR = 1;
    public static final int BORDER_COLOR = 2;
    public static final int MIN_SIZE = 5;
    private int fixedWidth = 0;
    private int fixedHeight = 0;
    private int margin = 0;
    private int borderSize = 0;
    private Color borderColor = null;
    private Border borderMargin = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    private Border outlineBorder = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    private boolean _hasBackground;
    JMenuItem italic = null;
    JMenuItem bold = null;
    private boolean _showBorder = true;
    public static final int LEFT = 0;
    public static final int RIGHT = 2;
    public static final int CENTRE = 4;
    private int justification = 4;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL_UP = 1;
    public static final int VERTICAL_DOWN = 2;
    private int orientation = 0;
    ArrayList<JMenuItem> editAdditionalMenu = new ArrayList(0);
    ArrayList<JMenuItem> viewAdditionalMenu = new ArrayList(0);
    private static final Logger log = LoggerFactory.getLogger(PositionablePopupUtil.class);

    public PositionablePopupUtil(Positionable parent, JComponent textComp) {
        this._parent = parent;
        this._textType = textComp instanceof JLabel ? 1 : (textComp instanceof JTextField ? 2 : 3);
        this._textComponent = textComp;
        this._self = this;
        this.defaultBorderColor = this._parent.getBackground();
        this._propertiesUtil = new PositionablePropertiesUtil(this._parent);
    }

    public PositionablePopupUtil clone(Positionable parent, JComponent textComp) {
        PositionablePopupUtil util = new PositionablePopupUtil(parent, textComp);
        util.setJustification(this.getJustification());
        util.setHorizontalAlignment(this.getJustification());
        util.setFixedWidth(this.getFixedWidth());
        util.setFixedHeight(this.getFixedHeight());
        util.setMargin(this.getMargin());
        util.setBorderSize(this.getBorderSize());
        util.setBorderColor(this.getBorderColor());
        util.setFont(this.getFont().deriveFont(this.getFontStyle()));
        util.setFontSize(this.getFontSize());
        util.setFontStyle(this.getFontStyle());
        util.setOrientation(this.getOrientation());
        util.setBackgroundColor(this.getBackground());
        util.setForeground(this.getForeground());
        util.setHasBackground(this.hasBackground());
        return util;
    }

    public String toString() {
        return this._parent.getNameString() + ": fixedWidth= " + this.fixedWidth + ", fixedHeight= " + this.fixedHeight + ", margin= " + this.margin + ", borderSize= " + this.borderSize;
    }

    public void propertyUtil(JPopupMenu popup) {
        JMenuItem edit = new JMenuItem(Bundle.getMessage("MenuItemProperties") + "...");
        edit.addActionListener(e -> this._propertiesUtil.display());
        popup.add(edit);
    }

    public void setFixedTextMenu(JPopupMenu popup) {
        JMenu edit = new JMenu(Bundle.getMessage("EditFixed"));
        JMenuItem jmi = this.getFixedWidth() == 0 ? edit.add("Width = Auto") : edit.add("Width = " + this._parent.maxWidth());
        jmi.setEnabled(false);
        jmi = this.getFixedHeight() == 0 ? edit.add("Height = Auto") : edit.add("Height = " + this._parent.maxHeight());
        jmi.setEnabled(false);
        edit.add(CoordinateEdit.getFixedSizeEditAction(this._parent));
        popup.add(edit);
    }

    public void setTextMarginMenu(JPopupMenu popup) {
        JMenu edit = new JMenu(Bundle.getMessage("EditMargin"));
        if (this.fixedHeight == 0 || this.fixedWidth == 0) {
            JMenuItem jmi = edit.add("Margin = " + this.getMargin());
            jmi.setEnabled(false);
            edit.add(CoordinateEdit.getMarginEditAction(this._parent));
        }
        popup.add(edit);
    }

    public void setBackgroundMenu(JPopupMenu popup) {
        JMenuItem edit = new JMenuItem(Bundle.getMessage("FontBackgroundColor"));
        edit.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this._textComponent, Bundle.getMessage("FontBackgroundColor"), this.getBackground());
            if (desiredColor != null) {
                this.setBackgroundColor(desiredColor);
            }
        });
        popup.add(edit);
    }

    public void setTextBorderMenu(JPopupMenu popup) {
        JMenu edit = new JMenu(Bundle.getMessage("EditBorder"));
        JMenuItem jmi = edit.add("Border Size = " + this.borderSize);
        jmi.setEnabled(false);
        edit.add(CoordinateEdit.getBorderEditAction(this._parent));
        JMenuItem colorMenu = new JMenuItem(Bundle.getMessage("BorderColorMenu"));
        colorMenu.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this._textComponent, Bundle.getMessage("BorderColorMenu"), this.defaultBorderColor);
            if (desiredColor != null) {
                this.setBorderColor(desiredColor);
            }
        });
        edit.add(colorMenu);
        popup.add(edit);
    }

    public void setTextFontMenu(JPopupMenu popup) {
        JMenu edit = new JMenu(Bundle.getMessage("EditFont"));
        edit.add(this.makeFontMenu());
        edit.add(this.makeFontSizeMenu());
        edit.add(this.makeFontStyleMenu());
        JMenuItem colorMenu = new JMenuItem(Bundle.getMessage("FontColor"));
        colorMenu.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this._textComponent, Bundle.getMessage("FontColor"), this._textComponent.getForeground());
            if (desiredColor != null) {
                this._textComponent.setForeground(desiredColor);
            }
        });
        edit.add(colorMenu);
        popup.add(edit);
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int m) {
        this.margin = m;
        this.borderMargin = this._parent.isOpaque() ? new LineBorder(this.getBackground(), m) : BorderFactory.createEmptyBorder(m, m, m, m);
        if (this._showBorder) {
            this._parent.setBorder(new CompoundBorder(this.outlineBorder, this.borderMargin));
        }
        this._parent.updateSize();
    }

    public int getFixedWidth() {
        return this.fixedWidth;
    }

    public void setFixedWidth(int w) {
        this.fixedWidth = w;
        if (log.isDebugEnabled()) {
            log.debug("setFixedWidth()={}", (Object)this.getFixedWidth());
        }
        this._parent.updateSize();
    }

    public int getFixedHeight() {
        return this.fixedHeight;
    }

    public void setFixedHeight(int h) {
        this.fixedHeight = h;
        log.debug("setFixedHeight()={}", (Object)this.getFixedHeight());
        this._parent.updateSize();
    }

    public void setFixedSize(int w, int h) {
        this.fixedWidth = w;
        this.fixedHeight = h;
        log.debug("setFixedSize()=({},{})", (Object)this.getFixedWidth(), (Object)this.getFixedHeight());
        this._parent.updateSize();
    }

    public void setBorderSize(int border) {
        this.borderSize = border;
        if (this.borderColor != null) {
            this.outlineBorder = new LineBorder(this.borderColor, this.borderSize);
            this._parent.setBorder(new CompoundBorder(this.outlineBorder, this.borderMargin));
        }
        this._parent.updateSize();
    }

    public void setBorder(boolean set) {
        this._showBorder = set;
        if (set) {
            if (this.borderColor != null) {
                this.outlineBorder = new LineBorder(this.borderColor, this.borderSize);
                this._parent.setBorder(new CompoundBorder(this.outlineBorder, this.borderMargin));
            }
        } else {
            this._parent.setBorder(null);
        }
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public void setBorderColor(Color border) {
        this.borderColor = border;
        if (this.borderColor != null && this._showBorder) {
            this.outlineBorder = new LineBorder(this.borderColor, this.borderSize);
            this._parent.setBorder(new CompoundBorder(this.outlineBorder, this.borderMargin));
        }
        if (!this._suppressRecentColor) {
            JmriColorChooser.addRecentColor(border);
        }
    }

    public Color getBorderColor() {
        if (this.borderColor == null) {
            this.borderColor = this._parent.getBackground();
        }
        return this.borderColor;
    }

    public void setForeground(Color c) {
        this._textComponent.setForeground(c);
        this._parent.updateSize();
        if (!this._suppressRecentColor) {
            JmriColorChooser.addRecentColor(c);
        }
    }

    public Color getForeground() {
        return this._textComponent.getForeground();
    }

    public void setBackgroundColor(Color color) {
        if (color == null || color.getAlpha() == 0) {
            this.setHasBackground(false);
            this._textComponent.setBackground(color);
        } else {
            this.setHasBackground(true);
            this._textComponent.setBackground(color);
            this._parent.setBackground(color);
            this._parent.setOpaque(true);
            if (!this._suppressRecentColor) {
                JmriColorChooser.addRecentColor(color);
            }
        }
        if (this.hasBackground()) {
            this.setMargin(this.margin);
        }
        this._parent.updateSize();
    }

    public void setSuppressRecentColor(boolean b) {
        this._suppressRecentColor = b;
    }

    public void setHasBackground(boolean set) {
        this._hasBackground = set;
        if (this._textComponent instanceof PositionableJPanel) {
            this._textComponent.setOpaque(this._hasBackground);
        }
        if (!this._hasBackground) {
            this._parent.setOpaque(false);
            this._textComponent.setOpaque(false);
        }
    }

    public boolean hasBackground() {
        return this._hasBackground;
    }

    public Color getBackground() {
        Color c = this._textComponent.getBackground();
        if (c == null) {
            c = Color.WHITE;
        }
        if (!this._hasBackground) {
            c = ColorUtil.setAlpha(c, 0);
        }
        return c;
    }

    protected JMenu makeFontMenu() {
        JMenu fontMenu = new JMenu("Font");
        String defaultFontFamilyName = this._textComponent.getFont().getFamily();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilyNames = ge.getAvailableFontFamilyNames();
        ButtonGroup fontButtonGroup = new ButtonGroup();
        for (String fontFamilyName : fontFamilyNames) {
            JCheckBoxMenuItem fontMenuItem = new JCheckBoxMenuItem(fontFamilyName);
            Font menuFont = fontMenuItem.getFont();
            menuFont = new Font(fontFamilyName, menuFont.getStyle(), menuFont.getSize());
            fontMenuItem.setFont(menuFont);
            fontMenuItem.addActionListener(e -> {
                Font newFont;
                Font oldFont = this._textComponent.getFont();
                if (!oldFont.equals(newFont = new Font(fontFamilyName, oldFont.getStyle(), oldFont.getSize()))) {
                    this.setFont(newFont);
                }
            });
            fontButtonGroup.add(fontMenuItem);
            fontMenuItem.setSelected(defaultFontFamilyName.equals(fontFamilyName));
            fontMenu.add(fontMenuItem);
        }
        MenuScroller.setScrollerFor(fontMenu, 36);
        return fontMenu;
    }

    protected JMenu makeFontSizeMenu() {
        JMenu sizeMenu = new JMenu("Font Size");
        ButtonGroup buttonGrp = new ButtonGroup();
        this.addFontSizeMenuEntry(sizeMenu, buttonGrp, 6);
        this.addFontSizeMenuEntry(sizeMenu, buttonGrp, 8);
        this.addFontSizeMenuEntry(sizeMenu, buttonGrp, 10);
        this.addFontSizeMenuEntry(sizeMenu, buttonGrp, 11);
        this.addFontSizeMenuEntry(sizeMenu, buttonGrp, 12);
        this.addFontSizeMenuEntry(sizeMenu, buttonGrp, 14);
        this.addFontSizeMenuEntry(sizeMenu, buttonGrp, 16);
        this.addFontSizeMenuEntry(sizeMenu, buttonGrp, 18);
        this.addFontSizeMenuEntry(sizeMenu, buttonGrp, 20);
        this.addFontSizeMenuEntry(sizeMenu, buttonGrp, 24);
        this.addFontSizeMenuEntry(sizeMenu, buttonGrp, 28);
        this.addFontSizeMenuEntry(sizeMenu, buttonGrp, 32);
        this.addFontSizeMenuEntry(sizeMenu, buttonGrp, 36);
        return sizeMenu;
    }

    void addFontSizeMenuEntry(JMenu menu, ButtonGroup fontButtonGroup, int size) {
        JRadioButtonMenuItem r = new JRadioButtonMenuItem("" + size);
        r.addActionListener(e -> this.setFontSize(size));
        fontButtonGroup.add(r);
        r.setSelected(this._textComponent.getFont().getSize() == size);
        menu.add(r);
    }

    public void setFont(Font font) {
        Font newFont;
        Font oldFont = this._textComponent.getFont();
        if (!oldFont.equals(newFont = new Font(font.getFamily(), oldFont.getStyle(), oldFont.getSize()))) {
            this._textComponent.setFont(newFont);
            this._parent.updateSize();
            this._parent.getEditor().setAttributes(this._self, this._parent);
        }
    }

    public Font getFont() {
        return this._textComponent.getFont();
    }

    public void setFontSize(float newSize) {
        this._textComponent.setFont(this._textComponent.getFont().deriveFont(newSize));
        this._parent.updateSize();
    }

    public int getFontSize() {
        return this._textComponent.getFont().getSize();
    }

    void setItalic() {
        log.debug("When style item selected italic state is {}", (Object)this.italic.isSelected());
        if (this.italic.isSelected()) {
            this.setFontStyle(2, 0);
        } else {
            this.setFontStyle(0, 2);
        }
    }

    void setBold() {
        log.debug("When style item selected bold state is {}", (Object)this.bold.isSelected());
        if (this.bold.isSelected()) {
            this.setFontStyle(1, 0);
        } else {
            this.setFontStyle(0, 1);
        }
    }

    protected JMenu makeFontStyleMenu() {
        JMenu styleMenu = new JMenu(Bundle.getMessage("FontStyle"));
        this.italic = this.newStyleMenuItem(new AbstractAction(Bundle.getMessage("Italic")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (log.isDebugEnabled()) {
                    log.debug("When style item selected {} italic state is {}", this.getValue("Name"), (Object)PositionablePopupUtil.this.italic.isSelected());
                }
                if (PositionablePopupUtil.this.italic.isSelected()) {
                    PositionablePopupUtil.this.setFontStyle(2, 0);
                } else {
                    PositionablePopupUtil.this.setFontStyle(0, 2);
                }
            }
        }, 2);
        styleMenu.add(this.italic);
        this.bold = this.newStyleMenuItem(new AbstractAction(Bundle.getMessage("Bold")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (log.isDebugEnabled()) {
                    log.debug("When style item selected {} bold state is {}", this.getValue("Name"), (Object)PositionablePopupUtil.this.bold.isSelected());
                }
                if (PositionablePopupUtil.this.bold.isSelected()) {
                    PositionablePopupUtil.this.setFontStyle(1, 0);
                } else {
                    PositionablePopupUtil.this.setFontStyle(0, 1);
                }
            }
        }, 1);
        styleMenu.add(this.bold);
        return styleMenu;
    }

    public void setFontStyle(int style) {
        this._textComponent.setFont(this._textComponent.getFont().deriveFont(style));
        this._parent.updateSize();
    }

    public void setFontStyle(int addStyle, int dropStyle) {
        int styleValue = this.getFontStyle() & ~dropStyle | addStyle;
        log.debug("setFontStyle: addStyle={}, dropStyle={}, net styleValue is {}", new Object[]{addStyle, dropStyle, styleValue});
        if (this.bold != null) {
            this.bold.setSelected((styleValue & 1) != 0);
        }
        if (this.italic != null) {
            this.italic.setSelected((styleValue & 2) != 0);
        }
        this._textComponent.setFont(this._textComponent.getFont().deriveFont(styleValue));
        this._parent.updateSize();
    }

    public int getFontStyle() {
        return this._textComponent.getFont().getStyle();
    }

    protected JMenuItem newStyleMenuItem(AbstractAction a, int mask) {
        JCheckBoxMenuItem c = new JCheckBoxMenuItem((String)a.getValue("Name"));
        c.addActionListener(a);
        if (log.isDebugEnabled()) {
            log.debug("When creating style item {} mask was {} state was {}", new Object[]{a.getValue("Name"), mask, this.getFontStyle()});
        }
        if ((mask & this.getFontStyle()) == mask) {
            c.setSelected(true);
        }
        return c;
    }

    public void copyItem(JPopupMenu popup) {
        JMenuItem edit = new JMenuItem("Copy");
        edit.addActionListener(e -> this._parent.getEditor().copyItem(this._parent));
        popup.add(edit);
    }

    public void setTextJustificationMenu(JPopupMenu popup) {
        JMenu justMenu = new JMenu(Bundle.getMessage("Justification"));
        this.addJustificationMenuEntry(justMenu, 0);
        this.addJustificationMenuEntry(justMenu, 2);
        this.addJustificationMenuEntry(justMenu, 4);
        popup.add(justMenu);
    }

    public void setJustification(int just) {
        log.debug("setJustification: justification={}", (Object)just);
        this.justification = just;
        this.setHorizontalAlignment(this.justification);
        this._parent.updateSize();
    }

    public void setJustification(String just) {
        log.debug("setJustification: justification ={}", (Object)just);
        switch (just) {
            case "right": {
                this.justification = 2;
                break;
            }
            case "center": 
            case "centre": {
                this.justification = 4;
                break;
            }
            default: {
                this.justification = 0;
            }
        }
        this.setHorizontalAlignment(this.justification);
        this._parent.updateSize();
    }

    public int getJustification() {
        log.debug("getJustification: justification ={}", (Object)this.justification);
        return this.justification;
    }

    void addJustificationMenuEntry(JMenu menu, int just) {
        JRadioButtonMenuItem r;
        ButtonGroup justButtonGroup = new ButtonGroup();
        switch (just) {
            case 2: {
                r = new JRadioButtonMenuItem(Bundle.getMessage("right"));
                break;
            }
            case 4: {
                r = new JRadioButtonMenuItem(Bundle.getMessage("center"));
                break;
            }
            default: {
                r = new JRadioButtonMenuItem(Bundle.getMessage("left"));
            }
        }
        r.addActionListener(e -> this.setJustification(just));
        justButtonGroup.add(r);
        if (this.justification == just) {
            r.setSelected(true);
        } else {
            r.setSelected(false);
        }
        menu.add(r);
    }

    public void setHorizontalAlignment(int alignment) {
        if (this._textType == 1) {
            switch (alignment) {
                case 0: {
                    ((JLabel)this._textComponent).setHorizontalAlignment(2);
                    break;
                }
                case 2: {
                    ((JLabel)this._textComponent).setHorizontalAlignment(4);
                    break;
                }
                default: {
                    ((JLabel)this._textComponent).setHorizontalAlignment(0);
                    break;
                }
            }
        } else if (this._textType == 2) {
            switch (alignment) {
                case 0: {
                    ((JTextField)this._textComponent).setHorizontalAlignment(2);
                    break;
                }
                case 2: {
                    ((JTextField)this._textComponent).setHorizontalAlignment(4);
                    break;
                }
                default: {
                    ((JTextField)this._textComponent).setHorizontalAlignment(0);
                }
            }
        }
    }

    public String getText() {
        if (this._textType == 1) {
            return ((JLabel)this._textComponent).getText();
        }
        if (this._textType == 2) {
            return ((JTextField)this._textComponent).getText();
        }
        return null;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int ori) {
        this.orientation = ori;
        this._parent.updateSize();
    }

    public void setOrientation(String ori) {
        switch (ori) {
            case "vertical_up": {
                this.setOrientation(1);
                break;
            }
            case "vertical_down": {
                this.setOrientation(2);
                break;
            }
            default: {
                this.setOrientation(0);
            }
        }
    }

    public void setTextOrientationMenu(JPopupMenu popup) {
        JMenu oriMenu = new JMenu(Bundle.getMessage("Orientation"));
        this.addOrientationMenuEntry(oriMenu, 0);
        this.addOrientationMenuEntry(oriMenu, 1);
        this.addOrientationMenuEntry(oriMenu, 2);
        popup.add(oriMenu);
    }

    void addOrientationMenuEntry(JMenu menu, int ori) {
        JRadioButtonMenuItem r;
        ButtonGroup justButtonGroup = new ButtonGroup();
        switch (ori) {
            default: {
                r = new JRadioButtonMenuItem("Horizontal");
                break;
            }
            case 1: {
                r = new JRadioButtonMenuItem("Vertical Up");
                break;
            }
            case 2: {
                r = new JRadioButtonMenuItem("Vertical Down");
            }
        }
        r.addActionListener(e -> this.setOrientation(ori));
        justButtonGroup.add(r);
        if (this.orientation == ori) {
            r.setSelected(true);
        } else {
            r.setSelected(false);
        }
        menu.add(r);
    }

    public void addEditPopUpMenu(JMenuItem menu) {
        if (!this.editAdditionalMenu.contains(menu)) {
            this.editAdditionalMenu.add(menu);
        }
    }

    public void addViewPopUpMenu(JMenuItem menu) {
        if (!this.viewAdditionalMenu.contains(menu)) {
            this.viewAdditionalMenu.add(menu);
        }
    }

    public void setAdditionalEditPopUpMenu(JPopupMenu popup) {
        if (this.editAdditionalMenu.isEmpty()) {
            return;
        }
        popup.addSeparator();
        this.editAdditionalMenu.forEach(popup::add);
    }

    public void setAdditionalViewPopUpMenu(JPopupMenu popup) {
        if (this.viewAdditionalMenu.isEmpty()) {
            return;
        }
        this.viewAdditionalMenu.forEach(popup::add);
    }
}

