/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.palette.Bundle;
import jmri.util.swing.ImagePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewPanel
extends JPanel {
    DisplayFrame _parent;
    JComboBox<String> _bgColorBox;
    private static final Logger log = LoggerFactory.getLogger(PreviewPanel.class);

    public PreviewPanel(DisplayFrame parent, ImagePanel panel1, ImagePanel panel2, boolean hasComboBox) {
        this._parent = parent;
        this.init(panel1, panel2, hasComboBox);
    }

    private void init(ImagePanel panel1, ImagePanel panel2, boolean hasComboBox) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 1), Bundle.getMessage("PreviewBorderTitle")));
        if (hasComboBox) {
            this.add(this.makeBgButtonPanel(panel1, panel2));
        }
        if (panel1 != null) {
            this.add(panel1);
        }
        if (panel2 != null) {
            this.add(panel2);
        }
    }

    public void setBackgroundSelection(int index) {
        if (this._bgColorBox != null) {
            this._bgColorBox.setSelectedIndex(index);
        }
    }

    private JPanel makeBgButtonPanel(ImagePanel preview1, ImagePanel preview2) {
        this._bgColorBox = new JComboBox();
        this._bgColorBox.addItem(Bundle.getMessage("PanelBgColor"));
        this._bgColorBox.addItem(Bundle.getMessage("White"));
        this._bgColorBox.addItem(Bundle.getMessage("LightGray"));
        this._bgColorBox.addItem(Bundle.getMessage("DarkGray"));
        this._bgColorBox.addItem(Bundle.getMessage("Checkers"));
        this._bgColorBox.setSelectedIndex(this._parent.getPreviewBg());
        JPanel bkgdBoxPanel = new JPanel();
        bkgdBoxPanel.setLayout(new BoxLayout(bkgdBoxPanel, 1));
        bkgdBoxPanel.add(new JLabel(Bundle.getMessage("setBackground"), 4));
        bkgdBoxPanel.add(this._bgColorBox);
        this._bgColorBox.addActionListener(e -> {
            log.debug("PreviewPanel _bgColorBox action");
            int previewBgSet = this._bgColorBox.getSelectedIndex();
            this._parent.setPreviewBg(previewBgSet);
            log.debug("PreviewPanel color #{} set", (Object)previewBgSet);
            if (preview1 != null) {
                preview1.setImage(this._parent.getPreviewBackground());
                preview1.revalidate();
            }
            if (preview2 != null) {
                preview2.setImage(this._parent.getPreviewBackground());
                preview2.revalidate();
            }
        });
        JPanel panel = new JPanel();
        panel.add(bkgdBoxPanel);
        return panel;
    }
}

