/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Reportable;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.picker.PickListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterIcon
extends PositionableLabel
implements PropertyChangeListener {
    Reporter reporter = null;
    private static final Logger log = LoggerFactory.getLogger(ReporterIcon.class);

    public ReporterIcon(Editor editor) {
        super("???", editor);
        this.setText("???");
        this.setPopupUtility(new ReporterPopupUtil(this, this));
    }

    @Override
    public Positionable deepClone() {
        ReporterIcon pos = new ReporterIcon(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(ReporterIcon pos) {
        pos.setReporter(this.reporter.getSystemName());
        return super.finishClone(pos);
    }

    public void setReporter(String pName) {
        if (InstanceManager.getNullableDefault(ReporterManager.class) != null) {
            try {
                this.reporter = InstanceManager.getDefault(ReporterManager.class).provideReporter(pName);
                this.setReporter(this.reporter);
            }
            catch (IllegalArgumentException e) {
                log.error("Reporter '{}' not available, icon won't see changes", (Object)pName);
            }
        } else {
            log.error("No ReporterManager for this protocol, icon won't see changes");
        }
    }

    public void setReporter(Reporter r) {
        if (this.reporter != null) {
            this.reporter.removePropertyChangeListener(this);
        }
        this.reporter = r;
        if (this.reporter != null) {
            this.displayState();
            this.reporter.addPropertyChangeListener(this);
        }
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("property change: {} is now {}", (Object)e.getPropertyName(), e.getNewValue());
        }
        this.displayState();
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_ReporterIcon");
    }

    @Override
    public String getNameString() {
        String name = this.reporter == null ? Bundle.getMessage("NotConnected") : this.reporter.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    void displayState() {
        Object currentReport = this.reporter.getCurrentReport();
        if (currentReport != null) {
            String reportString = null;
            reportString = currentReport instanceof Reportable ? ((Reportable)currentReport).toReportString() : currentReport.toString();
            if (currentReport.equals("")) {
                this.setText(Bundle.getMessage("Blank"));
            } else {
                this.setText(reportString);
            }
        } else {
            this.setText(Bundle.getMessage("NoReport"));
        }
        this.updateSize();
    }

    @Override
    protected void edit() {
        this.makeIconEditorFrame(this, "Reporter", true, null);
        this._iconEditor.setPickList(PickListModel.reporterPickModelInstance());
        ActionListener addIconAction = a -> this.editReporter();
        this._iconEditor.complete(addIconAction, false, true, true);
        this._iconEditor.setSelection(this.reporter);
    }

    void editReporter() {
        this.setReporter((Reporter)this._iconEditor.getTableSelection());
        this.setSize(this.getPreferredSize().width, this.getPreferredSize().height);
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.invalidate();
    }

    @Override
    public void dispose() {
        this.reporter.removePropertyChangeListener(this);
        this.reporter = null;
        super.dispose();
    }

    @Override
    public int maxHeight() {
        return this.getMaximumSize().height;
    }

    @Override
    public int maxWidth() {
        return this.getMaximumSize().width;
    }

    static class ReporterPopupUtil
    extends PositionablePopupUtil {
        ReporterPopupUtil(Positionable parent, JComponent textComp) {
            super(parent, textComp);
        }

        @Override
        public void setTextJustificationMenu(JPopupMenu popup) {
        }

        @Override
        public void setFixedTextMenu(JPopupMenu popup) {
        }

        @Override
        public void setTextMarginMenu(JPopupMenu popup) {
        }
    }
}

