/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.CoordinateEdit;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableIcon;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.SensorTextEdit;
import jmri.jmrit.display.palette.TableItemPanel;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.JmriColorChooser;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorIcon
extends PositionableIcon
implements PropertyChangeListener {
    public static final int UNKOWN_FONT_COLOR = 3;
    public static final int UNKOWN_BACKGROUND_COLOR = 4;
    public static final int ACTIVE_FONT_COLOR = 5;
    public static final int ACTIVE_BACKGROUND_COLOR = 6;
    public static final int INACTIVE_FONT_COLOR = 7;
    public static final int INACTIVE_BACKGROUND_COLOR = 8;
    public static final int INCONSISTENT_FONT_COLOR = 10;
    public static final int INCONSISTENT_BACKGROUND_COLOR = 11;
    protected HashMap<String, Integer> _name2stateMap;
    protected HashMap<Integer, String> _state2nameMap;
    private NamedBeanHandle<Sensor> namedSensor;
    JCheckBoxMenuItem momentaryItem = new JCheckBoxMenuItem(Bundle.getMessage("Momentary"));
    TableItemPanel<Sensor> _itemPanel;
    String originalText;
    boolean momentary = false;
    Color textColorActive = Color.red;
    Color textColorInActive = Color.yellow;
    Color textColorUnknown = Color.blue;
    Color textColorInconsistent = Color.black;
    Color backgroundColorActive = null;
    Color backgroundColorInActive = null;
    Color backgroundColorUnknown = null;
    Color backgroundColorInconsistent = null;
    private String activeText;
    private String inactiveText;
    private String inconsistentText;
    private String unknownText;
    private int flashStateOn = -1;
    private int flashStateOff = -1;
    private boolean flashon = false;
    private ActionListener taskPerformer;
    private Timer flashTimer;
    private static final Logger log = LoggerFactory.getLogger(SensorIcon.class);

    public SensorIcon(Editor editor) {
        this(new NamedIcon("resources/icons/smallschematics/tracksegments/circuit-error.gif", "resources/icons/smallschematics/tracksegments/circuit-error.gif"), editor);
    }

    public SensorIcon(NamedIcon s, Editor editor) {
        super(s, editor);
        this.setOpaque(false);
        this._control = true;
        this.setPopupUtility(new SensorPopupUtil(this, this));
    }

    public SensorIcon(String s, Editor editor) {
        super(s, editor);
        this._control = true;
        this.originalText = s;
        this.setPopupUtility(new SensorPopupUtil(this, this));
        this.displayState(this.sensorState());
    }

    @Override
    public Positionable deepClone() {
        SensorIcon pos = new SensorIcon(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(SensorIcon pos) {
        pos.setSensor(this.getNamedSensor().getName());
        pos.makeIconMap();
        pos._iconMap = SensorIcon.cloneMap(this._iconMap, pos);
        pos.setMomentary(this.getMomentary());
        pos.originalText = this.originalText;
        pos.setText(this.getText());
        pos.setIcon(null);
        pos._namedIcon = null;
        pos.activeText = this.activeText;
        pos.inactiveText = this.inactiveText;
        pos.inconsistentText = this.inconsistentText;
        pos.unknownText = this.unknownText;
        pos.textColorInconsistent = this.textColorInconsistent;
        pos.textColorUnknown = this.textColorUnknown;
        pos.textColorInActive = this.textColorInActive;
        pos.textColorActive = this.textColorActive;
        pos.backgroundColorInActive = this.backgroundColorInActive;
        pos.backgroundColorActive = this.backgroundColorActive;
        pos.backgroundColorUnknown = this.backgroundColorUnknown;
        pos.backgroundColorInconsistent = this.backgroundColorInconsistent;
        return super.finishClone(pos);
    }

    public void setSensor(String pName) {
        if (InstanceManager.getNullableDefault(SensorManager.class) != null) {
            try {
                Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(pName);
                this.setSensor(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, sensor));
            }
            catch (IllegalArgumentException ex) {
                log.error("Sensor '{}' not available, icon won't see changes", (Object)pName);
            }
        } else {
            log.error("No SensorManager for this protocol, icon won't see changes");
        }
    }

    public void setSensor(NamedBeanHandle<Sensor> s) {
        if (this.namedSensor != null) {
            this.getSensor().removePropertyChangeListener(this);
        }
        this.namedSensor = s;
        if (this.namedSensor != null) {
            if (this._iconMap == null) {
                this.makeIconMap();
            }
            this.getSensor().addPropertyChangeListener(this, s.getName(), "SensorIcon on Panel " + this._editor.getName());
            this.setName(this.namedSensor.getName());
        }
        this.setAttributes();
    }

    private void setAttributes() {
        if (this.isText()) {
            if (this.namedSensor != null && this.getSensor().getUserName() != null) {
                String userName = this.getSensor().getUserName();
                if (this.activeText == null) {
                    this.activeText = userName;
                }
                if (this.inactiveText == null) {
                    this.inactiveText = userName;
                }
                if (this.inconsistentText == null) {
                    this.inconsistentText = userName;
                }
                if (this.unknownText == null) {
                    this.unknownText = userName;
                }
            }
            if (this.activeText == null) {
                this.activeText = "<" + Bundle.getMessage("SensorStateActive").toLowerCase() + ">";
            }
            if (this.inactiveText == null) {
                this.inactiveText = "<" + Bundle.getMessage("SensorStateInactive").toLowerCase() + ">";
            }
            if (this.inconsistentText == null) {
                this.inconsistentText = "<" + Bundle.getMessage("BeanStateInconsistent").toLowerCase() + ">";
            }
            if (this.unknownText == null) {
                this.unknownText = "<" + Bundle.getMessage("BeanStateUnknown").toLowerCase() + ">";
            }
            if (this.textColorActive == null) {
                this.textColorActive = Color.red;
            }
            if (this.textColorInActive == null) {
                this.textColorInActive = Color.yellow;
            }
            if (this.textColorUnknown == null) {
                this.textColorUnknown = Color.blue;
            }
            if (this.textColorInconsistent == null) {
                this.textColorInconsistent = Color.black;
            }
        } else {
            this.setOpaque(false);
        }
        this.displayState(this.sensorState());
        if (log.isDebugEnabled()) {
            log.debug("setSensor: namedSensor= {} isIcon= {}, isText= {}, activeText= {}", new Object[]{this.namedSensor == null ? "null" : this.getNameString(), this.isIcon(), this.isText(), this.activeText});
        }
        this.repaint();
    }

    public Sensor getSensor() {
        if (this.namedSensor == null) {
            return null;
        }
        return this.namedSensor.getBean();
    }

    @Override
    public NamedBean getNamedBean() {
        return this.getSensor();
    }

    public NamedBeanHandle<Sensor> getNamedSensor() {
        return this.namedSensor;
    }

    void makeIconMap() {
        this._iconMap = new HashMap();
        this._name2stateMap = new HashMap();
        this._name2stateMap.put("BeanStateUnknown", 1);
        this._name2stateMap.put("BeanStateInconsistent", 8);
        this._name2stateMap.put("SensorStateActive", 2);
        this._name2stateMap.put("SensorStateInactive", 4);
        this._state2nameMap = new HashMap();
        this._state2nameMap.put(1, "BeanStateUnknown");
        this._state2nameMap.put(8, "BeanStateInconsistent");
        this._state2nameMap.put(2, "SensorStateActive");
        this._state2nameMap.put(4, "SensorStateInactive");
    }

    @Override
    public Collection<String> getStateNameCollection() {
        return this._state2nameMap.values();
    }

    public void setIcon(String name, NamedIcon icon) {
        log.debug("setIcon for name \"{}\"", (Object)name);
        if (this._iconMap == null) {
            this.makeIconMap();
        }
        this._iconMap.put(name, icon);
        this.displayState(this.sensorState());
    }

    @Override
    public NamedIcon getIcon(String state) {
        return (NamedIcon)this._iconMap.get(state);
    }

    public NamedIcon getIcon(int state) {
        return (NamedIcon)this._iconMap.get(this._state2nameMap.get(state));
    }

    @Override
    public String getFamily() {
        return this._iconFamily;
    }

    @Override
    public void setFamily(String family) {
        this._iconFamily = family;
    }

    int sensorState() {
        if (this.namedSensor != null) {
            return this.getSensor().getKnownState();
        }
        return 1;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("property change: {}", (Object)e);
        if (e.getPropertyName().equals("KnownState")) {
            int now = (Integer)e.getNewValue();
            this.displayState(now);
            this._editor.repaint();
        }
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_SensorIcon");
    }

    @Override
    @Nonnull
    public String getNameString() {
        String name = this.namedSensor == null ? Bundle.getMessage("NotConnected") : this.getSensor().getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this.isEditable()) {
            if (this.isIcon()) {
                popup.add(new AbstractAction(Bundle.getMessage("ChangeToText")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SensorIcon.this.changeLayoutSensorType();
                    }
                });
            } else {
                popup.add(new AbstractAction(Bundle.getMessage("ChangeToIcon")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SensorIcon.this.changeLayoutSensorType();
                    }
                });
            }
            popup.add(this.momentaryItem);
            this.momentaryItem.setSelected(this.getMomentary());
            this.momentaryItem.addActionListener(e -> this.setMomentary(this.momentaryItem.isSelected()));
        } else if (this.getPopupUtility() != null) {
            this.getPopupUtility().setAdditionalViewPopUpMenu(popup);
        }
        return true;
    }

    @Override
    public boolean setTextEditMenu(JPopupMenu popup) {
        log.debug("setTextEditMenu isIcon={}, isText={}", (Object)this.isIcon(), (Object)this.isText());
        if (this.isIcon()) {
            popup.add(CoordinateEdit.getTextEditAction(this, "OverlayText"));
        } else {
            popup.add(new AbstractAction(Bundle.getMessage("SetSensorText")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String name = SensorIcon.this.getNameString();
                    SensorIcon.this.sensorTextEdit(name);
                }
            });
            if (this.isText() && !this.isIcon()) {
                JMenu stateColor = new JMenu(Bundle.getMessage("StateColors"));
                stateColor.add(this.stateMenu(Bundle.getMessage("BeanStateUnknown"), 3));
                stateColor.add(this.stateMenu(Bundle.getMessage("SensorStateActive"), 5));
                stateColor.add(this.stateMenu(Bundle.getMessage("SensorStateInactive"), 7));
                stateColor.add(this.stateMenu(Bundle.getMessage("BeanStateInconsistent"), 10));
                popup.add(stateColor);
            }
        }
        return true;
    }

    public void sensorTextEdit(String name) {
        log.debug("make text edit menu");
        SensorTextEdit f = new SensorTextEdit();
        f.addHelpMenu("package.jmri.jmrit.display.SensorTextEdit", true);
        try {
            f.initComponents(this, name);
        }
        catch (Exception ex) {
            log.error("Exception: {}", (Object)ex.toString());
        }
        f.setVisible(true);
    }

    @Override
    public void displayState(int state) {
        if (this.getNamedSensor() == null) {
            log.debug("Display state {}, disconnected", (Object)state);
        } else if (this.isIcon()) {
            NamedIcon icon = this.getIcon(state);
            if (icon != null) {
                super.setIcon(icon);
            }
        } else if (this.isText()) {
            switch (state) {
                case 1: {
                    super.setText(this.unknownText);
                    this.getPopupUtility().setBackgroundColor(this.backgroundColorUnknown);
                    this.getPopupUtility().setForeground(this.textColorUnknown);
                    break;
                }
                case 2: {
                    super.setText(this.activeText);
                    this.getPopupUtility().setBackgroundColor(this.backgroundColorActive);
                    this.getPopupUtility().setForeground(this.textColorActive);
                    break;
                }
                case 4: {
                    super.setText(this.inactiveText);
                    this.getPopupUtility().setBackgroundColor(this.backgroundColorInActive);
                    this.getPopupUtility().setForeground(this.textColorInActive);
                    break;
                }
                default: {
                    super.setText(this.inconsistentText);
                    this.getPopupUtility().setBackgroundColor(this.backgroundColorInconsistent);
                    this.getPopupUtility().setForeground(this.textColorInconsistent);
                }
            }
        }
        int deg = this.getDegrees();
        this.rotate(deg);
        if (deg == 0) {
            this.setOpaque(this.getPopupUtility().hasBackground());
        }
        this.updateSize();
    }

    @Override
    public boolean setEditItemMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameSensor"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensorIcon.this.editItem();
            }
        });
        return true;
    }

    protected void editItem() {
        this._paletteFrame = this.makePaletteFrame(MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameSensor")));
        this._itemPanel = new TableItemPanel<Sensor>(this._paletteFrame, "Sensor", this._iconFamily, PickListModel.sensorPickModelInstance());
        ActionListener updateAction = a -> this.updateItem();
        HashMap<String, NamedIcon> map = new HashMap<String, NamedIcon>();
        for (Map.Entry entry : this._iconMap.entrySet()) {
            NamedIcon oldIcon = (NamedIcon)entry.getValue();
            NamedIcon newIcon = SensorIcon.cloneIcon(oldIcon, this);
            newIcon.rotate(0, this);
            newIcon.scale(1.0, this);
            newIcon.setRotation(4, this);
            map.put((String)entry.getKey(), newIcon);
        }
        this._itemPanel.init(updateAction, map);
        this._itemPanel.setSelection(this.getSensor());
        this.initPaletteFrame(this._paletteFrame, this._itemPanel);
    }

    void updateItem() {
        HashMap<String, NamedIcon> oldMap = SensorIcon.cloneMap(this._iconMap, this);
        this.setSensor(this._itemPanel.getTableSelection().getSystemName());
        this._iconFamily = this._itemPanel.getFamilyName();
        HashMap<String, NamedIcon> iconMap = this._itemPanel.getIconMap();
        if (iconMap != null) {
            for (Map.Entry<String, NamedIcon> entry : iconMap.entrySet()) {
                if (log.isDebugEnabled()) {
                    log.debug("key= {}", (Object)entry.getKey());
                }
                NamedIcon newIcon = entry.getValue();
                NamedIcon oldIcon = oldMap.get(entry.getKey());
                newIcon.setLoad(oldIcon.getDegrees(), oldIcon.getScale(), this);
                newIcon.setRotation(oldIcon.getRotation(), this);
                this.setIcon(entry.getKey(), newIcon);
            }
        }
        this.finishItemUpdate(this._paletteFrame, this._itemPanel);
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameSensor"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensorIcon.this.edit();
            }
        });
        return true;
    }

    @Override
    protected void edit() {
        this.makeIconEditorFrame(this, "Sensor", true, null);
        this._iconEditor.setPickList(PickListModel.sensorPickModelInstance());
        int i = 0;
        for (Map.Entry entry : this._iconMap.entrySet()) {
            this._iconEditor.setIcon(i++, (String)entry.getKey(), (NamedIcon)entry.getValue());
        }
        this._iconEditor.makeIconPanel(false);
        ActionListener addIconAction = a -> this.updateSensor();
        this._iconEditor.complete(addIconAction, true, true, true);
        this._iconEditor.setSelection(this.getSensor());
    }

    void updateSensor() {
        HashMap<String, NamedIcon> oldMap = SensorIcon.cloneMap(this._iconMap, this);
        this.setSensor(this._iconEditor.getTableSelection().getDisplayName());
        Hashtable<String, NamedIcon> iconMap = this._iconEditor.getIconMap();
        for (Map.Entry<String, NamedIcon> entry : iconMap.entrySet()) {
            log.debug("key= {}", (Object)entry.getKey());
            NamedIcon newIcon = entry.getValue();
            NamedIcon oldIcon = oldMap.get(entry.getKey());
            newIcon.setLoad(oldIcon.getDegrees(), oldIcon.getScale(), this);
            newIcon.setRotation(oldIcon.getRotation(), this);
            this.setIcon(entry.getKey(), newIcon);
        }
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.invalidate();
    }

    public void setOriginalText(String s) {
        this.originalText = s;
        this.displayState(this.sensorState());
    }

    public String getOriginalText() {
        return this.originalText;
    }

    @Override
    public void setText(String s) {
        this.setOpaque(false);
        if (this._rotateText && !this._icon) {
            return;
        }
        this._text = s != null && s.length() > 0;
        super.setText(s);
        this.updateSize();
    }

    public boolean getMomentary() {
        return this.momentary;
    }

    public void setMomentary(boolean m) {
        this.momentary = m;
    }

    public boolean buttonLive() {
        if (this.namedSensor == null) {
            log.error("No sensor connection, can't process click");
            return false;
        }
        return this._editor.getFlag(2, this.isControlling());
    }

    @Override
    public void doMousePressed(JmriMouseEvent e) {
        log.debug("doMousePressed buttonLive={}, getMomentary={}", (Object)this.buttonLive(), (Object)this.getMomentary());
        if (this.getMomentary() && this.buttonLive() && !e.isMetaDown() && !e.isAltDown()) {
            try {
                this.getSensor().setKnownState(2);
            }
            catch (JmriException reason) {
                log.warn("Exception setting momentary sensor", (Throwable)reason);
            }
        }
        super.doMousePressed(e);
    }

    @Override
    public void doMouseReleased(JmriMouseEvent e) {
        if (this.getMomentary() && this.buttonLive() && !e.isMetaDown() && !e.isAltDown()) {
            try {
                this.getSensor().setKnownState(4);
            }
            catch (JmriException reason) {
                log.warn("Exception setting momentary sensor", (Throwable)reason);
            }
        }
        super.doMouseReleased(e);
    }

    @Override
    public void doMouseClicked(JmriMouseEvent e) {
        if (this.buttonLive() && !this.getMomentary() && !e.isMetaDown() && !e.isAltDown()) {
            try {
                if (this.getSensor().getKnownState() == 4) {
                    this.getSensor().setKnownState(2);
                } else {
                    this.getSensor().setKnownState(4);
                }
            }
            catch (JmriException reason) {
                log.warn("Exception flipping sensor", (Throwable)reason);
            }
        }
        super.doMouseClicked(e);
    }

    @Override
    public void dispose() {
        if (this.namedSensor != null) {
            this.getSensor().removePropertyChangeListener(this);
        }
        this.namedSensor = null;
        this._iconMap = null;
        this._name2stateMap = null;
        this._state2nameMap = null;
        super.dispose();
    }

    protected HashMap<Integer, NamedIcon> cloneMap(HashMap<Integer, NamedIcon> map, SensorIcon pos) {
        HashMap<Integer, NamedIcon> clone = new HashMap<Integer, NamedIcon>();
        if (map != null) {
            for (Map.Entry<Integer, NamedIcon> entry : map.entrySet()) {
                clone.put(entry.getKey(), SensorIcon.cloneIcon(entry.getValue(), pos));
                if (pos == null) continue;
                pos.setIcon(pos._state2nameMap.get(entry.getKey()), (NamedIcon)this._iconMap.get(entry.getKey().toString()));
            }
        }
        return clone;
    }

    public void setTextActive(Color color) {
        this.textColorActive = color;
        this.displayState(this.sensorState());
        JmriColorChooser.addRecentColor(color);
    }

    public Color getTextActive() {
        return this.textColorActive;
    }

    public void setTextInActive(Color color) {
        this.textColorInActive = color;
        this.displayState(this.sensorState());
        JmriColorChooser.addRecentColor(color);
    }

    public Color getTextInActive() {
        return this.textColorInActive;
    }

    public void setTextUnknown(Color color) {
        this.textColorUnknown = color;
        this.displayState(this.sensorState());
        JmriColorChooser.addRecentColor(color);
    }

    public Color getTextUnknown() {
        return this.textColorUnknown;
    }

    public void setTextInconsistent(Color color) {
        this.textColorInconsistent = color;
        this.displayState(this.sensorState());
        JmriColorChooser.addRecentColor(color);
    }

    public Color getTextInconsistent() {
        return this.textColorInconsistent;
    }

    public void setBackgroundActive(Color color) {
        this.backgroundColorActive = color;
        this.displayState(this.sensorState());
        JmriColorChooser.addRecentColor(color);
    }

    public Color getBackgroundActive() {
        return this.backgroundColorActive;
    }

    public void setBackgroundInActive(Color color) {
        this.backgroundColorInActive = color;
        this.displayState(this.sensorState());
        JmriColorChooser.addRecentColor(color);
    }

    public Color getBackgroundInActive() {
        return this.backgroundColorInActive;
    }

    public void setBackgroundUnknown(Color color) {
        this.backgroundColorUnknown = color;
        this.displayState(this.sensorState());
        JmriColorChooser.addRecentColor(color);
    }

    public Color getBackgroundUnknown() {
        return this.backgroundColorUnknown;
    }

    public void setBackgroundInconsistent(Color color) {
        this.backgroundColorInconsistent = color;
        this.displayState(this.sensorState());
        JmriColorChooser.addRecentColor(color);
    }

    public Color getBackgroundInconsistent() {
        return this.backgroundColorInconsistent;
    }

    public String getActiveText() {
        return this.activeText;
    }

    public void setActiveText(String i) {
        this.activeText = i;
        this.displayState(this.sensorState());
    }

    public String getInactiveText() {
        return this.inactiveText;
    }

    public void setInactiveText(String i) {
        this.inactiveText = i;
        this.displayState(this.sensorState());
    }

    public String getInconsistentText() {
        return this.inconsistentText;
    }

    public void setInconsistentText(String i) {
        this.inconsistentText = i;
        this.displayState(this.sensorState());
    }

    public String getUnknownText() {
        return this.unknownText;
    }

    public void setUnknownText(String i) {
        this.unknownText = i;
        this.displayState(this.sensorState());
    }

    JMenu stateMenu(String name, int state) {
        JMenu menu = new JMenu(name);
        JMenuItem colorMenu = new JMenuItem(Bundle.getMessage("FontColor"));
        colorMenu.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("FontColor"), this.getColor(state));
            if (desiredColor != null) {
                this.setColor(desiredColor, state);
            }
        });
        menu.add(colorMenu);
        colorMenu = new JMenuItem(Bundle.getMessage("FontBackgroundColor"));
        colorMenu.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("FontBackgroundColor"), this.getColor(state + 1));
            if (desiredColor != null) {
                this.setColor(desiredColor, state + 1);
            }
        });
        menu.add(colorMenu);
        return menu;
    }

    private void setColor(Color desiredColor, int state) {
        PositionablePopupUtil pop = this.getPopupUtility();
        if (pop instanceof SensorPopupUtil) {
            SensorPopupUtil util = (SensorPopupUtil)pop;
            switch (state) {
                case 0: {
                    util.setForeground(desiredColor);
                    break;
                }
                case 1: {
                    util.setBackgroundColor(desiredColor);
                    break;
                }
                case 2: {
                    util.setBorderColor(desiredColor);
                    break;
                }
                case 3: {
                    this.setTextUnknown(desiredColor);
                    break;
                }
                case 4: {
                    util.setHasBackground(desiredColor != null);
                    this.setBackgroundUnknown(desiredColor);
                    break;
                }
                case 5: {
                    this.setTextActive(desiredColor);
                    break;
                }
                case 6: {
                    util.setHasBackground(desiredColor != null);
                    this.setBackgroundActive(desiredColor);
                    break;
                }
                case 7: {
                    this.setTextInActive(desiredColor);
                    break;
                }
                case 8: {
                    util.setHasBackground(desiredColor != null);
                    this.setBackgroundInActive(desiredColor);
                    break;
                }
                case 10: {
                    this.setTextInconsistent(desiredColor);
                    break;
                }
                case 11: {
                    util.setHasBackground(desiredColor != null);
                    this.setBackgroundInconsistent(desiredColor);
                    break;
                }
            }
        }
    }

    private Color getColor(int state) {
        PositionablePopupUtil pop = this.getPopupUtility();
        if (pop instanceof SensorPopupUtil) {
            SensorPopupUtil util = (SensorPopupUtil)pop;
            switch (state) {
                case 0: {
                    return util.getForeground();
                }
                case 1: {
                    return util.getBackground();
                }
                case 2: {
                    return util.getBorderColor();
                }
                case 3: {
                    return this.getTextUnknown();
                }
                case 4: {
                    return this.getBackgroundUnknown();
                }
                case 5: {
                    return this.getTextActive();
                }
                case 6: {
                    return this.getBackgroundActive();
                }
                case 7: {
                    return this.getTextInActive();
                }
                case 8: {
                    return this.getBackgroundInActive();
                }
                case 10: {
                    return this.getTextInconsistent();
                }
                case 11: {
                    return this.getBackgroundInconsistent();
                }
            }
            return null;
        }
        return null;
    }

    void changeLayoutSensorType() {
        if (this.isIcon()) {
            this._icon = false;
            this._text = true;
            this.setIcon(null);
            this.setSuperText(null);
            this.setOpaque(true);
        } else if (this.isText()) {
            this._icon = true;
            this._text = this.originalText != null && this.originalText.length() > 0;
            this.setUnRotatedText(this.getOriginalText());
            this.setOpaque(false);
        }
        this._namedIcon = null;
        this.setAttributes();
        this.displayState(this.sensorState());
        int deg = this.getDegrees();
        this.rotate(deg);
        if (deg != 0 && this._text && !this._icon) {
            this.setSuperText(null);
        }
    }

    public synchronized void flashSensor(int tps, int state1, int state2) {
        if (this.flashTimer != null && this.flashTimer.isRunning()) {
            return;
        }
        if (tps > 10) {
            tps = 10;
        } else if (tps <= 0) {
            return;
        }
        if (this._state2nameMap.get(state1) == null || this._state2nameMap.get(state2) == null) {
            log.error("one or other of the states passed for flash is null");
            return;
        }
        if (state1 == state2) {
            log.debug("Both states to flash between are the same, therefore no flashing will occur");
            return;
        }
        int interval = 1000 / tps / 2;
        this.flashStateOn = state1;
        this.flashStateOff = state2;
        if (this.taskPerformer == null) {
            this.taskPerformer = evt -> {
                if (this.flashon) {
                    this.flashon = false;
                    this.displayState(this.flashStateOn);
                } else {
                    this.flashon = true;
                    this.displayState(this.flashStateOff);
                }
            };
        }
        this.flashTimer = new Timer(interval, this.taskPerformer);
        this.flashTimer.start();
    }

    public synchronized void stopFlash() {
        if (this.flashTimer != null) {
            this.flashTimer.stop();
        }
        this.displayState(this.sensorState());
    }

    class SensorPopupUtil
    extends PositionablePopupUtil {
        SensorPopupUtil(Positionable parent, JComponent textComp) {
            super(parent, textComp);
        }

        @Override
        public SensorPopupUtil clone(Positionable parent, JComponent textComp) {
            SensorPopupUtil util = new SensorPopupUtil(parent, textComp);
            util.setJustification(this.getJustification());
            util.setHorizontalAlignment(this.getJustification());
            util.setFixedWidth(this.getFixedWidth());
            util.setFixedHeight(this.getFixedHeight());
            util.setMargin(this.getMargin());
            util.setBorderSize(this.getBorderSize());
            util.setBorderColor(this.getBorderColor());
            util.setFont(util.getFont().deriveFont(this.getFontStyle()));
            util.setFontSize(this.getFontSize());
            util.setOrientation(this.getOrientation());
            util.setBackgroundColor(this.getBackground());
            util.setForeground(this.getForeground());
            util.setHasBackground(this.hasBackground());
            return util;
        }

        @Override
        public void setTextJustificationMenu(JPopupMenu popup) {
            if (SensorIcon.this.isText()) {
                super.setTextJustificationMenu(popup);
            }
        }

        @Override
        public void setTextOrientationMenu(JPopupMenu popup) {
            if (SensorIcon.this.isText()) {
                super.setTextOrientationMenu(popup);
            }
        }

        @Override
        public void setFixedTextMenu(JPopupMenu popup) {
            if (SensorIcon.this.isText()) {
                super.setFixedTextMenu(popup);
            }
        }

        @Override
        public void setTextMarginMenu(JPopupMenu popup) {
            if (SensorIcon.this.isText()) {
                super.setTextMarginMenu(popup);
            }
        }

        @Override
        public void setTextBorderMenu(JPopupMenu popup) {
            if (SensorIcon.this.isText()) {
                super.setTextBorderMenu(popup);
            }
        }

        @Override
        public void setTextFontMenu(JPopupMenu popup) {
            if (SensorIcon.this.isText()) {
                super.setTextFontMenu(popup);
            }
        }

        @Override
        public void setBackgroundMenu(JPopupMenu popup) {
            if (SensorIcon.this.isIcon()) {
                super.setBackgroundMenu(popup);
            }
        }
    }
}

