/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.jmrit.blockboss.BlockBossFrame;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableIcon;
import jmri.jmrit.display.palette.SignalHeadItemPanel;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHeadIcon
extends PositionableIcon
implements PropertyChangeListener {
    private String[] _validKeys;
    private NamedBeanHandle<SignalHead> namedHead;
    private HashMap<String, NamedIcon> _saveMap;
    private SignalHeadItemPanel _itemPanel;
    protected int clickMode = 3;
    protected boolean litMode = false;
    private static final Logger log = LoggerFactory.getLogger(SignalHeadIcon.class);

    public SignalHeadIcon(Editor editor) {
        super(editor);
        this._control = true;
    }

    @Override
    public Positionable deepClone() {
        SignalHeadIcon pos = new SignalHeadIcon(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(SignalHeadIcon pos) {
        pos.setSignalHead(this.getNamedSignalHead().getName());
        for (Map.Entry entry : this._iconMap.entrySet()) {
            pos.setIcon((String)entry.getKey(), (NamedIcon)entry.getValue());
        }
        pos.setClickMode(this.getClickMode());
        pos.setLitMode(this.getLitMode());
        return super.finishClone(pos);
    }

    public void setSignalHead(NamedBeanHandle<SignalHead> sh) {
        if (this.namedHead != null) {
            this.getSignalHead().removePropertyChangeListener(this);
        }
        this.namedHead = sh;
        if (this.namedHead != null) {
            this._iconMap = new HashMap();
            this._validKeys = this.getSignalHead().getValidStateKeys();
            this.displayState(this.headState());
            this.getSignalHead().addPropertyChangeListener(this, this.namedHead.getName(), "SignalHead Icon");
        }
    }

    public void setSignalHead(String pName) {
        SignalHead mHead = (SignalHead)InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(pName);
        if (mHead == null) {
            log.warn("did not find a SignalHead named {}", (Object)pName);
        } else {
            this.setSignalHead(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, mHead));
        }
    }

    public NamedBeanHandle<SignalHead> getNamedSignalHead() {
        return this.namedHead;
    }

    public SignalHead getSignalHead() {
        if (this.namedHead == null) {
            return null;
        }
        return this.namedHead.getBean();
    }

    @Override
    public NamedBean getNamedBean() {
        return this.getSignalHead();
    }

    public void setIcon(String state, NamedIcon icon) {
        log.debug("setIcon for {}", (Object)state);
        if (this.isValidState(state)) {
            this._iconMap.put(state, icon);
            this.displayState(this.headState());
        }
    }

    private boolean isValidState(String key) {
        if (key == null) {
            return false;
        }
        if (key.equals("SignalHeadStateDark") || key.equals("SignalHeadStateHeld")) {
            log.debug("{} is a valid state.", (Object)key);
            return true;
        }
        for (String valid : this._validKeys) {
            if (!key.equals(valid)) continue;
            log.debug("{} is a valid state.", (Object)key);
            return true;
        }
        log.debug("{} is NOT a valid state.", (Object)key);
        return false;
    }

    public int headState() {
        if (this.getSignalHead() == null) {
            return 0;
        }
        return this.getSignalHead().getAppearance();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("property change: {} current state: {}", (Object)e.getPropertyName(), (Object)this.headState());
        this.displayState(this.headState());
        this._editor.getTargetPanel().repaint();
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_SignalHead");
    }

    @Override
    @Nonnull
    public String getNameString() {
        if (this.namedHead == null) {
            return Bundle.getMessage("NotConnected");
        }
        return this.namedHead.getName();
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this.isEditable()) {
            JMenu clickMenu = new JMenu(Bundle.getMessage("WhenClicked"));
            ButtonGroup clickButtonGroup = new ButtonGroup();
            JRadioButtonMenuItem r = new JRadioButtonMenuItem(Bundle.getMessage("ChangeAspect"));
            r.addActionListener(e -> this.setClickMode(3));
            clickButtonGroup.add(r);
            r.setSelected(this.clickMode == 3);
            clickMenu.add(r);
            r = new JRadioButtonMenuItem(Bundle.getMessage("Cycle3Aspects"));
            r.addActionListener(e -> this.setClickMode(0));
            clickButtonGroup.add(r);
            r.setSelected(this.clickMode == 0);
            clickMenu.add(r);
            r = new JRadioButtonMenuItem(Bundle.getMessage("AlternateLit"));
            r.addActionListener(e -> this.setClickMode(1));
            clickButtonGroup.add(r);
            r.setSelected(this.clickMode == 1);
            clickMenu.add(r);
            r = new JRadioButtonMenuItem(Bundle.getMessage("AlternateHeld"));
            r.addActionListener(e -> this.setClickMode(2));
            clickButtonGroup.add(r);
            r.setSelected(this.clickMode == 2);
            clickMenu.add(r);
            popup.add(clickMenu);
            JMenu litMenu = new JMenu(Bundle.getMessage("WhenNotLit"));
            ButtonGroup litButtonGroup = new ButtonGroup();
            r = new JRadioButtonMenuItem(Bundle.getMessage("ShowAppearance"));
            r.setIconTextGap(10);
            r.addActionListener(e -> this.setLitMode(false));
            litButtonGroup.add(r);
            r.setSelected(!this.litMode);
            litMenu.add(r);
            r = new JRadioButtonMenuItem(Bundle.getMessage("ShowDarkIcon"));
            r.setIconTextGap(10);
            r.addActionListener(e -> this.setLitMode(true));
            litButtonGroup.add(r);
            r.setSelected(this.litMode);
            litMenu.add(r);
            popup.add(litMenu);
            popup.add(new AbstractAction(Bundle.getMessage("EditLogic")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BlockBossFrame f = new BlockBossFrame();
                    String name = SignalHeadIcon.this.getNameString();
                    f.setTitle(Bundle.getMessage("SignalLogic", name));
                    f.setSignal(SignalHeadIcon.this.getSignalHead());
                    f.setVisible(true);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    protected void rotateOrthogonal() {
        super.rotateOrthogonal();
        this.displayState(this.headState());
    }

    @Override
    public void setScale(double s) {
        super.setScale(s);
        this.displayState(this.headState());
    }

    @Override
    public void rotate(int deg) {
        super.rotate(deg);
        this.displayState(this.headState());
    }

    @Override
    public void displayState(int state) {
        this.updateSize();
        if (this.getSignalHead() == null) {
            log.debug("Display state {}, disconnected", (Object)state);
            return;
        }
        log.debug("Display state {} for {}", (Object)state, (Object)this.getNameString());
        if (this.getSignalHead().getHeld()) {
            if (this.isText()) {
                super.setText(Bundle.getMessage("Held"));
            }
            if (this.isIcon()) {
                super.setIcon((NamedIcon)this._iconMap.get("SignalHeadStateHeld"));
            }
        } else if (this.getLitMode() && !this.getSignalHead().getLit()) {
            if (this.isText()) {
                super.setText(Bundle.getMessage("Dark"));
            }
            if (this.isIcon()) {
                super.setIcon((NamedIcon)this._iconMap.get("SignalHeadStateDark"));
            }
        } else {
            NamedIcon icon;
            if (this.isText()) {
                super.setText(Bundle.getMessage(this.getSignalHead().getAppearanceKey(state)));
            }
            if (this.isIcon() && (icon = (NamedIcon)this._iconMap.get(this.getSignalHead().getAppearanceKey(state))) != null) {
                super.setIcon(icon);
            }
        }
    }

    @Override
    public boolean setEditItemMenu(JPopupMenu popup) {
        String txt = Bundle.getMessage("EditItem", Bundle.getMessage("BeanNameSignalHead"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignalHeadIcon.this.editItem();
            }
        });
        return true;
    }

    protected void editItem() {
        this._paletteFrame = this.makePaletteFrame(Bundle.getMessage("EditItem", Bundle.getMessage("BeanNameSignalHead")));
        this._itemPanel = new SignalHeadItemPanel(this._paletteFrame, "SignalHead", this.getFamily(), PickListModel.signalHeadPickModelInstance());
        ActionListener updateAction = a -> this.updateItem();
        HashMap<String, NamedIcon> map = new HashMap<String, NamedIcon>();
        for (Map.Entry entry : this._iconMap.entrySet()) {
            NamedIcon oldIcon = (NamedIcon)entry.getValue();
            NamedIcon newIcon = SignalHeadIcon.cloneIcon(oldIcon, this);
            newIcon.rotate(0, this);
            newIcon.scale(1.0, this);
            newIcon.setRotation(4, this);
            map.put((String)entry.getKey(), newIcon);
        }
        this._itemPanel.init(updateAction, map);
        this._itemPanel.setSelection(this.getSignalHead());
        this.initPaletteFrame(this._paletteFrame, this._itemPanel);
    }

    void updateItem() {
        this._saveMap = this._iconMap;
        this.setSignalHead(((SignalHead)this._itemPanel.getTableSelection()).getSystemName());
        this.setFamily(this._itemPanel.getFamilyName());
        HashMap<String, NamedIcon> map1 = this._itemPanel.getIconMap();
        if (map1 != null) {
            Hashtable<String, NamedIcon> map2 = new Hashtable<String, NamedIcon>();
            for (Map.Entry<String, NamedIcon> entry : map1.entrySet()) {
                map2.put(entry.getKey(), entry.getValue());
            }
            this.setIcons(map2);
        }
        this.displayState(this.getSignalHead().getAppearance());
        this.finishItemUpdate(this._paletteFrame, this._itemPanel);
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        String txt = Bundle.getMessage("EditItem", Bundle.getMessage("BeanNameSignalHead"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignalHeadIcon.this.edit();
            }
        });
        return true;
    }

    @Override
    protected void edit() {
        this.makeIconEditorFrame(this, "SignalHead", true, null);
        this._iconEditor.setPickList(PickListModel.signalHeadPickModelInstance());
        int i = 0;
        for (Map.Entry entry : this._iconMap.entrySet()) {
            this._iconEditor.setIcon(i++, (String)entry.getKey(), new NamedIcon((NamedIcon)entry.getValue()));
        }
        this._iconEditor.makeIconPanel(false);
        ActionListener addIconAction = a -> this.updateSignal();
        this._iconEditor.complete(addIconAction, true, false, true);
        this._iconEditor.setSelection(this.getSignalHead());
    }

    private void setIcons(Hashtable<String, NamedIcon> map) {
        HashMap<String, NamedIcon> tempMap = new HashMap<String, NamedIcon>();
        for (Map.Entry<String, NamedIcon> entry : map.entrySet()) {
            String name = entry.getKey();
            NamedIcon icon = entry.getValue();
            NamedIcon oldIcon = this._saveMap.get(name);
            log.debug("key= {}, localKey= {}, newIcon= {}, oldIcon= {}", new Object[]{entry.getKey(), name, icon, oldIcon});
            if (oldIcon != null) {
                icon.setLoad(oldIcon.getDegrees(), oldIcon.getScale(), this);
                icon.setRotation(oldIcon.getRotation(), this);
            }
            tempMap.put(name, icon);
        }
        this._iconMap = tempMap;
    }

    void updateSignal() {
        this._saveMap = this._iconMap;
        if (this._iconEditor != null) {
            this.setSignalHead(this._iconEditor.getTableSelection().getDisplayName());
            this.setIcons(this._iconEditor.getIconMap());
            this._iconEditorFrame.dispose();
            this._iconEditorFrame = null;
            this._iconEditor = null;
            this.invalidate();
        }
        this.displayState(this.headState());
    }

    public void setClickMode(int mode) {
        this.clickMode = mode;
    }

    public int getClickMode() {
        return this.clickMode;
    }

    public void setLitMode(boolean mode) {
        this.litMode = mode;
    }

    public boolean getLitMode() {
        return this.litMode;
    }

    @Override
    public void doMouseClicked(JmriMouseEvent e) {
        if (!this._editor.getFlag(2, this.isControlling())) {
            return;
        }
        this.performMouseClicked(e);
    }

    public void performMouseClicked(JmriMouseEvent e) {
        if (e.isMetaDown() || e.isAltDown()) {
            return;
        }
        if (this.getSignalHead() == null) {
            log.error("No SignalHead connection, can't process click");
            return;
        }
        switch (this.clickMode) {
            case 0: {
                switch (this.getSignalHead().getAppearance()) {
                    case 1: 
                    case 2: {
                        this.getSignalHead().setAppearance(4);
                        break;
                    }
                    case 4: 
                    case 8: {
                        this.getSignalHead().setAppearance(16);
                        break;
                    }
                    default: {
                        this.getSignalHead().setAppearance(1);
                    }
                }
                return;
            }
            case 1: {
                this.getSignalHead().setLit(!this.getSignalHead().getLit());
                return;
            }
            case 2: {
                this.getSignalHead().setHeld(!this.getSignalHead().getHeld());
                return;
            }
            case 3: {
                SignalHead sh = this.getSignalHead();
                int[] states = sh.getValidStates();
                int state = sh.getAppearance();
                for (int i = 0; i < states.length; ++i) {
                    if (state != states[i]) continue;
                    if (++i >= states.length) {
                        i = 0;
                    }
                    state = states[i];
                    break;
                }
                sh.setAppearance(state);
                log.debug("Set state= {}", (Object)state);
                return;
            }
        }
        log.error("Click in mode {}", (Object)this.clickMode);
    }

    @Override
    public void dispose() {
        if (this.getSignalHead() != null) {
            this.getSignalHead().removePropertyChangeListener(this);
        }
        this.namedHead = null;
        this._iconMap = null;
        super.dispose();
    }
}

