/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import jmri.jmrit.display.Positionable;

public class ToolTip {
    private Positionable _positionable;
    private Color _backgroundColor;
    private Color _fontColor;
    private Color _borderColor;
    private Font _tFont;
    private boolean _showDisplayName;
    private String _tip;
    private int _tx;
    private int _ty;

    public ToolTip(String text, int x, int y, Positionable pos) {
        this._positionable = pos;
        this._tip = text;
        this._tx = x;
        this._ty = y;
        this._tFont = new Font("SansSerif", 0, 12);
        this._fontColor = Color.black;
        this._backgroundColor = new Color(255, 250, 210);
        this._borderColor = Color.blue;
    }

    public ToolTip(ToolTip tooltip, Positionable pos) {
        this.setLocation(pos);
        this._positionable = pos;
        this._tFont = new Font(tooltip._tFont.getFamily(), tooltip._tFont.getStyle(), tooltip._tFont.getSize());
        this._fontColor = tooltip._fontColor;
        this._backgroundColor = tooltip._backgroundColor;
        this._borderColor = tooltip._borderColor;
    }

    public ToolTip(String text, int x, int y, Font font, Color fontColor, Color backgroundColor, Color borderColor, Positionable pos) {
        this._positionable = pos;
        this._tip = text;
        this._tx = x;
        this._ty = y;
        this._tFont = font;
        this._fontColor = fontColor;
        this._backgroundColor = backgroundColor;
        this._borderColor = borderColor;
    }

    public final void setPositionable(Positionable pos) {
        this._positionable = pos;
        this.setLocation(pos.getX() + pos.getWidth() / 2, pos.getY() + pos.getHeight() / 2);
    }

    public final Positionable getPositionable() {
        return this._positionable;
    }

    public final void setText(String text) {
        this._tip = text;
    }

    public final String getText() {
        return this._tip;
    }

    public final void setPrependToolTipWithDisplayName(boolean value) {
        this._showDisplayName = value;
    }

    public final boolean getPrependToolTipWithDisplayName() {
        return this._showDisplayName;
    }

    public final void setLocation(int x, int y) {
        this._tx = x;
        this._ty = y;
    }

    private final void setLocation(Positionable pos) {
        this.setLocation(pos.getX() + pos.getWidth() / 2, pos.getY() + pos.getHeight() / 2);
    }

    public final void setFontSize(int size) {
        this._tFont = this._tFont.deriveFont(size);
    }

    public final int getFontSize() {
        return this._tFont.getSize();
    }

    public final void setFontColor(Color fontColor) {
        this._fontColor = fontColor;
    }

    public final Color getFontColor() {
        return this._fontColor;
    }

    public final void setBackgroundColor(Color backgroundColor) {
        this._backgroundColor = backgroundColor;
    }

    public final Color getBackgroundColor() {
        return this._backgroundColor;
    }

    public final void setBoderColor(Color borderColor) {
        this._borderColor = borderColor;
    }

    public final Color getBorderColor() {
        return this._borderColor;
    }

    public String getTextToDisplay() {
        Object tipText = this._tip != null ? this._tip.trim() : "";
        String displayName = "";
        if (this._positionable != null) {
            displayName = this._positionable.getNameString();
        }
        if (((String)tipText).isEmpty()) {
            tipText = displayName;
        } else if (this._showDisplayName) {
            tipText = displayName + ": " + (String)tipText;
        }
        return tipText;
    }

    public void paint(Graphics2D g2d, double scale) {
        String tipText = this.getTextToDisplay();
        if (tipText.isEmpty()) {
            return;
        }
        Color color = g2d.getColor();
        Font font = g2d.getFont();
        TextLayout tl = new TextLayout(tipText, this._tFont, g2d.getFontRenderContext());
        Rectangle2D bds = tl.getBounds();
        int x0 = Math.max((int)(bds.getX() + (double)this._tx - bds.getWidth() / 2.0 - 9.0), 0);
        bds.setRect(x0, (double)this._ty + (bds.getHeight() - 9.0) / scale, bds.getWidth() + 9.0, bds.getHeight() + 8.0);
        g2d.setColor(this._backgroundColor);
        g2d.fill(bds);
        g2d.setColor(this._borderColor);
        g2d.draw(bds);
        g2d.setColor(this._fontColor);
        tl.draw(g2d, (float)x0 + 3.0f, (float)((double)this._ty + bds.getHeight() - 4.0));
        g2d.setColor(color);
        g2d.setFont(font);
    }
}

