/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableIcon;
import jmri.jmrit.display.palette.TableItemPanel;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutIcon
extends PositionableIcon
implements PropertyChangeListener {
    protected HashMap<Integer, NamedIcon> _iconStateMap;
    protected HashMap<String, Integer> _name2stateMap;
    protected HashMap<Integer, String> _state2nameMap;
    private NamedBeanHandle<Turnout> namedTurnout = null;
    private boolean tristate = false;
    private boolean momentary = false;
    private boolean directControl = false;
    private final JCheckBoxMenuItem momentaryItem = new JCheckBoxMenuItem(Bundle.getMessage("Momentary"));
    private final JCheckBoxMenuItem directControlItem = new JCheckBoxMenuItem(Bundle.getMessage("DirectControl"));
    private JCheckBoxMenuItem tristateItem = null;
    TableItemPanel<Turnout> _itemPanel;
    private static final Logger log = LoggerFactory.getLogger(TurnoutIcon.class);

    public TurnoutIcon(Editor editor) {
        super(new NamedIcon("resources/icons/smallschematics/tracksegments/os-lefthand-east-closed.gif", "resources/icons/smallschematics/tracksegments/os-lefthand-east-closed.gif"), editor);
        this._control = true;
        this.setPopupUtility(null);
    }

    @Override
    public Positionable deepClone() {
        TurnoutIcon pos = new TurnoutIcon(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(TurnoutIcon pos) {
        pos.setTurnout(this.getNamedTurnout().getName());
        pos._iconStateMap = this.cloneMap(this._iconStateMap, pos);
        pos.setTristate(this.getTristate());
        pos.setMomentary(this.getMomentary());
        pos.setDirectControl(this.getDirectControl());
        pos._iconFamily = this._iconFamily;
        return super.finishClone(pos);
    }

    public void setTurnout(String pName) {
        if (InstanceManager.getNullableDefault(TurnoutManager.class) != null) {
            try {
                Turnout turnout = InstanceManager.turnoutManagerInstance().provideTurnout(pName);
                this.setTurnout(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, turnout));
            }
            catch (IllegalArgumentException ex) {
                log.error("Turnout '{}' not available, icon won't see changes", (Object)pName);
            }
        } else {
            log.error("No TurnoutManager for this protocol, icon won't see changes");
        }
    }

    public void setTurnout(NamedBeanHandle<Turnout> to) {
        if (this.namedTurnout != null) {
            this.getTurnout().removePropertyChangeListener(this);
        }
        this.namedTurnout = to;
        if (this.namedTurnout != null) {
            this._iconStateMap = new HashMap();
            this._name2stateMap = new HashMap();
            this._name2stateMap.put("BeanStateUnknown", 1);
            this._name2stateMap.put("BeanStateInconsistent", 8);
            this._name2stateMap.put("TurnoutStateClosed", 2);
            this._name2stateMap.put("TurnoutStateThrown", 4);
            this._state2nameMap = new HashMap();
            this._state2nameMap.put(1, "BeanStateUnknown");
            this._state2nameMap.put(8, "BeanStateInconsistent");
            this._state2nameMap.put(2, "TurnoutStateClosed");
            this._state2nameMap.put(4, "TurnoutStateThrown");
            this.displayState(this.turnoutState());
            this.getTurnout().addPropertyChangeListener(this, this.namedTurnout.getName(), "Panel Editor Turnout Icon");
        }
    }

    public Turnout getTurnout() {
        return this.namedTurnout.getBean();
    }

    public NamedBeanHandle<Turnout> getNamedTurnout() {
        return this.namedTurnout;
    }

    @Override
    public NamedBean getNamedBean() {
        return this.getTurnout();
    }

    public void setIcon(String name, NamedIcon icon) {
        if (log.isDebugEnabled()) {
            log.debug("setIcon for name \"{}\" state= {}", (Object)name, (Object)this._name2stateMap.get(name));
        }
        this._iconStateMap.put(this._name2stateMap.get(name), icon);
        this.displayState(this.turnoutState());
    }

    @Override
    public NamedIcon getIcon(String state) {
        return this._iconStateMap.get(this._name2stateMap.get(state));
    }

    public NamedIcon getIcon(int state) {
        return this._iconStateMap.get(state);
    }

    @Override
    public int maxHeight() {
        int max = 0;
        for (NamedIcon namedIcon : this._iconStateMap.values()) {
            max = Math.max(namedIcon.getIconHeight(), max);
        }
        return max;
    }

    @Override
    public int maxWidth() {
        int max = 0;
        for (NamedIcon namedIcon : this._iconStateMap.values()) {
            max = Math.max(namedIcon.getIconWidth(), max);
        }
        return max;
    }

    int turnoutState() {
        if (this.namedTurnout != null) {
            return this.getTurnout().getKnownState();
        }
        return 1;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        int now;
        if (log.isDebugEnabled()) {
            log.debug("property change: {} {} is now {}", new Object[]{this.getNameString(), e.getPropertyName(), e.getNewValue()});
        }
        if (this.getTristate() && this.getTurnout().getFeedbackMode() != 1 && e.getPropertyName().equals("CommandedState")) {
            if (this.getTurnout().getCommandedState() != this.getTurnout().getKnownState()) {
                now = 8;
                this.displayState(now);
            }
            if (this.getTurnout().getCommandedState() == this.getTurnout().getKnownState()) {
                now = (Integer)e.getNewValue();
                this.displayState(now);
            }
        }
        if (e.getPropertyName().equals("KnownState")) {
            now = (Integer)e.getNewValue();
            this.displayState(now);
        }
    }

    public String getStateName(int state) {
        return this._state2nameMap.get(state);
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_TurnoutIcon");
    }

    @Override
    public String getNameString() {
        String name = this.namedTurnout == null ? Bundle.getMessage("NotConnected") : this.getTurnout().getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    public void setTristate(boolean set) {
        this.tristate = set;
    }

    public boolean getTristate() {
        return this.tristate;
    }

    public boolean getMomentary() {
        return this.momentary;
    }

    public void setMomentary(boolean m) {
        this.momentary = m;
    }

    public boolean getDirectControl() {
        return this.directControl;
    }

    public void setDirectControl(boolean m) {
        this.directControl = m;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this.isEditable()) {
            if (this.namedTurnout != null && this.getTurnout().getFeedbackMode() != 1) {
                this.addTristateEntry(popup);
            }
            popup.add(this.momentaryItem);
            this.momentaryItem.setSelected(this.getMomentary());
            this.momentaryItem.addActionListener(e -> this.setMomentary(this.momentaryItem.isSelected()));
            popup.add(this.directControlItem);
            this.directControlItem.setSelected(this.getDirectControl());
            this.directControlItem.addActionListener(e -> this.setDirectControl(this.directControlItem.isSelected()));
        } else if (this.getDirectControl()) {
            this.getTurnout().setCommandedState(4);
        }
        return true;
    }

    void addTristateEntry(JPopupMenu popup) {
        this.tristateItem = new JCheckBoxMenuItem(Bundle.getMessage("Tristate"));
        this.tristateItem.setSelected(this.getTristate());
        popup.add(this.tristateItem);
        this.tristateItem.addActionListener(e -> this.setTristate(this.tristateItem.isSelected()));
    }

    @Override
    protected void rotateOrthogonal() {
        for (Map.Entry<Integer, NamedIcon> entry : this._iconStateMap.entrySet()) {
            entry.getValue().setRotation(entry.getValue().getRotation() + 1, this);
        }
        this.displayState(this.turnoutState());
        this.repaint();
    }

    @Override
    public void setScale(double s) {
        this._scale = s;
        for (Map.Entry<Integer, NamedIcon> entry : this._iconStateMap.entrySet()) {
            entry.getValue().scale(s, this);
        }
        this.displayState(this.turnoutState());
    }

    @Override
    public void rotate(int deg) {
        for (Map.Entry<Integer, NamedIcon> entry : this._iconStateMap.entrySet()) {
            entry.getValue().rotate(deg, this);
        }
        this.setDegrees(deg);
        this.displayState(this.turnoutState());
    }

    @Override
    public void displayState(int state) {
        if (this.getNamedTurnout() == null) {
            log.debug("Display state {}, disconnected", (Object)state);
        } else {
            NamedIcon icon;
            if (this.isText()) {
                super.setText(this._state2nameMap.get(state));
            }
            if (this.isIcon() && (icon = this.getIcon(state)) != null) {
                super.setIcon(icon);
            }
        }
        this.updateSize();
    }

    @Override
    public boolean setEditItemMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameTurnout"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                TurnoutIcon.this.editItem();
            }
        });
        return true;
    }

    protected void editItem() {
        this._paletteFrame = this.makePaletteFrame(MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameTurnout")));
        this._itemPanel = new TableItemPanel<Turnout>(this._paletteFrame, "Turnout", this._iconFamily, PickListModel.turnoutPickModelInstance());
        ActionListener updateAction = a -> this.updateItem();
        HashMap<String, NamedIcon> strMap = new HashMap<String, NamedIcon>();
        for (Map.Entry<Integer, NamedIcon> entry : this._iconStateMap.entrySet()) {
            NamedIcon oldIcon = entry.getValue();
            NamedIcon newIcon = TurnoutIcon.cloneIcon(oldIcon, this);
            newIcon.rotate(0, this);
            newIcon.scale(1.0, this);
            newIcon.setRotation(4, this);
            strMap.put(this._state2nameMap.get(entry.getKey()), newIcon);
        }
        this._itemPanel.init(updateAction, strMap);
        this._itemPanel.setSelection(this.getTurnout());
        this.initPaletteFrame(this._paletteFrame, this._itemPanel);
    }

    void updateItem() {
        HashMap<Integer, NamedIcon> oldMap = this.cloneMap(this._iconStateMap, this);
        this.setTurnout(this._itemPanel.getTableSelection().getSystemName());
        this._iconFamily = this._itemPanel.getFamilyName();
        HashMap<String, NamedIcon> iconMap = this._itemPanel.getIconMap();
        if (iconMap != null) {
            for (Map.Entry<String, NamedIcon> entry : iconMap.entrySet()) {
                if (log.isDebugEnabled()) {
                    log.debug("key= {}", (Object)entry.getKey());
                }
                NamedIcon newIcon = entry.getValue();
                NamedIcon oldIcon = oldMap.get(this._name2stateMap.get(entry.getKey()));
                newIcon.setLoad(oldIcon.getDegrees(), oldIcon.getScale(), this);
                newIcon.setRotation(oldIcon.getRotation(), this);
                this.setIcon(entry.getKey(), newIcon);
            }
        }
        this.finishItemUpdate(this._paletteFrame, this._itemPanel);
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameTurnout"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                TurnoutIcon.this.edit();
            }
        });
        return true;
    }

    @Override
    protected void edit() {
        this.makeIconEditorFrame(this, "Turnout", true, null);
        this._iconEditor.setPickList(PickListModel.turnoutPickModelInstance());
        int i = 0;
        for (Map.Entry<Integer, NamedIcon> entry : this._iconStateMap.entrySet()) {
            this._iconEditor.setIcon(i++, this._state2nameMap.get(entry.getKey()), entry.getValue());
        }
        this._iconEditor.makeIconPanel(false);
        ActionListener addIconAction = a -> this.updateTurnout();
        this._iconEditor.complete(addIconAction, true, true, true);
        this._iconEditor.setSelection(this.getTurnout());
    }

    void updateTurnout() {
        HashMap<Integer, NamedIcon> oldMap = this.cloneMap(this._iconStateMap, this);
        this.setTurnout(this._iconEditor.getTableSelection().getDisplayName());
        Hashtable<String, NamedIcon> iconMap = this._iconEditor.getIconMap();
        for (Map.Entry<String, NamedIcon> entry : iconMap.entrySet()) {
            if (log.isDebugEnabled()) {
                log.debug("key= {}", (Object)entry.getKey());
            }
            NamedIcon newIcon = entry.getValue();
            NamedIcon oldIcon = oldMap.get(this._name2stateMap.get(entry.getKey()));
            newIcon.setLoad(oldIcon.getDegrees(), oldIcon.getScale(), this);
            newIcon.setRotation(oldIcon.getRotation(), this);
            this.setIcon(entry.getKey(), newIcon);
        }
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.invalidate();
    }

    public boolean buttonLive() {
        if (this.namedTurnout == null) {
            log.error("No turnout connection, can't process click");
            return false;
        }
        return true;
    }

    @Override
    public void doMousePressed(JmriMouseEvent e) {
        if (this.getMomentary() && this.buttonLive() && !e.isMetaDown() && !e.isAltDown()) {
            this.getTurnout().setCommandedState(4);
        }
        super.doMousePressed(e);
    }

    @Override
    public void doMouseReleased(JmriMouseEvent e) {
        if (this.getMomentary() && this.buttonLive() && !e.isMetaDown() && !e.isAltDown()) {
            this.getTurnout().setCommandedState(2);
        }
        super.doMouseReleased(e);
    }

    @Override
    public void doMouseClicked(JmriMouseEvent e) {
        if (!this._editor.getFlag(2, this.isControlling())) {
            return;
        }
        if (e.isMetaDown() || e.isAltDown() || !this.buttonLive() || this.getMomentary()) {
            return;
        }
        if (this.getDirectControl() && !this.isEditable()) {
            this.getTurnout().setCommandedState(2);
        } else {
            this.alternateOnClick();
        }
    }

    void alternateOnClick() {
        if (this.getTurnout().getKnownState() == 2) {
            this.getTurnout().setCommandedState(4);
        } else if (this.getTurnout().getKnownState() == 4) {
            this.getTurnout().setCommandedState(2);
        } else if (this.getTurnout().getCommandedState() == 2) {
            this.getTurnout().setCommandedState(4);
        } else {
            this.getTurnout().setCommandedState(2);
        }
    }

    @Override
    public void dispose() {
        if (this.namedTurnout != null) {
            this.getTurnout().removePropertyChangeListener(this);
        }
        this.namedTurnout = null;
        this._iconStateMap = null;
        this._name2stateMap = null;
        this._state2nameMap = null;
        super.dispose();
    }

    protected HashMap<Integer, NamedIcon> cloneMap(HashMap<Integer, NamedIcon> map, TurnoutIcon pos) {
        HashMap<Integer, NamedIcon> clone = new HashMap<Integer, NamedIcon>();
        if (map != null) {
            for (Map.Entry<Integer, NamedIcon> entry : map.entrySet()) {
                clone.put(entry.getKey(), TurnoutIcon.cloneIcon(entry.getValue(), pos));
                if (pos == null) continue;
                pos.setIcon(this._state2nameMap.get(entry.getKey()), this._iconStateMap.get(entry.getKey()));
            }
        }
        return clone;
    }
}

