/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.util.List;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.audio.AudioBuffer;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.AudioIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(AudioIconXml.class);

    @Override
    public Element store(Object o) {
        AudioIcon p = (AudioIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("audioicon");
        this.storeCommonAttributes(p, element);
        element.addContent((Content)new Element("Identity").addContent(Integer.toString(p.getIdentity())));
        AudioSource source = (AudioSource)p.getAudio();
        if (source != null) {
            element.setAttribute("audio", source.getSystemName());
            AudioBuffer buffer = (AudioBuffer)InstanceManager.getDefault(AudioManager.class).getAudio(source.getAssignedBufferName());
            if (buffer != null) {
                element.setAttribute("sound", buffer.getURL());
            }
        }
        if (p.isText()) {
            if (p.getUnRotatedText() != null) {
                element.setAttribute("text", p.getUnRotatedText());
            }
            this.storeTextInfo(p, element);
        }
        if (p.isIcon() && p.getIcon() != null) {
            element.setAttribute("icon", "yes");
            element.addContent((Content)this.storeIcon("icon", (NamedIcon)p.getIcon()));
        }
        element.setAttribute("onClickOperation", p.getOnClickOperation().name());
        element.setAttribute("playSoundWhenJmriPlays", p.getPlaySoundWhenJmriPlays() ? "yes" : "no");
        element.setAttribute("stopSoundWhenJmriStops", p.getStopSoundWhenJmriStops() ? "yes" : "no");
        this.storeLogixNG_Data(p, element);
        element.setAttribute("class", "jmri.jmrit.display.configurexml.AudioIconXml");
        return element;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        AudioIcon l = null;
        int identity = Integer.parseInt(element.getChildText("Identity"));
        Editor editor = (Editor)o;
        Attribute attr = element.getAttribute("audio");
        if (attr == null) {
            log.error("incorrect information for audio; must use audio name");
            editor.loadFailed();
            return;
        }
        String audioName = attr.getValue();
        if (element.getAttribute("icon") != null) {
            NamedIcon icon;
            String name = element.getAttribute("icon").getValue();
            if (name.equals("yes")) {
                icon = this.getNamedIcon("icon", element, "AudioIcon ", editor);
            } else {
                icon = NamedIcon.getIconByName(name);
                if (icon == null && (icon = editor.loadFailed("AudioIcon", name)) == null) {
                    log.info("AudioIcon icon removed for url= {}", (Object)name);
                    return;
                }
            }
            if (icon == null && !name.equals("yes")) {
                log.info("AudioIcon icon removed for url= {}", (Object)name);
                return;
            }
            l = new AudioIcon(identity, icon, editor);
            try {
                Object a = element.getAttribute("rotate");
                if (a != null && icon != null) {
                    int rotation = element.getAttribute("rotate").getIntValue();
                    icon.setRotation(rotation, l);
                }
            }
            catch (DataConversionException a) {
                // empty catch block
            }
            if (name.equals("yes")) {
                NamedIcon nIcon = this.loadIcon(l, "icon", element, "AudioIcon ", editor);
                if (nIcon == null) {
                    log.info("AudioIcon icon removed for url= {}", (Object)name);
                    return;
                }
                l.updateIcon(nIcon);
            } else {
                l.updateIcon(icon);
            }
        }
        if (element.getAttribute("text") != null) {
            if (l == null) {
                l = new AudioIcon(identity, element.getAttribute("text").getValue(), editor);
            }
            this.loadTextInfo(l, element);
        } else if (l == null) {
            log.error("AudioIcon is null!");
            if (log.isDebugEnabled()) {
                List attrs = element.getAttributes();
                log.debug("\tElement Has {} Attributes:", (Object)attrs.size());
                for (Object a : attrs) {
                    log.debug("  attribute:  {} = {}", (Object)a.getName(), (Object)a.getValue());
                }
                List kids = element.getChildren();
                log.debug("\tElementHas {} children:", (Object)kids.size());
                for (Element e : kids) {
                    log.debug("  child:  {} = \"{}\"", (Object)e.getName(), (Object)e.getValue());
                }
            }
            editor.loadFailed();
            return;
        }
        l.setAudio(audioName);
        String onClickOperation = element.getAttribute("onClickOperation").getValue();
        l.setOnClickOperation(AudioIcon.OnClickOperation.valueOf(onClickOperation));
        String yesno = element.getAttribute("playSoundWhenJmriPlays").getValue();
        if (yesno != null && !yesno.equals("")) {
            l.setPlaySoundWhenJmriPlays(yesno.equals("yes"));
        }
        if ((yesno = element.getAttribute("stopSoundWhenJmriStops").getValue()) != null && !yesno.equals("")) {
            l.setStopSoundWhenJmriStops(yesno.equals("yes"));
        }
        try {
            editor.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        this.loadLogixNG_Data(l, element);
        this.loadCommonAttributes(l, 4, element);
    }
}

