/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.BlockContentsIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockContentsIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(BlockContentsIconXml.class);

    @Override
    public Element store(Object o) {
        HashMap<String, NamedIcon> map;
        BlockContentsIcon p = (BlockContentsIcon)o;
        Element element = new Element("BlockContentsIcon");
        element.setAttribute("blockcontents", p.getNamedBlock().getName());
        this.storeCommonAttributes(p, element);
        this.storeTextInfo(p, element);
        if (p.getPopupUtility().getFixedWidth() == 0 && p.getPopupUtility().getJustification() != 0) {
            element.setAttribute("x", "" + p.getOriginalX());
            element.setAttribute("y", "" + p.getOriginalY());
        }
        element.setAttribute("selectable", p.isSelectable() ? "yes" : "no");
        element.setAttribute("class", "jmri.jmrit.display.configurexml.BlockContentsIconXml");
        if (p.getDefaultIcon() != null) {
            element.setAttribute("defaulticon", p.getDefaultIcon().getURL());
        }
        if ((map = p.getMap()) != null) {
            for (Map.Entry<String, NamedIcon> mi : map.entrySet()) {
                String key = mi.getKey();
                String value = mi.getValue().getName();
                Element e2 = new Element("blockstate");
                e2.setAttribute("value", key);
                e2.setAttribute("icon", value);
                element.addContent((Content)e2);
            }
        }
        this.storeLogixNG_Data(p, element);
        return element;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        BlockContentsIcon l;
        Editor ed = null;
        if (o instanceof LayoutEditor) {
            ed = (LayoutEditor)o;
            l = new jmri.jmrit.display.layoutEditor.BlockContentsIcon("   ", (LayoutEditor)ed);
        } else if (o instanceof Editor) {
            ed = (Editor)o;
            l = new BlockContentsIcon("", ed);
        } else {
            log.error("Unrecognizable class - {}", (Object)o.getClass().getName());
            return;
        }
        Attribute attr = element.getAttribute("blockcontents");
        if (attr == null) {
            log.error("incorrect information for a block contents; must use block name");
            ed.loadFailed();
            return;
        }
        String name = attr.getValue();
        this.loadTextInfo(l, element);
        Block m = InstanceManager.getDefault(BlockManager.class).getBlock(name);
        if (m != null) {
            l.setBlock(name);
        } else {
            log.error("Block named '{}' not found.", (Object)attr.getValue());
            ed.loadFailed();
        }
        Attribute a = element.getAttribute("selectable");
        if (a != null && a.getValue().equals("yes")) {
            l.setSelectable(true);
        } else {
            l.setSelectable(false);
        }
        List items = element.getChildren("blockstate");
        for (Element item : items) {
            String iconName = item.getAttribute("icon").getValue();
            NamedIcon icon = NamedIcon.getIconByName(iconName);
            if (icon == null && (icon = ed.loadFailed("Memory " + name, iconName)) == null) {
                log.info("Memory \"{}\" icon removed for url= {}", (Object)name, (Object)iconName);
            }
            if (icon == null) continue;
            String keyValue = item.getAttribute("value").getValue();
            l.addKeyAndIcon(icon, keyValue);
        }
        try {
            ed.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadCommonAttributes(l, 5, element);
        int x = 0;
        int y = 0;
        try {
            x = element.getAttribute("x").getIntValue();
            y = element.getAttribute("y").getIntValue();
        }
        catch (DataConversionException e) {
            log.error("failed to convert positional attribute");
        }
        l.setOriginalLocation(x, y);
        l.displayState();
        this.loadLogixNG_Data(l, element);
    }
}

