/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.GlobalVariableComboIcon;
import jmri.jmrit.display.MemoryOrGVComboIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import jmri.jmrit.logixng.GlobalVariable;
import jmri.jmrit.logixng.GlobalVariableManager;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalVariableComboIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(GlobalVariableComboIconXml.class);

    @Override
    public Element store(Object obj) {
        GlobalVariableComboIcon globalVariableIcon = (GlobalVariableComboIcon)obj;
        Element element = new Element("globalVariableComboIcon");
        Element elem = new Element("itemList");
        MemoryOrGVComboIcon.ComboModel model = globalVariableIcon.getComboModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Element e = new Element("item");
            e.setAttribute("index", "" + i);
            e.addContent((String)model.getElementAt(i));
            elem.addContent((Content)e);
        }
        element.addContent((Content)elem);
        element.setAttribute("globalVariable", globalVariableIcon.getNamedGlobalVariable().getName());
        this.storeCommonAttributes(globalVariableIcon, element);
        this.storeTextInfo(globalVariableIcon, element);
        this.storeLogixNG_Data(globalVariableIcon, element);
        element.setAttribute("class", "jmri.jmrit.display.configurexml.GlobalVariableComboIconXml");
        return element;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        Editor p = (Editor)o;
        Element elem = element.getChild("itemList");
        List list = elem.getChildren("item");
        String[] items = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Element e = (Element)list.get(i);
            String item = e.getText();
            try {
                int idx = e.getAttribute("index").getIntValue();
                items[idx] = item;
                continue;
            }
            catch (DataConversionException ex) {
                log.error("failed to convert ComboBoxIcon index attribute");
                if (items[i] != null) continue;
                items[i] = item;
            }
        }
        GlobalVariableComboIcon l = new GlobalVariableComboIcon(p, items);
        this.loadTextInfo(l, element);
        Attribute attr = element.getAttribute("globalVariable");
        if (attr == null) {
            log.error("incorrect information for a globalVariable location; must use globalVariable name");
            p.loadFailed();
            return;
        }
        String name = attr.getValue();
        GlobalVariable m = InstanceManager.getDefault(GlobalVariableManager.class).getGlobalVariable(name);
        if (m == null) {
            log.error("GlobalVariable named '{}' not found.", (Object)attr.getValue());
            p.loadFailed();
            return;
        }
        l.setGlobalVariable(name);
        try {
            p.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadLogixNG_Data(l, element);
        this.loadCommonAttributes(l, 5, element);
    }
}

