/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jmri.NamedBeanHandle;
import jmri.Sensor;
import jmri.Turnout;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.IndicatorTurnoutIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import jmri.jmrit.logix.OBlock;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicatorTurnoutIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(IndicatorTurnoutIconXml.class);

    @Override
    public Element store(Object o) {
        NamedBeanHandle<OBlock> b;
        IndicatorTurnoutIcon p = (IndicatorTurnoutIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("indicatorturnouticon");
        this.storeCommonAttributes(p, element);
        NamedBeanHandle<Turnout> t = p.getNamedTurnout();
        if (t != null) {
            element.addContent((Content)this.storeNamedBean("turnout", t));
        }
        if ((b = p.getNamedOccBlock()) != null) {
            element.addContent((Content)this.storeNamedBean("occupancyblock", b));
        }
        NamedBeanHandle<Sensor> s = p.getNamedOccSensor();
        if (b == null && s != null) {
            element.addContent((Content)this.storeNamedBean("occupancysensor", s));
        }
        Element elem = new Element("showTrainName");
        String show = "no";
        if (p.showTrain()) {
            show = "yes";
        }
        elem.addContent(show);
        element.addContent((Content)elem);
        HashMap<String, HashMap<Integer, NamedIcon>> iconMaps = p.getIconMaps();
        Iterator<Map.Entry<String, HashMap<Integer, NamedIcon>>> it = iconMaps.entrySet().iterator();
        Element el = new Element("iconmaps");
        String family = p.getFamily();
        if (family != null) {
            el.setAttribute("family", family);
        }
        while (it.hasNext()) {
            Map.Entry<String, HashMap<Integer, NamedIcon>> ent = it.next();
            elem = new Element(ent.getKey());
            for (Map.Entry entry : ent.getValue().entrySet()) {
                elem.addContent((Content)this.storeIcon(p.getStateName((Integer)entry.getKey()), (NamedIcon)entry.getValue()));
            }
            el.addContent((Content)elem);
        }
        element.addContent((Content)el);
        elem = new Element("paths");
        ArrayList<String> paths = p.getPaths();
        if (paths != null) {
            for (String string : paths) {
                Element e = new Element("path");
                e.addContent(string);
                elem.addContent((Content)e);
            }
            element.addContent((Content)elem);
        }
        element.setAttribute("class", "jmri.jmrit.display.configurexml.IndicatorTurnoutIconXml");
        this.storeLogixNG_Data(p, element);
        return element;
    }

    Element storeNamedBean(String elemName, NamedBeanHandle<?> nb) {
        Element elem = new Element(elemName);
        elem.addContent(nb.getName());
        return elem;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        Editor p = (Editor)o;
        IndicatorTurnoutIcon l = new IndicatorTurnoutIcon(p);
        Element name = element.getChild("turnout");
        if (name == null) {
            log.error("incorrect information for turnout; must use turnout name");
        } else {
            l.setTurnout(name.getText());
        }
        Element elem = element.getChild("iconmaps");
        if (elem != null) {
            Attribute attr;
            List maps = elem.getChildren();
            if (maps.size() > 0) {
                for (Element map : maps) {
                    String status = map.getName();
                    List states = map.getChildren();
                    for (Element state : states) {
                        String msg = "IndicatorTurnout \"" + l.getNameString() + "\" icon \"" + state.getName() + "\" ";
                        NamedIcon icon = this.loadIcon(l, state.getName(), map, msg, p);
                        if (icon != null) {
                            l.setIcon(status, state.getName(), icon);
                            continue;
                        }
                        log.info("{} removed for url= {}", (Object)msg, (Object)name);
                        return;
                    }
                }
            }
            if ((attr = elem.getAttribute("family")) != null) {
                l.setFamily(attr.getValue());
            }
        }
        if ((name = element.getChild("occupancyblock")) != null) {
            l.setOccBlock(name.getText());
        } else {
            name = element.getChild("occupancysensor");
            if (name != null) {
                l.setOccSensor(name.getText());
            }
        }
        l.setShowTrain(false);
        name = element.getChild("showTrainName");
        if (name != null && "yes".equals(name.getText())) {
            l.setShowTrain(true);
        }
        if ((elem = element.getChild("paths")) != null) {
            ArrayList<String> paths = new ArrayList<String>();
            List pth = elem.getChildren();
            for (Element value : pth) {
                paths.add(value.getText());
            }
            l.setPaths(paths);
        }
        l.updateSize();
        try {
            p.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadLogixNG_Data(l, element);
        this.loadCommonAttributes(l, 7, element);
    }
}

