/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.util.List;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.LinkingLabel;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkingLabelXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(LinkingLabelXml.class);

    @Override
    public Element store(Object o) {
        LinkingLabel p = (LinkingLabel)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("linkinglabel");
        this.storeCommonAttributes(p, element);
        if (p.isText()) {
            if (p.getUnRotatedText() != null) {
                element.setAttribute("text", p.getUnRotatedText());
            }
            this.storeTextInfo(p, element);
        }
        if (p.isIcon() && p.getIcon() != null) {
            element.setAttribute("icon", "yes");
            element.addContent((Content)this.storeIcon("icon", (NamedIcon)p.getIcon()));
        }
        element.addContent((Content)new Element("url").addContent(p.getURL()));
        this.storeLogixNG_Data(p, element);
        element.setAttribute("class", "jmri.jmrit.display.configurexml.LinkingLabelXml");
        return element;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        LinkingLabel l;
        String url = element.getChild("url").getText();
        Editor editor = (Editor)o;
        if (element.getAttribute("icon") != null) {
            NamedIcon icon;
            String name = element.getAttribute("icon").getValue();
            if (name.equals("yes")) {
                icon = this.getNamedIcon("icon", element, "LinkingLabel ", editor);
            } else {
                icon = NamedIcon.getIconByName(name);
                if (icon == null && (icon = editor.loadFailed("LinkingLabel", name)) == null) {
                    log.info("LinkingLabel icon removed for url= {}", (Object)name);
                    return;
                }
            }
            if (icon == null && !name.equals("yes")) {
                log.info("LinkingLabel icon removed for url= {}", (Object)name);
                return;
            }
            l = new LinkingLabel(icon, editor, url);
            l.setPopupUtility(null);
            try {
                Attribute a = element.getAttribute("rotate");
                if (a != null && icon != null) {
                    int rotation = element.getAttribute("rotate").getIntValue();
                    icon.setRotation(rotation, l);
                }
            }
            catch (DataConversionException a) {
                // empty catch block
            }
            if (name.equals("yes")) {
                NamedIcon nIcon = this.loadIcon(l, "icon", element, "LinkingLabel ", editor);
                if (nIcon == null) {
                    log.info("LinkingLabel icon removed for url= {}", (Object)name);
                    return;
                }
                l.updateIcon(nIcon);
            } else {
                l.updateIcon(icon);
            }
        } else if (element.getAttribute("text") != null) {
            l = new LinkingLabel(element.getAttribute("text").getValue(), editor, url);
            this.loadTextInfo(l, element);
        } else {
            log.error("LinkingLabel is null!");
            if (log.isDebugEnabled()) {
                List attrs = element.getAttributes();
                log.debug("\tElement Has {} Attributes:", (Object)attrs.size());
                for (Attribute a : attrs) {
                    log.debug("\tattribute:\t{} = {}", (Object)a.getName(), (Object)a.getValue());
                }
                List kids = element.getChildren();
                log.debug("\tElementHas {} children:", (Object)kids.size());
                for (Element e : kids) {
                    log.debug("\tchild:\t{} = \"{}\"", (Object)e.getName(), (Object)e.getValue());
                }
            }
            editor.loadFailed();
            return;
        }
        try {
            editor.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadLogixNG_Data(l, element);
        this.loadCommonAttributes(l, 4, element);
    }
}

