/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.util.List;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.LogixNGIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixNGIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(LogixNGIconXml.class);

    @Override
    public Element store(Object o) {
        LogixNGIcon p = (LogixNGIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("logixngicon");
        this.storeCommonAttributes(p, element);
        element.addContent((Content)new Element("Identity").addContent(Integer.toString(p.getIdentity())));
        if (p.isText()) {
            if (p.getUnRotatedText() != null) {
                element.setAttribute("text", p.getUnRotatedText());
            }
            this.storeTextInfo(p, element);
        }
        if (p.isIcon() && p.getIcon() != null) {
            element.setAttribute("icon", "yes");
            element.addContent((Content)this.storeIcon("icon", (NamedIcon)p.getIcon()));
        }
        this.storeLogixNG_Data(p, element);
        element.setAttribute("class", "jmri.jmrit.display.configurexml.LogixNGIconXml");
        return element;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        LogixNGIcon l = null;
        int identity = Integer.parseInt(element.getChildText("Identity"));
        Editor editor = (Editor)o;
        if (element.getAttribute("icon") != null) {
            NamedIcon icon;
            String name = element.getAttribute("icon").getValue();
            if (name.equals("yes")) {
                icon = this.getNamedIcon("icon", element, "LogixNGIcon ", editor);
            } else {
                icon = NamedIcon.getIconByName(name);
                if (icon == null && (icon = editor.loadFailed("LogixNGIcon", name)) == null) {
                    log.info("LogixNGIcon icon removed for url= {}", (Object)name);
                    return;
                }
            }
            if (icon == null && !name.equals("yes")) {
                log.info("LogixNGIcon icon removed for url= {}", (Object)name);
                return;
            }
            l = new LogixNGIcon(identity, icon, editor);
            try {
                Attribute a = element.getAttribute("rotate");
                if (a != null && icon != null) {
                    int rotation = element.getAttribute("rotate").getIntValue();
                    icon.setRotation(rotation, l);
                }
            }
            catch (DataConversionException a) {
                // empty catch block
            }
            if (name.equals("yes")) {
                NamedIcon nIcon = this.loadIcon(l, "icon", element, "LogixNGIcon ", editor);
                if (nIcon == null) {
                    log.info("LogixNGIcon icon removed for url= {}", (Object)name);
                    return;
                }
                l.updateIcon(nIcon);
            } else {
                l.updateIcon(icon);
            }
        }
        if (element.getAttribute("text") != null) {
            if (l == null) {
                l = new LogixNGIcon(identity, element.getAttribute("text").getValue(), editor);
            }
            this.loadTextInfo(l, element);
        } else if (l == null) {
            log.error("LogixNGIcon is null!");
            if (log.isDebugEnabled()) {
                List attrs = element.getAttributes();
                log.debug("\tElement Has {} Attributes:", (Object)attrs.size());
                for (Attribute a : attrs) {
                    log.debug("  attribute:  {} = {}", (Object)a.getName(), (Object)a.getValue());
                }
                List kids = element.getChildren();
                log.debug("\tElementHas {} children:", (Object)kids.size());
                for (Element e : kids) {
                    log.debug("  child:  {} = \"{}\"", (Object)e.getName(), (Object)e.getValue());
                }
            }
            editor.loadFailed();
            return;
        }
        try {
            editor.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        this.loadLogixNG_Data(l, element);
        this.loadCommonAttributes(l, 4, element);
    }
}

