/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import javax.swing.JComponent;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.MemoryInputIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryInputIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(MemoryInputIconXml.class);

    @Override
    public Element store(Object o) {
        MemoryInputIcon p = (MemoryInputIcon)o;
        Element element = new Element("memoryInputIcon");
        element.setAttribute("colWidth", "" + p.getNumColumns());
        element.setAttribute("memory", p.getNamedMemory().getName());
        this.storeCommonAttributes(p, element);
        this.storeTextInfo(p, element);
        this.storeLogixNG_Data(p, element);
        element.setAttribute("class", "jmri.jmrit.display.configurexml.MemoryInputIconXml");
        return element;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        Editor p = (Editor)o;
        int nCol = 2;
        try {
            nCol = element.getAttribute("colWidth").getIntValue();
        }
        catch (DataConversionException e) {
            log.error("failed to convert colWidth attribute");
        }
        MemoryInputIcon l = new MemoryInputIcon(nCol, p);
        this.loadTextInfo(l, element);
        Attribute attr = element.getAttribute("memory");
        if (attr == null) {
            log.error("incorrect information for a memory location; must use memory name");
            p.loadFailed();
            return;
        }
        String name = attr.getValue();
        Memory m = InstanceManager.memoryManagerInstance().getMemory(name);
        if (m == null) {
            log.error("Memory named '{}' not found.", (Object)attr.getValue());
            p.loadFailed();
            return;
        }
        l.setMemory(name);
        try {
            p.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadLogixNG_Data(l, element);
        this.loadCommonAttributes(l, 5, element);
        JComponent textField = l.getTextComponent();
        PositionablePopupUtil util = l.getPopupUtility();
        if (util.hasBackground()) {
            textField.setBackground(util.getBackground());
        } else {
            textField.setBackground(null);
            textField.setOpaque(false);
        }
    }
}

