/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.util.List;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.MultiSensorIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSensorIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(MultiSensorIconXml.class);

    @Override
    public Element store(Object o) {
        MultiSensorIcon p = (MultiSensorIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("multisensoricon");
        this.storeCommonAttributes(p, element);
        element.setAttribute("updown", p.getUpDown() ? "true" : "false");
        for (int i = 0; i < p.getNumEntries(); ++i) {
            Element e = this.storeIcon("active", p.getSensorIcon(i));
            e.setAttribute("sensor", p.getSensorName(i));
            element.addContent((Content)e);
        }
        element.addContent((Content)this.storeIcon("inactive", p.getInactiveIcon()));
        element.addContent((Content)this.storeIcon("unknown", p.getUnknownIcon()));
        element.addContent((Content)this.storeIcon("inconsistent", p.getInconsistentIcon()));
        this.storeLogixNG_Data(p, element);
        element.setAttribute("class", "jmri.jmrit.display.configurexml.MultiSensorIconXml");
        return element;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        Editor pe = (Editor)o;
        MultiSensorIcon l = new MultiSensorIcon(pe);
        int rotation = 0;
        try {
            rotation = element.getAttribute("rotate").getIntValue();
        }
        catch (DataConversionException dataConversionException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        NamedIcon icon = this.loadSensorIcon("inactive", rotation, l, element, pe);
        if (icon == null) {
            return;
        }
        l.setInactiveIcon(icon);
        icon = this.loadSensorIcon("unknown", rotation, l, element, pe);
        if (icon == null) {
            return;
        }
        l.setUnknownIcon(icon);
        icon = this.loadSensorIcon("inconsistent", rotation, l, element, pe);
        if (icon == null) {
            return;
        }
        l.setInconsistentIcon(icon);
        Attribute a = element.getAttribute("updown");
        if (a != null && a.getValue().equals("true")) {
            l.setUpDown(true);
        } else {
            l.setUpDown(false);
        }
        List items = element.getChildren();
        for (Element item : items) {
            String name;
            if (item.getAttribute("sensor") == null) continue;
            String sensor = item.getAttribute("sensor").getValue();
            if (item.getAttribute("url") != null) {
                name = item.getAttribute("url").getValue();
                icon = NamedIcon.getIconByName(name);
                if (icon == null && (icon = pe.loadFailed("MultiSensor \"" + l.getNameString() + "\" ", name)) == null) {
                    log.error("MultiSensor \"{}\" removed for url= {}", (Object)l.getNameString(), (Object)name);
                    return;
                }
                try {
                    int deg = 0;
                    a = item.getAttribute("degrees");
                    if (a != null) {
                        deg = a.getIntValue();
                        double scale = 1.0;
                        a = item.getAttribute("scale");
                        if (a != null) {
                            scale = item.getAttribute("scale").getDoubleValue();
                        }
                        icon.setLoad(deg, scale, l);
                    }
                    if (deg == 0 && (a = item.getAttribute("rotate")) != null) {
                        rotation = a.getIntValue();
                        icon.setRotation(rotation, l);
                    }
                }
                catch (DataConversionException dataConversionException) {}
            } else {
                name = item.getAttribute("icon").getValue();
                icon = NamedIcon.getIconByName(name);
                if (icon == null && (icon = pe.loadFailed("MultiSensor \"" + l.getNameString(), name)) == null) {
                    log.info("MultiSensor \"{} removed for url= {}", (Object)l.getNameString(), (Object)name);
                    return;
                }
                if (rotation != 0) {
                    icon.setRotation(rotation, l);
                }
            }
            l.addEntry(sensor, icon);
        }
        try {
            pe.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadLogixNG_Data(l, element);
        this.loadCommonAttributes(l, 10, element);
    }

    private NamedIcon loadSensorIcon(String state, int rotation, MultiSensorIcon l, Element element, Editor ed) {
        String msg = "MultiSensor \"" + l.getNameString() + "\": icon \"" + state + "\" ";
        NamedIcon icon = this.loadIcon(l, state, element, msg, ed);
        if (icon == null) {
            if (element.getAttribute(state) != null) {
                String iconName = element.getAttribute(state).getValue();
                icon = NamedIcon.getIconByName(iconName);
                if (icon == null) {
                    icon = ed.loadFailed(msg, iconName);
                    if (icon == null) {
                        log.info("{} removed for url= {}", (Object)msg, (Object)iconName);
                    }
                } else {
                    icon.setRotation(rotation, l);
                }
            } else {
                log.warn("did not locate {} for Multisensor icon file", (Object)state);
            }
        }
        if (icon == null) {
            log.info("MultiSensor Icon \"{}\": icon \"{}\" removed", (Object)l.getNameString(), (Object)state);
        }
        return icon;
    }
}

