/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.Set;
import jmri.InstanceManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.ToolTip;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.util.gui.GuiLafPreferencesManager;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionableLabelXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(PositionableLabelXml.class);

    @Override
    public Element store(Object o) {
        PositionableLabel p = (PositionableLabel)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("positionablelabel");
        this.storeCommonAttributes(p, element);
        if (p.isText()) {
            if (p.getUnRotatedText() != null) {
                element.setAttribute("text", p.getUnRotatedText());
            }
            this.storeTextInfo(p, element);
        }
        if (p.isIcon() && p.getIcon() != null) {
            element.setAttribute("icon", "yes");
            element.addContent((Content)this.storeIcon("icon", (NamedIcon)p.getIcon()));
        }
        this.storeLogixNG_Data(p, element);
        element.setAttribute("class", "jmri.jmrit.display.configurexml.PositionableLabelXml");
        return element;
    }

    protected void storeTextInfo(Positionable p, Element element) {
        String just;
        PositionablePopupUtil util = p.getPopupUtility();
        GuiLafPreferencesManager manager = InstanceManager.getDefault(GuiLafPreferencesManager.class);
        String defaultFontName = manager.getDefaultFont().getFontName();
        String fontName = util.getFont().getFontName();
        if (!fontName.equals(defaultFontName)) {
            element.setAttribute("fontFamily", util.getFont().getFamily());
            element.setAttribute("fontname", fontName);
        }
        element.setAttribute("size", "" + util.getFontSize());
        element.setAttribute("style", "" + util.getFontStyle());
        element.setAttribute("red", "" + util.getForeground().getRed());
        element.setAttribute("green", "" + util.getForeground().getGreen());
        element.setAttribute("blue", "" + util.getForeground().getBlue());
        element.setAttribute("hasBackground", util.hasBackground() ? "yes" : "no");
        if (util.hasBackground()) {
            element.setAttribute("redBack", "" + util.getBackground().getRed());
            element.setAttribute("greenBack", "" + util.getBackground().getGreen());
            element.setAttribute("blueBack", "" + util.getBackground().getBlue());
        }
        if (util.getMargin() != 0) {
            element.setAttribute("margin", "" + util.getMargin());
        }
        if (util.getBorderSize() != 0) {
            element.setAttribute("borderSize", "" + util.getBorderSize());
            element.setAttribute("redBorder", "" + util.getBorderColor().getRed());
            element.setAttribute("greenBorder", "" + util.getBorderColor().getGreen());
            element.setAttribute("blueBorder", "" + util.getBorderColor().getBlue());
        }
        if (util.getFixedWidth() != 0) {
            element.setAttribute("fixedWidth", "" + util.getFixedWidth());
        }
        if (util.getFixedHeight() != 0) {
            element.setAttribute("fixedHeight", "" + util.getFixedHeight());
        }
        switch (util.getJustification()) {
            case 2: {
                just = "right";
                break;
            }
            case 4: {
                just = "centre";
                break;
            }
            default: {
                just = "left";
            }
        }
        element.setAttribute("justification", just);
        if (util.getOrientation() != 0) {
            String ori;
            switch (util.getOrientation()) {
                case 2: {
                    ori = "vertical_down";
                    break;
                }
                case 1: {
                    ori = "vertical_up";
                    break;
                }
                default: {
                    ori = "horizontal";
                }
            }
            element.setAttribute("orientation", ori);
        }
    }

    public void storeCommonAttributes(Positionable p, Element element) {
        Set<String> classes;
        if (p.getId() != null) {
            element.setAttribute("id", p.getId());
        }
        if (!(classes = p.getClasses()).isEmpty()) {
            StringBuilder classNames = new StringBuilder();
            for (String className : classes) {
                if (className.contains(",")) {
                    throw new UnsupportedOperationException("Comma is not allowed in class names");
                }
                if (classNames.length() > 0) {
                    classNames.append(",");
                }
                classNames.append(className);
            }
            element.setAttribute("classes", classNames.toString());
        }
        element.setAttribute("x", "" + p.getX());
        element.setAttribute("y", "" + p.getY());
        element.setAttribute("level", String.valueOf(p.getDisplayLevel()));
        element.setAttribute("forcecontroloff", !p.isControlling() ? "true" : "false");
        element.setAttribute("hidden", p.isHidden() ? "yes" : "no");
        if (p.isEmptyHidden()) {
            element.setAttribute("emptyHidden", "yes");
        }
        if (p.isValueEditDisabled()) {
            element.setAttribute("valueEditDisabled", "yes");
        }
        element.setAttribute("positionable", p.isPositionable() ? "true" : "false");
        element.setAttribute("showtooltip", p.showToolTip() ? "true" : "false");
        element.setAttribute("editable", p.isEditable() ? "true" : "false");
        ToolTip tip = p.getToolTip();
        if (tip != null) {
            String txt;
            if (tip.getPrependToolTipWithDisplayName()) {
                element.addContent((Content)new Element("tooltip_prependWithDisplayName").addContent("yes"));
            }
            if ((txt = tip.getText()) != null) {
                Element elem = new Element("tooltip").addContent(txt);
                element.addContent((Content)elem);
            }
        }
        if (p.getDegrees() != 0) {
            element.setAttribute("degrees", "" + p.getDegrees());
        }
    }

    public Element storeIcon(String elemName, NamedIcon icon) {
        if (icon == null) {
            return null;
        }
        Element element = new Element(elemName);
        element.setAttribute("url", icon.getURL());
        element.setAttribute("degrees", String.valueOf(icon.getDegrees()));
        element.setAttribute("scale", String.valueOf(icon.getScale()));
        element.addContent((Content)new Element("rotation").addContent(String.valueOf(icon.getRotation())));
        return element;
    }

    public void storeLogixNG_Data(Positionable p, Element element) {
        if (p.getLogixNG() == null) {
            return;
        }
        if (p.getLogixNG().getNumConditionalNGs() == 0) {
            return;
        }
        Element logixNG_Element = new Element("LogixNG");
        logixNG_Element.addContent((Content)new Element("InlineLogixNG_SystemName").addContent(p.getLogixNG().getSystemName()));
        element.addContent((Content)logixNG_Element);
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        log.error("Invalid method called");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        PositionableLabel l = null;
        Editor editor = (Editor)o;
        if (element.getAttribute("icon") != null) {
            NamedIcon icon;
            String name = element.getAttribute("icon").getValue();
            if (name.equals("yes")) {
                icon = this.getNamedIcon("icon", element, "PositionableLabel ", editor);
            } else {
                icon = NamedIcon.getIconByName(name);
                if (icon == null && (icon = editor.loadFailed("PositionableLabel", name)) == null) {
                    log.info("PositionableLabel icon removed for url= {}", (Object)name);
                    return;
                }
            }
            if (icon == null && !name.equals("yes")) {
                log.info("PositionableLabel icon removed for url= {}", (Object)name);
                return;
            }
            l = new PositionableLabel(icon, editor);
            try {
                Attribute a = element.getAttribute("rotate");
                if (a != null && icon != null) {
                    int rotation = element.getAttribute("rotate").getIntValue();
                    icon.setRotation(rotation, l);
                }
            }
            catch (DataConversionException a) {
                // empty catch block
            }
            if (name.equals("yes")) {
                NamedIcon nIcon = this.loadIcon(l, "icon", element, "PositionableLabel ", editor);
                if (nIcon == null) {
                    log.info("PositionableLabel icon removed for url= {}", (Object)name);
                    return;
                }
                l.updateIcon(nIcon);
            } else {
                l.updateIcon(icon);
            }
        }
        if (element.getAttribute("text") != null) {
            if (l == null) {
                l = new PositionableLabel(element.getAttribute("text").getValue(), editor);
            }
            this.loadTextInfo(l, element);
        } else if (l == null) {
            log.error("PositionableLabel is null!");
            if (log.isDebugEnabled()) {
                List attrs = element.getAttributes();
                log.debug("\tElement Has {} Attributes:", (Object)attrs.size());
                for (Attribute a : attrs) {
                    log.debug("  attribute:  {} = {}", (Object)a.getName(), (Object)a.getValue());
                }
                List kids = element.getChildren();
                log.debug("\tElementHas {} children:", (Object)kids.size());
                for (Element e : kids) {
                    log.debug("  child:  {} = \"{}\"", (Object)e.getName(), (Object)e.getValue());
                }
            }
            editor.loadFailed();
            return;
        }
        try {
            editor.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        this.loadLogixNG_Data(l, element);
        this.loadCommonAttributes(l, 4, element);
    }

    protected void loadTextInfo(Positionable l, Element element) {
        int green;
        int blue;
        PositionablePopupUtil util;
        if (log.isDebugEnabled()) {
            log.debug("loadTextInfo");
        }
        if ((util = l.getPopupUtility()) == null) {
            log.warn("PositionablePopupUtil is null! {}", (Object)element);
            return;
        }
        Attribute a = element.getAttribute("size");
        try {
            if (a != null) {
                util.setFontSize(a.getFloatValue());
            }
        }
        catch (DataConversionException ex) {
            log.warn("invalid size attribute value");
        }
        a = element.getAttribute("style");
        try {
            if (a != null) {
                int style = a.getIntValue();
                int drop = 0;
                switch (style) {
                    case 0: 
                    case 2: {
                        drop = 1;
                        break;
                    }
                }
                util.setFontStyle(style, drop);
            }
        }
        catch (DataConversionException ex) {
            log.warn("invalid style attribute value");
        }
        a = element.getAttribute("fontname");
        try {
            if (a != null) {
                util.setFont(new Font(a.getValue(), util.getFontStyle(), util.getFontSize()));
                util = l.getPopupUtility();
            }
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            int red = element.getAttribute("red").getIntValue();
            blue = element.getAttribute("blue").getIntValue();
            green = element.getAttribute("green").getIntValue();
            util.setForeground(new Color(red, green, blue));
        }
        catch (DataConversionException e) {
            log.warn("Could not parse color attributes!");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        a = element.getAttribute("hasBackground");
        if (a != null) {
            util.setHasBackground("yes".equals(a.getValue()));
        } else {
            util.setHasBackground(true);
        }
        if (util.hasBackground()) {
            try {
                int red = element.getAttribute("redBack").getIntValue();
                blue = element.getAttribute("blueBack").getIntValue();
                green = element.getAttribute("greenBack").getIntValue();
                util.setBackgroundColor(new Color(red, green, blue));
            }
            catch (DataConversionException e) {
                log.warn("Could not parse background color attributes!");
            }
            catch (NullPointerException e) {
                util.setHasBackground(false);
            }
        }
        int fixedWidth = 0;
        int fixedHeight = 0;
        try {
            fixedHeight = element.getAttribute("fixedHeight").getIntValue();
        }
        catch (DataConversionException e) {
            log.warn("Could not parse fixed Height attributes!");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            fixedWidth = element.getAttribute("fixedWidth").getIntValue();
        }
        catch (DataConversionException e) {
            log.warn("Could not parse fixed Width attribute!");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (fixedWidth != 0 || fixedHeight != 0) {
            util.setFixedSize(fixedWidth, fixedHeight);
        }
        if (util.getFixedWidth() == 0 || util.getFixedHeight() == 0) {
            try {
                util.setMargin(element.getAttribute("margin").getIntValue());
            }
            catch (DataConversionException e) {
                log.warn("Could not parse margin attribute!");
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        try {
            util.setBorderSize(element.getAttribute("borderSize").getIntValue());
            int red = element.getAttribute("redBorder").getIntValue();
            int blue2 = element.getAttribute("blueBorder").getIntValue();
            int green2 = element.getAttribute("greenBorder").getIntValue();
            util.setBorderColor(new Color(red, green2, blue2));
        }
        catch (DataConversionException e) {
            log.warn("Could not parse border attributes!");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        a = element.getAttribute("justification");
        if (a != null) {
            util.setJustification(a.getValue());
        } else {
            util.setJustification("left");
        }
        a = element.getAttribute("orientation");
        if (a != null) {
            util.setOrientation(a.getValue());
        } else {
            util.setOrientation("horizontal");
        }
        int deg = 0;
        try {
            a = element.getAttribute("degrees");
            if (a != null) {
                deg = a.getIntValue();
                l.rotate(deg);
            }
        }
        catch (DataConversionException ex) {
            log.warn("invalid 'degrees' value (non integer)");
        }
        if (deg == 0 && util.hasBackground()) {
            l.setOpaque(true);
        }
    }

    public void loadCommonAttributes(Positionable l, int defaultLevel, Element element) throws JmriConfigureXmlException {
        ToolTip tip;
        Element elem;
        if (element.getAttribute("id") != null) {
            try {
                l.setId(element.getAttribute("id").getValue());
            }
            catch (Positionable.DuplicateIdException e) {
                throw new JmriConfigureXmlException("Positionable id is not unique", e);
            }
        }
        if (element.getAttribute("classes") != null) {
            String classes = element.getAttribute("classes").getValue();
            for (String className : classes.split(",")) {
                if (className.isBlank()) continue;
                l.addClass(className);
            }
        }
        try {
            l.setControlling(!element.getAttribute("forcecontroloff").getBooleanValue());
        }
        catch (DataConversionException e1) {
            log.warn("unable to convert positionable label forcecontroloff attribute");
        }
        catch (Exception e1) {
            // empty catch block
        }
        int x = 0;
        int y = 0;
        try {
            x = element.getAttribute("x").getIntValue();
            y = element.getAttribute("y").getIntValue();
        }
        catch (DataConversionException e) {
            log.error("failed to convert positional attribute");
        }
        l.setLocation(x, y);
        int level = defaultLevel;
        try {
            level = element.getAttribute("level").getIntValue();
        }
        catch (DataConversionException e) {
            log.warn("Could not parse level attribute!");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        l.setDisplayLevel(level);
        try {
            boolean value = element.getAttribute("hidden").getBooleanValue();
            l.setHidden(value);
            l.setVisible(!value);
        }
        catch (DataConversionException e) {
            log.warn("unable to convert positionable label hidden attribute");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            boolean value = element.getAttribute("emptyHidden").getBooleanValue();
            l.setEmptyHidden(value);
        }
        catch (DataConversionException e) {
            log.warn("unable to convert positionable label emptyHidden attribute");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            boolean value = element.getAttribute("valueEditDisabled").getBooleanValue();
            l.setValueEditDisabled(value);
        }
        catch (DataConversionException e) {
            log.warn("unable to convert positionable label valueEditDisabled attribute");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            l.setPositionable(element.getAttribute("positionable").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert positionable label positionable attribute");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            l.setShowToolTip(element.getAttribute("showtooltip").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert positionable label showtooltip attribute");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            l.setEditable(element.getAttribute("editable").getBooleanValue());
        }
        catch (DataConversionException e) {
            log.warn("unable to convert positionable label editable attribute");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Attribute a = element.getAttribute("degrees");
        if (a != null && l instanceof PositionableLabel) {
            try {
                int deg = a.getIntValue();
                ((PositionableLabel)l).setDegrees(deg);
            }
            catch (DataConversionException deg) {
                // empty catch block
            }
        }
        if ((elem = element.getChild("tooltip_prependWithDisplayName")) != null && (tip = l.getToolTip()) != null) {
            tip.setPrependToolTipWithDisplayName("yes".equals(elem.getText()));
        }
        if ((elem = element.getChild("tooltip")) == null) {
            elem = element.getChild("toolTip");
        }
        if (elem != null && (tip = l.getToolTip()) != null) {
            tip.setText(elem.getText());
        }
    }

    public NamedIcon loadIcon(PositionableLabel l, String attrName, Element element, String name, Editor ed) {
        NamedIcon icon = this.getNamedIcon(attrName, element, name, ed);
        if (icon != null) {
            try {
                int deg = 0;
                double scale = 1.0;
                Element elem = element.getChild(attrName);
                if (elem != null) {
                    Attribute a = elem.getAttribute("degrees");
                    if (a != null) {
                        deg = a.getIntValue();
                    }
                    if ((a = elem.getAttribute("scale")) != null) {
                        scale = elem.getAttribute("scale").getDoubleValue();
                    }
                    icon.setLoad(deg, scale, l);
                    if (deg == 0) {
                        Element e;
                        a = elem.getAttribute("rotate");
                        if (a != null) {
                            int rotation = a.getIntValue();
                            if (scale == 1.0) {
                                icon.setRotation(rotation, l);
                            }
                        }
                        if ((e = elem.getChild("rotation")) != null) {
                            int rotation = Integer.parseInt(e.getText());
                            icon.setRotation(rotation, l);
                        }
                    }
                }
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        return icon;
    }

    protected NamedIcon getNamedIcon(String childName, Element element, String name, Editor ed) {
        NamedIcon icon = null;
        Element elem = element.getChild(childName);
        if (elem != null) {
            String iconName = elem.getAttribute("url").getValue();
            icon = NamedIcon.getIconByName(iconName);
            if (icon == null && (icon = ed.loadFailed(name, iconName)) == null) {
                log.info("{} removed for url= {}", (Object)name, (Object)iconName);
            }
        } else {
            log.debug("getNamedIcon: child element \"{}\" not found in element {}", (Object)childName, (Object)element.getName());
        }
        return icon;
    }

    public void loadLogixNG_Data(Positionable p, Element element) {
        Element logixNG_Element = element.getChild("LogixNG");
        if (logixNG_Element == null) {
            return;
        }
        Element inlineLogixNG = logixNG_Element.getChild("InlineLogixNG_SystemName");
        if (inlineLogixNG != null) {
            String systemName = inlineLogixNG.getTextTrim();
            p.setLogixNG_SystemName(systemName);
            InstanceManager.getDefault(LogixNG_Manager.class).registerSetupTask(() -> p.setupLogixNG());
        }
    }
}

