/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.SensorIcon;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorIconXml
extends PositionableLabelXml {
    static final HashMap<String, String> _nameMap = new HashMap();
    boolean _icon;
    private static final Logger log = LoggerFactory.getLogger(SensorIconXml.class);

    public SensorIconXml() {
        _nameMap.put("active", "SensorStateActive");
        _nameMap.put("inactive", "SensorStateInactive");
        _nameMap.put("unknown", "BeanStateUnknown");
        _nameMap.put("inconsistent", "BeanStateInconsistent");
    }

    @Override
    public Element store(Object o) {
        SensorIcon p = (SensorIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("sensoricon");
        element.setAttribute("sensor", p.getNamedSensor().getName());
        this.storeCommonAttributes(p, element);
        element.setAttribute("momentary", p.getMomentary() ? "true" : "false");
        element.setAttribute("icon", p.isIcon() ? "yes" : "no");
        this.storeIconInfo(p, element);
        this.storeTextInfo(p, element);
        this.storeLogixNG_Data(p, element);
        element.setAttribute("class", "jmri.jmrit.display.configurexml.SensorIconXml");
        return element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void storeTextInfo(SensorIcon p, Element element) {
        if (p.getText() == null) {
            String s = p.getOriginalText();
            if (s != null && s.length() > 0) {
                element.setAttribute("text", s);
            } else {
                if (!p.isText()) return;
                element.setAttribute("text", "");
            }
        } else {
            element.setAttribute("text", p.getText());
        }
        super.storeTextInfo(p, element);
        Element textElement = new Element("activeText");
        if (p.getActiveText() != null) {
            textElement.setAttribute("text", p.getActiveText());
        }
        textElement.setAttribute("red", "" + p.getTextActive().getRed());
        textElement.setAttribute("green", "" + p.getTextActive().getGreen());
        textElement.setAttribute("blue", "" + p.getTextActive().getBlue());
        if (p.getBackgroundActive() != null) {
            textElement.setAttribute("redBack", "" + p.getBackgroundActive().getRed());
            textElement.setAttribute("greenBack", "" + p.getBackgroundActive().getGreen());
            textElement.setAttribute("blueBack", "" + p.getBackgroundActive().getBlue());
        }
        element.addContent((Content)textElement);
        textElement = new Element("inactiveText");
        if (p.getInactiveText() != null) {
            textElement.setAttribute("text", p.getInactiveText());
        }
        textElement.setAttribute("red", "" + p.getTextInActive().getRed());
        textElement.setAttribute("green", "" + p.getTextInActive().getGreen());
        textElement.setAttribute("blue", "" + p.getTextInActive().getBlue());
        if (p.getBackgroundInActive() != null) {
            textElement.setAttribute("redBack", "" + p.getBackgroundInActive().getRed());
            textElement.setAttribute("greenBack", "" + p.getBackgroundInActive().getGreen());
            textElement.setAttribute("blueBack", "" + p.getBackgroundInActive().getBlue());
        }
        element.addContent((Content)textElement);
        textElement = new Element("unknownText");
        if (p.getUnknownText() != null) {
            textElement.setAttribute("text", p.getUnknownText());
        }
        textElement.setAttribute("red", "" + p.getTextUnknown().getRed());
        textElement.setAttribute("green", "" + p.getTextUnknown().getGreen());
        textElement.setAttribute("blue", "" + p.getTextUnknown().getBlue());
        if (p.getBackgroundUnknown() != null) {
            textElement.setAttribute("redBack", "" + p.getBackgroundUnknown().getRed());
            textElement.setAttribute("greenBack", "" + p.getBackgroundUnknown().getGreen());
            textElement.setAttribute("blueBack", "" + p.getBackgroundUnknown().getBlue());
        }
        element.addContent((Content)textElement);
        textElement = new Element("inconsistentText");
        if (p.getInconsistentText() != null) {
            textElement.setAttribute("text", p.getInconsistentText());
        }
        textElement.setAttribute("red", "" + p.getTextInconsistent().getRed());
        textElement.setAttribute("green", "" + p.getTextInconsistent().getGreen());
        textElement.setAttribute("blue", "" + p.getTextInconsistent().getBlue());
        if (p.getBackgroundInconsistent() != null) {
            textElement.setAttribute("redBack", "" + p.getBackgroundInconsistent().getRed());
            textElement.setAttribute("greenBack", "" + p.getBackgroundInconsistent().getGreen());
            textElement.setAttribute("blueBack", "" + p.getBackgroundInconsistent().getBlue());
        }
        element.addContent((Content)textElement);
    }

    protected void storeIconInfo(SensorIcon p, Element element) {
        element.addContent((Content)this.storeIcon("active", p.getIcon("SensorStateActive")));
        element.addContent((Content)this.storeIcon("inactive", p.getIcon("SensorStateInactive")));
        element.addContent((Content)this.storeIcon("unknown", p.getIcon("BeanStateUnknown")));
        element.addContent((Content)this.storeIcon("inconsistent", p.getIcon("BeanStateInconsistent")));
        Element elem = new Element("iconmaps");
        String family = p.getFamily();
        if (family != null) {
            elem.setAttribute("family", family);
        }
        element.addContent((Content)elem);
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        Attribute a;
        String yesno;
        Editor ed = (Editor)o;
        Attribute attr = element.getAttribute("sensor");
        if (attr == null) {
            log.error("incorrect information for sensor; must use sensor name");
            ed.loadFailed();
            return;
        }
        String name = attr.getValue();
        this._icon = true;
        if (element.getAttribute("icon") != null && (yesno = element.getAttribute("icon").getValue()) != null && !yesno.equals("")) {
            if (yesno.equals("yes")) {
                this._icon = true;
            } else if (yesno.equals("no")) {
                this._icon = false;
            }
        }
        SensorIcon l = this._icon ? new SensorIcon(new NamedIcon("resources/icons/smallschematics/tracksegments/circuit-error.gif", "resources/icons/smallschematics/tracksegments/circuit-error.gif"), ed) : new SensorIcon("  ", ed);
        int rotation = 0;
        try {
            rotation = element.getAttribute("rotate").getIntValue();
        }
        catch (DataConversionException dataConversionException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.loadSensorIcon("active", rotation, l, element, name, ed) == null) {
            return;
        }
        if (this.loadSensorIcon("inactive", rotation, l, element, name, ed) == null) {
            return;
        }
        if (this.loadSensorIcon("unknown", rotation, l, element, name, ed) == null) {
            return;
        }
        if (this.loadSensorIcon("inconsistent", rotation, l, element, name, ed) == null) {
            return;
        }
        Element elem = element.getChild("iconmaps");
        if (elem != null && (attr = elem.getAttribute("family")) != null) {
            l.setFamily(attr.getValue());
        }
        if ((a = element.getAttribute("momentary")) != null && a.getValue().equals("true")) {
            l.setMomentary(true);
        } else {
            l.setMomentary(false);
        }
        this.loadTextInfo(l, element);
        l.setSensor(name);
        try {
            ed.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadLogixNG_Data(l, element);
        this.loadCommonAttributes(l, 10, element);
        if (l.isIcon() && l.getText() != null) {
            l.setOpaque(false);
        }
    }

    private NamedIcon loadSensorIcon(String state, int rotation, SensorIcon l, Element element, String name, Editor ed) {
        String msg = "SensorIcon \"" + name + "\": icon \"" + state + "\" ";
        NamedIcon icon = this.loadIcon(l, state, element, msg, ed);
        if (icon == null && this._icon) {
            String iconName;
            if (element.getAttribute(state) != null && !(iconName = element.getAttribute(state).getValue()).equals("")) {
                icon = NamedIcon.getIconByName(iconName);
                if (icon == null) {
                    icon = ed.loadFailed(msg, iconName);
                    if (icon == null) {
                        log.info("{} removed for url= {}", (Object)msg, (Object)iconName);
                    }
                } else {
                    icon.setRotation(rotation, l);
                }
            } else {
                log.warn("did not locate {} icon file for {}", (Object)state, (Object)name);
            }
        }
        if (icon == null) {
            log.info("{} removed", (Object)msg);
        } else {
            l.setIcon(_nameMap.get(state), icon);
        }
        return icon;
    }

    void loadTextInfo(SensorIcon l, Element element) {
        super.loadTextInfo(l, element);
        this.loadSensorTextState("Active", l, element);
        this.loadSensorTextState("InActive", l, element);
        this.loadSensorTextState("Unknown", l, element);
        this.loadSensorTextState("Inconsistent", l, element);
        if (element.getAttribute("text") != null) {
            l.setOriginalText(element.getAttribute("text").getValue());
            l.setText(element.getAttribute("text").getValue());
        }
    }

    private void loadSensorTextState(String state, SensorIcon l, Element element) {
        String name = null;
        Color clrText = null;
        Color clrBackground = null;
        List textList = element.getChildren(state.toLowerCase() + "Text");
        if (log.isDebugEnabled()) {
            log.debug("Found {} {}Text objects", (Object)textList.size(), (Object)state);
        }
        if (textList.size() > 0) {
            int green;
            int blue;
            Element elem = (Element)textList.get(0);
            try {
                name = elem.getAttribute("text").getValue();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                int red = elem.getAttribute("red").getIntValue();
                blue = elem.getAttribute("blue").getIntValue();
                green = elem.getAttribute("green").getIntValue();
                clrText = new Color(red, green, blue);
            }
            catch (DataConversionException e) {
                log.warn("Could not parse color attributes!");
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                int red = elem.getAttribute("redBack").getIntValue();
                blue = elem.getAttribute("blueBack").getIntValue();
                green = elem.getAttribute("greenBack").getIntValue();
                clrBackground = new Color(red, green, blue);
            }
            catch (DataConversionException e) {
                log.warn("Could not parse color attributes!");
            }
            catch (NullPointerException e) {}
        } else {
            int green;
            int blue;
            if (element.getAttribute(state.toLowerCase()) != null) {
                name = element.getAttribute(state.toLowerCase()).getValue();
            }
            try {
                int red = element.getAttribute("red" + state).getIntValue();
                blue = element.getAttribute("blue" + state).getIntValue();
                green = element.getAttribute("green" + state).getIntValue();
                clrText = new Color(red, green, blue);
            }
            catch (DataConversionException e) {
                log.warn("Could not parse color attributes!");
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                int red = element.getAttribute("red" + state + "Back").getIntValue();
                blue = element.getAttribute("blue" + state + "Back").getIntValue();
                green = element.getAttribute("green" + state + "Back").getIntValue();
                clrBackground = new Color(red, green, blue);
            }
            catch (DataConversionException e) {
                log.warn("Could not parse color attributes!");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (state.equals("Active")) {
            if (name != null) {
                l.setActiveText(name);
            }
            if (clrText != null) {
                l.setTextActive(clrText);
            }
            if (clrBackground != null) {
                l.setBackgroundActive(clrBackground);
            }
        } else if (state.equals("InActive")) {
            if (name != null) {
                l.setInactiveText(name);
            }
            if (clrText != null) {
                l.setTextInActive(clrText);
            }
            if (clrBackground != null) {
                l.setBackgroundInActive(clrBackground);
            }
        } else if (state.equals("Unknown")) {
            if (name != null) {
                l.setUnknownText(name);
            }
            if (clrText != null) {
                l.setTextUnknown(clrText);
            }
            if (clrBackground != null) {
                l.setBackgroundUnknown(clrBackground);
            }
        } else if (state.equals("Inconsistent")) {
            if (name != null) {
                l.setInconsistentText(name);
            }
            if (clrText != null) {
                l.setTextInconsistent(clrText);
            }
            if (clrBackground != null) {
                l.setBackgroundInconsistent(clrBackground);
            }
        }
    }
}

