/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.SlipTurnoutIcon;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlipTurnoutIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(SlipTurnoutIconXml.class);

    @Override
    public Element store(Object o) {
        SlipTurnoutIcon p = (SlipTurnoutIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("slipturnouticon");
        element.addContent((Content)new Element("turnoutEast").addContent(p.getNamedTurnout(2).getName()));
        element.addContent((Content)new Element("turnoutWest").addContent(p.getNamedTurnout(1).getName()));
        switch (p.getTurnoutType()) {
            case 0: {
                element.addContent((Content)this.storeIcon("lowerWestToLowerEast", p.getLowerWestToLowerEastIcon(), p.getLWLEText()));
                element.addContent((Content)this.storeIcon("upperWestToUpperEast", p.getUpperWestToUpperEastIcon(), p.getUWUEText()));
                element.setAttribute("turnoutType", "doubleSlip");
                break;
            }
            case 2: {
                element.addContent((Content)this.storeIcon("lowerWestToLowerEast", p.getLowerWestToLowerEastIcon(), p.getLWLEText()));
                element.setAttribute("turnoutType", "singleSlip");
                element.setAttribute("singleSlipRoute", p.getSingleSlipRoute() ? "upperWestToUpperEast" : "lowerWestToLowerEast");
                break;
            }
            case 4: {
                element.addContent((Content)this.storeIcon("lowerWestToLowerEast", p.getLowerWestToLowerEastIcon(), p.getLWLEText()));
                element.setAttribute("turnoutType", "threeWay");
                element.setAttribute("firstTurnoutExit", p.getSingleSlipRoute() ? "upper" : "lower");
                break;
            }
            case 8: {
                if (!p.getSingleSlipRoute()) {
                    element.addContent((Content)new Element("turnoutLowerEast").addContent(p.getNamedTurnout(6).getName()));
                    element.addContent((Content)new Element("turnoutLowerWest").addContent(p.getNamedTurnout(4).getName()));
                }
                element.addContent((Content)this.storeIcon("lowerWestToLowerEast", p.getLowerWestToLowerEastIcon(), p.getLWLEText()));
                element.setAttribute("turnoutType", "scissor");
                break;
            }
            default: {
                log.warn("Unhandled turnout type: {}", (Object)p.getTurnoutType());
            }
        }
        this.storeCommonAttributes(p, element);
        element.setAttribute("tristate", p.getTristate() ? "true" : "false");
        element.addContent((Content)this.storeIcon("lowerWestToUpperEast", p.getLowerWestToUpperEastIcon(), p.getLWUEText()));
        element.addContent((Content)this.storeIcon("upperWestToLowerEast", p.getUpperWestToLowerEastIcon(), p.getUWLEText()));
        element.addContent((Content)super.storeIcon("unknown", p.getUnknownIcon()));
        element.addContent((Content)super.storeIcon("inconsistent", p.getInconsistentIcon()));
        this.storeLogixNG_Data(p, element);
        element.setAttribute("class", "jmri.jmrit.display.configurexml.SlipTurnoutIconXml");
        return element;
    }

    Element storeIcon(String elemName, NamedIcon icon, String text) {
        Element element = super.storeIcon(elemName, icon);
        element.addContent((Content)new Element("text").addContent(text));
        return element;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        Editor p = (Editor)o;
        SlipTurnoutIcon l = new SlipTurnoutIcon(p);
        int rotation = 0;
        try {
            Attribute a = element.getAttribute("rotate");
            rotation = a.getIntValue();
        }
        catch (DataConversionException a) {
        }
        catch (NullPointerException a) {
            // empty catch block
        }
        String nameEast = this.loadTurnout(element, "turnoutEast");
        String nameWest = this.loadTurnout(element, "turnoutWest");
        Attribute a = element.getAttribute("turnoutType");
        if (a != null) {
            if (a.getValue().equals("doubleSlip")) {
                l.setTurnoutType(0);
            } else if (a.getValue().equals("singleSlip")) {
                l.setTurnoutType(2);
                a = element.getAttribute("singleSlipRoute");
                if (a == null || a.getValue().equals("upperWestToUpperEast")) {
                    l.setSingleSlipRoute(true);
                } else {
                    l.setSingleSlipRoute(false);
                }
            } else if (a.getValue().equals("threeWay")) {
                l.setTurnoutType(4);
                a = element.getAttribute("firstTurnoutExit");
                if (a == null || a.getValue().equals("lower")) {
                    l.setSingleSlipRoute(false);
                } else {
                    l.setSingleSlipRoute(true);
                }
            } else if (a.getValue().equals("scissor")) {
                l.setTurnoutType(8);
                if (this.loadTurnout(element, "turnoutLowerWest") == null) {
                    l.setSingleSlipRoute(true);
                } else {
                    l.setSingleSlipRoute(false);
                    l.setTurnout(this.loadTurnout(element, "turnoutLowerEast"), 6);
                    l.setTurnout(this.loadTurnout(element, "turnoutLowerWest"), 4);
                }
            }
        }
        this.loadTurnoutIcon("lowerWestToUpperEast", rotation, l, element, p);
        this.loadTurnoutIcon("upperWestToLowerEast", rotation, l, element, p);
        switch (l.getTurnoutType()) {
            case 0: {
                this.loadTurnoutIcon("lowerWestToLowerEast", rotation, l, element, p);
                this.loadTurnoutIcon("upperWestToUpperEast", rotation, l, element, p);
                break;
            }
            default: {
                this.loadTurnoutIcon("lowerWestToLowerEast", rotation, l, element, p);
            }
        }
        this.loadTurnoutIcon("unknown", rotation, l, element, p);
        this.loadTurnoutIcon("inconsistent", rotation, l, element, p);
        a = element.getAttribute("tristate");
        if (a == null || a.getValue().equals("true")) {
            l.setTristate(true);
        } else {
            l.setTristate(false);
        }
        l.setTurnout(nameEast, 2);
        l.setTurnout(nameWest, 1);
        try {
            p.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadLogixNG_Data(l, element);
        this.loadCommonAttributes(l, 7, element);
    }

    private String loadTurnout(Element element, String turn) {
        Element e;
        if (element != null && (e = element.getChild(turn)) != null) {
            return e.getText();
        }
        return null;
    }

    private void loadTurnoutIcon(String state, int rotation, SlipTurnoutIcon l, Element element, Editor ed) {
        Element e;
        NamedIcon icon = this.loadIcon(l, state, element, "SlipTurnout \"" + l.getNameString() + "\" icon \"" + state + "\" ", ed);
        String textValue = null;
        if (icon != null) {
            if (state.equals("lowerWestToUpperEast")) {
                l.setLowerWestToUpperEastIcon(icon);
            } else if (state.equals("upperWestToLowerEast")) {
                l.setUpperWestToLowerEastIcon(icon);
            } else if (state.equals("lowerWestToLowerEast")) {
                l.setLowerWestToLowerEastIcon(icon);
            } else if (state.equals("upperWestToUpperEast")) {
                l.setUpperWestToUpperEastIcon(icon);
            } else if (state.equals("unknown")) {
                l.setUnknownIcon(icon);
            } else if (state.equals("inconsistent")) {
                l.setInconsistentIcon(icon);
            }
        } else {
            return;
        }
        Element elem = element.getChild(state);
        if (elem != null && (e = elem.getChild("text")) != null) {
            textValue = e.getText();
        }
        if (textValue != null) {
            if (state.equals("lowerWestToUpperEast")) {
                l.setLWUEText(textValue);
            } else if (state.equals("upperWestToLowerEast")) {
                l.setUWLEText(textValue);
            } else if (state.equals("lowerWestToLowerEast")) {
                l.setLWLEText(textValue);
            } else if (state.equals("upperWestToUpperEast")) {
                l.setUWUEText(textValue);
            }
        }
    }
}

