/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.util.HashMap;
import java.util.List;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.TurnoutIcon;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutIconXml
extends PositionableLabelXml {
    static final HashMap<String, String> _nameMap = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(TurnoutIconXml.class);

    public TurnoutIconXml() {
        _nameMap.put("closed", "TurnoutStateClosed");
        _nameMap.put("thrown", "TurnoutStateThrown");
        _nameMap.put("unknown", "BeanStateUnknown");
        _nameMap.put("inconsistent", "BeanStateInconsistent");
    }

    @Override
    public Element store(Object o) {
        TurnoutIcon p = (TurnoutIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("turnouticon");
        element.setAttribute("turnout", p.getNamedTurnout().getName());
        this.storeCommonAttributes(p, element);
        element.setAttribute("tristate", p.getTristate() ? "true" : "false");
        element.setAttribute("momentary", p.getMomentary() ? "true" : "false");
        element.setAttribute("directControl", p.getDirectControl() ? "true" : "false");
        Element elem = new Element("icons");
        elem.addContent((Content)this.storeIcon("closed", p.getIcon("TurnoutStateClosed")));
        elem.addContent((Content)this.storeIcon("thrown", p.getIcon("TurnoutStateThrown")));
        elem.addContent((Content)this.storeIcon("unknown", p.getIcon("BeanStateUnknown")));
        elem.addContent((Content)this.storeIcon("inconsistent", p.getIcon("BeanStateInconsistent")));
        element.addContent((Content)elem);
        elem = new Element("iconmaps");
        String family = p.getFamily();
        if (family != null) {
            elem.setAttribute("family", family);
        }
        element.addContent((Content)elem);
        this.storeLogixNG_Data(p, element);
        element.setAttribute("class", "jmri.jmrit.display.configurexml.TurnoutIconXml");
        return element;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        Attribute attr;
        String name;
        Editor p = (Editor)o;
        TurnoutIcon l = new TurnoutIcon(p);
        try {
            name = element.getAttribute("turnout").getValue();
        }
        catch (NullPointerException e) {
            log.error("incorrect information for turnout; must use turnout name");
            p.loadFailed();
            return;
        }
        l.setTurnout(name);
        Attribute a = element.getAttribute("tristate");
        if (a == null || a.getValue().equals("true")) {
            l.setTristate(true);
        } else {
            l.setTristate(false);
        }
        a = element.getAttribute("momentary");
        if (a != null && a.getValue().equals("true")) {
            l.setMomentary(true);
        } else {
            l.setMomentary(false);
        }
        a = element.getAttribute("directControl");
        if (a != null && a.getValue().equals("true")) {
            l.setDirectControl(true);
        } else {
            l.setDirectControl(false);
        }
        List states = element.getChildren();
        if (states.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Main element has{} items", (Object)states.size());
            }
            Element elem = element;
            Element icons = element.getChild("icons");
            if (icons != null) {
                states = icons.getChildren();
                elem = icons;
                if (log.isDebugEnabled()) {
                    log.debug("icons element has{} items", (Object)states.size());
                }
            }
            for (Element value : states) {
                NamedIcon icon;
                String state = value.getName();
                if (log.isDebugEnabled()) {
                    log.debug("setIcon for state \"{}\" and {}", (Object)state, (Object)_nameMap.get(state));
                }
                if ((icon = this.loadIcon(l, state, elem, "TurnoutIcon \"" + name + "\": icon \"" + state + "\" ", p)) != null) {
                    l.setIcon(_nameMap.get(state), icon);
                    continue;
                }
                log.info("TurnoutIcon \"{}\": icon \"{}\" removed", (Object)name, (Object)state);
                return;
            }
            log.debug("{} icons loaded for {}", (Object)states.size(), (Object)l.getNameString());
        } else {
            int rotation = 0;
            try {
                rotation = element.getAttribute("rotate").getIntValue();
            }
            catch (DataConversionException icons) {
            }
            catch (NullPointerException icons) {
                // empty catch block
            }
            if (this.loadTurnoutIcon("thrown", rotation, l, element, name, p) == null) {
                return;
            }
            if (this.loadTurnoutIcon("closed", rotation, l, element, name, p) == null) {
                return;
            }
            if (this.loadTurnoutIcon("unknown", rotation, l, element, name, p) == null) {
                return;
            }
            if (this.loadTurnoutIcon("inconsistent", rotation, l, element, name, p) == null) {
                return;
            }
        }
        Element elem = element.getChild("iconmaps");
        if (elem != null && (attr = elem.getAttribute("family")) != null) {
            l.setFamily(attr.getValue());
        }
        try {
            p.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadLogixNG_Data(l, element);
        this.loadCommonAttributes(l, 7, element);
    }

    private NamedIcon loadTurnoutIcon(String state, int rotation, TurnoutIcon l, Element element, String name, Editor ed) {
        NamedIcon icon = null;
        if (element.getAttribute(state) != null) {
            String iconName = element.getAttribute(state).getValue();
            icon = NamedIcon.getIconByName(iconName);
            if (icon == null) {
                icon = ed.loadFailed("Turnout \"" + name + "\" icon \"" + state + "\" ", iconName);
                if (icon == null) {
                    log.info("Turnout \"{}\" icon \"{}\" removed for url= {}", new Object[]{name, state, iconName});
                }
            } else {
                icon.setRotation(rotation, l);
            }
        } else {
            log.warn("did not locate {} icon file for Turnout {}", (Object)state, (Object)name);
        }
        if (icon == null) {
            log.info("Turnout Icon \"{}\": icon \"{}\" removed", (Object)name, (Object)state);
        } else {
            l.setIcon(_nameMap.get(state), icon);
        }
        return icon;
    }
}

