/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Path;
import jmri.Signal;
import jmri.SignalHeadManager;
import jmri.SignalMastManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.IndicatorTrack;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableIcon;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.SignalHeadIcon;
import jmri.jmrit.display.SignalMastIcon;
import jmri.jmrit.display.TurnoutIcon;
import jmri.jmrit.display.controlPanelEditor.Bundle;
import jmri.jmrit.display.controlPanelEditor.ControlPanelEditor;
import jmri.jmrit.display.controlPanelEditor.ConvertDialog;
import jmri.jmrit.display.controlPanelEditor.EditCircuitFrame;
import jmri.jmrit.display.controlPanelEditor.EditCircuitPaths;
import jmri.jmrit.display.controlPanelEditor.EditFrame;
import jmri.jmrit.display.controlPanelEditor.EditPortalDirection;
import jmri.jmrit.display.controlPanelEditor.EditPortalFrame;
import jmri.jmrit.display.controlPanelEditor.EditSignalFrame;
import jmri.jmrit.display.controlPanelEditor.PortalIcon;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.PortalManager;
import jmri.jmrit.logix.WarrantTableAction;
import jmri.jmrit.picker.PickListModel;
import jmri.util.HelpUtil;
import jmri.util.JmriJFrame;
import jmri.util.PlaceWindow;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitBuilder {
    static int STRUT_SIZE = 10;
    private JMenu _circuitMenu;
    private JMenu _todoMenu;
    private final HashMap<OBlock, ArrayList<Positionable>> _circuitMap = new HashMap();
    private final ArrayList<IndicatorTrack> _darkTrack = new ArrayList();
    private final ArrayList<OBlock> _bareBlock = new ArrayList();
    private final ArrayList<OBlock> _zeroBlock = new ArrayList();
    private final ArrayList<Positionable> _unconvertedTrack = new ArrayList();
    private final ArrayList<OBlock> _convertBlock = new ArrayList();
    private final ArrayList<Portal> _noPortalIcon = new ArrayList();
    private final ArrayList<OBlock> _noPortals = new ArrayList();
    private final ArrayList<OBlock> _noPaths = new ArrayList();
    private final ArrayList<PortalIcon> _misplacedPortalIcon = new ArrayList();
    private final HashMap<Portal, ArrayList<PortalIcon>> _portalIconMap = new HashMap();
    private final HashMap<NamedBean, ArrayList<PositionableIcon>> _signalIconMap = new HashMap();
    private final ArrayList<PositionableIcon> _unattachedMastIcon = new ArrayList();
    private final ArrayList<NamedBean> _unprotectingMast = new ArrayList();
    private final HashMap<NamedBean, Portal> _signalMap = new HashMap();
    private boolean _hasIndicatorTrackIcons;
    private boolean _hasPortalIcons;
    private boolean _hasMastIcons;
    private PickListModel<OBlock> _oblockModel;
    private JTable _blockTable;
    JmriJFrame _cbFrame;
    private EditFrame _editFrame;
    private OBlock _currentBlock;
    private JDialog _dialog;
    protected ControlPanelEditor _editor;
    private Positionable _selection;
    public static final Color _editGroupColor = new Color(100, 200, 255);
    public static final Color _pathColor = Color.green;
    public static final Color _highlightColor = new Color(255, 150, 220);
    ArrayList<Positionable> _saveSelectionGroup;
    static int NONE = 0;
    static int OBLOCK = 1;
    static int PORTAL = 2;
    static int OPATH = 3;
    static int ARROW = 4;
    static int SIGNAL = 5;
    private static final Logger log = LoggerFactory.getLogger(CircuitBuilder.class);

    public CircuitBuilder() {
        log.error("CircuitBuilder ctor requires an Editor class");
    }

    public CircuitBuilder(ControlPanelEditor ed) {
        this._editor = ed;
        this._oblockModel = PickListModel.oBlockPickModelInstance();
        this._blockTable = this._oblockModel.makePickTable();
    }

    protected JMenu makeMenu() {
        this._circuitMenu = new JMenu(Bundle.getMessage("CircuitBuilder"));
        OBlockManager manager = InstanceManager.getDefault(OBlockManager.class);
        SortedSet oblocks = manager.getNamedBeanSet();
        for (OBlock block : oblocks) {
            this._circuitMap.put(block, new ArrayList());
        }
        this.checkCircuits();
        int num = Math.min(manager.getObjectCount(), 20) + 5;
        this._blockTable.setPreferredScrollableViewportSize(new Dimension(300, this._blockTable.getRowHeight() * num));
        return this._circuitMenu;
    }

    protected void openCBWindow() {
        if (this._cbFrame != null) {
            this._cbFrame.toFront();
        } else {
            this._cbFrame = new CBFrame(Bundle.getMessage("CircuitBuilder"));
        }
    }

    private void makeNoOBlockMenu() {
        JMenuItem circuitItem = new JMenuItem(Bundle.getMessage("newCircuitItem"));
        this._circuitMenu.add(circuitItem);
        circuitItem.addActionListener(event -> this.newCircuit());
        this._circuitMenu.add(new JMenuItem(Bundle.getMessage("noCircuitsItem")));
        JMenuItem helpItem = new JMenuItem(Bundle.getMessage("AboutCircuitBuilder"));
        HelpUtil.enableHelpOnButton(helpItem, "package.jmri.jmrit.display.CircuitBuilder");
        this._circuitMenu.add(helpItem);
    }

    private void makeCircuitMenu() {
        JMenuItem editItem = new JMenuItem(Bundle.getMessage("newCircuitItem"));
        this._circuitMenu.add(editItem);
        editItem.addActionListener(event -> {
            this.closeCBWindow();
            this.newCircuit();
        });
        editItem = new JMenuItem(Bundle.getMessage("editCircuitItem"));
        this._circuitMenu.add(editItem);
        editItem.addActionListener(event -> {
            this.closeCBWindow();
            this.editCircuit("editCircuitItem", true);
        });
        editItem = new JMenuItem(Bundle.getMessage("editPortalsItem"));
        this._circuitMenu.add(editItem);
        editItem.addActionListener(event -> {
            this.closeCBWindow();
            this.editPortals("editPortalsItem", true);
        });
        editItem = new JMenuItem(Bundle.getMessage("editCircuitPathsItem"));
        this._circuitMenu.add(editItem);
        editItem.addActionListener(event -> {
            this.closeCBWindow();
            this.editCircuitPaths("editCircuitPathsItem", true);
        });
        editItem = new JMenuItem(Bundle.getMessage("editDirectionItem"));
        this._circuitMenu.add(editItem);
        editItem.addActionListener(event -> {
            this.closeCBWindow();
            this.editPortalDirection("editDirectionItem", true);
        });
        editItem = new JMenuItem(Bundle.getMessage("editSignalItem"));
        this._circuitMenu.add(editItem);
        editItem.addActionListener(event -> {
            this.closeCBWindow();
            this.editSignalFrame("editSignalItem", true);
        });
        this._todoMenu = new JMenu(Bundle.getMessage("circuitErrorsItem"));
        this._circuitMenu.add(this._todoMenu);
        editItem = this.makePortalIconMenu();
        this._circuitMenu.add(editItem);
        JMenuItem helpItem = new JMenuItem(Bundle.getMessage("AboutCircuitBuilder"));
        HelpUtil.enableHelpOnButton(helpItem, "package.jmri.jmrit.display.CircuitBuilder");
        this._circuitMenu.add(helpItem);
        this.makeToDoMenu();
    }

    private void addIcon(OBlock block, Positionable pos) {
        ArrayList<Positionable> icons = this.getCircuitIcons(block);
        if (pos != null && !icons.contains(pos)) {
            icons.add(pos);
        }
        this._darkTrack.remove(pos);
    }

    private JMenu makePortalIconMenu() {
        JMenu familyMenu = new JMenu(Bundle.getMessage("portalIconSet"));
        ButtonGroup familyGroup = new ButtonGroup();
        ActionListener portalIconAction = event -> {
            String family = event.getActionCommand();
            if (!family.equals(this._editor.getPortalIconFamily())) {
                this.closeCBWindow();
                this._editor.setPortalIconFamily(family);
                for (Positionable pos : this._editor.getContents()) {
                    if (!(pos instanceof PortalIcon)) continue;
                    PortalIcon pIcon = (PortalIcon)pos;
                    pIcon.setMap(this._editor.getPortalIconMap());
                }
            }
        };
        HashMap<String, HashMap<String, NamedIcon>> familyMap = ItemPalette.getFamilyMaps("Portal");
        for (String family : familyMap.keySet()) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(family);
            familyGroup.add(mi);
            if (this._editor.getPortalIconFamily().equals(family)) {
                mi.setSelected(true);
            }
            mi.setActionCommand(family);
            mi.addActionListener(portalIconAction);
            familyMenu.add(mi);
        }
        return familyMenu;
    }

    private void makeToDoMenu() {
        JMenuItem mi;
        Iterator<PortalIcon> editPortalAction;
        if (this._todoMenu == null) {
            this._todoMenu = new JMenu(Bundle.getMessage("circuitErrorsItem"));
            this._circuitMenu.add(this._todoMenu);
        } else {
            this._todoMenu.removeAll();
        }
        JMenu blockNeeds = new JMenu(Bundle.getMessage("blockNeedsIconsItem"));
        ActionListener editCircuitAction = event -> {
            String sysName = event.getActionCommand();
            this.editCircuitError(sysName);
        };
        if (this._bareBlock.size() > 0) {
            for (OBlock block : this._bareBlock) {
                JMenuItem jMenuItem = new JMenuItem(MessageFormat.format(Bundle.getMessage("OpenCircuitItem"), block.getDisplayName()));
                jMenuItem.setActionCommand(block.getSystemName());
                jMenuItem.addActionListener(editCircuitAction);
                blockNeeds.add(jMenuItem);
            }
        } else {
            blockNeeds.add(new JMenuItem(Bundle.getMessage("circuitsHaveIcons")));
        }
        this._todoMenu.add(blockNeeds);
        blockNeeds = new JMenu(Bundle.getMessage("blocksNeedConversionItem"));
        if (this._convertBlock.size() > 0) {
            for (OBlock block : this._convertBlock) {
                JMenuItem jMenuItem = new JMenuItem(MessageFormat.format(Bundle.getMessage("OpenCircuitItem"), block.getDisplayName()));
                jMenuItem.setActionCommand(block.getSystemName());
                jMenuItem.addActionListener(editCircuitAction);
                blockNeeds.add(jMenuItem);
            }
        } else {
            blockNeeds.add(new JMenuItem(Bundle.getMessage("circuitIconsConverted")));
        }
        this._todoMenu.add(blockNeeds);
        JMenuItem iconNeeds = new JMenuItem(Bundle.getMessage("iconsNeedConversionItem"));
        if (this._unconvertedTrack.size() > 0) {
            iconNeeds.addActionListener(event -> {
                if (this.editingOK()) {
                    this.hidePortalIcons(true);
                    ArrayList<Positionable> group = new ArrayList<Positionable>();
                    for (Positionable positionable : this._unconvertedTrack) {
                        group.add(positionable);
                    }
                    this._editor.setSelectionGroup(group);
                }
            });
        } else {
            iconNeeds = new JMenuItem(Bundle.getMessage("noneNeedConversion"));
        }
        this._todoMenu.add(iconNeeds);
        if (this._darkTrack.size() > 0) {
            iconNeeds = new JMenuItem(Bundle.getMessage("iconsNeedsBlocksItem"));
            iconNeeds.addActionListener(event -> {
                if (this.editingOK()) {
                    this.hidePortalIcons(true);
                    ArrayList<Positionable> group = new ArrayList<Positionable>();
                    for (Positionable positionable : this._darkTrack) {
                        group.add(positionable);
                    }
                    this._editor.setSelectionGroup(group);
                }
            });
        } else {
            iconNeeds = this._hasIndicatorTrackIcons ? new JMenuItem(Bundle.getMessage("IconsHaveCircuits")) : new JMenuItem(Bundle.getMessage("noIndicatorTrackIcon"));
        }
        this._todoMenu.add(iconNeeds);
        if (!this._noPortals.isEmpty()) {
            blockNeeds = new JMenu(Bundle.getMessage("blockNeedsPortals"));
            editPortalAction = event -> {
                String sysName = event.getActionCommand();
                this._currentBlock = InstanceManager.getDefault(OBlockManager.class).getOBlock(sysName);
                this.editPortals(null, false);
            };
            for (OBlock oBlock : this._noPortals) {
                mi = new JMenuItem(MessageFormat.format(Bundle.getMessage("OpenPortalTitle"), oBlock.getDisplayName()));
                mi.setActionCommand(oBlock.getSystemName());
                mi.addActionListener((ActionListener)((Object)editPortalAction));
                blockNeeds.add(mi);
            }
        } else if (this._noPaths.size() > 0) {
            blockNeeds = new JMenu(Bundle.getMessage("blockNeedsPaths"));
            editPortalAction = event -> {
                String sysName = event.getActionCommand();
                this._currentBlock = InstanceManager.getDefault(OBlockManager.class).getOBlock(sysName);
                this.editCircuitPaths(null, false);
            };
            for (OBlock oBlock : this._noPaths) {
                mi = new JMenuItem(MessageFormat.format(Bundle.getMessage("OpenPathTitle"), oBlock.getDisplayName()));
                mi.setActionCommand(oBlock.getSystemName());
                mi.addActionListener((ActionListener)((Object)editPortalAction));
                blockNeeds.add(mi);
            }
        } else {
            blockNeeds = new JMenu(Bundle.getMessage("circuitsHavePortalsPaths"));
        }
        this._todoMenu.add(blockNeeds);
        if (this._zeroBlock.isEmpty()) {
            blockNeeds = new JMenu(Bundle.getMessage("blocksHaveLength"));
        } else {
            blockNeeds = new JMenu(Bundle.getMessage("blockNeedLength"));
            for (OBlock oBlock : this._zeroBlock) {
                JMenuItem jMenuItem = new JMenuItem(MessageFormat.format(Bundle.getMessage("OpenCircuitItem"), oBlock.getDisplayName()));
                jMenuItem.setActionCommand(oBlock.getSystemName());
                jMenuItem.addActionListener(editCircuitAction);
                blockNeeds.add(jMenuItem);
            }
        }
        this._todoMenu.add(blockNeeds);
        blockNeeds = new JMenu(Bundle.getMessage("portalsMisplaced"));
        if (this._misplacedPortalIcon.size() > 0) {
            for (PortalIcon portalIcon : this._misplacedPortalIcon) {
                Portal portal = portalIcon.getPortal();
                OBlock fromBlock = portal.getFromBlock();
                OBlock toBlock = portal.getToBlock();
                if (fromBlock != null) {
                    JMenuItem mi4 = new JMenuItem(Bundle.getMessage("OpenPortalTitle", fromBlock.getDisplayName()));
                    mi4.addActionListener(event -> this.editPortalError(fromBlock, portal, portalIcon));
                    blockNeeds.add(mi4);
                    continue;
                }
                if (toBlock == null) continue;
                JMenuItem mi2 = new JMenuItem(Bundle.getMessage("OpenPortalTitle", toBlock.getDisplayName()));
                mi2.addActionListener(event -> this.editPortalError(toBlock, portal, portalIcon));
                blockNeeds.add(mi2);
            }
        } else if (this._hasPortalIcons) {
            blockNeeds.add(new JMenuItem(Bundle.getMessage("portalsInPlace")));
        } else {
            blockNeeds.add(new JMenuItem(Bundle.getMessage("NoPortalIcons")));
        }
        this._todoMenu.add(blockNeeds);
        if (this._misplacedPortalIcon.size() > 0) {
            iconNeeds = new JMenuItem(Bundle.getMessage("iconsNeedPositioning"));
            iconNeeds.addActionListener(event -> {
                if (this.editingOK()) {
                    ArrayList<Positionable> group = new ArrayList<Positionable>();
                    for (PortalIcon pi : this._misplacedPortalIcon) {
                        group.add(pi);
                        pi.setStatus("block");
                    }
                    this._editor.setSelectionGroup(group);
                }
            });
        } else {
            iconNeeds = this._hasPortalIcons ? new JMenuItem(Bundle.getMessage("portalsInPlace")) : new JMenuItem(Bundle.getMessage("NoPortalIcons"));
        }
        this._todoMenu.add(iconNeeds);
        JMenu mastNeeds = new JMenu(Bundle.getMessage("UnprotectingMasts"));
        if (!this._unprotectingMast.isEmpty()) {
            for (NamedBean namedBean : this._unprotectingMast) {
                mi = new JMenuItem(namedBean.getDisplayName());
                mastNeeds.add(mi);
            }
        } else {
            mastNeeds.add(new JMenuItem(Bundle.getMessage("mastsInPlace")));
        }
        this._todoMenu.add(mastNeeds);
        if (this._unattachedMastIcon.size() > 0) {
            iconNeeds = new JMenuItem(Bundle.getMessage("UnattachedMasts"));
            iconNeeds.addActionListener(event -> {
                ArrayList<Positionable> group = new ArrayList<Positionable>();
                for (PositionableIcon pi : this._unattachedMastIcon) {
                    group.add(pi);
                }
                this._editor.setSelectionGroup(group);
            });
        } else {
            iconNeeds = this._hasMastIcons ? new JMenuItem(Bundle.getMessage("mastsInPlace")) : new JMenuItem(Bundle.getMessage("NoMastIcons"));
        }
        this._todoMenu.add(iconNeeds);
        blockNeeds = new JMenu(Bundle.getMessage("portalNeedsIcon"));
        ActionListener actionListener = event -> {
            String portalName = event.getActionCommand();
            this.editPortalError(portalName);
        };
        if (this._noPortalIcon.size() > 0) {
            for (Portal portal : this._noPortalIcon) {
                JMenuItem mi5 = new JMenuItem(portal.toString());
                mi5.setActionCommand(portal.getName());
                mi5.addActionListener(actionListener);
                blockNeeds.add(mi5);
            }
        } else {
            blockNeeds.add(new JMenuItem(Bundle.getMessage("portalsHaveIcons")));
        }
        this._todoMenu.add(blockNeeds);
        JMenuItem jMenuItem = new JMenuItem(Bundle.getMessage("CheckPortalPaths"));
        jMenuItem.addActionListener(event -> {
            if (!WarrantTableAction.getDefault().errorCheck()) {
                JmriJFrame frame = this._editFrame != null ? this._editFrame : (this._cbFrame != null ? this._cbFrame : this._editor);
                JmriJOptionPane.showMessageDialog(frame, Bundle.getMessage("blocksEtcOK"), Bundle.getMessage("ButtonOK"), 1);
            }
        });
        this._todoMenu.add(jMenuItem);
    }

    protected EditFrame getEditFrame() {
        return this._editFrame;
    }

    protected void newCircuit() {
        if (this.editingOK()) {
            this._blockTable.clearSelection();
            this.setUpEditCircuit();
            this._editFrame = new EditCircuitFrame(Bundle.getMessage("newCircuitItem"), this, null);
        }
    }

    protected void editCircuit(String title, boolean fromMenu) {
        if (this.editingOK()) {
            if (fromMenu) {
                this.editCircuitDialog(title);
            }
            if (this._currentBlock != null) {
                this.setUpEditCircuit();
                this._editFrame = new EditCircuitFrame(Bundle.getMessage("OpenCircuitItem"), this, this._currentBlock);
            } else if (!fromMenu) {
                this.selectPrompt();
            }
        }
    }

    private void setUpEditCircuit() {
        this._editor.setSelectionGroup(this.makeSelectionGroup(this._currentBlock, false));
        this._editor.disableMenus();
        Editor.TargetPane targetPane = (Editor.TargetPane)this._editor.getTargetPanel();
        targetPane.setSelectGroupColor(_editGroupColor);
        targetPane.setHighlightColor(_highlightColor);
    }

    protected void editCircuitError(String sysName) {
        this.hidePortalIcons(true);
        if (this.editingOK()) {
            this._currentBlock = (OBlock)InstanceManager.getDefault(OBlockManager.class).getBySystemName(sysName);
            if (this._currentBlock != null) {
                this._editor.setSelectionGroup(this.makeSelectionGroup(this._currentBlock, false));
                this._editor.disableMenus();
                this._editFrame = new EditCircuitFrame(Bundle.getMessage("OpenCircuitItem"), this, this._currentBlock);
            }
        }
    }

    protected void editPortals(String title, boolean fromMenu) {
        if (this.editingOK()) {
            if (fromMenu) {
                this.editCircuitDialog(title);
            }
            if (this._currentBlock != null) {
                this._editor.setSelectionGroup(this.makeSelectionGroup(this._currentBlock, true));
                this._editor.disableMenus();
                Editor.TargetPane targetPane = (Editor.TargetPane)this._editor.getTargetPanel();
                targetPane.setSelectGroupColor(_editGroupColor);
                targetPane.setHighlightColor(_highlightColor);
                this.setPortalsPositionable(this._currentBlock, true);
                this._editFrame = new EditPortalFrame(Bundle.getMessage("OpenPortalTitle"), this, this._currentBlock);
                this._editFrame.canEdit();
            } else if (!fromMenu) {
                this.selectPrompt();
            }
        }
    }

    protected void editPortalError(String name) {
        if (this.editingOK()) {
            Portal portal = InstanceManager.getDefault(PortalManager.class).getPortal(name);
            this._currentBlock = portal.getFromBlock();
            if (this._currentBlock == null) {
                this._currentBlock = portal.getToBlock();
            }
            this.editPortals(null, false);
        }
    }

    protected void editPortalError(OBlock block, Portal portal, PortalIcon icon) {
        if (this.editingOK()) {
            this._currentBlock = block;
            if (this._currentBlock != null) {
                this._editor.setSelectionGroup(this.makeSelectionGroup(this._currentBlock, true));
                this._editor.disableMenus();
                Editor.TargetPane targetPane = (Editor.TargetPane)this._editor.getTargetPanel();
                targetPane.setSelectGroupColor(_editGroupColor);
                targetPane.setHighlightColor(_highlightColor);
                this.setPortalsPositionable(this._currentBlock, true);
                this._editFrame = new EditPortalFrame(Bundle.getMessage("OpenPortalTitle"), this, this._currentBlock, portal, icon);
            }
        }
    }

    protected void editPortalDirection(String title, boolean fromMenu) {
        if (this.editingOK()) {
            if (fromMenu) {
                this.editCircuitDialog(title);
            }
            if (this._currentBlock != null) {
                this._editor.setSelectionGroup(this.makeSelectionGroup(this._currentBlock, true));
                this._editor.disableMenus();
                Editor.TargetPane targetPane = (Editor.TargetPane)this._editor.getTargetPanel();
                targetPane.setSelectGroupColor(_editGroupColor);
                targetPane.setHighlightColor(_highlightColor);
                this.setPortalsPositionable(this._currentBlock, true);
                this._editFrame = new EditPortalDirection(Bundle.getMessage("OpenDirectionTitle"), this, this._currentBlock);
                this._editFrame.canEdit();
            } else if (!fromMenu) {
                this.selectPrompt();
            }
        }
    }

    protected void editSignalFrame(String title, boolean fromMenu) {
        if (this.editingOK()) {
            if (fromMenu) {
                this.editCircuitDialog(title);
            }
            if (this._currentBlock != null) {
                this._editor.setSelectionGroup(this.makeSelectionGroup(this._currentBlock, true));
                this._editor.disableMenus();
                Editor.TargetPane targetPane = (Editor.TargetPane)this._editor.getTargetPanel();
                targetPane.setSelectGroupColor(_editGroupColor);
                targetPane.setHighlightColor(_highlightColor);
                this._editFrame = new EditSignalFrame(Bundle.getMessage("OpenSignalsTitle"), this, this._currentBlock);
                this._editFrame.canEdit();
            } else if (!fromMenu) {
                this.selectPrompt();
            }
        }
    }

    protected void editCircuitPaths(String title, boolean fromMenu) {
        if (this.editingOK()) {
            if (fromMenu) {
                this.editCircuitDialog(title);
            }
            if (this._currentBlock != null) {
                this._editor.setSelectionGroup(this.makeSelectionGroup(this._currentBlock, true));
                this._currentBlock.allocatePath("TEST_PATH");
                this._editor.disableMenus();
                Editor.TargetPane targetPane = (Editor.TargetPane)this._editor.getTargetPanel();
                targetPane.setSelectGroupColor(_editGroupColor);
                targetPane.setHighlightColor(_editGroupColor);
                this._currentBlock.setState(4);
                this._editFrame = new EditCircuitPaths(Bundle.getMessage("OpenPathTitle"), this, this._currentBlock);
                this._editFrame.canEdit();
            } else if (!fromMenu) {
                this.selectPrompt();
            }
        }
    }

    protected void setCurrentBlock(OBlock b) {
        this._currentBlock = b;
    }

    protected void hidePortalIcons(boolean hideAll) {
        if (this._editFrame != null) {
            this._editFrame.clearListSelection();
        } else {
            for (ArrayList<PortalIcon> array : this._portalIconMap.values()) {
                for (PortalIcon pi : array) {
                    if (!hideAll && !pi.getStatus().equals("block")) continue;
                    pi.setStatus("hidden");
                }
            }
        }
    }

    private boolean editingOK() {
        if (this._editFrame != null) {
            JmriJOptionPane.showMessageDialog(this._editFrame, Bundle.getMessage("AlreadyEditing"), Bundle.getMessage("ErrorTitle"), 0);
            this._editFrame.toFront();
            this._editFrame.setVisible(true);
            return false;
        }
        OBlockManager manager = InstanceManager.getDefault(OBlockManager.class);
        if (manager.getObjectCount() == 0) {
            return true;
        }
        for (OBlock block : manager.getNamedBeanSet()) {
            if ((block.getState() & 0x10) == 0) continue;
            JmriJOptionPane.showMessageDialog(this._editor, Bundle.getMessage("cannotEditCB", block.getWarrant().getDisplayName()), Bundle.getMessage("editCiruit"), 1);
            return false;
        }
        this.checkCircuits();
        return true;
    }

    private void editCircuitDialog(String title) {
        this._dialog = new JDialog(this._editor, Bundle.getMessage(title), true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(10, 10));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        JPanel p = new JPanel();
        p.add(new JLabel(Bundle.getMessage("selectOBlock")));
        p.setMaximumSize(new Dimension(300, p.getPreferredSize().height));
        mainPanel.add(p);
        mainPanel.add(new JScrollPane(this._blockTable));
        mainPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        mainPanel.add(this.makeDoneButtonPanel());
        panel.add(mainPanel);
        this._dialog.getContentPane().add(panel);
        this._dialog.setLocation(this._editor.getLocation().x + 100, this._editor.getLocation().y + 100);
        this._dialog.pack();
        this._dialog.setVisible(true);
    }

    private JPanel makeDoneButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JPanel panel0 = new JPanel();
        panel0.setLayout(new FlowLayout());
        JButton doneButton = new JButton(Bundle.getMessage("ButtonOpenCircuit"));
        doneButton.addActionListener(a -> {
            if (this.doOpenAction()) {
                this._dialog.dispose();
            }
        });
        panel0.add(doneButton);
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(a -> this._dialog.dispose());
        panel0.add(cancelButton);
        buttonPanel.add(panel0);
        buttonPanel.setMaximumSize(new Dimension(300, buttonPanel.getPreferredSize().height));
        return buttonPanel;
    }

    private boolean doOpenAction() {
        int row = this._blockTable.getSelectedRow();
        if (row >= 0) {
            row = this._blockTable.convertRowIndexToModel(row);
            this._currentBlock = this._oblockModel.getBeanAt(row);
            return true;
        }
        this._currentBlock = null;
        this.selectPrompt();
        return false;
    }

    private void selectPrompt() {
        JmriJOptionPane.showMessageDialog(this._editor, Bundle.getMessage("selectOBlock"), Bundle.getMessage("NeedDataTitle"), 1);
    }

    private void setPortalsPositionable(OBlock block, boolean set) {
        for (Positionable p : this.getCircuitIcons(block)) {
            if (!(p instanceof PortalIcon)) continue;
            p.setPositionable(set);
        }
    }

    protected void setIconGroup(OBlock block) {
        for (Positionable pos : this.getCircuitIcons(block)) {
            if (!(pos instanceof IndicatorTrack)) continue;
            ((IndicatorTrack)pos).setOccBlockHandle(null);
        }
        ArrayList<Positionable> selections = this._editor.getSelectionGroup();
        ArrayList<Positionable> icons = this.getCircuitIcons(block);
        icons.clear();
        if (selections != null && !selections.isEmpty()) {
            NamedBeanHandle<OBlock> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(block.getSystemName(), block);
            for (Positionable pos : selections) {
                if (pos instanceof IndicatorTrack) {
                    ((IndicatorTrack)pos).setOccBlockHandle(handle);
                }
                icons.add(pos);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("setIconGroup: block \"{}\" has {} icons.", (Object)block.getDisplayName(), (Object)icons.size());
        }
    }

    protected void closeCircuitBuilder(OBlock block) {
        this._currentBlock = null;
        this._editFrame = null;
        this.checkCircuits();
        this.setPortalsPositionable(block, false);
        this.hidePortalIcons(true);
        this._editor.resetEditor();
    }

    private void checkCircuits() {
        this._portalIconMap.clear();
        this._signalIconMap.clear();
        this._signalMap.clear();
        this._unattachedMastIcon.clear();
        this._darkTrack.clear();
        this._unconvertedTrack.clear();
        this._hasIndicatorTrackIcons = false;
        this._hasPortalIcons = false;
        this._hasMastIcons = false;
        ArrayList<PositionableIcon> removeList = new ArrayList<PositionableIcon>();
        PortalManager portalMgr = InstanceManager.getDefault(PortalManager.class);
        for (Positionable positionable : this._editor.getContents()) {
            List<PositionableIcon> siArray;
            Signal mast;
            PositionableIcon sIcon;
            if (positionable instanceof IndicatorTrack) {
                IndicatorTrack iPos = (IndicatorTrack)positionable;
                this._hasIndicatorTrackIcons = true;
                OBlock block = iPos.getOccBlock();
                iPos.removePath("TEST_PATH");
                if (block != null) {
                    this.addIcon(block, iPos);
                    continue;
                }
                this._darkTrack.add(iPos);
                continue;
            }
            if (positionable instanceof PortalIcon) {
                this._hasPortalIcons = true;
                PortalIcon pIcon = (PortalIcon)positionable;
                Portal portal = pIcon.getPortal();
                if (portal == null) {
                    log.error("No Portal for PortalIcon called \"{}\". Discarding icon.", (Object)pIcon.getName());
                    removeList.add(pIcon);
                    continue;
                }
                List<PortalIcon> piArray = this.getPortalIcons(portal);
                piArray.add(pIcon);
                continue;
            }
            if (positionable instanceof SignalMastIcon) {
                this._hasMastIcons = true;
                sIcon = (SignalMastIcon)positionable;
                mast = ((SignalMastIcon)sIcon).getSignalMast();
                if (mast == null) {
                    log.error("No SignalMast for SignalMastIcon called \"{}\".", (Object)((SignalMastIcon)sIcon).getNameString());
                    removeList.add(sIcon);
                    continue;
                }
                siArray = this.getSignalIconMap(mast);
                siArray.add(sIcon);
                this._unattachedMastIcon.add(sIcon);
                continue;
            }
            if (positionable instanceof SignalHeadIcon) {
                this._hasMastIcons = true;
                sIcon = (SignalHeadIcon)positionable;
                mast = ((SignalHeadIcon)sIcon).getSignalHead();
                if (mast == null) {
                    log.error("No SignalHead for SignalHeadIcon called \"{}\".", (Object)((SignalHeadIcon)sIcon).getNameString());
                    removeList.add(sIcon);
                    continue;
                }
                siArray = this.getSignalIconMap(mast);
                siArray.add(sIcon);
                this._unattachedMastIcon.add(sIcon);
                continue;
            }
            if (!CircuitBuilder.isUnconvertedTrack(positionable) || this._unconvertedTrack.contains(positionable)) continue;
            this._unconvertedTrack.add(positionable);
        }
        for (Positionable positionable : removeList) {
            positionable.remove();
        }
        this._bareBlock.clear();
        this._zeroBlock.clear();
        this._convertBlock.clear();
        this._misplacedPortalIcon.clear();
        this._noPortalIcon.clear();
        this._noPortals.clear();
        this._noPaths.clear();
        this._unprotectingMast.clear();
        Iterator iter1 = InstanceManager.getDefault(SignalMastManager.class).getNamedBeanSet().iterator();
        while (iter1.hasNext()) {
            this._signalMap.put((NamedBean)iter1.next(), null);
        }
        Iterator iterator = InstanceManager.getDefault(SignalHeadManager.class).getNamedBeanSet().iterator();
        while (iterator.hasNext()) {
            this._signalMap.put((NamedBean)iterator.next(), null);
        }
        OBlockManager manager = InstanceManager.getDefault(OBlockManager.class);
        SortedSet oblocks = manager.getNamedBeanSet();
        for (OBlock oBlock : oblocks) {
            block39: {
                float blkLen;
                List<Path> paths;
                block38: {
                    List<Portal> portals = oBlock.getPortals();
                    if (portals.isEmpty()) {
                        this._noPortals.add(oBlock);
                    } else {
                        for (Portal portal : portals) {
                            List<PortalIcon> piArray = this.getPortalIcons(portal);
                            Iterator<PortalIcon> iterator2 = piArray.iterator();
                            while (iterator2.hasNext()) {
                                PortalIcon pi = iterator2.next();
                                this.addIcon(oBlock, pi);
                            }
                            NamedBean mast = portal.getSignalProtectingBlock(oBlock);
                            if (mast != null) {
                                List<PositionableIcon> siArray = this.getSignalIconMap(mast);
                                for (PositionableIcon si : siArray) {
                                    this.addIcon(oBlock, si);
                                    this._unattachedMastIcon.remove(si);
                                }
                                this._signalMap.put(mast, portal);
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Portal {} in block {} has {} icons", new Object[]{portal.getName(), oBlock.getDisplayName(), piArray.size()});
                        }
                    }
                    paths = oBlock.getPaths();
                    blkLen = oBlock.getLengthMm();
                    if (!paths.isEmpty()) break block38;
                    this._noPaths.add(oBlock);
                    if (!(blkLen < 0.001f)) break block39;
                    this._zeroBlock.add(oBlock);
                    break block39;
                }
                if (blkLen < 0.001f) {
                    for (Path path : paths) {
                        if (!(path.getLengthMm() < 0.001f)) continue;
                        this._zeroBlock.add(oBlock);
                        break;
                    }
                }
            }
            ArrayList<Positionable> icons = this.getCircuitIcons(oBlock);
            if (log.isDebugEnabled()) {
                log.debug("checkCircuits: block {} has {} icons.", (Object)oBlock.getDisplayName(), (Object)icons.size());
            }
            if (icons.isEmpty()) {
                this._bareBlock.add(oBlock);
                continue;
            }
            boolean hasTrackIcon = false;
            boolean iconNeedsConversion = false;
            for (Positionable pos : icons) {
                if (pos instanceof PortalIcon || pos instanceof SignalMastIcon || pos instanceof SignalHeadIcon) continue;
                hasTrackIcon = true;
                if (pos instanceof IndicatorTrack) continue;
                iconNeedsConversion = true;
            }
            if (hasTrackIcon) {
                this._bareBlock.remove(oBlock);
            } else if (!this._bareBlock.contains(oBlock)) {
                this._bareBlock.add(oBlock);
            }
            if (!iconNeedsConversion || this._convertBlock.contains(oBlock)) continue;
            this._convertBlock.add(oBlock);
        }
        for (Portal portal : portalMgr.getPortalSet()) {
            List<PortalIcon> piArray = this.getPortalIcons(portal);
            if (piArray.isEmpty()) {
                this._noPortalIcon.add(portal);
                continue;
            }
            PortalIcon icon1 = piArray.get(0);
            if (piArray.size() == 1) {
                if (this.iconIntersectsBlock(icon1, portal.getToBlock()) && this.iconIntersectsBlock(icon1, portal.getFromBlock())) continue;
                this._misplacedPortalIcon.add(icon1);
                continue;
            }
            boolean fromOK = false;
            boolean toOK = false;
            PortalIcon icon = null;
            for (PortalIcon ic : piArray) {
                if (!toOK && this.iconIntersectsBlock(ic, portal.getToBlock()) && !this.iconIntersectsBlock(ic, portal.getFromBlock())) {
                    toOK = true;
                    continue;
                }
                if (!fromOK && !this.iconIntersectsBlock(ic, portal.getToBlock()) && this.iconIntersectsBlock(ic, portal.getFromBlock())) {
                    fromOK = true;
                    continue;
                }
                icon = ic;
            }
            if (toOK && fromOK) continue;
            this._misplacedPortalIcon.add(icon);
        }
        for (Map.Entry entry : this._signalMap.entrySet()) {
            if (entry.getValue() != null) continue;
            this._unprotectingMast.add((NamedBean)entry.getKey());
        }
        if (oblocks.size() > 1) {
            if (this._circuitMenu.getItemCount() <= 3) {
                this._circuitMenu.removeAll();
                this.makeCircuitMenu();
            } else {
                this.makeToDoMenu();
            }
        } else {
            this._circuitMenu.removeAll();
            this.makeNoOBlockMenu();
        }
    }

    protected boolean iconIntersectsBlock(Positionable icon, OBlock block) {
        Rectangle iconRect = icon.getBounds(new Rectangle());
        return this.rectIntersectsBlock(iconRect, block);
    }

    protected boolean rectIntersectsBlock(Rectangle iconRect, OBlock block) {
        ArrayList<Positionable> list = this.getCircuitIcons(block);
        if (list.isEmpty()) {
            return false;
        }
        Rectangle rect = new Rectangle();
        for (Positionable comp : list) {
            if (!CircuitBuilder.isTrack(comp) || !iconRect.intersects(rect = comp.getBounds(rect))) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    protected ArrayList<Positionable> getCircuitIcons(OBlock block) {
        return this._circuitMap.computeIfAbsent(block, k -> new ArrayList());
    }

    @Nonnull
    protected List<PortalIcon> getPortalIcons(@Nonnull Portal portal) {
        return this._portalIconMap.computeIfAbsent(portal, k -> new ArrayList());
    }

    @Nonnull
    protected List<PositionableIcon> getSignalIconMap(@Nonnull NamedBean mast) {
        return this._signalIconMap.computeIfAbsent(mast, k -> new ArrayList());
    }

    protected HashMap<NamedBean, ArrayList<PositionableIcon>> getSignalIconMap() {
        return this._signalIconMap;
    }

    protected Portal getSignalPortal(@Nonnull NamedBean mast) {
        return this._signalMap.get(mast);
    }

    protected void putSignalPortal(@Nonnull NamedBean mast, Portal portal) {
        if (portal == null) {
            this._signalMap.remove(mast);
        }
        this._signalMap.put(mast, portal);
    }

    protected void removeBlock(OBlock block) {
        ArrayList<Positionable> list = this.getCircuitIcons(block);
        for (Positionable pos : list) {
            if (!(pos instanceof IndicatorTrack)) continue;
            ((IndicatorTrack)pos).setOccBlockHandle(null);
            this._darkTrack.add((IndicatorTrack)pos);
        }
        block.dispose();
        if (InstanceManager.getDefault(OBlockManager.class).getNamedBeanSet().size() < 2) {
            this._editor.makeWarrantMenu(true, false);
        }
    }

    protected String checkForPortals(@Nonnull OBlock block, String key) {
        StringBuffer sb = new StringBuffer();
        List<Portal> portals = block.getPortals();
        if (portals.isEmpty()) {
            sb.append(Bundle.getMessage("needPortal", block.getDisplayName(), Bundle.getMessage(key)));
        } else {
            for (Portal portal : portals) {
                if (portal.getToBlock() != null && portal.getFromBlock() != null) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(Bundle.getMessage("portalNeedsBlock", portal.getName()));
            }
            for (Portal portal : portals) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                if (block.equals(portal.getToBlock()) || block.equals(portal.getFromBlock())) continue;
                sb.append(Bundle.getMessage("portalNotInCircuit", portal.getName(), block.getDisplayName()));
            }
        }
        return sb.toString();
    }

    protected String checkForPortalIcons(@Nonnull OBlock block, String key) {
        StringBuffer sb = new StringBuffer();
        List<Portal> portals = block.getPortals();
        if (portals.isEmpty()) {
            sb.append(Bundle.getMessage("needPortal", block.getDisplayName(), Bundle.getMessage(key)));
        } else if (this._editFrame instanceof EditPortalFrame) {
            for (Portal portal : portals) {
                String msg = ((EditPortalFrame)this._editFrame).checkPortalIcons(portal, false, key);
                if (msg == null) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(msg);
            }
        }
        boolean ok = false;
        ArrayList<Positionable> list = this.getCircuitIcons(block);
        if (!list.isEmpty()) {
            for (Positionable pos : list) {
                if (!(pos instanceof PortalIcon)) continue;
                ok = true;
            }
        }
        if (!ok) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(Bundle.getMessage("needPortalIcons", block.getDisplayName(), Bundle.getMessage(key)));
        }
        return sb.toString();
    }

    protected String checkForTrackIcons(@Nonnull OBlock block, String key) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Positionable> list = this.getCircuitIcons(block);
        if (list.isEmpty()) {
            sb.append(Bundle.getMessage("needIcons", block.getDisplayName(), Bundle.getMessage(key)));
        } else {
            boolean ok = true;
            for (Positionable p : list) {
                PositionableLabel pos = (PositionableLabel)p;
                if (!CircuitBuilder.isUnconvertedTrack(pos)) continue;
                ok = false;
                break;
            }
            if (!ok) {
                sb.append(Bundle.getMessage("cantSaveIcon", block.getDisplayName()));
                sb.append("\n");
                sb.append(Bundle.getMessage("needIcons", block.getDisplayName(), Bundle.getMessage(key)));
            }
        }
        return sb.toString();
    }

    protected void deletePortalIcon(PortalIcon icon) {
        ArrayList<Positionable> selections;
        Portal portal;
        if (log.isDebugEnabled()) {
            log.debug("deletePortalIcon: {}", (Object)icon.getName());
        }
        if ((portal = icon.getPortal()) != null) {
            this.getCircuitIcons(portal.getToBlock()).remove(icon);
            this.getCircuitIcons(portal.getFromBlock()).remove(icon);
            this.getPortalIcons(portal).remove(icon);
        }
        if ((selections = this._editor.getSelectionGroup()) != null) {
            this._editor.getSelectionGroup().remove(icon);
        }
        this._editor.repaint();
    }

    protected boolean queryConvertTrackIcons(@Nonnull OBlock block, String key) {
        ArrayList<Positionable> list = new ArrayList<Positionable>(this.getCircuitIcons(block));
        String msg = null;
        if (list.isEmpty()) {
            msg = Bundle.getMessage("needIcons", block.getDisplayName(), Bundle.getMessage(key));
        } else {
            boolean needConversion = false;
            for (Positionable p : list) {
                PositionableLabel pos = (PositionableLabel)p;
                if (!CircuitBuilder.isUnconvertedTrack(pos)) continue;
                this._editor.highlight(pos);
                needConversion = true;
                new ConvertDialog(this, pos, block);
                this._editor.highlight(null);
            }
            if (!needConversion) {
                msg = Bundle.getMessage("noneNeedConversion");
            }
        }
        if (msg != null) {
            JmriJOptionPane.showMessageDialog(this._editFrame, msg, Bundle.getMessage("noIcons"), 1);
            return false;
        }
        return true;
    }

    private ArrayList<Positionable> makeSelectionGroup(OBlock block, boolean showPortal) {
        ArrayList<Positionable> group = new ArrayList<Positionable>();
        for (Positionable p : this.getCircuitIcons(block)) {
            if (p instanceof PortalIcon) {
                if (!showPortal) continue;
                ((PortalIcon)p).setStatus("block");
                group.add(p);
                continue;
            }
            if (p instanceof SignalMastIcon || p instanceof SignalHeadIcon) continue;
            group.add(p);
        }
        return group;
    }

    protected static boolean isTrack(Positionable pos) {
        String fileName;
        NamedIcon icon;
        PositionableLabel pl;
        if (pos instanceof IndicatorTrack) {
            return true;
        }
        if (pos instanceof TurnoutIcon) {
            return true;
        }
        if (pos instanceof PortalIcon || pos instanceof SignalMastIcon || pos instanceof SignalHeadIcon) {
            return false;
        }
        return pos instanceof PositionableLabel && (pl = (PositionableLabel)pos).isIcon() && (icon = (NamedIcon)pl.getIcon()) != null && (fileName = icon.getURL()) != null && (fileName.contains("/track/") || fileName.contains("/tracksegments/") && !fileName.contains("circuit"));
    }

    private static boolean isUnconvertedTrack(Positionable pos) {
        NamedIcon icon;
        PositionableLabel pl;
        if (pos instanceof IndicatorTrack || pos instanceof PortalIcon || pos instanceof SignalMastIcon || pos instanceof SignalHeadIcon) {
            return false;
        }
        if (pos instanceof TurnoutIcon) {
            return true;
        }
        if (pos instanceof PositionableLabel && (pl = (PositionableLabel)pos).isIcon() && (icon = (NamedIcon)pl.getIcon()) != null) {
            String fileName = icon.getURL();
            if (log.isDebugEnabled()) {
                log.debug("isUnconvertedTrack Test: url= {}", (Object)fileName);
            }
            if (fileName != null && (fileName.contains("/track/") || fileName.contains("/tracksegments/")) && !fileName.contains("circuit")) {
                return true;
            }
        }
        return false;
    }

    private boolean okToAdd(Positionable pos, OBlock editBlock) {
        OBlock block;
        if (pos instanceof IndicatorTrack && (block = ((IndicatorTrack)pos).getOccBlock()) != null && !block.equals(editBlock)) {
            int result = JmriJOptionPane.showConfirmDialog(this._editor, MessageFormat.format(Bundle.getMessage("iconBlockConflict"), block.getDisplayName(), editBlock.getDisplayName()), Bundle.getMessage("whichCircuit"), 0, 3);
            if (result == 0) {
                this.getCircuitIcons(block).remove(pos);
                ((IndicatorTrack)pos).setOccBlockHandle(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(editBlock.getSystemName(), editBlock));
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean portalIconMove(PortalIcon pos, int x, int y) {
        Portal port;
        if (this._editFrame == null || this._editFrame instanceof EditPortalFrame) {
            return true;
        }
        Rectangle iconRect = pos.getBounds(new Rectangle());
        iconRect.x = x;
        iconRect.y = y;
        OBlock block = this._editFrame._homeBlock;
        if (this.rectIntersectsBlock(iconRect, block) && ((block = block.equals((port = pos.getPortal()).getToBlock()) ? port.getFromBlock() : port.getToBlock()) == null || this.rectIntersectsBlock(iconRect, block))) {
            return true;
        }
        JmriJOptionPane.showMessageDialog(this._editFrame, Bundle.getMessage("moveOffBlock", block.getDisplayName(), pos.getNameString()), Bundle.getMessage("editCiruit"), 1);
        return false;
    }

    protected boolean saveSelectionGroup(ArrayList<Positionable> selectionGroup) {
        this._saveSelectionGroup = selectionGroup;
        return this._editFrame != null;
    }

    protected boolean doMousePressed(JmriMouseEvent event, Positionable selection) {
        this._selection = selection;
        return true;
    }

    protected boolean doMousePressed(JmriMouseEvent event) {
        if (this._editFrame == null) {
            return false;
        }
        this._editFrame.toFront();
        this._editor.setSelectionGroup(this._saveSelectionGroup);
        return true;
    }

    public boolean doMouseReleased(Positionable selection, boolean dragging) {
        PortalIcon pos;
        Portal portal;
        if (this._editFrame != null) {
            if (this._editFrame instanceof EditPortalFrame && selection instanceof PortalIcon && this.getCircuitIcons(this._editFrame._homeBlock).contains(selection)) {
                PortalIcon icon = (PortalIcon)selection;
                if (dragging) {
                    Portal portal2 = icon.getPortal();
                    ((EditPortalFrame)this._editFrame).checkPortalIcons(portal2, true, null);
                } else {
                    ((EditPortalFrame)this._editFrame).setSelected(icon);
                }
            }
            return true;
        }
        if (this._selection != null && this._selection instanceof PortalIcon && (portal = (pos = (PortalIcon)this._selection).getPortal()) != null) {
            OBlock block = portal.getToBlock();
            if (block == null) {
                block = portal.getFromBlock();
            }
            this.editPortalError(block, portal, pos);
        }
        return false;
    }

    protected boolean doMouseClicked(List<Positionable> selections, JmriMouseEvent event) {
        if (this._editFrame != null) {
            if (selections != null && selections.size() > 0) {
                Positionable pos;
                ArrayList<Positionable> tracks = new ArrayList<Positionable>();
                Iterator<Positionable> iter = selections.iterator();
                if (this._editFrame instanceof EditCircuitFrame) {
                    while (iter.hasNext()) {
                        pos = iter.next();
                        if (!CircuitBuilder.isTrack(pos)) continue;
                        tracks.add(pos);
                    }
                } else if (this._editFrame instanceof EditCircuitPaths) {
                    while (iter.hasNext()) {
                        pos = iter.next();
                        if (!CircuitBuilder.isTrack(pos) && !(pos instanceof PortalIcon)) continue;
                        tracks.add(pos);
                    }
                } else if (this._editFrame instanceof EditSignalFrame) {
                    while (iter.hasNext()) {
                        pos = iter.next();
                        if (!(pos instanceof PortalIcon) && !(pos instanceof SignalMastIcon) && !(pos instanceof SignalHeadIcon)) continue;
                        tracks.add(pos);
                    }
                } else {
                    while (iter.hasNext()) {
                        pos = iter.next();
                        if (!(pos instanceof PortalIcon)) continue;
                        tracks.add(pos);
                    }
                }
                if (tracks.size() > 0) {
                    Positionable selection = tracks.size() == 1 ? (Positionable)tracks.get(0) : this.getSelection(tracks);
                    if (this._editFrame instanceof EditCircuitPaths && event.isShiftDown() && !event.isControlDown()) {
                        selection.doMouseClicked(event);
                    }
                    this.handleSelection(selection, event);
                }
                this._editFrame.toFront();
            }
            return true;
        }
        return false;
    }

    private Positionable getSelection(List<Positionable> tracks) {
        if (tracks.size() > 0) {
            if (tracks.size() == 1) {
                return tracks.get(0);
            }
            if (tracks.size() > 1) {
                Object[] selects = new String[tracks.size()];
                Iterator<Positionable> iter = tracks.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    selects[i++] = iter.next().getNameString();
                }
                Object select = JmriJOptionPane.showInputDialog(this._editor, Bundle.getMessage("multipleSelections"), Bundle.getMessage("QuestionTitle"), 3, null, selects, null);
                if (select != null) {
                    for (Positionable pos : tracks) {
                        if (!((String)select).equals(pos.getNameString())) continue;
                        return pos;
                    }
                }
            }
        }
        return null;
    }

    public boolean doMouseDragged(Positionable selection, JmriMouseEvent event) {
        if (this._editFrame != null) {
            if (selection instanceof PortalIcon) {
                if (this._editFrame instanceof EditPortalFrame) {
                    ((EditPortalFrame)this._editFrame).setSelected((PortalIcon)selection);
                    return false;
                }
                if (this._editFrame instanceof EditPortalDirection) {
                    return false;
                }
            }
            return !(selection instanceof SignalMastIcon) && !(selection instanceof SignalHeadIcon) || !(this._editFrame instanceof EditSignalFrame);
        }
        return false;
    }

    public boolean dragPortal() {
        return this._editFrame instanceof EditPortalFrame || this._editFrame instanceof EditPortalDirection;
    }

    private void handleSelection(Positionable selection, JmriMouseEvent event) {
        if (this._editFrame == null) {
            return;
        }
        if (this._editFrame instanceof EditCircuitFrame) {
            EditCircuitFrame editCircuitFrame = (EditCircuitFrame)this._editFrame;
            ArrayList<Positionable> selectionGroup = this._editor.getSelectionGroup();
            if (selectionGroup == null) {
                selectionGroup = new ArrayList();
            }
            if (selectionGroup.contains(selection)) {
                selectionGroup.remove(selection);
            } else if (this.okToAdd(selection, editCircuitFrame._homeBlock)) {
                selectionGroup.add(selection);
            }
            editCircuitFrame.updateIconList(selectionGroup);
            this._editor.setSelectionGroup(selectionGroup);
        } else if (this._editFrame instanceof EditCircuitPaths) {
            EditCircuitPaths editPathsFrame = (EditCircuitPaths)this._editFrame;
            editPathsFrame.updateSelections(!event.isShiftDown(), selection);
        } else if (this._editFrame instanceof EditPortalFrame) {
            EditPortalFrame editPortalFrame = (EditPortalFrame)this._editFrame;
            if (selection instanceof PortalIcon && this.getCircuitIcons(this._editFrame._homeBlock).contains(selection)) {
                editPortalFrame.setSelected((PortalIcon)selection);
            }
        } else if (this._editFrame instanceof EditPortalDirection) {
            EditPortalDirection editDirectionFrame = (EditPortalDirection)this._editFrame;
            if (selection instanceof PortalIcon) {
                editDirectionFrame.setPortalIcon((PortalIcon)selection, true);
            }
        } else if (this._editFrame instanceof EditSignalFrame) {
            EditSignalFrame editSignalFrame = (EditSignalFrame)this._editFrame;
            editSignalFrame.setSelected((PositionableIcon)selection);
        }
    }

    protected void closeCBWindow() {
        if (this._cbFrame != null) {
            this._cbFrame.dispose();
        }
        if (this._editFrame != null) {
            this._editFrame.closingEvent(true, null);
        }
    }

    protected static void doSize(JComponent comp, int max, int min) {
        Dimension dim = comp.getPreferredSize();
        dim.width = max;
        comp.setMaximumSize(dim);
        dim.width = min;
        comp.setMinimumSize(dim);
    }

    protected static JPanel makeTextBoxPanel(boolean vertical, JTextField textField, String label, boolean editable, String tooltip) {
        JPanel panel = CircuitBuilder.makeBoxPanel(vertical, textField, label, tooltip);
        textField.setEditable(editable);
        textField.setBackground(Color.white);
        return panel;
    }

    protected static JPanel makeBoxPanel(boolean vertical, JComponent textField, String label, String tooltip) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        JLabel l = new JLabel(Bundle.getMessage(label));
        if (vertical) {
            c.anchor = 15;
            l.setAlignmentX(0.5f);
            textField.setAlignmentX(0.5f);
        } else {
            c.anchor = 13;
            l.setAlignmentX(0.0f);
            textField.setAlignmentX(1.0f);
        }
        panel.add((Component)l, c);
        if (vertical) {
            c.anchor = 11;
            c.gridy = 1;
        } else {
            c.anchor = 17;
            c.gridx = 1;
        }
        c.fill = 2;
        CircuitBuilder.doSize(textField, 9000, 200);
        panel.add((Component)textField, c);
        if (tooltip != null) {
            textField.setToolTipText(Bundle.getMessage(tooltip));
            l.setToolTipText(Bundle.getMessage(tooltip));
            panel.setToolTipText(Bundle.getMessage(tooltip));
        }
        return panel;
    }

    class CBFrame
    extends JmriJFrame
    implements ListSelectionListener {
        ButtonGroup _buttonGroup;
        int _which;
        JRadioButton _newCircuitButton;

        CBFrame(String title) {
            super(false, false);
            this._buttonGroup = new ButtonGroup();
            this._which = 0;
            this._newCircuitButton = this.makeButton("newCircuitItem", NONE);
            this.setTitle(title);
            this.addHelpMenu("package.jmri.jmrit.display.CircuitBuilder", true);
            CircuitBuilder.this._blockTable.getSelectionModel().addListSelectionListener(this);
            JPanel contentPane = new JPanel();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            Border padding = BorderFactory.createEmptyBorder(10, 5, 4, 5);
            contentPane.setBorder(padding);
            JPanel panel0 = new JPanel();
            panel0.setLayout(new BoxLayout(panel0, 0));
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(this._newCircuitButton);
            panel.add(this.makeButton("editCircuitItem", OBLOCK));
            panel.add(this.makeButton("editPortalsItem", PORTAL));
            panel.add(this.makeButton("editCircuitPathsItem", OPATH));
            panel.add(this.makeButton("editDirectionItem", ARROW));
            panel.add(this.makeButton("editSignalItem", SIGNAL));
            this._newCircuitButton.setSelected(true);
            panel0.add(panel);
            panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(new JScrollPane(CircuitBuilder.this._blockTable));
            panel0.add(panel);
            contentPane.add(panel0);
            panel0 = new JPanel();
            panel0.setLayout(new BoxLayout(panel0, 0));
            panel = new JPanel();
            JButton button = new JButton(Bundle.getMessage("ButtonOpen"));
            button.addActionListener(event -> {
                if (CircuitBuilder.this.editingOK()) {
                    this.setCurrentBlock();
                    if (this._which == NONE) {
                        CircuitBuilder.this.newCircuit();
                    } else if (this._which == OBLOCK) {
                        CircuitBuilder.this.editCircuit("editCircuitItem", false);
                    } else if (this._which == PORTAL) {
                        CircuitBuilder.this.editPortals("editPortalsItem", false);
                    } else if (this._which == OPATH) {
                        CircuitBuilder.this.editCircuitPaths("editCircuitPathsItem", false);
                    } else if (this._which == ARROW) {
                        CircuitBuilder.this.editPortalDirection("editDirectionItem", false);
                    } else if (this._which == SIGNAL) {
                        CircuitBuilder.this.editSignalFrame("editSignalItem", false);
                    }
                }
            });
            panel.add(button);
            button = new JButton(Bundle.getMessage("ButtonDone"));
            button.addActionListener(a -> {
                CircuitBuilder.this._currentBlock = null;
                this.dispose();
            });
            panel.add(button);
            panel.setMaximumSize(new Dimension(300, panel.getPreferredSize().height));
            panel0.add(panel);
            contentPane.add(panel0);
            this.setContentPane(contentPane);
            CircuitBuilder.this._blockTable.clearSelection();
            this.pack();
            InstanceManager.getDefault(PlaceWindow.class).nextTo(CircuitBuilder.this._editor, null, this);
            this.setVisible(true);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setCurrentBlock();
        }

        private void setCurrentBlock() {
            int row = CircuitBuilder.this._blockTable.getSelectedRow();
            if (row >= 0) {
                row = CircuitBuilder.this._blockTable.convertRowIndexToModel(row);
                CircuitBuilder.this._currentBlock = CircuitBuilder.this._oblockModel.getBeanAt(row);
            } else {
                CircuitBuilder.this._currentBlock = null;
            }
        }

        JRadioButton makeButton(String title, int which) {
            JRadioButton button = new JRadioButton(Bundle.getMessage(title));
            button.addActionListener(event -> {
                this._which = which;
            });
            this._buttonGroup.add(button);
            return button;
        }

        @Override
        public void dispose() {
            CircuitBuilder.this._cbFrame = null;
            super.dispose();
        }
    }
}

