/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import jmri.CatalogTreeManager;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.configurexml.StoreXmlUserAction;
import jmri.jmrit.beantable.ListedTableAction;
import jmri.jmrit.beantable.OBlockTableAction;
import jmri.jmrit.catalog.ImageIndexEditor;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.CoordinateEdit;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.IndicatorTrack;
import jmri.jmrit.display.LinkingObject;
import jmri.jmrit.display.LocoIcon;
import jmri.jmrit.display.MemoryOrGVIcon;
import jmri.jmrit.display.NewPanelAction;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableIcon;
import jmri.jmrit.display.PositionableJComponent;
import jmri.jmrit.display.PositionableJPanel;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.ReporterIcon;
import jmri.jmrit.display.RpsPositionIcon;
import jmri.jmrit.display.ToolTip;
import jmri.jmrit.display.controlPanelEditor.Bundle;
import jmri.jmrit.display.controlPanelEditor.CircuitBuilder;
import jmri.jmrit.display.controlPanelEditor.PortalIcon;
import jmri.jmrit.display.controlPanelEditor.shape.PositionableShape;
import jmri.jmrit.display.controlPanelEditor.shape.ShapeDrawer;
import jmri.jmrit.display.palette.ColorDialog;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.WarrantTableAction;
import jmri.util.HelpUtil;
import jmri.util.SystemType;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlPanelEditor
extends Editor
implements DropTargetListener,
ClipboardOwner {
    protected JMenuBar _menuBar;
    private JMenu _editorMenu;
    protected JMenu _editMenu;
    protected JMenu _fileMenu;
    protected JMenu _optionMenu;
    protected JMenu _iconMenu;
    protected JMenu _zoomMenu;
    private JMenu _markerMenu;
    private JMenu _warrantMenu;
    private JMenu _circuitMenu;
    private JMenu _drawMenu;
    private CircuitBuilder _circuitBuilder;
    private final ArrayList<Rectangle> _highlightGroup = new ArrayList();
    private ShapeDrawer _shapeDrawer;
    private ItemPalette _itemPalette;
    private boolean _disableShapeSelection;
    private boolean _disablePortalSelection = true;
    private String _portalIconFamily = "Standard";
    private HashMap<String, NamedIcon> _portalIconMap;
    private final JCheckBoxMenuItem useGlobalFlagBox = new JCheckBoxMenuItem(Bundle.getMessage("CheckBoxGlobalFlags"));
    private final JCheckBoxMenuItem positionableBox = new JCheckBoxMenuItem(Bundle.getMessage("CheckBoxPositionable"));
    private final JCheckBoxMenuItem controllingBox = new JCheckBoxMenuItem(Bundle.getMessage("CheckBoxControlling"));
    private final JCheckBoxMenuItem showTooltipBox = new JCheckBoxMenuItem(Bundle.getMessage("CheckBoxShowTooltips"));
    private final JCheckBoxMenuItem hiddenBox = new JCheckBoxMenuItem(Bundle.getMessage("CheckBoxHidden"));
    private final JCheckBoxMenuItem disableShapeSelect = new JCheckBoxMenuItem(Bundle.getMessage("disableShapeSelect"));
    private final JRadioButtonMenuItem scrollBoth = new JRadioButtonMenuItem(Bundle.getMessage("ScrollBoth"));
    private final JRadioButtonMenuItem scrollNone = new JRadioButtonMenuItem(Bundle.getMessage("ScrollNone"));
    private final JRadioButtonMenuItem scrollHorizontal = new JRadioButtonMenuItem(Bundle.getMessage("ScrollHorizontal"));
    private final JRadioButtonMenuItem scrollVertical = new JRadioButtonMenuItem(Bundle.getMessage("ScrollVertical"));
    ArrayList<Positionable> _clipGroup;
    int _fitX = 0;
    int _fitY = 0;
    private boolean _manualSelection = false;
    private long _mouseDownTime = 0L;
    private long _clickTime;
    DataFlavor _positionableDataFlavor;
    DataFlavor _positionableListDataFlavor;
    DataFlavor _namedIconDataFlavor;
    private static final Logger log = LoggerFactory.getLogger(ControlPanelEditor.class);

    public ControlPanelEditor() {
    }

    public ControlPanelEditor(String name) {
        super(name);
        this.init(name);
    }

    @Override
    protected void init(String name) {
        this.setVisible(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.setGlobalSetsLocalFlag(false);
        this.setUseGlobalFlag(false);
        this._menuBar = new JMenuBar();
        this._circuitBuilder = new CircuitBuilder(this);
        this._shapeDrawer = new ShapeDrawer(this);
        this.makeDrawMenu();
        this.makeWarrantMenu(true, true);
        this.makeIconMenu();
        this.makeZoomMenu();
        this.makeMarkerMenu();
        this.makeOptionMenu();
        this.makeEditMenu();
        this.makeFileMenu();
        this.setJMenuBar(this._menuBar);
        this.addHelpMenu("package.jmri.jmrit.display.ControlPanelEditor", true);
        super.setTargetPanel(null, null);
        super.setTargetPanelSize(300, 300);
        this.makeDataFlavors();
        this.setScroll(1);
        this.scrollBoth.setSelected(true);
        super.setDefaultToolTip(new ToolTip(null, 0, 0, new Font("Serif", 0, 12), Color.black, new Color(255, 250, 210), Color.black, null));
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.registerUser(this);
        }
        this.pack();
        this.setVisible(true);
    }

    protected void makeIconMenu() {
        this._iconMenu = new JMenu(Bundle.getMessage("MenuIcon"));
        this._menuBar.add((Component)this._iconMenu, 0);
        JMenuItem mi = new JMenuItem(Bundle.getMessage("CircuitBuilder"));
        mi.addActionListener(event -> this._circuitBuilder.openCBWindow());
        this.setMenuAcceleratorKey(mi, 66);
        this._iconMenu.add(mi);
        this._iconMenu.add(new JSeparator());
        mi = new JMenuItem(Bundle.getMessage("MenuItemItemPalette"));
        mi.addActionListener(new ActionListener(){
            Editor editor;

            ActionListener init(Editor ed) {
                this.editor = ed;
                return this;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelEditor.this._itemPalette = ItemPalette.getDefault(Bundle.getMessage("MenuItemItemPalette"), this.editor);
                assert (ControlPanelEditor.this._itemPalette != null);
                ControlPanelEditor.this._itemPalette.setVisible(true);
            }
        }.init(this));
        this.setMenuAcceleratorKey(mi, 80);
        this._iconMenu.add(mi);
        this._iconMenu.add(new OBlockTableAction(Bundle.getMessage("MenuItemOBlockTable")));
        mi = (JMenuItem)this._iconMenu.getMenuComponent(3);
        this.setMenuAcceleratorKey(mi, 79);
        this._iconMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemTableList")));
        mi = (JMenuItem)this._iconMenu.getMenuComponent(4);
        this.setMenuAcceleratorKey(mi, 84);
    }

    private void setMenuAcceleratorKey(JMenuItem mi, int key) {
        if (SystemType.isMacOSX()) {
            mi.setAccelerator(KeyStroke.getKeyStroke(key, 256));
        } else {
            mi.setAccelerator(KeyStroke.getKeyStroke(key, 128));
        }
    }

    protected void makeCircuitMenu(boolean edit) {
        if (edit) {
            if (this._circuitMenu == null) {
                ItemPalette.loadIcons();
                this._circuitMenu = this._circuitBuilder.makeMenu();
                int idx = this._menuBar.getComponentIndex(this._warrantMenu);
                this._menuBar.add((Component)this._circuitMenu, ++idx);
                this._menuBar.revalidate();
            }
        } else if (this._circuitMenu != null) {
            this._circuitBuilder.closeCBWindow();
            this._circuitMenu = null;
        }
    }

    protected void makeDrawMenu() {
        if (this._drawMenu == null) {
            this._drawMenu = this._shapeDrawer.makeMenu();
            this._drawMenu.add(this.disableShapeSelect);
            this.disableShapeSelect.addActionListener(event -> {
                this._disableShapeSelection = this.disableShapeSelect.isSelected();
            });
        }
        this._menuBar.add((Component)this._drawMenu, 0);
    }

    public boolean getShapeSelect() {
        return !this._disableShapeSelection;
    }

    public void setShapeSelect(boolean set) {
        this._disableShapeSelection = !set;
        this.disableShapeSelect.setSelected(this._disableShapeSelection);
    }

    public String getPortalIconFamily() {
        return this._portalIconFamily;
    }

    public void setPortalIconFamily(String family) {
        if (family != null && !family.equals(this._portalIconFamily)) {
            this._portalIconMap = null;
        }
        this._portalIconFamily = family;
    }

    @Nonnull
    public HashMap<String, NamedIcon> getPortalIconMap() {
        if (this._portalIconMap == null) {
            ItemPalette.loadIcons();
            this._portalIconMap = ItemPalette.getIconMap("Portal", this._portalIconFamily);
            if (this._portalIconMap == null) {
                HashMap<String, HashMap<String, NamedIcon>> familyMap = ItemPalette.getFamilyMaps("Portal");
                this._portalIconMap = familyMap.get("Standard");
                if (this._portalIconMap == null) {
                    log.warn("empty PortalIconMap returned");
                    this._portalIconMap = new HashMap();
                    this._portalIconMap.put("hidden", new NamedIcon("resources/icons/Invisible.gif", "resources/icons/Invisible.gif"));
                    this._portalIconMap.put("path", new NamedIcon("resources/icons/greenSquare.gif", "resources/icons/greenSquare.gif"));
                    this._portalIconMap.put("block", new NamedIcon("resources/icons/throttles/RoundRedCircle20.png", "resources/icons/throttles/RoundRedCircle20.png"));
                    this._portalIconMap.put("toArrow", new NamedIcon("resources/icons/track/toArrow.gif", "resources/icons/track/toArrow.gif"));
                    this._portalIconMap.put("fromArrow", new NamedIcon("resources/icons/track/fromArrow.gif", "resources/icons/track/fromArrow.gif"));
                }
            }
        }
        return PositionableIcon.cloneMap(this._portalIconMap, null);
    }

    public ShapeDrawer getShapeDrawer() {
        return this._shapeDrawer;
    }

    protected void makeZoomMenu() {
        this._zoomMenu = new JMenu(Bundle.getMessage("MenuZoom"));
        this._menuBar.add((Component)this._zoomMenu, 0);
        JMenuItem addItem = new JMenuItem(Bundle.getMessage("NoZoom"));
        this._zoomMenu.add(addItem);
        addItem.addActionListener(event -> this.zoomRestore());
        addItem = new JMenuItem(Bundle.getMessage("Zoom", "..."));
        this._zoomMenu.add(addItem);
        PositionableJComponent z = new PositionableJComponent(this);
        z.setScale(this.getPaintScale());
        addItem.addActionListener(CoordinateEdit.getZoomEditAction(z));
        addItem = new JMenuItem(Bundle.getMessage("ZoomFit"));
        this._zoomMenu.add(addItem);
        addItem.addActionListener(event -> this.zoomToFit());
    }

    protected void makeWarrantMenu(boolean edit, boolean addMenu) {
        JMenu oldMenu = this._warrantMenu;
        this._warrantMenu = WarrantTableAction.getDefault().makeWarrantMenu(edit);
        if (this._warrantMenu == null) {
            this._warrantMenu = new JMenu(ResourceBundle.getBundle("jmri.jmrit.logix.WarrantBundle").getString("MenuWarrant"));
            JMenuItem aboutItem = new JMenuItem(Bundle.getMessage("AboutWarrant"));
            HelpUtil.enableHelpOnButton(aboutItem, "package.jmri.jmrit.logix.Warrant");
            this._warrantMenu.add(aboutItem);
            aboutItem = new JMenuItem(Bundle.getMessage("AboutOBlock"));
            HelpUtil.enableHelpOnButton(aboutItem, "package.jmri.jmrit.logix.OBlockTable");
            this._warrantMenu.add(aboutItem);
            aboutItem = new JMenuItem(Bundle.getMessage("AboutCircuitMenu"));
            HelpUtil.enableHelpOnButton(aboutItem, "package.jmri.jmrit.display.CircuitBuilder");
            this._warrantMenu.add(aboutItem);
            aboutItem.addActionListener(event -> this.makeCircuitMenu(true));
        }
        if (edit) {
            this.makeCircuitMenu(edit);
            JMenuItem item = new JMenuItem(Bundle.getMessage("OpenCircuitMenu"));
            this._warrantMenu.add(item);
            item.addActionListener(event -> this._circuitBuilder.openCBWindow());
        }
        if (addMenu) {
            this._menuBar.add((Component)this._warrantMenu, 0);
        } else if (oldMenu != null) {
            int idx = this._menuBar.getComponentIndex(oldMenu);
            this._menuBar.remove(oldMenu);
            this._menuBar.add((Component)this._warrantMenu, idx);
        }
        this._menuBar.revalidate();
    }

    protected void makeMarkerMenu() {
        this._markerMenu = new JMenu(Bundle.getMessage("MenuMarker"));
        this._menuBar.add(this._markerMenu);
        this._markerMenu.add(new AbstractAction(Bundle.getMessage("AddLoco")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelEditor.this.locoMarkerFromInput();
            }
        });
        this._markerMenu.add(new AbstractAction(Bundle.getMessage("AddLocoRoster")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelEditor.this.locoMarkerFromRoster();
            }
        });
        this._markerMenu.add(new AbstractAction(Bundle.getMessage("RemoveMarkers")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelEditor.this.removeMarkers();
            }
        });
    }

    protected void makeOptionMenu() {
        this._optionMenu = new JMenu(Bundle.getMessage("MenuOptions"));
        this._menuBar.add((Component)this._optionMenu, 0);
        this._optionMenu.add(this.useGlobalFlagBox);
        this.useGlobalFlagBox.addActionListener(event -> this.setUseGlobalFlag(this.useGlobalFlagBox.isSelected()));
        this.useGlobalFlagBox.setSelected(this.useGlobalFlag());
        this._optionMenu.add(this.positionableBox);
        this.positionableBox.addActionListener(event -> this.setAllPositionable(this.positionableBox.isSelected()));
        this.positionableBox.setSelected(this.allPositionable());
        this._optionMenu.add(this.controllingBox);
        this.controllingBox.addActionListener(event -> this.setAllControlling(this.controllingBox.isSelected()));
        this.controllingBox.setSelected(this.allControlling());
        this._optionMenu.add(this.hiddenBox);
        this.hiddenBox.addActionListener(event -> this.setShowHidden(this.hiddenBox.isSelected()));
        this.hiddenBox.setSelected(this.showHidden());
        this._optionMenu.add(this.showTooltipBox);
        this.showTooltipBox.addActionListener(e -> this.setAllShowToolTip(this.showTooltipBox.isSelected()));
        this.showTooltipBox.setSelected(this.showToolTip());
        JMenu scrollMenu = new JMenu(Bundle.getMessage("ComboBoxScrollable"));
        this._optionMenu.add(scrollMenu);
        ButtonGroup scrollGroup = new ButtonGroup();
        scrollGroup.add(this.scrollBoth);
        scrollMenu.add(this.scrollBoth);
        this.scrollBoth.addActionListener(event -> this.setScroll(1));
        scrollGroup.add(this.scrollNone);
        scrollMenu.add(this.scrollNone);
        this.scrollNone.addActionListener(event -> this.setScroll(0));
        scrollGroup.add(this.scrollHorizontal);
        scrollMenu.add(this.scrollHorizontal);
        this.scrollHorizontal.addActionListener(event -> this.setScroll(2));
        scrollGroup.add(this.scrollVertical);
        scrollMenu.add(this.scrollVertical);
        this.scrollVertical.addActionListener(event -> this.setScroll(3));
    }

    private void makeFileMenu() {
        this._fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        this._menuBar.add((Component)this._fileMenu, 0);
        this._fileMenu.add(new NewPanelAction(Bundle.getMessage("MenuItemNew")));
        this._fileMenu.add(new StoreXmlUserAction(Bundle.getMessage("FileMenuItemStore")));
        JMenuItem storeIndexItem = new JMenuItem(Bundle.getMessage("MIStoreImageIndex"));
        this._fileMenu.add(storeIndexItem);
        storeIndexItem.addActionListener(event -> InstanceManager.getDefault(CatalogTreeManager.class).storeImageIndex());
        JMenuItem editItem = new JMenuItem(Bundle.getMessage("renamePanelMenu", "..."));
        PositionableJComponent z = new PositionableJComponent(this);
        z.setScale(this.getPaintScale());
        editItem.addActionListener(CoordinateEdit.getNameEditAction(z));
        this._fileMenu.add(editItem);
        editItem = new JMenuItem(Bundle.getMessage("editIndexMenu"));
        this._fileMenu.add(editItem);
        editItem.addActionListener(event -> {
            ImageIndexEditor ii = InstanceManager.getDefault(ImageIndexEditor.class);
            ii.pack();
            ii.setVisible(true);
        });
        editItem = new JMenuItem(Bundle.getMessage("PEView"));
        this._fileMenu.add(editItem);
        editItem.addActionListener(event -> {
            this.changeView("jmri.jmrit.display.panelEditor.PanelEditor");
            if (this._itemPalette != null) {
                this._itemPalette.dispose();
            }
        });
        this._fileMenu.addSeparator();
        JMenuItem deleteItem = new JMenuItem(Bundle.getMessage("DeletePanel"));
        this._fileMenu.add(deleteItem);
        deleteItem.addActionListener(event -> {
            if (this.deletePanel()) {
                this.dispose();
            }
        });
        this._fileMenu.addSeparator();
        editItem = new JMenuItem(Bundle.getMessage("CloseEditor"));
        this._fileMenu.add(editItem);
        editItem.addActionListener(event -> this.setAllEditable(false));
    }

    protected void makeEditMenu() {
        this._editMenu = new JMenu(Bundle.getMessage("ButtonEdit"));
        this._menuBar.add((Component)this._editMenu, 0);
        this._editMenu.setMnemonic(69);
        JMenuItem menuItem = new JMenuItem(Bundle.getMessage("MenuItemCut"));
        menuItem.addActionListener(event -> {
            this.copyToClipboard();
            this.removeSelections(null);
        });
        this.setMenuAcceleratorKey(menuItem, 88);
        this._editMenu.add(menuItem);
        menuItem = new JMenuItem(Bundle.getMessage("MenuItemCopy"));
        menuItem.addActionListener(event -> this.copyToClipboard());
        this.setMenuAcceleratorKey(menuItem, 67);
        this._editMenu.add(menuItem);
        menuItem = new JMenuItem(Bundle.getMessage("MenuItemPaste"));
        menuItem.addActionListener(event -> this.pasteFromClipboard());
        this.setMenuAcceleratorKey(menuItem, 86);
        this._editMenu.add(menuItem);
        this._editMenu.add(this.makeSelectTypeMenu());
        this._editMenu.add(this.makeSelectLevelMenu());
        menuItem = new JMenuItem(Bundle.getMessage("SelectAll"));
        menuItem.addActionListener(event -> {
            this._selectionGroup = new ArrayList<Positionable>(this.getContents());
            this._targetPanel.repaint();
        });
        this.setMenuAcceleratorKey(menuItem, 65);
        this._editMenu.add(menuItem);
    }

    private JMenu makeSelectTypeMenu() {
        JMenu menu = new JMenu(Bundle.getMessage("SelectType"));
        ButtonGroup typeGroup = new ButtonGroup();
        JRadioButtonMenuItem button = this.makeSelectTypeButton("IndicatorTrack", "jmri.jmrit.display.IndicatorTrackIcon");
        typeGroup.add(button);
        menu.add(button);
        button = this.makeSelectTypeButton("IndicatorTO", "jmri.jmrit.display.IndicatorTurnoutIcon");
        typeGroup.add(button);
        menu.add(button);
        button = this.makeSelectTypeButton("BeanNameTurnout", "jmri.jmrit.display.TurnoutIcon");
        typeGroup.add(button);
        menu.add(button);
        button = this.makeSelectTypeButton("BeanNameSensor", "jmri.jmrit.display.SensorIcon");
        typeGroup.add(button);
        menu.add(button);
        button = this.makeSelectTypeButton("Shape", "jmri.jmrit.display.controlPanelEditor.shape.PositionableShape");
        typeGroup.add(button);
        menu.add(button);
        button = this.makeSelectTypeButton("BeanNameSignalMast", "jmri.jmrit.display.SignalMastIcon");
        typeGroup.add(button);
        menu.add(button);
        button = this.makeSelectTypeButton("BeanNameSignalHead", "jmri.jmrit.display.SignalHeadIcon");
        typeGroup.add(button);
        menu.add(button);
        button = this.makeSelectTypeButton("BeanNameMemory", "jmri.jmrit.display.MemoryIcon");
        typeGroup.add(button);
        menu.add(button);
        button = this.makeSelectTypeButton("MemoryInput", "jmri.jmrit.display.PositionableJPanel");
        typeGroup.add(button);
        menu.add(button);
        button = this.makeSelectTypeButton("MultiSensor", "jmri.jmrit.display.MultiSensorIcon");
        typeGroup.add(button);
        menu.add(button);
        button = this.makeSelectTypeButton("LocoID", "jmri.jmrit.display.LocoIcon");
        typeGroup.add(button);
        menu.add(button);
        button = this.makeSelectTypeButton("BeanNameLight", "jmri.jmrit.display.LightIcon");
        typeGroup.add(button);
        menu.add(button);
        return menu;
    }

    private JRadioButtonMenuItem makeSelectTypeButton(String label, String className) {
        JRadioButtonMenuItem button = new JRadioButtonMenuItem(Bundle.getMessage(label));
        button.addActionListener(new ActionListener(){
            String cName;

            ActionListener init(String name) {
                this.cName = name;
                return this;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                ControlPanelEditor.this.selectType(this.cName);
            }
        }.init(className));
        return button;
    }

    private void selectType(String name) {
        try {
            Class<?> cl = Class.forName(name);
            this._selectionGroup = new ArrayList();
            for (Positionable pos : this.getContents()) {
                if (!cl.isInstance(pos)) continue;
                this._selectionGroup.add(pos);
            }
        }
        catch (ClassNotFoundException cnfe) {
            log.error("selectType Menu {}", (Object)cnfe.toString());
        }
        this._targetPanel.repaint();
    }

    private JMenu makeSelectLevelMenu() {
        JMenu menu = new JMenu(Bundle.getMessage("SelectLevel"));
        ButtonGroup levelGroup = new ButtonGroup();
        for (int i = 0; i < 11; ++i) {
            JRadioButtonMenuItem button = new JRadioButtonMenuItem(Bundle.getMessage("selectLevel", "" + i));
            levelGroup.add(button);
            menu.add(button);
            button.addActionListener(new ActionListener(){
                int j;

                ActionListener init(int k) {
                    this.j = k;
                    return this;
                }

                @Override
                public void actionPerformed(ActionEvent event) {
                    ControlPanelEditor.this.selectLevel(this.j);
                }
            }.init(i));
        }
        return menu;
    }

    private void selectLevel(int i) {
        this._selectionGroup = new ArrayList();
        for (Positionable pos : this.getContents()) {
            if (pos.getDisplayLevel() != i) continue;
            this._selectionGroup.add(pos);
        }
        this._targetPanel.repaint();
    }

    public CircuitBuilder getCircuitBuilder() {
        return this._circuitBuilder;
    }

    private void pasteFromClipboard() {
        DataFlavor[] flavors;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        for (DataFlavor flavor : flavors = clipboard.getAvailableDataFlavors()) {
            if (!this._positionableListDataFlavor.equals(flavor)) continue;
            try {
                List clipGroup = (List)clipboard.getData(this._positionableListDataFlavor);
                if (clipGroup != null && clipGroup.size() > 0) {
                    Positionable pos = (Positionable)clipGroup.get(0);
                    int minX = pos.getLocation().x;
                    int minY = pos.getLocation().y;
                    for (int i = 1; i < clipGroup.size(); ++i) {
                        pos = (Positionable)clipGroup.get(i);
                        minX = Math.min(minX, pos.getLocation().x);
                        minY = Math.min(minY, pos.getLocation().y);
                    }
                    if (this._pastePending) {
                        this.abortPasteItems();
                    }
                    this._selectionGroup = new ArrayList();
                    Iterator iterator = clipGroup.iterator();
                    while (iterator.hasNext()) {
                        Positionable positionable;
                        pos = positionable = (Positionable)iterator.next();
                        pos.setEditor(this);
                        pos.setLocation(pos.getLocation().x + this._anchorX - minX, pos.getLocation().y + this._anchorY - minY);
                        pos.setDisplayLevel(pos.getDisplayLevel());
                        try {
                            pos.setId(null);
                            this.putItem(pos);
                        }
                        catch (Positionable.DuplicateIdException e) {
                            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
                        }
                        pos.updateSize();
                        pos.setVisible(true);
                        this._selectionGroup.add(pos);
                        if (pos instanceof PositionableIcon) {
                            NamedBean bean = pos.getNamedBean();
                            if (bean != null) {
                                ((PositionableIcon)pos).displayState(bean.getState());
                            }
                        } else if (pos instanceof MemoryOrGVIcon) {
                            ((MemoryOrGVIcon)pos).displayState();
                        } else if (pos instanceof PositionableJComponent) {
                            ((PositionableJComponent)pos).displayState();
                        }
                        log.debug("Paste Added at ({}, {})", (Object)pos.getLocation().x, (Object)pos.getLocation().y);
                    }
                }
                return;
            }
            catch (IOException ioe) {
                log.warn("Editor Paste caught IOException", (Throwable)ioe);
            }
            catch (UnsupportedFlavorException ufe) {
                log.warn("Editor Paste caught UnsupportedFlavorException", (Throwable)ufe);
            }
        }
    }

    private void copyToClipboard() {
        if (this._selectionGroup != null) {
            ArrayList<Positionable> dragGroup = new ArrayList<Positionable>();
            for (Positionable comp : this._selectionGroup) {
                Positionable pos = comp.deepClone();
                dragGroup.add(pos);
                this.removeFromTarget(pos);
            }
            log.debug("copyToClipboard: cloned _selectionGroup, size= {}", (Object)this._selectionGroup.size());
            this._clipGroup = dragGroup;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new PositionableListDnD(this._clipGroup), this);
            log.debug("copyToClipboard: setContents _selectionGroup, size= {}", (Object)this._selectionGroup.size());
        } else {
            this._clipGroup = null;
        }
    }

    public ArrayList<Positionable> getClipGroup() {
        if (log.isDebugEnabled()) {
            log.debug("getClipGroup: _clipGroup{}", this._clipGroup == null ? "=null" : ", size= " + this._clipGroup.size());
        }
        if (this._clipGroup == null) {
            return null;
        }
        ArrayList<Positionable> clipGrp = new ArrayList<Positionable>();
        for (Positionable _comp : this._clipGroup) {
            Positionable pos = _comp.deepClone();
            clipGrp.add(pos);
            this.removeFromTarget(pos);
        }
        return clipGrp;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        log.debug("lostOwnership: content flavor[0] = {}", (Object)contents.getTransferDataFlavors()[0]);
    }

    @Override
    public void setAllEditable(boolean edit) {
        if (this._warrantMenu != null) {
            this._menuBar.remove(this._warrantMenu);
        }
        if (this._circuitMenu != null) {
            this._menuBar.remove(this._circuitMenu);
            this._circuitMenu = null;
        }
        if (edit) {
            if (this._editorMenu != null) {
                this._menuBar.remove(this._editorMenu);
            }
            if (this._markerMenu != null) {
                this._menuBar.remove(this._markerMenu);
            }
            if (this._drawMenu == null) {
                this.makeDrawMenu();
            } else {
                this._menuBar.add((Component)this._drawMenu, 0);
            }
            this.makeWarrantMenu(true, true);
            if (this._iconMenu == null) {
                this.makeIconMenu();
            } else {
                this._menuBar.add((Component)this._iconMenu, 0);
            }
            if (this._zoomMenu == null) {
                this.makeZoomMenu();
            } else {
                this._menuBar.add((Component)this._zoomMenu, 0);
            }
            if (this._optionMenu == null) {
                this.makeOptionMenu();
            } else {
                this._menuBar.add((Component)this._optionMenu, 0);
            }
            if (this._editMenu == null) {
                this.makeEditMenu();
            } else {
                this._menuBar.add((Component)this._editMenu, 0);
            }
            if (this._fileMenu == null) {
                this.makeFileMenu();
            } else {
                this._menuBar.add((Component)this._fileMenu, 0);
            }
        } else {
            if (this._fileMenu != null) {
                this._menuBar.remove(this._fileMenu);
            }
            if (this._editMenu != null) {
                this._menuBar.remove(this._editMenu);
            }
            if (this._optionMenu != null) {
                this._menuBar.remove(this._optionMenu);
            }
            if (this._zoomMenu != null) {
                this._menuBar.remove(this._zoomMenu);
            }
            if (this._iconMenu != null) {
                this._menuBar.remove(this._iconMenu);
            }
            if (this._drawMenu != null) {
                this._menuBar.remove(this._drawMenu);
            }
            if (InstanceManager.getDefault(OBlockManager.class).getNamedBeanSet().size() > 1) {
                this.makeWarrantMenu(false, true);
            }
            if (this._markerMenu == null) {
                this.makeMarkerMenu();
            } else {
                this._menuBar.add((Component)this._markerMenu, 0);
            }
            if (this._editorMenu == null) {
                this._editorMenu = new JMenu(Bundle.getMessage("MenuEdit"));
                this._editorMenu.add(new AbstractAction(Bundle.getMessage("OpenEditor")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ControlPanelEditor.this.setAllEditable(true);
                    }
                });
            }
            this._menuBar.add((Component)this._editorMenu, 0);
        }
        super.setAllEditable(edit);
        this.setTitle();
        this._menuBar.revalidate();
    }

    @Override
    public void setUseGlobalFlag(boolean set) {
        this.positionableBox.setEnabled(set);
        this.controllingBox.setEnabled(set);
        super.setUseGlobalFlag(set);
    }

    private void zoomRestore() {
        List<Positionable> contents = this.getContents();
        for (Positionable p : contents) {
            p.setLocation(p.getX() + this._fitX, p.getY() + this._fitY);
        }
        this.setPaintScale(1.0);
    }

    private void zoomToFit() {
        double minX = 1000.0;
        double maxX = 0.0;
        double minY = 1000.0;
        double maxY = 0.0;
        List<Positionable> contents = this.getContents();
        for (Positionable p : contents) {
            minX = Math.min((double)p.getX(), minX);
            minY = Math.min((double)p.getY(), minY);
            maxX = Math.max((double)(p.getX() + p.getWidth()), maxX);
            maxY = Math.max((double)(p.getY() + p.getHeight()), maxY);
        }
        this._fitX = (int)Math.floor(minX);
        this._fitY = (int)Math.floor(minY);
        JFrame frame = this.getTargetFrame();
        Container contentPane = this.getTargetFrame().getContentPane();
        Dimension dim = contentPane.getSize();
        Dimension d = this.getTargetPanel().getSize();
        this.getTargetPanel().setSize((int)Math.ceil(maxX - minX), (int)Math.ceil(maxY - minY));
        JScrollPane scrollPane = this.getPanelScrollPane();
        scrollPane.getHorizontalScrollBar().setValue(0);
        scrollPane.getVerticalScrollBar().setValue(0);
        JViewport viewPort = scrollPane.getViewport();
        Dimension dv = viewPort.getExtentSize();
        int dX = frame.getWidth() - dv.width;
        int dY = frame.getHeight() - dv.height;
        log.debug("zoomToFit: layoutWidth= {}, layoutHeight= {}\n\tframeWidth= {}, frameHeight= {}, viewWidth= {}, viewHeight= {}\n\tconWidth= {}, conHeight= {}, panelWidth= {}, panelHeight= {}", new Object[]{maxX - minX, maxY - minY, frame.getWidth(), frame.getHeight(), dv.width, dv.height, dim.width, dim.height, d.width, d.height});
        double ratioX = (double)dv.width / (maxX - minX);
        double ratioY = (double)dv.height / (maxY - minY);
        double ratio = Math.min(ratioX, ratioY);
        this._fitX = (int)Math.floor(minX);
        this._fitY = (int)Math.floor(minY);
        for (Positionable p : contents) {
            p.setLocation(p.getX() - this._fitX, p.getY() - this._fitY);
        }
        this.setScroll(1);
        this.setPaintScale(ratio);
        this.setScroll(0);
        this.scrollNone.setSelected(true);
        frame.setSize((int)Math.ceil((maxX - minX) * ratio) + dX, (int)Math.ceil((maxY - minY) * ratio) + dY);
        scrollPane.getHorizontalScrollBar().setValue(0);
        scrollPane.getVerticalScrollBar().setValue(0);
        log.debug("zoomToFit: ratio= {}, w= {}, h= {}, frameWidth= {}, frameHeight= {}", new Object[]{ratio, maxX - minX, maxY - minY, frame.getWidth(), frame.getHeight()});
    }

    @Override
    public void setTitle() {
        Object name = this.getName();
        if (name == null || ((String)name).length() == 0) {
            name = Bundle.getMessage("untitled");
        }
        String ending = " " + Bundle.getMessage("LabelEditor");
        String defaultName = Bundle.getMessage("ControlPanelEditor");
        defaultName = defaultName.substring(0, defaultName.length() - ending.length());
        if (((String)name).endsWith(ending)) {
            name = ((String)name).substring(0, ((String)name).length() - ending.length());
        }
        if (((String)name).equals(defaultName)) {
            name = Bundle.getMessage("untitled") + "(" + (String)name + ")";
        }
        if (this.isEditable()) {
            super.setTitle((String)name + " " + Bundle.getMessage("LabelEditor"));
        } else {
            super.setTitle((String)name);
        }
        this.setName((String)name);
    }

    public void loadComplete() {
        log.debug("loadComplete");
    }

    @Override
    public void initView() {
        this.positionableBox.setSelected(this.allPositionable());
        this.controllingBox.setSelected(this.allControlling());
        this.showTooltipBox.setSelected(this.showToolTip());
        this.hiddenBox.setSelected(this.showHidden());
        switch (this._scrollState) {
            case 0: {
                this.scrollNone.setSelected(true);
                break;
            }
            case 1: {
                this.scrollBoth.setSelected(true);
                break;
            }
            case 2: {
                this.scrollHorizontal.setSelected(true);
                break;
            }
            case 3: {
                this.scrollVertical.setSelected(true);
                break;
            }
            default: {
                log.warn("Unhandled scroll state: {}", (Object)this._scrollState);
            }
        }
        log.debug("InitView done");
    }

    @Override
    public void deselectSelectionGroup() {
        this._circuitBuilder.hidePortalIcons(false);
        super.deselectSelectionGroup();
    }

    protected Positionable getCurrentSelection(JmriMouseEvent event) {
        if (this._pastePending && !event.isPopupTrigger() && !event.isMetaDown() && !event.isAltDown()) {
            return this.getCopySelection(event);
        }
        List<Positionable> selections = this.getSelectedItems(event);
        if (this._disableShapeSelection || this._disablePortalSelection) {
            ArrayList<Positionable> list = new ArrayList<Positionable>();
            for (Positionable pos : selections) {
                if (this._disableShapeSelection && pos instanceof PositionableShape || this._disablePortalSelection && pos instanceof PortalIcon) continue;
                list.add(pos);
            }
            selections = list;
        }
        Positionable selection = null;
        if (selections.size() > 0) {
            if (event.isControlDown()) {
                if (event.isShiftDown() && selections.size() > 3) {
                    if (this._manualSelection) {
                        this.deselectSelectionGroup();
                        return this._currentSelection;
                    }
                    Object[] selects = new String[selections.size()];
                    Iterator<Positionable> iter = selections.iterator();
                    int i = 0;
                    while (iter.hasNext()) {
                        Positionable pos = iter.next();
                        if (pos instanceof NamedBean) {
                            selects[i++] = ((NamedBean)((Object)pos)).getDisplayName();
                            continue;
                        }
                        selects[i++] = pos.getNameString();
                    }
                    Object select = JmriJOptionPane.showInputDialog(this, Bundle.getMessage("multipleSelections"), Bundle.getMessage("QuestionTitle"), 3, null, selects, null);
                    if (select != null) {
                        for (Positionable pos : selections) {
                            String name = pos instanceof NamedBean ? ((NamedBean)((Object)pos)).getDisplayName() : pos.getNameString();
                            if (!select.equals(name)) continue;
                            this._manualSelection = true;
                            this.highlight(pos);
                            return pos;
                        }
                    } else {
                        selection = selections.get(selections.size() - 1);
                    }
                } else {
                    selection = selections.get(selections.size() - 1);
                    if (selection.getDisplayLevel() <= 1 && selections.size() > 1) {
                        selection = selections.get(selections.size() - 2);
                    }
                }
            } else {
                selection = event.isShiftDown() && selections.size() > 1 ? selections.get(1) : selections.get(0);
                if (selection.getDisplayLevel() <= 1) {
                    selection = null;
                }
                this._manualSelection = false;
            }
        } else if (event.isControlDown() && (event.isPopupTrigger() || event.isMetaDown() || event.isAltDown())) {
            ControlPanelEditor ed = this;
            ActionListener ca = e -> {
                if (this._itemPalette != null) {
                    this._itemPalette.setEditor(ed);
                }
            };
            new ColorDialog((Frame)this, this.getTargetPanel(), 0, ca);
        }
        if (!this.isEditable() && selection != null && selection.isHidden()) {
            selection = null;
        }
        return selection;
    }

    private Positionable getCopySelection(JmriMouseEvent event) {
        if (this._selectionGroup == null) {
            return null;
        }
        double x = event.getX();
        double y = event.getY();
        for (Positionable p : this._selectionGroup) {
            Rectangle2D.Double rect2D = new Rectangle2D.Double((double)p.getX() * this._paintScale, (double)p.getY() * this._paintScale, (double)p.maxWidth() * this._paintScale, (double)p.maxHeight() * this._paintScale);
            if (!rect2D.contains(x, y)) continue;
            return p;
        }
        return null;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int x = 0;
        int y = 0;
        switch (e.getKeyCode()) {
            case 38: 
            case 104: 
            case 224: {
                y = -1;
                break;
            }
            case 40: 
            case 98: 
            case 225: {
                y = 1;
                break;
            }
            case 37: 
            case 100: 
            case 226: {
                x = -1;
                break;
            }
            case 39: 
            case 102: 
            case 227: {
                x = 1;
                break;
            }
            case 45: 
            case 68: 
            case 127: {
                this._shapeDrawer.delete();
                break;
            }
            case 65: 
            case 155: 
            case 521: {
                this._shapeDrawer.add(e.isShiftDown());
                break;
            }
            default: {
                return;
            }
        }
        if (e.isShiftDown()) {
            x *= 5;
            y *= 5;
        }
        if (this._selectionGroup != null) {
            for (Positionable comp : this._selectionGroup) {
                this.moveItem(comp, x, y);
            }
        }
        this.repaint();
    }

    @Override
    public void mousePressed(JmriMouseEvent event) {
        this._mouseDownTime = System.currentTimeMillis();
        this.setToolTip(null);
        log.debug("mousePressed at ({},{}) _dragging={}", new Object[]{event.getX(), event.getY(), this._dragging});
        boolean circuitBuilder = this._circuitBuilder.saveSelectionGroup(this._selectionGroup);
        this._anchorX = event.getX();
        this._anchorY = event.getY();
        this._lastX = this._anchorX;
        this._lastY = this._anchorY;
        this._currentSelection = this.getCurrentSelection(event);
        this._circuitBuilder.doMousePressed(event, this._currentSelection);
        if (!(event.isPopupTrigger() || event.isMetaDown() || event.isAltDown() || circuitBuilder)) {
            this._shapeDrawer.doMousePressed(event, this._currentSelection);
            if (this._currentSelection != null) {
                this._currentSelection.doMousePressed(event);
                if (this.isEditable() && !event.isControlDown() && this._selectionGroup != null && !this._selectionGroup.contains(this._currentSelection)) {
                    if (this._pastePending) {
                        this.abortPasteItems();
                    }
                    this.deselectSelectionGroup();
                }
            } else {
                this._highlightcomponent = null;
                if (this._pastePending) {
                    this.abortPasteItems();
                }
                this.deselectSelectionGroup();
            }
        } else if (this._currentSelection == null || this._selectionGroup != null && !this._selectionGroup.contains(this._currentSelection)) {
            this.deselectSelectionGroup();
        }
        this._circuitBuilder.doMousePressed(event);
        this._targetPanel.repaint();
    }

    @Override
    public void mouseReleased(JmriMouseEvent event) {
        this._mouseDownTime = 0L;
        this.setToolTip(null);
        if (log.isDebugEnabled()) {
            log.debug("mouseReleased at ({},{}) dragging={}, pastePending={}, selectRect is{} null", new Object[]{event.getX(), event.getY(), this._dragging, this._pastePending, this._selectRect == null ? "" : " not"});
        }
        Positionable selection = this.getCurrentSelection(event);
        if (event.isPopupTrigger() || event.isMetaDown() || event.isAltDown()) {
            if (selection != null) {
                this._highlightcomponent = null;
                this.showPopUp(selection, event);
            } else if (this._selectRect != null) {
                this.makeSelectionGroup(event);
            }
        } else {
            if (selection != null) {
                selection.doMouseReleased(event);
            }
            if (this._pastePending && this._dragging) {
                this.pasteItems();
            }
            if (this.isEditable()) {
                this._shapeDrawer.doMouseReleased(selection, event, this);
                if (!this._circuitBuilder.doMouseReleased(selection, this._dragging)) {
                    if (selection != null && !this._dragging) {
                        this.modifySelectionGroup(selection, event);
                    }
                    if (this._selectRect != null) {
                        this.makeSelectionGroup(event);
                    }
                    if (this._currentSelection != null && (this._selectionGroup == null || this._selectionGroup.isEmpty())) {
                        if (this._selectionGroup == null) {
                            this._selectionGroup = new ArrayList();
                        }
                        this._selectionGroup.add(this._currentSelection);
                    }
                }
                this._currentSelection = selection;
            } else {
                this.deselectSelectionGroup();
                this._currentSelection = null;
                this._highlightcomponent = null;
            }
        }
        this._selectRect = null;
        if (InstanceManager.getDefault(GuiLafPreferencesManager.class).isNonStandardMouseEvent()) {
            this.mouseClicked(event);
        }
        this._lastX = event.getX();
        this._lastY = event.getY();
        this._dragging = false;
        this._currentSelection = null;
        this._targetPanel.repaint();
    }

    @Override
    public void mouseClicked(JmriMouseEvent event) {
        if (InstanceManager.getDefault(GuiLafPreferencesManager.class).isNonStandardMouseEvent()) {
            long time = System.currentTimeMillis();
            if (time - this._clickTime < 20L) {
                return;
            }
            this._clickTime = time;
        }
        this.setToolTip(null);
        log.debug("mouseClicked at ({},{})", (Object)event.getX(), (Object)event.getY());
        Positionable selection = this.getCurrentSelection(event);
        if (this._shapeDrawer.doMouseClicked(event, this)) {
            return;
        }
        if (event.isPopupTrigger() || event.isMetaDown() || event.isAltDown()) {
            if (selection != null) {
                this._highlightcomponent = null;
                this.showPopUp(selection, event);
            }
        } else if (selection != null) {
            if (this._circuitBuilder.doMouseClicked(this.getSelectedItems(event), event)) {
                return;
            }
            selection.doMouseClicked(event);
            if (selection instanceof IndicatorTrack) {
                WarrantTableAction.getDefault().mouseClickedOnBlock(((IndicatorTrack)selection).getOccBlock());
            }
        }
        if (!this.isEditable()) {
            this.deselectSelectionGroup();
            this._currentSelection = null;
            this._highlightcomponent = null;
        }
        this._targetPanel.repaint();
    }

    @Override
    public void mouseDragged(JmriMouseEvent event) {
        this.setToolTip(null);
        long time = System.currentTimeMillis();
        if (time - this._mouseDownTime < 200L) {
            return;
        }
        this._dragging = true;
        if (this._circuitBuilder.doMouseDragged(this._currentSelection, event)) {
            return;
        }
        if (!(event.isPopupTrigger() || event.isMetaDown() || event.isAltDown() || this._shapeDrawer.doMouseDragged(event) || !this.isEditable() && !(this._currentSelection instanceof LocoIcon))) {
            if (this._currentSelection != null && this.getFlag(1, this._currentSelection.isPositionable())) {
                int deltaX = event.getX() - this._lastX;
                int deltaY = event.getY() - this._lastY;
                int minX = this.getItemX(this._currentSelection, deltaX);
                int minY = this.getItemY(this._currentSelection, deltaY);
                if (this._selectionGroup != null && this._selectionGroup.contains(this._currentSelection)) {
                    for (Positionable comp : this._selectionGroup) {
                        minX = Math.min(this.getItemX(comp, deltaX), minX);
                        minY = Math.min(this.getItemY(comp, deltaY), minY);
                    }
                }
                if (minX >= 0 && minY >= 0) {
                    if (this._selectionGroup != null && this._selectionGroup.contains(this._currentSelection) && !this._circuitBuilder.dragPortal()) {
                        for (Positionable comp : this._selectionGroup) {
                            this.moveItem(comp, deltaX, deltaY);
                        }
                        this._highlightcomponent = null;
                    } else {
                        this.moveItem(this._currentSelection, deltaX, deltaY);
                    }
                }
            } else if (this.isEditable() && this._selectionGroup == null) {
                this.drawSelectRect(event.getX(), event.getY());
            }
        }
        this._highlightGroup.clear();
        this._lastX = event.getX();
        this._lastY = event.getY();
        this._targetPanel.repaint();
    }

    @Override
    public void mouseMoved(JmriMouseEvent event) {
        if (this._dragging || event.isPopupTrigger() || event.isMetaDown() || event.isAltDown()) {
            return;
        }
        if (!(event.isShiftDown() && event.isControlDown() || this._shapeDrawer.doMouseMoved(event))) {
            Positionable selection = this.getCurrentSelection(event);
            if (selection != null && selection.getDisplayLevel() > 1 && selection.showToolTip()) {
                this.showToolTip(selection, event);
            } else {
                this.setToolTip(null);
            }
        }
        this._targetPanel.repaint();
    }

    @Override
    public void mouseEntered(JmriMouseEvent event) {
        this._targetPanel.repaint();
    }

    @Override
    public void mouseExited(JmriMouseEvent event) {
        this.setToolTip(null);
        this._targetPanel.repaint();
    }

    @Override
    protected void targetWindowClosingEvent(WindowEvent e) {
        this.targetWindowClosing();
    }

    @Override
    protected void paintTargetPanel(Graphics g) {
        this._shapeDrawer.paint(g);
        if (!this._highlightGroup.isEmpty()) {
            g.setColor(((Editor.TargetPane)this.getTargetPanel()).getHighlightColor());
            for (Rectangle r : this._highlightGroup) {
                g.drawRect(r.x, r.y, r.width, r.height);
            }
        }
    }

    @Override
    public void setNextLocation(Positionable obj) {
        obj.setLocation(0, 0);
    }

    @Override
    protected void copyItem(Positionable p) {
        if (log.isDebugEnabled()) {
            log.debug("Enter copyItem: _selectionGroup size={}", this._selectionGroup != null ? Integer.valueOf(this._selectionGroup.size()) : "(null)");
        }
        if (this._pastePending) {
            this.pasteItems();
        }
        if (this._selectionGroup != null && !this._selectionGroup.contains(p)) {
            this.deselectSelectionGroup();
        }
        if (this._selectionGroup == null) {
            this._selectionGroup = new ArrayList();
            this._selectionGroup.add(p);
        }
        ArrayList<Positionable> selectionGroup = new ArrayList<Positionable>();
        for (Positionable comp : this._selectionGroup) {
            Positionable pos = comp.deepClone();
            selectionGroup.add(pos);
        }
        this._selectionGroup = selectionGroup;
        this._pastePending = true;
        log.debug("Exit copyItem: _selectionGroup.size()={}", (Object)this._selectionGroup.size());
    }

    void pasteItems() {
        if (this._selectionGroup != null) {
            for (Positionable pos : this._selectionGroup) {
                NamedBean bean;
                if (pos instanceof PositionableIcon && (bean = pos.getNamedBean()) != null) {
                    ((PositionableIcon)pos).displayState(bean.getState());
                }
                try {
                    pos.setId(null);
                    this.putItem(pos);
                }
                catch (Positionable.DuplicateIdException e) {
                    log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
                }
                log.debug("Add {}", (Object)pos.getNameString());
            }
            if (this._selectionGroup.get(0) instanceof LocoIcon) {
                LocoIcon p = (LocoIcon)this._selectionGroup.get(0);
                CoordinateEdit f = new CoordinateEdit();
                f.init("Train Name", p, false);
                f.initText();
                f.setVisible(true);
                f.setLocationRelativeTo(p);
            }
        }
        this._pastePending = false;
    }

    void abortPasteItems() {
        if (log.isDebugEnabled()) {
            log.debug("abortPasteItems: _selectionGroup{}", this._selectionGroup == null ? "=null" : ".size=" + this._selectionGroup.size());
        }
        if (this._selectionGroup != null) {
            for (Positionable comp : this._selectionGroup) {
                comp.setVisible(false);
                comp.remove();
            }
        }
        this.deselectSelectionGroup();
        this._pastePending = false;
    }

    public void setCopyMenu(Positionable p, JPopupMenu popup) {
        JMenuItem edit = new JMenuItem(Bundle.getMessage("MenuItemDuplicate"));
        edit.addActionListener(new ActionListener(){
            Positionable comp;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelEditor.this.copyItem(this.comp);
            }

            ActionListener init(Positionable pos) {
                this.comp = pos;
                return this;
            }
        }.init(p));
        popup.add(edit);
    }

    @Override
    protected void setSelectionsScale(double s, Positionable p) {
        if (this._circuitBuilder.saveSelectionGroup(this._selectionGroup)) {
            p.setScale(s);
        } else {
            super.setSelectionsScale(s, p);
        }
    }

    @Override
    protected void setSelectionsRotation(int k, Positionable p) {
        if (this._circuitBuilder.saveSelectionGroup(this._selectionGroup)) {
            p.rotate(k);
        } else {
            super.setSelectionsRotation(k, p);
        }
    }

    protected void showPopUp(Positionable p, JmriMouseEvent event) {
        if (!((JComponent)((Object)p)).isVisible()) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        PositionablePopupUtil util = p.getPopupUtility();
        if (p.isEditable()) {
            if (p.doViemMenu()) {
                popup.add(p.getNameString());
                this.setPositionableMenu(p, popup);
                if (p.isPositionable()) {
                    this.setShowCoordinatesMenu(p, popup);
                    this.setShowAlignmentMenu(p, popup);
                }
                this.setDisplayLevelMenu(p, popup);
                this.setHiddenMenu(p, popup);
                this.setEmptyHiddenMenu(p, popup);
                this.setValueEditDisabledMenu(p, popup);
                this.setEditIdMenu(p, popup);
                this.setEditClassesMenu(p, popup);
                popup.addSeparator();
                this.setLogixNGPositionableMenu(p, popup);
                popup.addSeparator();
                this.setCopyMenu(p, popup);
            }
            boolean popupSet = false;
            popupSet |= p.setRotateMenu(popup);
            if (popupSet |= p.setScaleMenu(popup)) {
                popup.addSeparator();
                popupSet = false;
            }
            if (popupSet = p.setEditItemMenu(popup)) {
                popup.addSeparator();
                popupSet = false;
            }
            if (p instanceof PositionableLabel) {
                PositionableLabel pl = (PositionableLabel)p;
                if (pl.isText()) {
                    this.setColorMenu(popup, (JComponent)((Object)p), 1);
                    this.setColorMenu(popup, (JComponent)((Object)p), 2);
                    this.setColorMenu(popup, (JComponent)((Object)p), 5);
                    if (!(pl instanceof ReporterIcon) && !(pl instanceof RpsPositionIcon)) {
                        popupSet |= pl.setEditTextItemMenu(popup);
                    }
                }
            } else if (p instanceof PositionableJPanel) {
                this.setColorMenu(popup, (JComponent)((Object)p), 1);
                this.setColorMenu(popup, (JComponent)((Object)p), 2);
                this.setColorMenu(popup, (JComponent)((Object)p), 5);
                PositionableJPanel pj = (PositionableJPanel)p;
                popupSet |= pj.setEditTextItemMenu(popup);
            }
            if (p instanceof LinkingObject) {
                ((LinkingObject)((Object)p)).setLinkMenu(popup);
            }
            if (popupSet) {
                popup.addSeparator();
                popupSet = false;
            }
            p.setDisableControlMenu(popup);
            if (util != null) {
                util.setAdditionalEditPopUpMenu(popup);
            }
            p.showPopUp(popup);
            if (p.doViemMenu()) {
                this.setShowToolTipMenu(p, popup);
                this.setRemoveMenu(p, popup);
            }
        } else {
            if (p instanceof LocoIcon) {
                this.setCopyMenu(p, popup);
            }
            p.showPopUp(popup);
            if (util != null) {
                util.setAdditionalViewPopUpMenu(popup);
            }
        }
        popup.show((Component)((Object)p), p.getWidth() / 2 + (int)((this.getPaintScale() - 1.0) * (double)p.getX()), p.getHeight() / 2 + (int)((this.getPaintScale() - 1.0) * (double)p.getY()));
        this._currentSelection = null;
    }

    public void setColorMenu(JPopupMenu popup, JComponent pos, int type) {
        String title;
        switch (type) {
            case 1: {
                title = "SetBorderSizeColor";
                break;
            }
            case 2: {
                title = "SetMarginSizeColor";
                break;
            }
            case 5: {
                title = "SetFontSizeColor";
                break;
            }
            case 6: {
                title = "SetTextSizeColor";
                break;
            }
            default: {
                String title2 = "untitled";
                return;
            }
        }
        JMenuItem edit = new JMenuItem(Bundle.getMessage(title));
        edit.addActionListener(event -> new ColorDialog((Frame)this, pos, type, null));
        popup.add(edit);
    }

    protected void disableMenus() {
        this._drawMenu.setEnabled(false);
        this._warrantMenu.setEnabled(false);
        this._iconMenu.setEnabled(false);
        this._zoomMenu.setEnabled(false);
        this._optionMenu.setEnabled(false);
        this._editMenu.setEnabled(false);
        this._fileMenu.setEnabled(false);
        this._disablePortalSelection = false;
    }

    public void resetEditor() {
        this._drawMenu.setEnabled(true);
        this._warrantMenu.setEnabled(true);
        this._iconMenu.setEnabled(true);
        this._zoomMenu.setEnabled(true);
        this._optionMenu.setEnabled(true);
        this._editMenu.setEnabled(true);
        this._fileMenu.setEnabled(true);
        this.highlight(null);
        Editor.TargetPane targetPane = (Editor.TargetPane)this.getTargetPanel();
        targetPane.setDefaultColors();
        targetPane.revalidate();
        this.setSelectionGroup(null);
        this._disablePortalSelection = true;
    }

    protected void highlight(Positionable pos) {
        if (pos == null) {
            this._highlightGroup.clear();
            this._highlightcomponent = null;
        } else {
            Rectangle rect;
            this._highlightcomponent = rect = new Rectangle(pos.getX(), pos.getY(), pos.maxWidth(), pos.maxHeight());
            if (!this._dragging) {
                this._highlightGroup.add(rect);
            }
        }
        this.repaint();
    }

    protected void setSelectionGroup(ArrayList<Positionable> group) {
        this._highlightcomponent = null;
        this._selectionGroup = group;
        this.repaint();
    }

    protected ArrayList<Positionable> getSelectionGroup() {
        return this._selectionGroup;
    }

    protected void makeDataFlavors() {
        try {
            this._positionableDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable");
            this._namedIconDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.catalog.NamedIcon");
            this._positionableListDataFlavor = new DataFlavor(List.class, "JComponentList");
        }
        catch (ClassNotFoundException cnfe) {
            log.error("Unable to find class supporting {}", (Object)"application/x-java-jvm-local-objectref;class=jmri.jmrit.catalog.NamedIcon", (Object)cnfe);
        }
        new DropTarget(this, 3, this);
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        block25: {
            try {
                Point pt = this._targetPanel.getMousePosition(true);
                if (pt == null) {
                    return;
                }
                Transferable tr = evt.getTransferable();
                if (log.isDebugEnabled()) {
                    DataFlavor[] flavors = tr.getTransferDataFlavors();
                    StringBuilder flavor = new StringBuilder();
                    for (DataFlavor flavor1 : flavors) {
                        flavor.append(flavor1.getRepresentationClass().getName()).append(", ");
                    }
                    log.debug("Editor Drop: flavor classes={}", (Object)flavor);
                }
                if (tr.isDataFlavorSupported(this._positionableDataFlavor)) {
                    Positionable item = (Positionable)tr.getTransferData(this._positionableDataFlavor);
                    if (item == null) {
                        return;
                    }
                    item.setLocation((int)Math.round((double)pt.x / this.getPaintScale()), (int)Math.round((double)pt.y / this.getPaintScale()));
                    item.setDisplayLevel(item.getDisplayLevel());
                    item.setEditor(this);
                    try {
                        this.putItem(item);
                    }
                    catch (Positionable.DuplicateIdException e) {
                        log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
                    }
                    item.updateSize();
                    this._circuitBuilder.doMouseReleased(item, true);
                    evt.dropComplete(true);
                    return;
                }
                if (tr.isDataFlavorSupported(this._namedIconDataFlavor)) {
                    NamedIcon newIcon = new NamedIcon((NamedIcon)tr.getTransferData(this._namedIconDataFlavor));
                    String url = newIcon.getURL();
                    NamedIcon icon = NamedIcon.getIconByName(url);
                    PositionableLabel ni = new PositionableLabel(icon, (Editor)this);
                    assert (icon != null);
                    if (icon.getIconHeight() > 500 || icon.getIconWidth() > 600) {
                        ni.setDisplayLevel(1);
                    } else {
                        ni.setDisplayLevel(3);
                    }
                    ni.setLocation((int)Math.round((double)pt.x / this.getPaintScale()), (int)Math.round((double)pt.y / this.getPaintScale()));
                    ni.setEditor(this);
                    try {
                        this.putItem(ni);
                    }
                    catch (Positionable.DuplicateIdException e) {
                        log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
                    }
                    ni.updateSize();
                    evt.dropComplete(true);
                    return;
                }
                if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String text = (String)tr.getTransferData(DataFlavor.stringFlavor);
                    PositionableLabel l = new PositionableLabel(text, (Editor)this);
                    l.setSize(l.getPreferredSize().width, l.getPreferredSize().height);
                    l.setDisplayLevel(4);
                    l.setLocation((int)Math.round((double)pt.x / this.getPaintScale()), (int)Math.round((double)pt.y / this.getPaintScale()));
                    l.setEditor(this);
                    try {
                        this.putItem(l);
                    }
                    catch (Positionable.DuplicateIdException e) {
                        log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
                    }
                    evt.dropComplete(true);
                    break block25;
                }
                if (tr.isDataFlavorSupported(this._positionableListDataFlavor)) {
                    List dragGroup = (List)tr.getTransferData(this._positionableListDataFlavor);
                    for (Positionable pos : dragGroup) {
                        pos.setEditor(this);
                        pos.setLocation((int)Math.round((double)pt.x / this.getPaintScale()), (int)Math.round((double)pt.y / this.getPaintScale()));
                        try {
                            this.putItem(pos);
                        }
                        catch (Positionable.DuplicateIdException ignore) {
                            try {
                                pos.setId(null);
                                this.putItem(pos);
                            }
                            catch (Positionable.DuplicateIdException e) {
                                log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
                            }
                        }
                        pos.updateSize();
                        log.debug("DnD Add {}", (Object)pos.getNameString());
                    }
                    break block25;
                }
                log.warn("Editor DropTargetListener supported DataFlavors not available at drop from {}", (Object)tr.getClass().getName());
            }
            catch (IOException ioe) {
                log.warn("Editor DropTarget caught IOException", (Throwable)ioe);
            }
            catch (UnsupportedFlavorException ufe) {
                log.warn("Editor DropTarget caught UnsupportedFlavorException", (Throwable)ufe);
            }
        }
        log.debug("Editor DropTargetListener drop REJECTED!");
        evt.rejectDrop();
    }

    protected static class PositionableListDnD
    implements Transferable {
        List<Positionable> _sourceEditor;
        DataFlavor _dataFlavor;

        PositionableListDnD(List<Positionable> source) {
            this._sourceEditor = source;
            this._dataFlavor = new DataFlavor(List.class, "JComponentList");
        }

        @Override
        @Nonnull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            log.debug("PositionableListDnD.getTransferData:");
            if (flavor.equals(this._dataFlavor)) {
                return this._sourceEditor;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this._dataFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(this._dataFlavor);
        }
    }
}

