/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.IndicatorTrackIcon;
import jmri.jmrit.display.IndicatorTurnoutIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.TurnoutIcon;
import jmri.jmrit.display.controlPanelEditor.Bundle;
import jmri.jmrit.display.controlPanelEditor.CircuitBuilder;
import jmri.jmrit.display.palette.FamilyItemPanel;
import jmri.jmrit.display.palette.IndicatorItemPanel;
import jmri.jmrit.display.palette.IndicatorTOItemPanel;
import jmri.jmrit.logix.OBlock;
import jmri.util.PlaceWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConvertDialog
extends JDialog {
    private final CircuitBuilder _parent;
    private final PositionableLabel _pos;
    FamilyItemPanel _panel;
    DisplayFrame _filler;
    private static final Logger log = LoggerFactory.getLogger(ConvertDialog.class);

    ConvertDialog(CircuitBuilder cb, PositionableLabel pos, OBlock block) {
        super((Frame)cb._editor, true);
        ActionListener updateAction;
        String title;
        this._parent = cb;
        this._pos = pos;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConvertDialog.this._parent._editor.highlight(null);
            }
        });
        if (pos == null) {
            this.dispose();
            return;
        }
        this._filler = pos.makePaletteFrame("Dummy");
        if (pos instanceof TurnoutIcon) {
            title = "IndicatorTO";
            this._panel = new IndicatorTOItemPanel(this._filler, title, null, null){

                @Override
                protected void showIcons() {
                    super.showIcons();
                    ConvertDialog.this.displayIcons();
                }

                @Override
                protected void hideIcons() {
                    super.hideIcons();
                    ConvertDialog.this.displayIcons();
                }
            };
            updateAction = a -> this.convertTO(block);
        } else {
            title = "IndicatorTrack";
            this._panel = new IndicatorItemPanel(this._filler, title, null){

                @Override
                protected void showIcons() {
                    super.showIcons();
                    ConvertDialog.this.displayIcons();
                }

                @Override
                protected void hideIcons() {
                    super.hideIcons();
                    ConvertDialog.this.displayIcons();
                }
            };
            updateAction = a -> this.convertSeg(block);
        }
        JPanel p = new JPanel();
        p.add(new JLabel(Bundle.getMessage("notIndicatorIcon")));
        this._panel.add(p);
        this._panel.init(this.makeBottomPanel(updateAction, block));
        Dimension dim = this._panel.getPreferredSize();
        JScrollPane sp = new JScrollPane(this._panel);
        dim = new Dimension(dim.width + 25, dim.height + 25);
        sp.setPreferredSize(dim);
        sp.setPreferredSize(dim);
        this.add(sp);
        this.setTitle(Bundle.getMessage(title));
        this.pack();
        InstanceManager.getDefault(PlaceWindow.class).nextTo(cb._editor, pos, this);
        this.setVisible(true);
    }

    private JPanel makeBottomPanel(ActionListener updateAction, OBlock block) {
        JPanel panel = new JPanel();
        JButton button = new JButton(Bundle.getMessage("convert"));
        button.addActionListener(updateAction);
        panel.add(button);
        button = new JButton(Bundle.getMessage("skip"));
        button.addActionListener(a -> this.dispose());
        panel.add(button);
        return panel;
    }

    private void displayIcons() {
        Dimension newDim = this._panel.getPreferredSize();
        Dimension deltaDim = this._panel.shellDimension(this._panel);
        Dimension dim = new Dimension(deltaDim.width + newDim.width, deltaDim.height + newDim.height);
        this.setPreferredSize(dim);
        this.invalidate();
        this.pack();
    }

    private void convertTO(OBlock block) {
        IndicatorTurnoutIcon t = new IndicatorTurnoutIcon(this._parent._editor);
        t.setOccBlockHandle(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(block.getSystemName(), block));
        if (this._pos instanceof TurnoutIcon) {
            t.setTurnout(((TurnoutIcon)this._pos).getNamedTurnout());
        }
        t.setFamily(this._panel.getFamilyName());
        HashMap<String, HashMap<String, NamedIcon>> iconMap = ((IndicatorTOItemPanel)this._panel).getIconMaps();
        for (Map.Entry<String, HashMap<String, NamedIcon>> entry : iconMap.entrySet()) {
            String status = entry.getKey();
            for (Map.Entry<String, NamedIcon> ent : entry.getValue().entrySet()) {
                t.setIcon(status, ent.getKey(), new NamedIcon(ent.getValue()));
            }
        }
        t.setLevel(7);
        t.setScale(this._pos.getScale());
        t.rotate(this._pos.getDegrees());
        this.finishConvert(t, block);
    }

    private void convertSeg(OBlock block) {
        IndicatorTrackIcon t = new IndicatorTrackIcon(this._parent._editor);
        t.setOccBlockHandle(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(block.getSystemName(), block));
        t.setFamily(this._panel.getFamilyName());
        HashMap<String, NamedIcon> iconMap = this._panel.getIconMap();
        for (Map.Entry<String, NamedIcon> entry : iconMap.entrySet()) {
            t.setIcon(entry.getKey(), new NamedIcon(entry.getValue()));
        }
        t.setLevel(7);
        t.setScale(this._pos.getScale());
        t.rotate(this._pos.getDegrees());
        this.finishConvert(t, block);
    }

    private void finishConvert(Positionable pos, OBlock block) {
        ArrayList<Positionable> selectionGroup = this._parent._editor.getSelectionGroup();
        selectionGroup.remove(this._pos);
        selectionGroup.add(pos);
        ArrayList<Positionable> circuitIcons = this._parent.getCircuitIcons(block);
        circuitIcons.remove(this._pos);
        circuitIcons.add(pos);
        pos.setLocation(this._pos.getLocation());
        this._pos.remove();
        try {
            this._parent._editor.putItem(pos);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() has thrown DuplicateIdException", (Throwable)e);
        }
        pos.updateSize();
        this._parent._editor.highlight(null);
        this.dispose();
        this._filler.dispose();
    }
}

