/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrit.display.IndicatorTrack;
import jmri.jmrit.display.IndicatorTrackIcon;
import jmri.jmrit.display.IndicatorTurnoutIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.ToolTip;
import jmri.jmrit.display.TurnoutIcon;
import jmri.jmrit.display.controlPanelEditor.Bundle;
import jmri.jmrit.display.controlPanelEditor.CircuitBuilder;
import jmri.jmrit.display.controlPanelEditor.EditFrame;
import jmri.jmrit.display.controlPanelEditor.LengthPanel;
import jmri.jmrit.display.controlPanelEditor.OpenPickListButton;
import jmri.jmrit.display.controlPanelEditor.PortalIcon;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditCircuitFrame
extends EditFrame
implements PropertyChangeListener {
    private JTextField _systemName;
    private JTextField _blockName;
    private JTextField _detectorSensorName;
    private JTextField _errorSensorName;
    private JTextField _blockState;
    private JTextField _numTrackSeg;
    private JTextField _numTurnouts;
    private LengthPanel _lengthPanel;
    private JPanel _namePanel;
    private boolean _create;
    OpenPickListButton<Sensor> _pickTable;
    private static final Logger log = LoggerFactory.getLogger(EditCircuitFrame.class);

    public EditCircuitFrame(String title, CircuitBuilder parent, OBlock block) {
        super(title, parent, block);
        this._create = block == null;
        this.updateContentPanel(this._create);
        this._homeBlock.addPropertyChangeListener("deleted", this);
        this.pack();
    }

    @Override
    protected JPanel makeContentPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this._blockName = new JTextField();
        this._detectorSensorName = new JTextField();
        this._errorSensorName = new JTextField();
        this._blockState = new JTextField();
        this._numTrackSeg = new JTextField();
        this._numTurnouts = new JTextField();
        JPanel p = new JPanel();
        p.add(new JLabel(Bundle.getMessage("AddRemoveIcons")));
        contentPane.add(p);
        contentPane.add(Box.createVerticalStrut(STRUT_SIZE));
        JPanel panel = new JPanel();
        panel.add(CircuitBuilder.makeTextBoxPanel(false, this._blockState, "blockState", false, null));
        this._blockState.setPreferredSize(new Dimension(150, this._blockState.getPreferredSize().height));
        contentPane.add(panel);
        this._namePanel = new JPanel();
        this._namePanel.setLayout(new BoxLayout(this._namePanel, 1));
        contentPane.add(this._namePanel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel _buttonPanel = new JPanel();
        _buttonPanel.setLayout(new FlowLayout());
        panel.add(_buttonPanel);
        contentPane.add(panel);
        contentPane.add(Box.createVerticalStrut(STRUT_SIZE));
        p = new JPanel();
        p.add(new JLabel(Bundle.getMessage("numTrackElements")));
        contentPane.add(p);
        panel = new JPanel();
        panel.add(Box.createHorizontalGlue());
        panel.add(CircuitBuilder.makeTextBoxPanel(false, this._numTrackSeg, "Segments", false, null));
        this._numTrackSeg.setPreferredSize(new Dimension(20, this._numTrackSeg.getPreferredSize().height));
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        panel.add(CircuitBuilder.makeTextBoxPanel(false, this._numTurnouts, "Turnouts", false, null));
        this._numTurnouts.setPreferredSize(new Dimension(20, this._numTurnouts.getPreferredSize().height));
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        contentPane.add(panel);
        contentPane.add(Box.createVerticalStrut(STRUT_SIZE));
        panel = new JPanel();
        this._detectorSensorName.setPreferredSize(new Dimension(300, this._detectorSensorName.getPreferredSize().height));
        panel.add(CircuitBuilder.makeTextBoxPanel(false, this._detectorSensorName, "DetectionSensor", true, "detectorSensorName"));
        this._detectorSensorName.setToolTipText(Bundle.getMessage("detectorSensorName"));
        contentPane.add(panel);
        panel = new JPanel();
        this._errorSensorName.setPreferredSize(new Dimension(300, this._errorSensorName.getPreferredSize().height));
        panel.add(CircuitBuilder.makeTextBoxPanel(false, this._errorSensorName, "ErrorSensor", true, "detectorErrorName"));
        this._errorSensorName.setToolTipText(Bundle.getMessage("detectorErrorName"));
        contentPane.add(panel);
        String[] blurbLines = new String[]{Bundle.getMessage("DragOccupancySensor", Bundle.getMessage("DetectionSensor")), Bundle.getMessage("DragErrorName", Bundle.getMessage("ErrorSensor"))};
        this._pickTable = new OpenPickListButton<Sensor>(blurbLines, PickListModel.sensorPickModelInstance(), this, Bundle.getMessage("OpenPicklist", Bundle.getMessage("BeanNameSensor")));
        contentPane.add(this._pickTable.getButtonPanel());
        contentPane.add(Box.createVerticalStrut(STRUT_SIZE));
        this._lengthPanel = new LengthPanel(this._homeBlock, "blockLength", "TooltipPathLength");
        this._lengthPanel.changeUnits();
        this._lengthPanel.setLength(this._homeBlock.getLengthMm());
        contentPane.add(this._lengthPanel);
        contentPane.add(Box.createVerticalStrut(STRUT_SIZE));
        contentPane.add(this.makeDoneButtonPanel());
        return contentPane;
    }

    private JPanel makeCreateBlockPanel() {
        this._systemName = new JTextField();
        this._systemName.setText(this._homeBlock.getSystemName());
        this._blockName.setText(this._homeBlock.getUserName());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(CircuitBuilder.makeTextBoxPanel(false, this._systemName, "ColumnSystemName", true, "TooltipBlockName"));
        this._systemName.setPreferredSize(new Dimension(300, this._systemName.getPreferredSize().height));
        panel.add(CircuitBuilder.makeTextBoxPanel(false, this._blockName, "blockName", true, "TooltipBlockName"));
        this._blockName.setPreferredSize(new Dimension(300, this._blockName.getPreferredSize().height));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton createButton = new JButton(Bundle.getMessage("buttonCreate"));
        createButton.addActionListener(a -> this.createBlock());
        createButton.setToolTipText(Bundle.getMessage("createOBlock"));
        buttonPanel.add(createButton);
        panel.add(buttonPanel);
        panel.add(Box.createVerticalStrut(STRUT_SIZE));
        return panel;
    }

    private JPanel makeEditBlockPanel() {
        this._blockName.setText(this._homeBlock.getUserName());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(CircuitBuilder.makeTextBoxPanel(false, this._blockName, "blockName", true, "TooltipBlockName"));
        this._blockName.setPreferredSize(new Dimension(300, this._blockName.getPreferredSize().height));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton changeButton = new JButton(Bundle.getMessage("buttonChangeName"));
        changeButton.addActionListener(a -> this.changeBlockName());
        changeButton.setToolTipText(Bundle.getMessage("ToolTipChangeName"));
        buttonPanel.add(changeButton);
        JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
        deleteButton.addActionListener(a -> this.deleteCircuit());
        deleteButton.setToolTipText(Bundle.getMessage("ToolTipDeleteCircuit"));
        buttonPanel.add(deleteButton);
        panel.add(buttonPanel);
        panel.add(Box.createVerticalStrut(STRUT_SIZE));
        return panel;
    }

    @Override
    protected JPanel makeDoneButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton convertButton = new JButton(Bundle.getMessage("ButtonConvertIcon"));
        convertButton.addActionListener(a -> this.convertIcons());
        convertButton.setToolTipText(Bundle.getMessage("ToolTipConvertIcon"));
        panel.add(convertButton);
        JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
        doneButton.addActionListener(a -> {
            if (this._create) {
                this.closeCreate();
            } else {
                this.closingEvent(false);
            }
        });
        panel.add(doneButton);
        buttonPanel.add(panel);
        return buttonPanel;
    }

    private void convertIcons() {
        this._parent.setIconGroup(this._homeBlock);
        this._parent.queryConvertTrackIcons(this._homeBlock, "PortalOrPath");
        this.toFront();
    }

    private void createBlock() {
        OBlock block;
        String userName = this._blockName.getText().trim();
        String systemName = this._systemName.getText().trim();
        OBlockManager mgr = InstanceManager.getDefault(OBlockManager.class);
        StringBuilder sb = new StringBuilder();
        if (userName.length() > 0 && (block = (OBlock)mgr.getByUserName(userName)) != null) {
            sb.append(Bundle.getMessage("duplicateName", userName, block.getSystemName()));
            sb.append("\n");
        }
        if (!mgr.isValidSystemNameFormat(systemName)) {
            sb.append(Bundle.getMessage("sysnameOBlock"));
            sb.append("\n");
        } else {
            block = (OBlock)mgr.getBySystemName(systemName);
            if (block != null) {
                sb.append(Bundle.getMessage("duplicateName", systemName, block.getUserName()));
                sb.append("\n");
            }
        }
        if (sb.toString().length() > 0) {
            JmriJOptionPane.showMessageDialog(this, sb.toString(), Bundle.getMessage("editCiruit"), 1);
            this._systemName.setText(this._homeBlock.getSystemName());
            return;
        }
        this._homeBlock = mgr.createNewOBlock(systemName, userName);
        this.updateContentPanel(false);
    }

    private void changeBlockName() {
        String name = this._blockName.getText().trim();
        String msg = null;
        if (name.length() == 0) {
            msg = Bundle.getMessage("TooltipBlockName");
        } else {
            OBlock block = (OBlock)InstanceManager.getDefault(OBlockManager.class).getByUserName(name);
            if (block != null) {
                msg = Bundle.getMessage("duplicateName", name, block.getDisplayName(NamedBean.DisplayOptions.QUOTED_USERNAME_SYSTEMNAME));
            }
        }
        if (msg != null) {
            JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("editCiruit"), 1);
            return;
        }
        this._homeBlock.setUserName(name);
        for (Positionable p : this._parent.getCircuitIcons(this._homeBlock)) {
            if (!(p instanceof PortalIcon)) continue;
            PortalIcon icon = (PortalIcon)p;
            Portal portal = icon.getPortal();
            icon.setName(portal.getName());
            icon.setToolTip(new ToolTip(portal.getDescription(), 0, 0, icon));
        }
    }

    private void deleteCircuit() {
        int result = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("confirmBlockDelete"), Bundle.getMessage("editCiruit"), 0, 3);
        if (result == 0) {
            this._parent.removeBlock(this._homeBlock);
            this.closingEvent(true, null);
        }
    }

    private void updateContentPanel(boolean create) {
        JPanel panel;
        this.updateIconList(this._parent._editor.getSelectionGroup());
        String name = "";
        Sensor sensor = this._homeBlock.getSensor();
        if (sensor != null) {
            name = sensor.getDisplayName();
            this._detectorSensorName.setText(name);
        }
        if ((sensor = this._homeBlock.getErrorSensor()) != null) {
            name = sensor.getDisplayName();
            this._errorSensorName.setText(name);
        }
        int state = this._homeBlock.getState();
        StringBuilder stateText = new StringBuilder();
        if ((state & 1) != 0) {
            stateText.append("Unknown ");
        }
        if ((state & 2) != 0) {
            stateText.append("Occupied ");
        }
        if ((state & 4) != 0) {
            stateText.append("Unoccupied ");
        }
        if ((state & 8) != 0) {
            stateText.append("Inconsistent ");
        }
        if ((state & 0x10) != 0) {
            stateText.append("Allocated ");
        }
        if ((state & 0x20) != 0) {
            stateText.append("Positioned ");
        }
        if ((state & 0x40) != 0) {
            stateText.append("OutOf Service ");
        }
        if ((state & 0x100) != 0) {
            stateText.append("Dark ");
        }
        if ((state & 0x80) != 0) {
            stateText.append("TrackError ");
        }
        if (state == 0) {
            stateText.append("Not Initialized");
        }
        if (log.isDebugEnabled()) {
            log.debug("updateContentPanel: state= {}", (Object)stateText);
        }
        this._blockState.setText(stateText.toString());
        if (create) {
            panel = this.makeCreateBlockPanel();
        } else {
            panel = this.makeEditBlockPanel();
            this._create = false;
        }
        this._namePanel.removeAll();
        this._namePanel.add(panel);
        this._namePanel.invalidate();
        this.pack();
    }

    private void closeCreate() {
        StringBuilder sb = new StringBuilder();
        String sysName = this._homeBlock.getSystemName();
        OBlock block = (OBlock)InstanceManager.getDefault(OBlockManager.class).getBySystemName(sysName);
        if (block == null) {
            for (Positionable pos : this._parent.getCircuitIcons(this._homeBlock)) {
                if (!(pos instanceof IndicatorTrack)) continue;
                ((IndicatorTrack)pos).setOccBlockHandle(null);
            }
            this._parent._editor.getSelectionGroup().clear();
            sb.append(Bundle.getMessage("notCreated", this._systemName.getText().trim()));
            this.closingEvent(false, sb.toString());
            if (this._pickTable != null) {
                this._pickTable.closePickList();
            }
        } else {
            this.closingEvent(false);
        }
    }

    @Override
    protected void closingEvent(boolean close) {
        String name;
        StringBuffer sb = new StringBuffer();
        String msg = this.checkForSensors();
        if (msg != null) {
            sb.append(msg);
            sb.append("\n");
        }
        if ((name = this._blockName.getText().trim()).length() == 0) {
            msg = Bundle.getMessage("blankUserName");
            if (msg != null) {
                sb.append(msg);
                sb.append("\n");
            }
        } else if (!name.equals(this._homeBlock.getUserName()) && (msg = Bundle.getMessage("changeBlockName", name, this._homeBlock.getDisplayName(NamedBean.DisplayOptions.QUOTED_USERNAME_SYSTEMNAME))) != null) {
            sb.append(msg);
            sb.append("\n");
        }
        this._parent.setIconGroup(this._homeBlock);
        msg = this._parent.checkForTrackIcons(this._homeBlock, "PortalOrPath");
        if (msg.length() > 0) {
            sb.append(msg);
            sb.append("\n");
        }
        if ((double)this._lengthPanel.getLength() <= 0.001) {
            msg = Bundle.getMessage("noBlockLength");
            if (msg != null) {
                sb.append(msg);
                sb.append("\n");
            }
        } else {
            this._homeBlock.setLength(this._lengthPanel.getLength());
        }
        this.closingEvent(close, sb.toString());
        if (this._pickTable != null) {
            this._pickTable.closePickList();
        }
    }

    private String checkForSensors() {
        Sensor sensor;
        String name = this._detectorSensorName.getText();
        String errName = this._errorSensorName.getText();
        if (!this._homeBlock.setSensor(name)) {
            return MessageFormat.format(Bundle.getMessage("badSensorName"), name);
        }
        if (errName.length() > 2) {
            if (this._homeBlock.getSensor() == null) {
                int result = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("mixedSensors"), Bundle.getMessage("noSensor"), 0, 3);
                if (result == 0) {
                    if (!this._homeBlock.setSensor(errName)) {
                        return MessageFormat.format(Bundle.getMessage("badSensorName"), errName);
                    }
                    this._homeBlock.setErrorSensor(null);
                    this._detectorSensorName.setText(this._homeBlock.getSensor().getDisplayName());
                    this._errorSensorName.setText(null);
                } else if (!this._homeBlock.setErrorSensor(errName)) {
                    return MessageFormat.format(Bundle.getMessage("badSensorName"), errName);
                }
            } else if (!this._homeBlock.setErrorSensor(errName)) {
                return MessageFormat.format(Bundle.getMessage("badSensorName"), errName);
            }
        } else if (errName.trim().length() == 0) {
            this._homeBlock.setErrorSensor(null);
        }
        if ((sensor = this._homeBlock.getSensor()) == null) {
            return Bundle.getMessage("noDetecterSensor");
        }
        if (sensor.equals(this._homeBlock.getErrorSensor())) {
            this._homeBlock.setErrorSensor(null);
            this._errorSensorName.setText(null);
            return MessageFormat.format(Bundle.getMessage("DuplSensorRemoved"), sensor.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME));
        }
        return null;
    }

    protected void updateIconList(List<Positionable> icons) {
        int segments = 0;
        int turnouts = 0;
        if (icons != null) {
            if (log.isDebugEnabled()) {
                log.debug("updateIconList: icons.size()= {}", (Object)icons.size());
            }
            for (Positionable pos : icons) {
                if (pos instanceof IndicatorTurnoutIcon) {
                    ++turnouts;
                    continue;
                }
                if (pos instanceof IndicatorTrackIcon) {
                    ++segments;
                    continue;
                }
                if (pos instanceof TurnoutIcon) {
                    ++turnouts;
                    continue;
                }
                ++segments;
            }
        }
        this._numTrackSeg.setText(String.valueOf(segments));
        this._numTurnouts.setText(String.valueOf(turnouts));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("deleted")) {
            this.closingEvent(true, null);
        }
    }
}

