/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import jmri.InstanceManager;
import jmri.jmrit.display.controlPanelEditor.Bundle;
import jmri.jmrit.display.controlPanelEditor.CircuitBuilder;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.util.JmriJFrame;
import jmri.util.PlaceWindow;
import jmri.util.swing.JmriJOptionPane;

public abstract class EditFrame
extends JmriJFrame {
    protected OBlock _homeBlock;
    protected final CircuitBuilder _parent;
    protected boolean _canEdit = true;
    protected boolean _suppressWarnings = false;
    static int STRUT_SIZE = 10;

    public EditFrame(String title, CircuitBuilder parent, OBlock block) {
        super(false, false);
        this._parent = parent;
        if (block != null) {
            this.setTitle(MessageFormat.format(title, block.getDisplayName()));
            this._homeBlock = block;
        } else {
            this.setTitle(Bundle.getMessage("newCircuitItem"));
            this._homeBlock = new OBlock(InstanceManager.getDefault(OBlockManager.class).getAutoSystemName(), null);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditFrame.this.closingEvent(true);
            }
        });
        this.addHelpMenu("package.jmri.jmrit.display.CircuitBuilder", true);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        Border padding = BorderFactory.createEmptyBorder(10, 5, 4, 5);
        contentPane.setBorder(padding);
        contentPane.add(new JScrollPane(this.makeContentPanel()));
        this.setContentPane(contentPane);
        this.pack();
        InstanceManager.getDefault(PlaceWindow.class).nextTo(this._parent._editor, null, this);
        this.setVisible(true);
    }

    protected abstract JPanel makeContentPanel();

    protected JPanel makeDoneButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
        doneButton.addActionListener(a -> this.closingEvent(false));
        panel.add(doneButton);
        buttonPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(buttonPanel);
        return panel;
    }

    protected void checkCircuitIcons(String editType) {
        StringBuilder sb = new StringBuilder();
        String msg = this._parent.checkForTrackIcons(this._homeBlock, editType);
        if (msg.length() > 0) {
            this._canEdit = false;
            sb.append(msg);
            sb.append("\n");
        }
        if ((msg = this._parent.checkForPortals(this._homeBlock, editType)).length() > 0) {
            this._canEdit = false;
            sb.append(msg);
            sb.append("\n");
        }
        if ((msg = this._parent.checkForPortalIcons(this._homeBlock, editType)).length() > 0) {
            this._canEdit = false;
            sb.append(msg);
        }
        if (!this._canEdit) {
            JmriJOptionPane.showMessageDialog(this, sb.toString(), Bundle.getMessage("incompleteCircuit"), 1);
        }
    }

    protected void clearListSelection() {
    }

    protected boolean canEdit() {
        if (!this._canEdit) {
            this.closingEvent(true, null);
        }
        return this._canEdit;
    }

    protected abstract void closingEvent(boolean var1);

    protected boolean closingEvent(boolean close, String msg) {
        if (msg != null && msg.length() > 0) {
            if (close) {
                JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("editCiruit"), 1);
            } else {
                StringBuilder sb = new StringBuilder(msg);
                sb.append(Bundle.getMessage("exitQuestion"));
                int answer = JmriJOptionPane.showConfirmDialog(this, sb.toString(), Bundle.getMessage("continue"), 0, 3);
                if (answer != 0) {
                    return false;
                }
            }
        }
        this._parent.closeCircuitBuilder(this._homeBlock);
        this.dispose();
        return true;
    }
}

