/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.CoordinateEdit;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableIcon;
import jmri.jmrit.display.ToolTip;
import jmri.jmrit.display.controlPanelEditor.Bundle;
import jmri.jmrit.display.controlPanelEditor.ControlPanelEditor;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.logix.Portal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalIcon
extends PositionableIcon
implements PropertyChangeListener {
    public static final String HIDDEN = "hidden";
    public static final String VISIBLE = "block";
    public static final String PATH = "path";
    public static final String TO_ARROW = "toArrow";
    public static final String FROM_ARROW = "fromArrow";
    private Portal _portal;
    private String _status = "hidden";
    private boolean _regular = true;
    private boolean _hide = false;
    private static final Logger log = LoggerFactory.getLogger(PortalIcon.class);

    public PortalIcon(Editor editor) {
        super(editor);
        this.makeIconMap();
    }

    public PortalIcon(Editor editor, Portal portal) {
        this(editor);
        this.setPortal(portal);
    }

    public static HashMap<String, NamedIcon> getPaletteMap() {
        HashMap<String, NamedIcon> iconMap;
        block1: {
            HashMap<String, NamedIcon> map;
            Iterator<HashMap<String, NamedIcon>> iterator;
            HashMap<String, HashMap<String, NamedIcon>> families = ItemPalette.getFamilyMaps("Portal");
            if (families.keySet().isEmpty()) {
                log.debug("Adding missing PortalIconMap");
                ItemPalette.loadMissingItemType("Portal");
                families = ItemPalette.getFamilyMaps("Portal");
            }
            if ((iconMap = families.get("Standard")) != null || !(iterator = families.values().iterator()).hasNext()) break block1;
            iconMap = map = iterator.next();
        }
        return PortalIcon.cloneMap(iconMap, null);
    }

    public void makeIconMap() {
        this._iconMap = ((ControlPanelEditor)this._editor).getPortalIconMap();
        int deg = this.getDegrees();
        if (!this._regular) {
            NamedIcon a = (NamedIcon)this._iconMap.get(TO_ARROW);
            NamedIcon b = (NamedIcon)this._iconMap.get(FROM_ARROW);
            this._iconMap.put(FROM_ARROW, a);
            this._iconMap.put(TO_ARROW, b);
        }
        this.setScale(this.getScale());
        this.rotate(deg);
        this.setIcon((NamedIcon)this._iconMap.get(HIDDEN));
    }

    @Override
    public String getFamily() {
        return ((ControlPanelEditor)this._editor).getPortalIconFamily();
    }

    protected void setMap(HashMap<String, NamedIcon> map) {
        this._iconMap = map;
    }

    @Override
    @Nonnull
    public Positionable deepClone() {
        PortalIcon pos = new PortalIcon(this._editor, this.getPortal());
        return this.finishClone(pos);
    }

    protected Positionable finishClone(PortalIcon pos) {
        pos._regular = this._regular;
        pos._hide = this._hide;
        pos._status = this._status;
        return super.finishClone(pos);
    }

    public void setIcon(String name, NamedIcon ic) {
        if (log.isDebugEnabled()) {
            log.debug("Icon {} put icon key= \"{}\" icon= {}", new Object[]{this.getPortal().getName(), name, ic});
        }
        NamedIcon icon = PortalIcon.cloneIcon(ic, this);
        icon.scale(this.getScale(), this);
        icon.rotate(this.getDegrees(), this);
        this._iconMap.put(name, icon);
    }

    public void setArrowOrientation(boolean set) {
        if (log.isDebugEnabled()) {
            log.debug("Icon {} setArrowOrientation regular={} from {}", new Object[]{this.getPortal().getName(), set, this._regular});
        }
        this._regular = set;
    }

    public void setHideArrows(boolean set) {
        if (log.isDebugEnabled()) {
            log.debug("Icon {} setHideArrows hide={} from {}", new Object[]{this.getPortal().getName(), set, this._hide});
        }
        this._hide = set;
    }

    public boolean getArrowSwitch() {
        return this._regular;
    }

    public boolean getArrowHide() {
        return this._hide;
    }

    public Portal getPortal() {
        return this._portal;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Portals always have userNames")
    public void setPortal(Portal portal) {
        if (portal == null) {
            return;
        }
        if (this._portal != null) {
            this._portal.removePropertyChangeListener(this);
        }
        this._portal = portal;
        this._portal.addPropertyChangeListener(this);
        this.setToolTip(new ToolTip(this._portal.getDescription(), 0, 0, this));
    }

    public void setStatus(String status) {
        this.setIcon((NamedIcon)this._iconMap.get(status));
        this._status = status;
        this.updateSize();
        this.repaint();
    }

    public String getStatus() {
        return this._status;
    }

    @Override
    public void remove() {
        ((ControlPanelEditor)this._editor).getCircuitBuilder().deletePortalIcon(this);
        super.remove();
    }

    @Override
    public void displayState(int state) {
        switch (state) {
            case 2: {
                if (this._hide) {
                    this.setStatus(HIDDEN);
                    break;
                }
                this.setStatus(TO_ARROW);
                break;
            }
            case 4: {
                if (this._hide) {
                    this.setStatus(HIDDEN);
                    break;
                }
                this.setStatus(FROM_ARROW);
                break;
            }
            case 16: {
                this.setStatus(VISIBLE);
                break;
            }
            case 32: {
                this.setStatus(PATH);
                break;
            }
            default: {
                this.setStatus(HIDDEN);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof Portal) {
            String propertyName = e.getPropertyName();
            if ("Direction".equals(propertyName)) {
                if (this._hide) {
                    this.setStatus(HIDDEN);
                    return;
                }
                switch ((Integer)e.getNewValue()) {
                    case 1: {
                        this.setStatus(HIDDEN);
                        break;
                    }
                    case 2: {
                        this.setStatus(TO_ARROW);
                        break;
                    }
                    case 4: {
                        this.setStatus(FROM_ARROW);
                        break;
                    }
                    default: {
                        log.warn("Unhandled portal value: {}", e.getNewValue());
                        break;
                    }
                }
            } else if ("NameChange".equals(propertyName)) {
                this.setName((String)e.getNewValue());
            } else if ("portalDelete".equals(propertyName)) {
                this.remove();
            }
        }
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_PortalIcon");
    }

    @Override
    @Nonnull
    public String getNameString() {
        Portal p = this.getPortal();
        if (p == null) {
            return "No Portal Defined";
        }
        return p.getDescription();
    }

    @Override
    public boolean doViemMenu() {
        return false;
    }

    private void setRemoveMenu(JPopupMenu popup) {
        popup.add(new AbstractAction(Bundle.getMessage("Remove")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortalIcon.this.remove();
            }
        });
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        popup.add(this.getNameString());
        this._editor.setPositionableMenu(this, popup);
        if (this.isPositionable()) {
            this._editor.setShowCoordinatesMenu(this, popup);
        }
        this._editor.setDisplayLevelMenu(this, popup);
        popup.addSeparator();
        popup.add(CoordinateEdit.getScaleEditAction(this));
        popup.add(CoordinateEdit.getRotateEditAction(this));
        popup.addSeparator();
        this.setRemoveMenu(popup);
        return true;
    }

    @Override
    public void setLocation(int x, int y) {
        ControlPanelEditor cpe = (ControlPanelEditor)this._editor;
        if (cpe.getCircuitBuilder().portalIconMove(this, x, y)) {
            super.setLocation(x, y);
        }
    }

    @Override
    public boolean setRotateMenu(@Nonnull JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setScaleMenu(@Nonnull JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setEditItemMenu(@Nonnull JPopupMenu popup) {
        return false;
    }
}

