/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jmri.NamedBean;
import jmri.jmrit.display.controlPanelEditor.EditFrame;
import jmri.jmrit.display.controlPanelEditor.SignalPair;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.Portal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalList
extends JList<SignalPair> {
    private final SignalListModel _signalListModel;
    private static final Logger log = LoggerFactory.getLogger(SignalList.class);

    SignalList(OBlock block, EditFrame parent) {
        this._signalListModel = new SignalListModel(block, parent);
        this.setModel(this._signalListModel);
        this.setCellRenderer(new SignalCellRenderer());
        this.setPreferredSize(new Dimension(300, 120));
        this.setVisibleRowCount(5);
    }

    void dataChange() {
        this._signalListModel.dataChange();
    }

    void setSelected(Portal portal) {
        for (SignalPair sp : this._signalListModel._list) {
            if (!sp._portal.equals(portal)) continue;
            this.setSelectedValue(sp, true);
            return;
        }
        this.clearSelection();
    }

    static class SignalListModel
    extends AbstractListModel<SignalPair>
    implements PropertyChangeListener {
        OBlock _homeBlock;
        private final EditFrame _parent;
        List<SignalPair> _list = new ArrayList<SignalPair>();

        SignalListModel(OBlock block, EditFrame parent) {
            this._homeBlock = block;
            this._parent = parent;
            this._homeBlock.addPropertyChangeListener(this);
            this.makeList();
        }

        private void makeList() {
            for (SignalPair sp : this._list) {
                sp._portal.removePropertyChangeListener(this);
            }
            this._list.clear();
            for (Portal portal : this._homeBlock.getPortals()) {
                NamedBean signal = portal.getSignalProtectingBlock(this._homeBlock);
                if (signal == null) continue;
                this._list.add(new SignalPair(signal, portal));
            }
            for (SignalPair sp : this._list) {
                sp._portal.addPropertyChangeListener(this);
            }
        }

        @Override
        public int getSize() {
            return this._list.size();
        }

        @Override
        public SignalPair getElementAt(int index) {
            if (index < this.getSize()) {
                return this._list.get(index);
            }
            return null;
        }

        public void dataChange() {
            this.fireContentsChanged(this, 0, 0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object source = e.getSource();
            String property = e.getPropertyName();
            if (log.isDebugEnabled()) {
                log.debug("property = {} source= {}", (Object)property, (Object)source.getClass().getName());
            }
            if (source instanceof OBlock && property.equals("deleted")) {
                this._homeBlock.removePropertyChangeListener(this);
                this._parent.closingEvent(true);
            } else {
                this.makeList();
                this.fireContentsChanged(this, 0, 0);
                if (property.equals("signalChange") || property.equals("NameChange")) {
                    this._parent.clearListSelection();
                }
            }
        }
    }

    private static class SignalCellRenderer
    extends JLabel
    implements ListCellRenderer<SignalPair> {
        private SignalCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SignalPair> list, SignalPair value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.getDiscription());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

