/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor.configurexml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JFrame;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.configurexml.XmlAdapter;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.controlPanelEditor.ControlPanelEditor;
import jmri.util.gui.GuiLafPreferencesManager;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlPanelEditorXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(ControlPanelEditorXml.class);

    @Override
    public Element store(Object o) {
        ControlPanelEditor p = (ControlPanelEditor)o;
        Element panel = new Element("paneleditor");
        JFrame frame = p.getTargetFrame();
        Dimension size = frame.getSize();
        Point posn = frame.getLocation();
        panel.setAttribute("class", "jmri.jmrit.display.controlPanelEditor.configurexml.ControlPanelEditorXml");
        panel.setAttribute("name", frame.getName());
        panel.setAttribute("x", "" + posn.x);
        panel.setAttribute("y", "" + posn.y);
        panel.setAttribute("height", "" + size.height);
        panel.setAttribute("width", "" + size.width);
        panel.setAttribute("editable", p.isEditable() ? "yes" : "no");
        panel.setAttribute("positionable", p.allPositionable() ? "yes" : "no");
        panel.setAttribute("showtooltips", p.showToolTip() ? "yes" : "no");
        panel.setAttribute("controlling", p.allControlling() ? "yes" : "no");
        panel.setAttribute("hide", p.showHidden() ? "no" : "yes");
        panel.setAttribute("panelmenu", p.isPanelMenuVisible() ? "yes" : "no");
        panel.setAttribute("scrollable", p.getScrollable());
        if (p.getBackgroundColor() != null) {
            panel.setAttribute("redBackground", "" + p.getBackgroundColor().getRed());
            panel.setAttribute("greenBackground", "" + p.getBackgroundColor().getGreen());
            panel.setAttribute("blueBackground", "" + p.getBackgroundColor().getBlue());
        }
        panel.setAttribute("state", "" + p.getExtendedState());
        panel.setAttribute("shapeSelect", p.getShapeSelect() ? "yes" : "no");
        String family = p.getPortalIconFamily();
        if (family != null && !family.equals("Standard")) {
            Element elem = new Element("icons");
            elem.setAttribute("portalFamily", family);
            panel.addContent((Content)elem);
        }
        List<Positionable> contents = p.getContents();
        log.debug("N elements: {}", (Object)contents.size());
        for (Positionable sub : contents) {
            if (sub == null || !sub.storeItem()) continue;
            try {
                Element e = ConfigXmlManager.elementFromObject(sub);
                if (e == null) continue;
                panel.addContent((Content)e);
            }
            catch (RuntimeException e) {
                log.error("Error storing panel element", (Throwable)e);
            }
        }
        return panel;
    }

    public Element storeIcon(String elemName, NamedIcon icon) {
        if (icon == null) {
            return null;
        }
        Element element = new Element(elemName);
        element.addContent((Content)new Element("url").addContent(icon.getURL()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        Attribute attr;
        Element elem;
        UserPreferencesManager prefsMgr;
        Attribute a;
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        boolean result = true;
        int x = 0;
        int y = 0;
        int height = 400;
        int width = 300;
        try {
            a = shared.getAttribute("x");
            if (a != null) {
                x = a.getIntValue();
            }
            if ((a = shared.getAttribute("y")) != null) {
                y = a.getIntValue();
            }
            if ((a = shared.getAttribute("height")) != null) {
                height = a.getIntValue();
            }
            if ((a = shared.getAttribute("width")) != null) {
                width = a.getIntValue();
            }
        }
        catch (DataConversionException e) {
            log.error("failed to convert ControlPanelEditor's attribute");
            result = false;
        }
        String name = "Control Panel";
        if (shared.getAttribute("name") != null) {
            name = shared.getAttribute("name").getValue();
        }
        if (InstanceManager.getDefault(EditorManager.class).contains(name)) {
            log.warn("File contains a panel with the same name ({}) as an existing panel", (Object)name);
            result = false;
        }
        if (!InstanceManager.getDefault(GuiLafPreferencesManager.class).isEditorUseOldLocSize() && (prefsMgr = InstanceManager.getNullableDefault(UserPreferencesManager.class)) != null) {
            Dimension prefsWindowSize;
            String windowFrameRef = "jmri.jmrit.display.controlPanelEditor.ControlPanelEditor:" + name;
            Point prefsWindowLocation = prefsMgr.getWindowLocation(windowFrameRef);
            if (prefsWindowLocation != null) {
                x = (int)prefsWindowLocation.getX();
                y = (int)prefsWindowLocation.getY();
            }
            if ((prefsWindowSize = prefsMgr.getWindowSize(windowFrameRef)) != null && prefsWindowSize.getHeight() != 0.0 && prefsWindowSize.getWidth() != 0.0) {
                height = (int)prefsWindowSize.getHeight();
                width = (int)prefsWindowSize.getWidth();
            }
        }
        ControlPanelEditor panel = new ControlPanelEditor(name);
        panel.getTargetFrame().setVisible(false);
        InstanceManager.getDefault(EditorManager.class).add(panel);
        boolean value = true;
        a = shared.getAttribute("editable");
        if (a != null && a.getValue().equals("no")) {
            value = false;
        }
        panel.setAllEditable(value);
        value = true;
        a = shared.getAttribute("positionable");
        if (a != null && a.getValue().equals("no")) {
            value = false;
        }
        panel.setAllPositionable(value);
        value = true;
        a = shared.getAttribute("showtooltips");
        if (a != null && a.getValue().equals("no")) {
            value = false;
        }
        panel.setAllShowToolTip(value);
        value = true;
        a = shared.getAttribute("controlling");
        if (a != null && a.getValue().equals("no")) {
            value = false;
        }
        panel.setAllControlling(value);
        value = true;
        a = shared.getAttribute("hide");
        if (a != null && a.getValue().equals("yes")) {
            value = false;
        }
        panel.setShowHidden(value);
        value = true;
        a = shared.getAttribute("panelmenu");
        if (a != null && a.getValue().equals("no")) {
            value = false;
        }
        panel.setPanelMenuVisible(value);
        value = true;
        a = shared.getAttribute("shapeSelect");
        if (a != null && a.getValue().equals("no")) {
            value = false;
        }
        panel.setShapeSelect(value);
        a = shared.getAttribute("state");
        if (a != null) {
            try {
                int xState = a.getIntValue();
                panel.setExtendedState(xState);
            }
            catch (DataConversionException e) {
                log.error("failed to convert ControlPanelEditor's extended State");
                result = false;
            }
        }
        if ((elem = shared.getChild("icons")) != null && (attr = elem.getAttribute("portalFamily")) != null) {
            panel.setPortalIconFamily(attr.getValue());
        }
        String state = "both";
        a = shared.getAttribute("scrollable");
        if (a != null) {
            state = a.getValue();
        }
        panel.setScroll(state);
        try {
            int red = shared.getAttribute("redBackground").getIntValue();
            int blue = shared.getAttribute("blueBackground").getIntValue();
            int green = shared.getAttribute("greenBackground").getIntValue();
            panel.setBackgroundColor(new Color(red, green, blue));
        }
        catch (DataConversionException e) {
            log.warn("Could not parse color attributes!");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        shared.removeChild("icons");
        panel.initView();
        List items = shared.getChildren();
        for (Element panelItem : items) {
            String adapterName = panelItem.getAttribute("class").getValue();
            log.debug("load via {}", (Object)adapterName);
            try {
                XmlAdapter adapter = (XmlAdapter)Class.forName(adapterName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                adapter.load(panelItem, panel);
                if (panel.loadOK()) continue;
                result = false;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | JmriConfigureXmlException e) {
                log.error("Exception while loading {}", (Object)panelItem.getName(), (Object)e);
                result = false;
            }
        }
        panel.disposeLoadData();
        panel.pack();
        panel.setAllEditable(panel.isEditable());
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.registerUser(panel);
        }
        panel.getTargetFrame().setLocation(x, y);
        panel.getTargetFrame().setSize(width, height);
        panel.setTitle();
        panel.getTargetFrame().setVisible(true);
        panel.loadComplete();
        return result;
    }

    public NamedIcon loadIcon(String key, Element element, Editor ed) {
        Element e;
        String iconName;
        Element elem = element.getChild(key);
        NamedIcon icon = null;
        if (elem != null && (icon = NamedIcon.getIconByName(iconName = (e = elem.getChild("url")).getText())) == null && (icon = ed.loadFailed(key, iconName)) == null) {
            log.info("{} removed for url= {}", (Object)key, (Object)iconName);
        }
        return icon;
    }

    @Override
    public int loadOrder() {
        return 390;
    }
}

