/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor.configurexml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import jmri.jmrit.display.controlPanelEditor.ControlPanelEditor;
import jmri.jmrit.display.controlPanelEditor.PortalIcon;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Portal;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(PortalIconXml.class);

    @Override
    public Element store(Object o) {
        PortalIcon p = (PortalIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("PortalIcon");
        this.storeCommonAttributes(p, element);
        element.setAttribute("scale", String.valueOf(p.getScale()));
        element.setAttribute("rotate", String.valueOf(p.getDegrees()));
        Portal portal = p.getPortal();
        if (portal == null) {
            log.info("PortalIcon has no associated Portal.");
            return null;
        }
        element.setAttribute("portalName", portal.getName());
        if (portal.getToBlock() != null) {
            element.setAttribute("toBlockName", portal.getToBlockName());
        }
        if (portal.getFromBlockName() != null) {
            element.setAttribute("fromBlockName", portal.getFromBlockName());
        }
        element.setAttribute("arrowSwitch", p.getArrowSwitch() ? "yes" : "no");
        element.setAttribute("arrowHide", p.getArrowHide() ? "yes" : "no");
        HashMap<String, NamedIcon> map = p.getIconMap();
        if (map != null) {
            Element elem = new Element("icons");
            String family = p.getFamily();
            if (family != null) {
                elem.setAttribute("family", family);
            }
            for (Map.Entry<String, NamedIcon> entry : map.entrySet()) {
                elem.addContent((Content)this.storeIcon(entry.getKey(), entry.getValue()));
            }
        }
        this.storeLogixNG_Data(p, element);
        element.setAttribute("class", "jmri.jmrit.display.controlPanelEditor.configurexml.PortalIconXml");
        return element;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        String portalName;
        String fromBlk;
        if (!(o instanceof ControlPanelEditor)) {
            log.error("Can't load portalIcon.  Panel editor must use ControlPanelEditor.");
            return;
        }
        ControlPanelEditor ed = (ControlPanelEditor)o;
        try {
            fromBlk = element.getAttribute("fromBlockName").getValue();
        }
        catch (NullPointerException e) {
            log.error("incorrect information for portalIcon; must use fromBlockName.");
            return;
        }
        try {
            portalName = element.getAttribute("portalName").getValue();
        }
        catch (NullPointerException e) {
            log.error("incorrect information for portalIcon; must use portalName.");
            return;
        }
        OBlock block = InstanceManager.getDefault(OBlockManager.class).getOBlock(fromBlk);
        Portal portal = block.getPortalByName(portalName);
        PortalIcon l = new PortalIcon(ed, portal);
        try {
            ed.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadCommonAttributes(l, 10, element);
        Attribute a = element.getAttribute("scale");
        double scale = 1.0;
        if (a != null) {
            try {
                scale = a.getDoubleValue();
            }
            catch (DataConversionException dce) {
                log.error("{} can't convert scale", (Object)l.getNameString(), (Object)dce);
            }
        }
        l.setScale(scale);
        a = element.getAttribute("rotate");
        int deg = 0;
        if (a != null) {
            try {
                deg = a.getIntValue();
            }
            catch (DataConversionException dce) {
                log.error("{} can't convert rotate", (Object)l.getNameString(), (Object)dce);
            }
        }
        l.setDegrees(deg);
        boolean value = true;
        a = element.getAttribute("arrowSwitch");
        if (a != null && a.getValue().equals("no")) {
            value = false;
        }
        l.setArrowOrientation(value);
        a = element.getAttribute("arrowHide");
        value = a != null && a.getValue().equals("yes");
        l.setHideArrows(value);
        Element iconsElem = element.getChild("icons");
        if (iconsElem != null) {
            Attribute attr = iconsElem.getAttribute("family");
            if (attr != null) {
                l.setFamily(attr.getValue());
            }
            List states = iconsElem.getChildren();
            if (log.isDebugEnabled()) {
                log.debug("icons element has{} items", (Object)states.size());
            }
            for (Element stateElem : states) {
                NamedIcon icon;
                String state = stateElem.getName();
                if (log.isDebugEnabled()) {
                    log.debug("setIcon for state \"{}\"", (Object)state);
                }
                if ((icon = this.loadIcon(l, state, iconsElem, "PortalIcon \"" + portalName + "\": icon \"" + state + "\" ", ed)) != null) {
                    l.setIcon(state, icon);
                    continue;
                }
                log.info("PortalIcon \"{}\": icon \"{}\" removed", (Object)portalName, (Object)state);
                return;
            }
        } else {
            ItemPalette.loadIcons();
            l.makeIconMap();
        }
        this.loadLogixNG_Data(l, element);
    }
}

