/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor.shape;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.controlPanelEditor.ControlPanelEditor;
import jmri.jmrit.display.controlPanelEditor.shape.Bundle;
import jmri.jmrit.display.controlPanelEditor.shape.PositionablePolygon;
import jmri.jmrit.display.controlPanelEditor.shape.PositionableShape;
import jmri.jmrit.display.controlPanelEditor.shape.ShapeDrawer;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import jmri.util.PlaceWindow;
import jmri.util.swing.JmriColorChooser;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DrawFrame
extends JmriJFrame {
    private final Editor _editor;
    protected PositionableShape _shape;
    private PositionableShape _originalShape;
    protected boolean _create;
    int _lineWidth;
    Color _lineColor;
    Color _fillColor;
    JColorChooser _chooser;
    JRadioButton _lineColorButon;
    JRadioButton _fillColorButon;
    JSlider _lineSlider;
    JSlider _alphaSlider;
    private final transient NamedBeanComboBox<Sensor> _sensorBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SensorManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    JRadioButton _hideShape;
    JRadioButton _changeLevel;
    JComboBox<String> _levelComboBox;
    JPanel _contentPanel;
    private static final Logger log = LoggerFactory.getLogger(DrawFrame.class);

    public DrawFrame(String which, String title, PositionableShape ps, Editor ed, boolean create) {
        super(false, false);
        this._shape = ps;
        this._editor = ed;
        this._create = create;
        this.setTitle(Bundle.getMessage(which, Bundle.getMessage(title)));
        this._lineWidth = 1;
        this._lineColor = Color.black;
        this._contentPanel = new JPanel();
        this._contentPanel.setLayout(new BorderLayout(10, 10));
        this._contentPanel.setLayout(new BoxLayout(this._contentPanel, 1));
        if (this._shape == null) {
            this._contentPanel.add(this.makeCreatePanel(title));
        } else {
            this._shape.removeListener();
        }
        this.setContentPane(new JScrollPane(this._contentPanel));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DrawFrame.this.closingEvent(true);
            }
        });
        super.pack();
        if (this._shape == null) {
            Point loc = this._editor.getLocationOnScreen();
            loc.x = Math.max(loc.x + 200, 0);
            loc.y = Math.max(loc.y, 0);
            this.setLocation(loc);
            this.setVisible(true);
            this.setAlwaysOnTop(true);
        }
    }

    private void addLabel(JPanel panel, String text) {
        JLabel label = new JLabel(text);
        label.setAlignmentX(0.0f);
        panel.add(label);
    }

    private JPanel makeCreatePanel(String type) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        Dimension dim = new Dimension(250, 8);
        panel.add(Box.createRigidArea(dim));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        p.add(Box.createHorizontalStrut(10));
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, 3));
        if (type != null && type.equals("Polygon")) {
            this.addLabel(pp, Bundle.getMessage("drawInstructions2a"));
            this.addLabel(pp, Bundle.getMessage("drawInstructions2b"));
        } else {
            this.addLabel(pp, Bundle.getMessage("drawInstructions2", type));
        }
        p.add(pp);
        p.add(Box.createHorizontalStrut(10));
        panel.add(p);
        panel.add(Box.createRigidArea(dim));
        this.setVisible(false);
        this.setUndecorated(true);
        this.setBackground(new Color(0.8f, 0.8f, 0.8f, 1.0f));
        return panel;
    }

    private JPanel makeEditPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(new JLabel(Bundle.getMessage("lineWidth")));
        JPanel pp = new JPanel();
        pp.add(new JLabel(Bundle.getMessage("thin")));
        this._lineSlider = new JSlider(0, 1, 30, this._lineWidth);
        this._lineSlider.addChangeListener(e -> this.widthChange());
        pp.add(this._lineSlider);
        pp.add(new JLabel(Bundle.getMessage("thick")));
        p.add(pp);
        panel.add(p);
        p = new JPanel();
        ButtonGroup bg = new ButtonGroup();
        this._lineColorButon = new JRadioButton(Bundle.getMessage("lineColor"));
        p.add(this._lineColorButon);
        bg.add(this._lineColorButon);
        this._fillColorButon = new JRadioButton(Bundle.getMessage("fillColor"));
        p.add(this._fillColorButon);
        bg.add(this._fillColorButon);
        this._lineColorButon.setSelected(true);
        panel.add(p);
        this._chooser = new JColorChooser(this._lineColor);
        this._chooser.getSelectionModel().addChangeListener(e -> this.colorChange());
        this._chooser.setPreviewPanel(new JPanel());
        this._chooser = JmriColorChooser.extendColorChooser(this._chooser);
        panel.add(this._chooser);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(new JLabel(Bundle.getMessage("transparency")));
        pp = new JPanel();
        pp.add(new JLabel(Bundle.getMessage("transparent")));
        this._alphaSlider = new JSlider(0, 0, 255, this._lineColor.getAlpha());
        this._alphaSlider.addChangeListener(e -> this.alphaChange());
        pp.add(this._alphaSlider);
        this._lineColorButon.addChangeListener(e -> this.buttonChange());
        pp.add(new JLabel(Bundle.getMessage("opaque")));
        p.add(pp);
        panel.add(p);
        return panel;
    }

    protected final JPanel makeSensorPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel(Bundle.getMessage("SensorMsg")));
        panel.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("VisibleSensor"))));
        this._sensorBox.setAllowNull(true);
        this._sensorBox.addActionListener(e -> {
            String msg = this._shape.setControlSensor(this._sensorBox.getSelectedItemDisplayName());
            log.debug("Setting sensor to {} after action", (Object)this._sensorBox.getSelectedItemDisplayName());
            if (msg != null) {
                JmriJOptionPane.showMessageDialog(panel, msg, Bundle.getMessage("ErrorSensor"), 1);
                this._sensorBox.setSelectedItem(null);
            }
            this.updateShape();
        });
        JPanel p = new JPanel();
        p.add(this._sensorBox);
        p.add(Box.createVerticalGlue());
        panel.add(p);
        panel.add(Box.createVerticalGlue());
        this._hideShape = new JRadioButton(Bundle.getMessage("HideOnSensor"));
        this._changeLevel = new JRadioButton(Bundle.getMessage("ChangeLevel"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._hideShape);
        bg.add(this._changeLevel);
        this._levelComboBox = new JComboBox();
        this._levelComboBox.addItem(Bundle.getMessage("SameLevel"));
        for (int i = 1; i < 11; ++i) {
            this._levelComboBox.addItem(Bundle.getMessage("Level") + " " + i);
        }
        this._levelComboBox.addActionListener(evt -> {
            int level = this._levelComboBox.getSelectedIndex();
            this._shape.setChangeLevel(level);
        });
        this._hideShape.addActionListener(a -> {
            this._shape.setHide(true);
            this._levelComboBox.setEnabled(false);
        });
        this._changeLevel.addActionListener(a -> {
            this._shape.setHide(false);
            this._levelComboBox.setEnabled(true);
        });
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        p1.add(this._hideShape);
        p1.add(this._changeLevel);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 1));
        p = new JPanel();
        p.add(this._levelComboBox);
        p2.add(p);
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 0));
        p3.add(p1);
        p3.add(Box.createHorizontalGlue());
        p3.add(p2);
        panel.add(Box.createVerticalGlue());
        panel.add(p3);
        panel.add(Box.createVerticalGlue());
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, 0));
        pp.add(Box.createHorizontalStrut(80));
        pp.add(Box.createHorizontalGlue());
        pp.add((Component)panel, "Center");
        pp.add(Box.createHorizontalGlue());
        return pp;
    }

    protected JPanel makeParamsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    protected void setDisplayParams(PositionableShape ps) {
        ShapeDrawer sd;
        if (!this._create) {
            this.makeCopy(ps);
        }
        if (!(sd = ((ControlPanelEditor)ps.getEditor()).getShapeDrawer()).setDrawFrame(this)) {
            this.closingEvent(true);
            return;
        }
        this._contentPanel.removeAll();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.makeEditPanel());
        panel.add(this.makeParamsPanel());
        JTabbedPane tPanel = new JTabbedPane();
        tPanel.addTab(Bundle.getMessage("attributeTab"), null, panel, Bundle.getMessage("drawInstructions1"));
        this._lineWidth = this._shape.getLineWidth();
        this._lineSlider.setValue(this._lineWidth);
        this._lineColor = this._shape.getLineColor();
        this._fillColor = this._shape.getFillColor();
        int alpha = this._lineColor.getAlpha();
        if (alpha > 5) {
            this._alphaSlider.setValue(alpha);
            this._lineColorButon.setSelected(true);
            this._chooser.setColor(this._lineColor);
        } else {
            this._alphaSlider.setValue(this._fillColor.getAlpha());
            this._lineColorButon.setSelected(false);
            this._chooser.setColor(this._fillColor);
        }
        tPanel.addTab(Bundle.getMessage("advancedTab"), null, this.makeSensorPanel(), Bundle.getMessage("drawInstructions3a"));
        this._sensorBox.setSelectedItem(this._shape.getControlSensor());
        this._levelComboBox.setSelectedIndex(this._shape.getChangeLevel());
        if (this._shape.isHideOnSensor()) {
            this._hideShape.setSelected(true);
            this._levelComboBox.setEnabled(false);
        } else {
            this._changeLevel.setSelected(true);
        }
        this._contentPanel.add(tPanel);
        this._contentPanel.add(this.makeDoneButtonPanel());
        this.pack();
        InstanceManager.getDefault(PlaceWindow.class).nextTo(this._editor, this._shape, this);
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        if (log.isDebugEnabled()) {
            Point pt1 = this.getLocation();
            GraphicsDevice device = this.getGraphicsConfiguration().getDevice();
            log.debug("setDisplayParams Screen device= {}: getLocation()= [{}, {}]", new Object[]{device.getIDstring(), pt1.x, pt1.y});
        }
    }

    private void makeCopy(PositionableShape ps) {
        this._originalShape = (PositionableShape)ps.deepClone();
        this._originalShape.remove();
        this._originalShape.removeListener();
        log.debug("_originalShape made");
    }

    private JPanel makeDoneButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(Box.createHorizontalGlue());
        JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
        doneButton.addActionListener(a -> {
            this.closingEvent(false);
            JmriColorChooser.addRecentColor(this._lineColor);
            if (this._fillColor != null) {
                JmriColorChooser.addRecentColor(this._fillColor);
            }
        });
        JPanel p = new JPanel();
        p.add(doneButton);
        panel.add(p);
        panel.add(Box.createHorizontalGlue());
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(a -> this.closingEvent(true));
        p = new JPanel();
        p.add(cancelButton);
        panel.add(p);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private void buttonChange() {
        if (this._lineColorButon.isSelected()) {
            this._chooser.setColor(this._lineColor);
            this._alphaSlider.setValue(this._lineColor.getAlpha());
        } else if (this._fillColor != null) {
            this._chooser.setColor(this._fillColor);
            this._alphaSlider.setValue(this._fillColor.getAlpha());
        } else {
            this._alphaSlider.setValue(255);
        }
        this._alphaSlider.revalidate();
        this._alphaSlider.repaint();
    }

    private void widthChange() {
        this._lineWidth = this._lineSlider.getValue();
        if (this._shape == null) {
            return;
        }
        this._shape.setLineWidth(this._lineWidth);
        this.updateShape();
    }

    private void colorChange() {
        Color c = this._chooser.getColor();
        int alpha = c.getAlpha();
        log.debug("colorChange: color= {}, alpha= {} ", (Object)c, (Object)alpha);
        this._alphaSlider.setValue(c.getAlpha());
        if (this._lineColorButon.isSelected()) {
            this._lineColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
            if (this._shape != null) {
                this._shape.setLineColor(this._lineColor);
            }
        } else {
            this._fillColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
            if (this._shape != null) {
                this._shape.setFillColor(this._fillColor);
            }
        }
        this.updateShape();
    }

    private void alphaChange() {
        int alpha = this._alphaSlider.getValue();
        if (this._lineColorButon.isSelected()) {
            this._lineColor = new Color(this._lineColor.getRed(), this._lineColor.getGreen(), this._lineColor.getBlue(), alpha);
            if (this._shape != null) {
                this._shape.setLineColor(this._lineColor);
            }
        } else if (this._fillColorButon.isSelected() && this._fillColor != null) {
            this._fillColor = new Color(this._fillColor.getRed(), this._fillColor.getGreen(), this._fillColor.getBlue(), alpha);
            if (this._shape != null) {
                this._shape.setFillColor(this._fillColor);
            }
        }
        this.updateShape();
    }

    protected void closingEvent(boolean cancel) {
        log.debug("closingEvent for {}", (Object)this.getTitle());
        if (this._shape != null) {
            if (cancel) {
                this._shape.remove();
                if (this._originalShape != null) {
                    try {
                        this._originalShape.getEditor().putItem(this._originalShape);
                    }
                    catch (Positionable.DuplicateIdException e) {
                        log.error("Editor.putItem() with has thrown DuplicateIdException", (Throwable)e);
                    }
                    this._originalShape.setListener();
                }
            } else {
                this._shape.setListener();
                ((ControlPanelEditor)this._editor).setShapeSelect(true);
            }
            this._shape.removeHandles();
            if (this._shape instanceof PositionablePolygon) {
                ((PositionablePolygon)this._shape).editing(false);
            }
        }
        ((ControlPanelEditor)this._editor).getShapeDrawer().setDrawFrame(null);
        this._create = false;
        this._shape = null;
        this.dispose();
    }

    protected int getInteger(JTextField field, int value) {
        try {
            int i = Integer.parseInt(field.getText());
            if (i > 0) {
                if (i < 4) {
                    i = 4;
                }
                return i;
            }
        }
        catch (NumberFormatException nfe) {
            JmriJOptionPane.showMessageDialog(this, nfe, Bundle.getMessage("WarningTitle"), 2);
        }
        field.setText(Integer.toString(value));
        return value;
    }

    protected void updateShape() {
        if (this._shape == null) {
            return;
        }
        this._shape.removeHandles();
        this._shape.drawHandles();
        this._shape.updateSize();
        this._shape.getEditor().getTargetPanel().repaint();
    }

    abstract void setDisplayWidth(int var1);

    abstract void setDisplayHeight(int var1);

    protected abstract PositionableShape makeFigure(Rectangle var1, Editor var2);
}

