/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor.shape;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.controlPanelEditor.shape.Bundle;
import jmri.jmrit.display.controlPanelEditor.shape.DrawFrame;
import jmri.jmrit.display.controlPanelEditor.shape.PositionableRectangle;
import jmri.jmrit.display.controlPanelEditor.shape.PositionableShape;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseMotionListener;

public class DrawRectangle
extends DrawFrame {
    int _width;
    int _height;
    JTextField _widthText;
    JTextField _heightText;

    public DrawRectangle(String which, String title, PositionableShape ps, Editor ed, boolean create) {
        super(which, title, ps, ed, create);
        this._lineWidth = 3;
    }

    @Override
    protected JPanel makeParamsPanel() {
        JPanel panel = super.makeParamsPanel();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JPanel pp = new JPanel();
        this._widthText = new JTextField(6);
        this._width = this._shape.getWidth();
        this._widthText.setText(Integer.toString(this._width));
        this._widthText.setHorizontalAlignment(4);
        pp.add(this._widthText);
        pp.add(new JLabel(Bundle.getMessage("width")));
        p.add(pp);
        this._widthText.addActionListener(e -> {
            this._shape.setWidth(this.getInteger(this._widthText, this._width));
            this.updateShape();
        });
        pp = new JPanel();
        this._heightText = new JTextField(6);
        this._height = this._shape.getHeight();
        this._heightText.setText(Integer.toString(this._height));
        this._heightText.setHorizontalAlignment(4);
        pp.add(this._heightText);
        pp.add(new JLabel(Bundle.getMessage("height")));
        p.add(pp);
        this._heightText.addActionListener(e -> {
            this._shape.setHeight(this.getInteger(this._heightText, this._height));
            this.updateShape();
        });
        p.addMouseMotionListener(JmriMouseMotionListener.adapt(new JmriMouseMotionListener(){

            @Override
            public void mouseDragged(JmriMouseEvent e) {
                DrawRectangle.this.updateShape();
            }

            @Override
            public void mouseMoved(JmriMouseEvent e) {
                DrawRectangle.this._shape.setWidth(DrawRectangle.this.getInteger(DrawRectangle.this._widthText, DrawRectangle.this._width));
                DrawRectangle.this._shape.setHeight(DrawRectangle.this.getInteger(DrawRectangle.this._heightText, DrawRectangle.this._height));
                DrawRectangle.this.updateShape();
            }
        }));
        panel.add(p);
        return panel;
    }

    @Override
    protected PositionableShape makeFigure(Rectangle r, Editor ed) {
        if (r != null) {
            Rectangle2D.Double rr = new Rectangle2D.Double(0.0, 0.0, this._width, this._height);
            this._shape = new PositionableRectangle(ed, rr);
        }
        return this._shape;
    }

    @Override
    void setDisplayWidth(int w) {
        this._widthText.setText(Integer.toString(w));
    }

    @Override
    void setDisplayHeight(int h) {
        this._heightText.setText(Integer.toString(h));
    }
}

