/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor.shape;

import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.controlPanelEditor.shape.Bundle;
import jmri.jmrit.display.controlPanelEditor.shape.DrawRectangle;
import jmri.jmrit.display.controlPanelEditor.shape.PositionableRoundRect;
import jmri.jmrit.display.controlPanelEditor.shape.PositionableShape;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseMotionListener;

public class DrawRoundRect
extends DrawRectangle {
    JTextField _radiusText;

    public DrawRoundRect(String which, String title, PositionableShape ps, Editor ed, boolean create) {
        super(which, title, ps, ed, create);
    }

    @Override
    protected JPanel makeParamsPanel() {
        JPanel panel = super.makeParamsPanel();
        final PositionableRoundRect shape = (PositionableRoundRect)this._shape;
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JPanel pp = new JPanel();
        this._radiusText = new JTextField(6);
        this._radiusText.setText(Integer.toString(shape.getCornerRadius()));
        this._radiusText.setHorizontalAlignment(4);
        pp.add(this._radiusText);
        this._radiusText.addActionListener(e -> {
            shape.setCornerRadius(this.getInteger(this._radiusText, shape.getCornerRadius()));
            this.updateShape();
        });
        this._radiusText.addMouseMotionListener(JmriMouseMotionListener.adapt(new JmriMouseMotionListener(){

            @Override
            public void mouseDragged(JmriMouseEvent e) {
                DrawRoundRect.this.updateShape();
            }

            @Override
            public void mouseMoved(JmriMouseEvent e) {
                shape.setCornerRadius(DrawRoundRect.this.getInteger(DrawRoundRect.this._radiusText, shape.getCornerRadius()));
                DrawRoundRect.this.updateShape();
            }
        }));
        pp.add(new JLabel(Bundle.getMessage("cornerRadius")));
        p.add(pp);
        panel.add(p);
        return panel;
    }

    @Override
    protected PositionableShape makeFigure(Rectangle r, Editor ed) {
        if (r != null) {
            RoundRectangle2D.Double rr = new RoundRectangle2D.Double(0.0, 0.0, r.width, r.height, 40.0, 40.0);
            this._shape = new PositionableRoundRect(ed, rr);
        }
        return this._shape;
    }
}

